/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.jetbrains.python.psi.LanguageLevel;
import java.util.EnumSet;
import org.intellij.lang.regexp.DefaultRegExpPropertiesProvider;
import org.intellij.lang.regexp.RegExpLanguageHost;
import org.intellij.lang.regexp.RegExpTT;
import org.intellij.lang.regexp.UnicodeCharacterNames;
import org.intellij.lang.regexp.psi.RegExpAtom;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpElement;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.intellij.lang.regexp.psi.RegExpNamedCharacter;
import org.intellij.lang.regexp.psi.RegExpNamedGroupRef;
import org.intellij.lang.regexp.psi.RegExpNumber;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonRegExpHost
implements RegExpLanguageHost {
    private final DefaultRegExpPropertiesProvider myPropertiesProvider = DefaultRegExpPropertiesProvider.getInstance();

    public boolean characterNeedsEscaping(char c) {
        return c == '\"' || c == '\'';
    }

    public boolean supportsPerl5EmbeddedComments() {
        return true;
    }

    public boolean supportsPossessiveQuantifiers() {
        return false;
    }

    public boolean supportsPythonConditionalRefs() {
        return true;
    }

    public boolean supportConditionalCondition(RegExpAtom condition) {
        if (condition instanceof RegExpGroup) {
            return false;
        }
        return condition.getNode().getFirstChildNode().getElementType() == RegExpTT.GROUP_BEGIN;
    }

    public boolean supportsNamedGroupSyntax(RegExpGroup group2) {
        return group2.getType() == RegExpGroup.Type.PYTHON_NAMED_GROUP;
    }

    public boolean supportsNamedGroupRefSyntax(RegExpNamedGroupRef ref) {
        return ref.isPythonNamedGroupRef();
    }

    @NotNull
    public EnumSet<RegExpGroup.Type> getSupportedNamedGroupTypes(RegExpElement context2) {
        EnumSet<RegExpGroup.Type> enumSet = EnumSet.of(RegExpGroup.Type.PYTHON_NAMED_GROUP);
        if (enumSet == null) {
            PythonRegExpHost.$$$reportNull$$$0(0);
        }
        return enumSet;
    }

    public boolean supportsExtendedHexCharacter(RegExpChar regExpChar) {
        return false;
    }

    public RegExpLanguageHost.Lookbehind supportsLookbehind(@NotNull RegExpGroup lookbehindGroup) {
        if (lookbehindGroup == null) {
            PythonRegExpHost.$$$reportNull$$$0(1);
        }
        return RegExpLanguageHost.Lookbehind.FIXED_LENGTH_ALTERNATION;
    }

    public Long getQuantifierValue(@NotNull RegExpNumber number) {
        if (number == null) {
            PythonRegExpHost.$$$reportNull$$$0(2);
        }
        try {
            long result = Long.parseLong(number.getUnescapedText());
            if (result >= 0xFFFFFFFFL) {
                return null;
            }
            return result;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public boolean isValidCategory(@NotNull String category) {
        if (category == null) {
            PythonRegExpHost.$$$reportNull$$$0(3);
        }
        return this.myPropertiesProvider.isValidCategory(category);
    }

    public String[] @NotNull [] getAllKnownProperties() {
        return this.myPropertiesProvider.getAllKnownProperties();
    }

    @Nullable
    public String getPropertyDescription(@Nullable String name2) {
        return this.myPropertiesProvider.getPropertyDescription(name2);
    }

    public String[] @NotNull [] getKnownCharacterClasses() {
        return this.myPropertiesProvider.getKnownCharacterClasses();
    }

    public boolean supportsNamedCharacters(RegExpNamedCharacter namedCharacter) {
        PsiLanguageInjectionHost host = InjectedLanguageManager.getInstance((Project)namedCharacter.getProject()).getInjectionHost((PsiElement)namedCharacter);
        return host == null || LanguageLevel.forElement((PsiElement)host).isAtLeast(LanguageLevel.PYTHON38);
    }

    public boolean isValidNamedCharacter(RegExpNamedCharacter namedCharacter) {
        return UnicodeCharacterNames.getCodePoint((String)namedCharacter.getName()) >= 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/PythonRegExpHost";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookbehindGroup";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "number";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedNamedGroupTypes";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/PythonRegExpHost";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "supportsLookbehind";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getQuantifierValue";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isValidCategory";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

