/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.mlcompletion;

import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.codeInsight.completion.PyCompletionUtilsKt;
import com.jetbrains.python.codeInsight.mlcompletion.PyMlCompletionHelpers;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001d\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/python/codeInsight/mlcompletion/PyImportCompletionFeatures;", "", "()V", "getElementImportPathFeatures", "Lcom/jetbrains/python/codeInsight/mlcompletion/PyImportCompletionFeatures$ElementImportPathFeatures;", "element", "Lcom/intellij/codeInsight/lookup/LookupElement;", "location", "Lcom/intellij/codeInsight/completion/CompletionLocation;", "getImportPopularityFeature", "", "locationPsi", "Lcom/intellij/psi/PsiElement;", "lookupString", "", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;)Ljava/lang/Integer;", "ElementImportPathFeatures", "intellij.python.community.impl"})
public final class PyImportCompletionFeatures {
    @NotNull
    public static final PyImportCompletionFeatures INSTANCE;

    @Nullable
    public final ElementImportPathFeatures getElementImportPathFeatures(@NotNull LookupElement element, @NotNull CompletionLocation location) {
        int n;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        PsiElement psiElement = element.getPsiElement();
        if (psiElement == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"element.psiElement ?: return null");
        PsiElement psiElement2 = psiElement;
        QualifiedName qualifiedName = QualifiedNameFinder.findShortestImportableQName((PsiFileSystemItem)psiElement2.getContainingFile());
        if (qualifiedName == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)qualifiedName, (String)"QualifiedNameFinder.find\u2026iningFile) ?: return null");
        QualifiedName importPath = qualifiedName;
        CompletionParameters completionParameters = location.getCompletionParameters();
        Intrinsics.checkNotNullExpressionValue((Object)completionParameters, (String)"location.completionParameters");
        PsiFile psiFile = completionParameters.getOriginalFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"location.completionParameters.originalFile");
        PsiFile caretLocationFile = psiFile;
        boolean isImported = PyCompletionUtilsKt.hasImportsFrom(caretLocationFile, importPath);
        int numComponents = importPath.getComponentCount();
        List list = importPath.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"importPath.components");
        Iterable $this$count$iv = list;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                int n2;
                String it = (String)element$iv;
                boolean bl = false;
                String string = it;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it");
                if (!StringsKt.startsWith$default((String)string, (String)"_", (boolean)false, (int)2, null) || (n2 = ++count$iv) >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int numPrivateComponents = n;
        return new ElementImportPathFeatures(isImported, numPrivateComponents, numComponents);
    }

    @Nullable
    public final Integer getImportPopularityFeature(@NotNull PsiElement locationPsi, @NotNull String lookupString) {
        Intrinsics.checkNotNullParameter((Object)locationPsi, (String)"locationPsi");
        Intrinsics.checkNotNullParameter((Object)lookupString, (String)"lookupString");
        if (!(locationPsi.getParent() instanceof PyReferenceExpression)) {
            return null;
        }
        PsiElement psiElement = locationPsi.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"locationPsi.parent");
        if (!(psiElement.getParent() instanceof PyImportElement)) {
            return null;
        }
        PsiElement psiElement2 = locationPsi.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"locationPsi.parent");
        PsiElement psiElement3 = psiElement2.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"locationPsi.parent.parent");
        if (!(psiElement3.getParent() instanceof PyImportStatement)) {
            return null;
        }
        return PyMlCompletionHelpers.INSTANCE.getImportPopularity().get(lookupString);
    }

    private PyImportCompletionFeatures() {
    }

    static {
        PyImportCompletionFeatures pyImportCompletionFeatures;
        INSTANCE = pyImportCompletionFeatures = new PyImportCompletionFeatures();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00032\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/python/codeInsight/mlcompletion/PyImportCompletionFeatures$ElementImportPathFeatures;", "", "isImported", "", "numPrivateComponents", "", "numComponents", "(ZII)V", "()Z", "getNumComponents", "()I", "getNumPrivateComponents", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "toString", "", "intellij.python.community.impl"})
    public static final class ElementImportPathFeatures {
        private final boolean isImported;
        private final int numPrivateComponents;
        private final int numComponents;

        public final boolean isImported() {
            return this.isImported;
        }

        public final int getNumPrivateComponents() {
            return this.numPrivateComponents;
        }

        public final int getNumComponents() {
            return this.numComponents;
        }

        public ElementImportPathFeatures(boolean isImported, int numPrivateComponents, int numComponents) {
            this.isImported = isImported;
            this.numPrivateComponents = numPrivateComponents;
            this.numComponents = numComponents;
        }

        public final boolean component1() {
            return this.isImported;
        }

        public final int component2() {
            return this.numPrivateComponents;
        }

        public final int component3() {
            return this.numComponents;
        }

        @NotNull
        public final ElementImportPathFeatures copy(boolean isImported, int numPrivateComponents, int numComponents) {
            return new ElementImportPathFeatures(isImported, numPrivateComponents, numComponents);
        }

        public static /* synthetic */ ElementImportPathFeatures copy$default(ElementImportPathFeatures elementImportPathFeatures, boolean bl, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                bl = elementImportPathFeatures.isImported;
            }
            if ((n3 & 2) != 0) {
                n = elementImportPathFeatures.numPrivateComponents;
            }
            if ((n3 & 4) != 0) {
                n2 = elementImportPathFeatures.numComponents;
            }
            return elementImportPathFeatures.copy(bl, n, n2);
        }

        @NotNull
        public String toString() {
            return "ElementImportPathFeatures(isImported=" + this.isImported + ", numPrivateComponents=" + this.numPrivateComponents + ", numComponents=" + this.numComponents + ")";
        }

        public int hashCode() {
            int n = this.isImported ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            return (n * 31 + Integer.hashCode(this.numPrivateComponents)) * 31 + Integer.hashCode(this.numComponents);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ElementImportPathFeatures)) break block3;
                    ElementImportPathFeatures elementImportPathFeatures = (ElementImportPathFeatures)object;
                    if (this.isImported != elementImportPathFeatures.isImported || this.numPrivateComponents != elementImportPathFeatures.numPrivateComponents || this.numComponents != elementImportPathFeatures.numComponents) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

