/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.intellij.DynamicBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.console.PyConsoleOptions;
import com.jetbrains.python.psi.impl.PyExpressionCodeFragmentImpl;
import com.jetbrains.python.run.AbstractPyCommonOptionsForm;
import com.jetbrains.python.run.AbstractPythonRunConfiguration;
import com.jetbrains.python.run.PyCommonOptionsFormData;
import com.jetbrains.python.run.PyCommonOptionsFormFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class PyConsoleSpecificOptionsPanel {
    private final Project myProject;
    private JPanel myWholePanel;
    private JPanel myStartingScriptPanel;
    private JPanel myInterpreterPanel;
    private PyConsoleOptions.PyConsoleSettings myConsoleSettings;
    private EditorTextField myEditorTextField;
    private AbstractPyCommonOptionsForm myCommonOptionsForm;

    public PyConsoleSpecificOptionsPanel(Project project) {
        this.myProject = project;
        this.$$$setupUI$$$();
    }

    public JPanel createPanel(PyConsoleOptions.PyConsoleSettings optionsProvider) {
        this.myInterpreterPanel.setLayout(new BorderLayout());
        this.myCommonOptionsForm = PyCommonOptionsFormFactory.getInstance().createForm(this.createCommonOptionsFormData());
        this.myCommonOptionsForm.subscribe();
        this.myInterpreterPanel.add((Component)this.myCommonOptionsForm.getMainPanel(), "Center");
        this.configureStartingScriptPanel(optionsProvider);
        return this.myWholePanel;
    }

    public void apply() {
        this.myConsoleSettings.myCustomStartScript = this.myEditorTextField.getText();
        this.myConsoleSettings.apply(this.myCommonOptionsForm);
    }

    public boolean isModified() {
        return !this.myEditorTextField.getText().equals(this.myConsoleSettings.myCustomStartScript) || this.myConsoleSettings.isModified(this.myCommonOptionsForm);
    }

    public void reset() {
        UIUtil.invokeLaterIfNeeded(() -> this.myEditorTextField.setText(this.myConsoleSettings.myCustomStartScript));
        this.myConsoleSettings.reset(this.myProject, this.myCommonOptionsForm);
    }

    private PyCommonOptionsFormData createCommonOptionsFormData() {
        return new PyCommonOptionsFormData(){

            @Override
            public Project getProject() {
                return PyConsoleSpecificOptionsPanel.this.myProject;
            }

            @Override
            public List<Module> getValidModules() {
                return AbstractPythonRunConfiguration.getValidModules(PyConsoleSpecificOptionsPanel.this.myProject);
            }

            @Override
            public boolean showConfigureInterpretersLink() {
                return true;
            }
        };
    }

    private void configureStartingScriptPanel(PyConsoleOptions.PyConsoleSettings optionsProvider) {
        this.myEditorTextField = new EditorTextField(PyConsoleSpecificOptionsPanel.createDocument(this.myProject, optionsProvider.myCustomStartScript), this.myProject, (FileType)PythonFileType.INSTANCE){

            @NotNull
            protected EditorEx createEditor() {
                EditorEx editor2 = super.createEditor();
                editor2.setVerticalScrollbarVisible(true);
                EditorEx editorEx = editor2;
                if (editorEx == null) {
                    2.$$$reportNull$$$0(0);
                }
                return editorEx;
            }

            protected boolean isOneLineMode() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/console/PyConsoleSpecificOptionsPanel$2", "createEditor"));
            }
        };
        this.myStartingScriptPanel.setLayout(new BorderLayout());
        this.myStartingScriptPanel.add((Component)this.myEditorTextField, "Center");
        this.myConsoleSettings = optionsProvider;
    }

    @NotNull
    public static Document createDocument(@NotNull Project project, @NotNull String text2) {
        if (project == null) {
            PyConsoleSpecificOptionsPanel.$$$reportNull$$$0(0);
        }
        if (text2 == null) {
            PyConsoleSpecificOptionsPanel.$$$reportNull$$$0(1);
        }
        text2 = text2.trim();
        PyExpressionCodeFragmentImpl fragment = new PyExpressionCodeFragmentImpl(project, "start_script.py", text2, true);
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument((PsiFile)fragment);
        if (document == null) {
            PyConsoleSpecificOptionsPanel.$$$reportNull$$$0(2);
        }
        return document;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        this.myWholePanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myStartingScriptPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel3.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, new Dimension(80, 80), new Dimension(100, 130), null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/PyBundle", PyConsoleSpecificOptionsPanel.class).getString("form.console.specific.options.starting.script"), (int)0, (int)0, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myInterpreterPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel3.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 3, new Dimension(80, 80), null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/console/PyConsoleSpecificOptionsPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/console/PyConsoleSpecificOptionsPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createDocument";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

