/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.containerview;

import com.intellij.openapi.util.Pair;
import java.awt.Color;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class PyNumericViewUtil {
    private static final Pattern PY_COMPLEX_NUMBER = Pattern.compile("([+-]?[.\\d]*(?:[eE][+-]?\\d*)?j?)?([+-]?[.\\d]*(?:[eE][+-]?\\d*)?j)?");

    public static double getRangedValue(String value, String type, double min, double max, String complexMax, String complexMin) {
        if ("iuf".contains(type)) {
            return (Double.parseDouble(value) - min) / (max - min);
        }
        if ("b".equals(type)) {
            return value.equals("True") ? 1.0 : 0.0;
        }
        if ("c".equals(type)) {
            return PyNumericViewUtil.getComplexRangedValue(value, complexMax, complexMin);
        }
        return 0.0;
    }

    public static Color rangedValueToColor(double rangedValue) {
        return new Color((int)Math.round(255.0 * rangedValue), 0, (int)Math.round(255.0 * (1.0 - rangedValue)), 130);
    }

    private static double getComplexRangedValue(String value, String complexMax, String complexMin) {
        Pair<Double, Double> med = PyNumericViewUtil.parsePyComplex(value);
        Pair<Double, Double> max = PyNumericViewUtil.parsePyComplex(complexMax);
        Pair<Double, Double> min = PyNumericViewUtil.parsePyComplex(complexMin);
        if (med == null || min == null || max == null) {
            return 0.0;
        }
        double range = ((Double)med.first - (Double)min.first) / ((Double)max.first - (Double)min.first);
        if (((Double)max.first).equals(min.first)) {
            range = ((Double)med.second - (Double)min.second) / ((Double)max.second - (Double)min.second);
        }
        return range;
    }

    private static Pair<Double, Double> parsePyComplex(@NotNull String pyComplexValue) {
        Matcher matcher;
        if (pyComplexValue == null) {
            PyNumericViewUtil.$$$reportNull$$$0(0);
        }
        if (pyComplexValue.startsWith("(") && pyComplexValue.endsWith(")")) {
            pyComplexValue = pyComplexValue.substring(1, pyComplexValue.length() - 1);
        }
        if ((matcher = PY_COMPLEX_NUMBER.matcher(pyComplexValue)).matches()) {
            String real = matcher.group(1);
            String imag = matcher.group(2);
            if (imag == null && real.contains("j")) {
                return new Pair((Object)new Double(0.0), (Object)Double.parseDouble(real.substring(0, real.length() - 1)));
            }
            if (imag != null) {
                return new Pair((Object)Double.parseDouble(real), (Object)Double.parseDouble(imag.substring(0, imag.length() - 1)));
            }
        } else {
            throw new IllegalArgumentException("Not a valid python complex value: " + pyComplexValue);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pyComplexValue", "com/jetbrains/python/debugger/containerview/PyNumericViewUtil", "parsePyComplex"));
    }
}

