/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.remote.vfs;

import com.google.common.collect.Maps;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.debugger.PyDebugProcess;
import com.jetbrains.python.debugger.PyLocalPositionConverter;
import com.jetbrains.python.debugger.remote.vfs.PyRemoteDebugVirtualFile;
import com.jetbrains.python.debugger.remote.vfs.PyRemotePositionConverter;
import com.jetbrains.python.remote.PyRemotePathMapper;
import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PyRemoteDebugVirtualFS
extends VirtualFileSystem {
    @NonNls
    private static final String PROTOCOL = "remoteDebugVfs";
    private final PyRemotePathMapper myPathMapper;
    private final PyDebugProcess myDebugProcess;
    private final PyRemotePositionConverter myRemotePositionConverter;
    private final Map<String, PyRemoteDebugVirtualFile> myFileCache = Maps.newHashMap();

    public PyRemoteDebugVirtualFS(PyDebugProcess debugProcess, PyRemotePathMapper pathMapper, PyRemotePositionConverter remotePositionConverter) {
        this.myDebugProcess = debugProcess;
        this.myRemotePositionConverter = remotePositionConverter;
        this.myPathMapper = pathMapper;
    }

    @NotNull
    public String getProtocol() {
        return PROTOCOL;
    }

    public VirtualFile findFileByPath(@NotNull @NonNls String path2) {
        if (path2 == null) {
            PyRemoteDebugVirtualFS.$$$reportNull$$$0(0);
        }
        String localPath = this.myPathMapper.convertToLocal(path2);
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(localPath);
        if (file == null) {
            file = PyLocalPositionConverter.findEggEntry((VirtualFileSystem)LocalFileSystem.getInstance(), localPath);
        }
        if (file == null) {
            if (!this.myFileCache.containsKey(path2)) {
                PyRemoteDebugVirtualFile vFile = new PyRemoteDebugVirtualFile(this, path2, this.myPathMapper);
                this.myFileCache.put(path2, vFile);
            }
            file = (VirtualFile)this.myFileCache.get(path2);
        }
        return file;
    }

    public PyRemotePositionConverter getRemotePositionConverter() {
        return this.myRemotePositionConverter;
    }

    public PyDebugProcess getDebugProcess() {
        return this.myDebugProcess;
    }

    public void refresh(boolean asynchronous) {
    }

    public VirtualFile refreshAndFindFileByPath(@NotNull String path2) {
        if (path2 == null) {
            PyRemoteDebugVirtualFS.$$$reportNull$$$0(1);
        }
        return null;
    }

    public void addVirtualFileListener(@NotNull VirtualFileListener listener2) {
        if (listener2 == null) {
            PyRemoteDebugVirtualFS.$$$reportNull$$$0(2);
        }
    }

    public void removeVirtualFileListener(@NotNull VirtualFileListener listener2) {
        if (listener2 == null) {
            PyRemoteDebugVirtualFS.$$$reportNull$$$0(3);
        }
    }

    protected void deleteFile(Object requestor, @NotNull VirtualFile vFile) throws IOException {
        if (vFile == null) {
            PyRemoteDebugVirtualFS.$$$reportNull$$$0(4);
        }
    }

    protected void moveFile(Object requestor, @NotNull VirtualFile vFile, @NotNull VirtualFile newParent) throws IOException {
        if (vFile == null) {
            PyRemoteDebugVirtualFS.$$$reportNull$$$0(5);
        }
        if (newParent == null) {
            PyRemoteDebugVirtualFS.$$$reportNull$$$0(6);
        }
    }

    protected void renameFile(Object requestor, @NotNull VirtualFile vFile, @NotNull String newName) throws IOException {
        if (vFile == null) {
            PyRemoteDebugVirtualFS.$$$reportNull$$$0(7);
        }
        if (newName == null) {
            PyRemoteDebugVirtualFS.$$$reportNull$$$0(8);
        }
    }

    @NotNull
    protected VirtualFile createChildFile(Object requestor, @NotNull VirtualFile vDir, @NotNull String fileName) throws IOException {
        if (vDir == null) {
            PyRemoteDebugVirtualFS.$$$reportNull$$$0(9);
        }
        if (fileName == null) {
            PyRemoteDebugVirtualFS.$$$reportNull$$$0(10);
        }
        throw new IncorrectOperationException();
    }

    @NotNull
    protected VirtualFile createChildDirectory(Object requestor, @NotNull VirtualFile vDir, @NotNull String dirName) throws IOException {
        if (vDir == null) {
            PyRemoteDebugVirtualFS.$$$reportNull$$$0(11);
        }
        if (dirName == null) {
            PyRemoteDebugVirtualFS.$$$reportNull$$$0(12);
        }
        throw new IncorrectOperationException();
    }

    @NotNull
    protected VirtualFile copyFile(Object requestor, @NotNull VirtualFile virtualFile, @NotNull VirtualFile newParent, @NotNull String copyName) throws IOException {
        if (virtualFile == null) {
            PyRemoteDebugVirtualFS.$$$reportNull$$$0(13);
        }
        if (newParent == null) {
            PyRemoteDebugVirtualFS.$$$reportNull$$$0(14);
        }
        if (copyName == null) {
            PyRemoteDebugVirtualFS.$$$reportNull$$$0(15);
        }
        VirtualFile virtualFile2 = virtualFile;
        if (virtualFile2 == null) {
            PyRemoteDebugVirtualFS.$$$reportNull$$$0(16);
        }
        return virtualFile2;
    }

    public boolean isReadOnly() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParent";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vDir";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/remote/vfs/PyRemoteDebugVirtualFS";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/remote/vfs/PyRemoteDebugVirtualFS";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "copyFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPath";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndFindFileByPath";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addVirtualFileListener";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeVirtualFileListener";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "deleteFile";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "moveFile";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "renameFile";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createChildFile";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createChildDirectory";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "copyFile";
                break;
            }
            case 16: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

