/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.variablesview.usertyperenderers;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.jetbrains.python.debugger.PyUserTypeRenderer;
import com.jetbrains.python.debugger.variablesview.usertyperenderers.PyUserNodeRenderer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="PyUserTypeRenderersSettings", storages={@Storage(value="user-variables-view-settings.xml")})
public class PyUserTypeRenderersSettings
implements PersistentStateComponent<Element> {
    private static final String LIST_TAG = "LIST";
    private static final String RENDERER_TAG = "RENDERER";
    private static final String VALUE_RENDERER_TAG = "VALUE_RENDERER";
    private static final String CHILDREN_RENDERER_TAG = "CHILDREN_RENDERER";
    private static final String CHILD_TAG = "CHILD";
    private static final String NAME = "name";
    private static final String IS_ENABLED = "isEnabled";
    private static final String IS_DEFAULT = "isDefault";
    private static final String EXPRESSION = "expression";
    private static final String TO_TYPE = "toType";
    private static final String TYPE_CANONICAL_IMPORT_PATH = "typeCanonicalImportPath";
    private static final String TYPE_QUALIFIED_NAME = "typeQualifiedName";
    private static final String TYPE_SOURCE_FILE = "typeSourceFile";
    private static final String APPEND_DEFAULT_CHILDREN = "appendDefaultChildren";
    @NotNull
    private final @NotNull ArrayList<@NotNull PyUserNodeRenderer> myRenderers = new ArrayList();

    public static PyUserTypeRenderersSettings getInstance() {
        return (PyUserTypeRenderersSettings)ApplicationManager.getApplication().getService(PyUserTypeRenderersSettings.class);
    }

    @Nullable
    public synchronized Element getState() {
        Element listElement = new Element(LIST_TAG);
        for (PyUserNodeRenderer renderer : this.myRenderers) {
            PyUserTypeRenderersSettings.addRendererToElement(renderer, listElement);
        }
        return listElement;
    }

    public synchronized void loadState(@NotNull Element state2) {
        if (state2 == null) {
            PyUserTypeRenderersSettings.$$$reportNull$$$0(0);
        }
        for (Element rendererElement : state2.getChildren(RENDERER_TAG)) {
            this.myRenderers.add(PyUserTypeRenderersSettings.loadRenderer(rendererElement));
        }
    }

    @NotNull
    public synchronized @NotNull ArrayList<@NotNull PyUserNodeRenderer> getRenderers() {
        ArrayList<PyUserNodeRenderer> arrayList = this.myRenderers;
        if (arrayList == null) {
            PyUserTypeRenderersSettings.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    public synchronized @NotNull ArrayList<@NotNull PyUserTypeRenderer> getApplicableRenderers() {
        HashSet<String> foundTypes = new HashSet<String>();
        ArrayList<PyUserTypeRenderer> filtered = new ArrayList<PyUserTypeRenderer>();
        for (PyUserNodeRenderer renderer : this.myRenderers) {
            if (!renderer.isApplicable() || foundTypes.contains(renderer.getToType())) continue;
            filtered.add(renderer.convertRenderer());
            foundTypes.add(renderer.getToType());
        }
        ArrayList<PyUserTypeRenderer> arrayList = filtered;
        if (arrayList == null) {
            PyUserTypeRenderersSettings.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    public synchronized void setRenderers(@NotNull @NotNull Collection<@NotNull PyUserNodeRenderer> newRenderers) {
        if (newRenderers == null) {
            PyUserTypeRenderersSettings.$$$reportNull$$$0(3);
        }
        this.myRenderers.clear();
        this.myRenderers.addAll(newRenderers);
    }

    private static void addRendererToElement(@NotNull PyUserNodeRenderer renderer, Element parent) {
        if (renderer == null) {
            PyUserTypeRenderersSettings.$$$reportNull$$$0(4);
        }
        Element rendererElement = new Element(RENDERER_TAG);
        JDOMExternalizerUtil.writeField((Element)rendererElement, (String)NAME, (String)renderer.getName());
        JDOMExternalizerUtil.writeField((Element)rendererElement, (String)IS_ENABLED, (String)String.valueOf(renderer.isEnabled()));
        JDOMExternalizerUtil.writeField((Element)rendererElement, (String)TO_TYPE, (String)renderer.getToType());
        JDOMExternalizerUtil.writeField((Element)rendererElement, (String)TYPE_CANONICAL_IMPORT_PATH, (String)renderer.getTypeCanonicalImportPath());
        JDOMExternalizerUtil.writeField((Element)rendererElement, (String)TYPE_QUALIFIED_NAME, (String)renderer.getTypeQualifiedName());
        JDOMExternalizerUtil.writeField((Element)rendererElement, (String)TYPE_SOURCE_FILE, (String)renderer.getTypeSourceFile());
        Element valueRendererElement = new Element(VALUE_RENDERER_TAG);
        PyUserNodeRenderer.PyNodeValueRenderer valueRenderer = renderer.getValueRenderer();
        JDOMExternalizerUtil.writeField((Element)valueRendererElement, (String)IS_DEFAULT, (String)String.valueOf(valueRenderer.isDefault()));
        JDOMExternalizerUtil.writeField((Element)valueRendererElement, (String)EXPRESSION, (String)valueRenderer.getExpression());
        rendererElement.addContent(valueRendererElement);
        Element childrenRendererElement = new Element(CHILDREN_RENDERER_TAG);
        PyUserNodeRenderer.PyNodeChildrenRenderer childrenRenderer = renderer.getChildrenRenderer();
        JDOMExternalizerUtil.writeField((Element)childrenRendererElement, (String)IS_DEFAULT, (String)String.valueOf(childrenRenderer.isDefault()));
        JDOMExternalizerUtil.writeField((Element)childrenRendererElement, (String)APPEND_DEFAULT_CHILDREN, (String)String.valueOf(childrenRenderer.getAppendDefaultChildren()));
        for (PyUserNodeRenderer.ChildInfo child : childrenRenderer.getChildren()) {
            Element childElement = new Element(CHILD_TAG);
            JDOMExternalizerUtil.writeField((Element)childElement, (String)EXPRESSION, (String)child.getExpression());
            childrenRendererElement.addContent(childElement);
        }
        rendererElement.addContent(childrenRendererElement);
        parent.addContent(rendererElement);
    }

    @NotNull
    private static String toString(@Nullable String s) {
        String string = s == null ? "" : s;
        if (string == null) {
            PyUserTypeRenderersSettings.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static boolean toBoolean(@Nullable String s) {
        return Boolean.parseBoolean(s);
    }

    @NotNull
    private static PyUserNodeRenderer loadRenderer(@NotNull Element element) {
        Element childrenRendererElement;
        if (element == null) {
            PyUserTypeRenderersSettings.$$$reportNull$$$0(6);
        }
        PyUserNodeRenderer renderer = new PyUserNodeRenderer(false, null);
        String name2 = PyUserTypeRenderersSettings.toString(JDOMExternalizerUtil.readField((Element)element, (String)NAME));
        boolean isEnabled = PyUserTypeRenderersSettings.toBoolean(JDOMExternalizerUtil.readField((Element)element, (String)IS_ENABLED));
        @NotNull String toType = PyUserTypeRenderersSettings.toString(JDOMExternalizerUtil.readField((Element)element, (String)TO_TYPE));
        @NotNull String typeCanonicalImportPath = PyUserTypeRenderersSettings.toString(JDOMExternalizerUtil.readField((Element)element, (String)TYPE_CANONICAL_IMPORT_PATH));
        @NotNull String typeQualifiedName = PyUserTypeRenderersSettings.toString(JDOMExternalizerUtil.readField((Element)element, (String)TYPE_QUALIFIED_NAME));
        @NotNull String typeSourceFile = PyUserTypeRenderersSettings.toString(JDOMExternalizerUtil.readField((Element)element, (String)TYPE_SOURCE_FILE));
        renderer.setName(name2);
        renderer.setEnabled(isEnabled);
        renderer.setToType(toType);
        renderer.setTypeCanonicalImportPath(typeCanonicalImportPath);
        renderer.setTypeQualifiedName(typeQualifiedName);
        renderer.setTypeSourceFile(typeSourceFile);
        @Nullable Element valueRendererElement = element.getChild(VALUE_RENDERER_TAG);
        if (valueRendererElement != null) {
            boolean isDefault = PyUserTypeRenderersSettings.toBoolean(JDOMExternalizerUtil.readField((Element)valueRendererElement, (String)IS_DEFAULT));
            @NotNull String expression = PyUserTypeRenderersSettings.toString(JDOMExternalizerUtil.readField((Element)valueRendererElement, (String)EXPRESSION));
            renderer.getValueRenderer().setDefault(isDefault);
            renderer.getValueRenderer().setExpression(expression);
        }
        if ((childrenRendererElement = element.getChild(CHILDREN_RENDERER_TAG)) != null) {
            boolean isDefault = PyUserTypeRenderersSettings.toBoolean(JDOMExternalizerUtil.readField((Element)childrenRendererElement, (String)IS_DEFAULT));
            boolean appendDefaultChildren = PyUserTypeRenderersSettings.toBoolean(JDOMExternalizerUtil.readField((Element)childrenRendererElement, (String)APPEND_DEFAULT_CHILDREN));
            ArrayList<PyUserNodeRenderer.ChildInfo> list = new ArrayList<PyUserNodeRenderer.ChildInfo>();
            for (Element childElement : childrenRendererElement.getChildren(CHILD_TAG)) {
                @NotNull String expression = PyUserTypeRenderersSettings.toString(JDOMExternalizerUtil.readField((Element)childElement, (String)EXPRESSION));
                list.add(new PyUserNodeRenderer.ChildInfo(expression));
            }
            renderer.getChildrenRenderer().setDefault(isDefault);
            renderer.getChildrenRenderer().setAppendDefaultChildren(appendDefaultChildren);
            renderer.getChildrenRenderer().setChildren(list);
        }
        PyUserNodeRenderer pyUserNodeRenderer = renderer;
        if (pyUserNodeRenderer == null) {
            PyUserTypeRenderersSettings.$$$reportNull$$$0(7);
        }
        return pyUserNodeRenderer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/variablesview/usertyperenderers/PyUserTypeRenderersSettings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRenderers";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/variablesview/usertyperenderers/PyUserTypeRenderersSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenderers";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicableRenderers";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "loadRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setRenderers";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addRendererToElement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadRenderer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

