/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation.docstrings;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.python.documentation.docstrings.SectionBasedDocString;
import com.jetbrains.python.toolbox.Substring;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NumpyDocString
extends SectionBasedDocString {
    private static final Pattern SIGNATURE = Pattern.compile("^[ \t]*([\\w., ]+=)?[ \t]*[\\w\\.]+\\(.*\\)[ \t]*$", 8);
    private static final Pattern NAME_SEPARATOR = Pattern.compile("[ \t]*,[ \t]*");
    public static final Pattern SECTION_HEADER = Pattern.compile("^[ \t]*[-=]{2,}[ \t]*$", 8);
    public static final List<String> PREFERRED_SECTION_HEADERS = ImmutableList.of((Object)"Parameters", (Object)"Other Parameters", (Object)"Returns", (Object)"Yields", (Object)"Raises", (Object)"Attributes", (Object)"See Also", (Object)"Methods", (Object)"References", (Object)"Examples", (Object)"Notes", (Object)"Warnings", (Object[])new String[0]);
    private static final ImmutableMap<String, SectionBasedDocString.FieldType> ourSectionFieldMapping = ImmutableMap.builder().put((Object)"returns", (Object)SectionBasedDocString.FieldType.TYPE_WITH_OPTIONAL_NAME).put((Object)"yields", (Object)SectionBasedDocString.FieldType.TYPE_WITH_OPTIONAL_NAME).put((Object)"raises", (Object)SectionBasedDocString.FieldType.ONLY_TYPE).put((Object)"methods", (Object)SectionBasedDocString.FieldType.ONLY_NAME).put((Object)"keyword arguments", (Object)SectionBasedDocString.FieldType.NAME_WITH_OPTIONAL_TYPE).put((Object)"parameters", (Object)SectionBasedDocString.FieldType.NAME_WITH_OPTIONAL_TYPE).put((Object)"attributes", (Object)SectionBasedDocString.FieldType.NAME_WITH_OPTIONAL_TYPE).put((Object)"other parameters", (Object)SectionBasedDocString.FieldType.NAME_WITH_OPTIONAL_TYPE).build();
    private Substring mySignature;

    public NumpyDocString(@NotNull Substring text2) {
        if (text2 == null) {
            NumpyDocString.$$$reportNull$$$0(0);
        }
        super(text2);
    }

    @Override
    protected int parseHeader(int startLine) {
        int nextNonEmptyLineNum = this.consumeEmptyLines(startLine);
        Substring line2 = this.getLineOrNull(nextNonEmptyLineNum);
        if (line2 != null && SIGNATURE.matcher(line2).matches()) {
            this.mySignature = line2.trim();
            return nextNonEmptyLineNum + 1;
        }
        return nextNonEmptyLineNum;
    }

    @Override
    @Nullable
    protected SectionBasedDocString.FieldType getFieldType(@NotNull String title) {
        if (title == null) {
            NumpyDocString.$$$reportNull$$$0(1);
        }
        return (SectionBasedDocString.FieldType)((Object)ourSectionFieldMapping.get((Object)title));
    }

    @Override
    @NotNull
    protected Pair<Substring, Integer> parseSectionHeader(int lineNum) {
        Substring nextLine;
        @NonNls String title = this.getLine(lineNum).trim().toString();
        if (SECTION_NAMES.contains(StringUtil.toLowerCase((String)title)) && (nextLine = this.getLineOrNull(lineNum + 1)) != null && SECTION_HEADER.matcher(nextLine).matches()) {
            Pair pair = Pair.create((Object)this.getLine(lineNum).trim(), (Object)(lineNum + 2));
            if (pair == null) {
                NumpyDocString.$$$reportNull$$$0(2);
            }
            return pair;
        }
        Pair pair = Pair.create(null, (Object)lineNum);
        if (pair == null) {
            NumpyDocString.$$$reportNull$$$0(3);
        }
        return pair;
    }

    @Override
    protected int getSectionIndentationThreshold(int sectionIndent) {
        return sectionIndent - 1;
    }

    @Override
    protected Pair<SectionBasedDocString.SectionField, Integer> parseSectionField(int lineNum, int sectionIndent, @NotNull SectionBasedDocString.FieldType kind) {
        Substring namesPart;
        if (kind == null) {
            NumpyDocString.$$$reportNull$$$0(4);
        }
        Substring line2 = this.getLine(lineNum);
        Substring type = null;
        Substring description = null;
        if (kind.canHaveBothNameAndType) {
            List<Substring> colonSeparatedParts = NumpyDocString.splitByFirstColon(line2);
            namesPart = colonSeparatedParts.get(0).trim();
            if (colonSeparatedParts.size() == 2) {
                type = colonSeparatedParts.get(1).trim();
            }
        } else {
            namesPart = line2.trim();
        }
        if (kind.preferType && type == null) {
            type = namesPart;
            namesPart = null;
        }
        ArrayList<Substring> names2 = new ArrayList<Substring>();
        if (namesPart != null) {
            for (Substring name2 : namesPart.split(NAME_SEPARATOR)) {
                Substring identifier = NumpyDocString.cleanUpName(name2);
                if (!this.isValidName(identifier.toString())) {
                    return Pair.create(null, (Object)lineNum);
                }
                names2.add(identifier);
            }
        }
        if (namesPart == null && !this.isValidType(type.toString())) {
            return Pair.create(null, (Object)lineNum);
        }
        Pair<List<Substring>, Integer> parsedDescription = this.parseIndentedBlock(lineNum + 1, this.getLineIndentSize(lineNum));
        List descriptionLines = (List)parsedDescription.getFirst();
        if (!descriptionLines.isEmpty()) {
            description = ((Substring)descriptionLines.get(0)).union((Substring)descriptionLines.get(descriptionLines.size() - 1));
        }
        return Pair.create((Object)new SectionBasedDocString.SectionField(names2, type, description != null ? description.trim() : null), (Object)((Integer)parsedDescription.getSecond()));
    }

    @NotNull
    public String getSignature() {
        return this.mySignature != null ? this.mySignature.toString() : "";
    }

    @Override
    protected boolean isBlockEnd(int lineNum) {
        return super.isBlockEnd(lineNum) || this.isEmpty(lineNum) && this.isEmptyOrDoesNotExist(lineNum + 1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/documentation/docstrings/NumpyDocString";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/documentation/docstrings/NumpyDocString";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parseSectionHeader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getFieldType";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseSectionField";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

