/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.formatter;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonCodeStyleService;
import com.jetbrains.python.PythonDialectsTokenSetProvider;
import com.jetbrains.python.codeInsight.imports.AddImportHelper;
import com.jetbrains.python.formatter.PyBlockContext;
import com.jetbrains.python.formatter.PyCodeStyleSettings;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyComprehensionElement;
import com.jetbrains.python.psi.PyConditionalStatementPart;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyElsePart;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyForStatement;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyIfPart;
import com.jetbrains.python.psi.PyIfStatement;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyNoneLiteralExpression;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyPassStatement;
import com.jetbrains.python.psi.PyRaiseStatement;
import com.jetbrains.python.psi.PyReturnStatement;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PySliceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStatementListContainer;
import com.jetbrains.python.psi.PyStatementPart;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTryExceptStatement;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.PyWhileStatement;
import com.jetbrains.python.psi.PyWithItem;
import com.jetbrains.python.psi.PyWithStatement;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.pyi.PyiUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyBlock
implements ASTBlock {
    private static final TokenSet STATEMENT_OR_DECLARATION = PythonDialectsTokenSetProvider.getInstance().getStatementTokens();
    private static final TokenSet ourListElementTypes = TokenSet.create((IElementType[])new IElementType[]{PyElementTypes.LIST_LITERAL_EXPRESSION, PyElementTypes.LIST_COMP_EXPRESSION, PyElementTypes.DICT_LITERAL_EXPRESSION, PyElementTypes.DICT_COMP_EXPRESSION, PyElementTypes.SET_LITERAL_EXPRESSION, PyElementTypes.SET_COMP_EXPRESSION, PyElementTypes.ARGUMENT_LIST, PyElementTypes.PARAMETER_LIST, PyElementTypes.TUPLE_EXPRESSION, PyElementTypes.PARENTHESIZED_EXPRESSION, PyElementTypes.SLICE_EXPRESSION, PyElementTypes.SUBSCRIPTION_EXPRESSION, PyElementTypes.GENERATOR_EXPRESSION, PyElementTypes.SEQUENCE_PATTERN, PyElementTypes.MAPPING_PATTERN, PyElementTypes.PATTERN_ARGUMENT_LIST});
    private static final TokenSet ourCollectionLiteralTypes = TokenSet.create((IElementType[])new IElementType[]{PyElementTypes.LIST_LITERAL_EXPRESSION, PyElementTypes.LIST_COMP_EXPRESSION, PyElementTypes.DICT_LITERAL_EXPRESSION, PyElementTypes.DICT_COMP_EXPRESSION, PyElementTypes.SET_LITERAL_EXPRESSION, PyElementTypes.SET_COMP_EXPRESSION});
    private static final TokenSet ourHangingIndentOwners = TokenSet.create((IElementType[])new IElementType[]{PyElementTypes.LIST_LITERAL_EXPRESSION, PyElementTypes.LIST_COMP_EXPRESSION, PyElementTypes.DICT_LITERAL_EXPRESSION, PyElementTypes.DICT_COMP_EXPRESSION, PyElementTypes.SET_LITERAL_EXPRESSION, PyElementTypes.SET_COMP_EXPRESSION, PyElementTypes.ARGUMENT_LIST, PyElementTypes.PARAMETER_LIST, PyElementTypes.TUPLE_EXPRESSION, PyElementTypes.PARENTHESIZED_EXPRESSION, PyElementTypes.GENERATOR_EXPRESSION, PyElementTypes.FUNCTION_DECLARATION, PyElementTypes.CALL_EXPRESSION, PyElementTypes.FROM_IMPORT_STATEMENT, PyElementTypes.SEQUENCE_PATTERN, PyElementTypes.MAPPING_PATTERN, PyElementTypes.PATTERN_ARGUMENT_LIST, PyElementTypes.WITH_STATEMENT});
    private static final boolean ALIGN_CONDITIONS_WITHOUT_PARENTHESES = false;
    private final PyBlock myParent;
    private final Alignment myAlignment;
    private final Indent myIndent;
    private final ASTNode myNode;
    private final Wrap myWrap;
    private final PyBlockContext myContext;
    private List<PyBlock> mySubBlocks;
    private Map<ASTNode, PyBlock> mySubBlockByNode;
    private final boolean myEmptySequence;
    private Alignment myChildAlignment;
    private Alignment myDictAlignment;
    private Wrap myDictWrapping;
    private Wrap myFromImportWrapping;
    private Wrap myParameterListWrapping;
    private Wrap myArgumentListWrapping;
    private static final TokenSet stopAtTokens = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{PyElementTypes.FSTRING_NODE}), PythonDialectsTokenSetProvider.getInstance().getStatementTokens()});

    public PyBlock(@Nullable PyBlock parent, @NotNull ASTNode node, @Nullable Alignment alignment, @NotNull Indent indent, @Nullable Wrap wrap, @NotNull PyBlockContext context2) {
        if (node == null) {
            PyBlock.$$$reportNull$$$0(0);
        }
        if (indent == null) {
            PyBlock.$$$reportNull$$$0(1);
        }
        if (context2 == null) {
            PyBlock.$$$reportNull$$$0(2);
        }
        this.mySubBlocks = null;
        this.mySubBlockByNode = null;
        this.myChildAlignment = null;
        this.myDictAlignment = null;
        this.myDictWrapping = null;
        this.myFromImportWrapping = null;
        this.myParameterListWrapping = null;
        this.myArgumentListWrapping = null;
        this.myParent = parent;
        this.myAlignment = alignment;
        this.myIndent = indent;
        this.myNode = node;
        this.myWrap = wrap;
        this.myContext = context2;
        this.myEmptySequence = PyBlock.isEmptySequence(node);
        CommonCodeStyleSettings settings = this.myContext.getSettings();
        PyCodeStyleSettings pySettings = this.myContext.getPySettings();
        if (node.getElementType() == PyElementTypes.DICT_LITERAL_EXPRESSION) {
            this.myDictAlignment = Alignment.createAlignment((boolean)true);
            this.myDictWrapping = Wrap.createWrap((int)pySettings.DICT_WRAPPING, (boolean)true);
        } else if (node.getElementType() == PyElementTypes.FROM_IMPORT_STATEMENT) {
            this.myFromImportWrapping = Wrap.createWrap((int)pySettings.FROM_IMPORT_WRAPPING, (boolean)false);
        } else if (node.getElementType() == PyElementTypes.PARAMETER_LIST) {
            this.myParameterListWrapping = Wrap.createWrap((int)settings.METHOD_PARAMETERS_WRAP, (boolean)settings.METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE);
        } else if (node.getElementType() == PyElementTypes.ARGUMENT_LIST) {
            this.myArgumentListWrapping = Wrap.createWrap((int)settings.CALL_PARAMETERS_WRAP, (boolean)settings.CALL_PARAMETERS_LPAREN_ON_NEXT_LINE);
        }
    }

    @NotNull
    public ASTNode getNode() {
        ASTNode aSTNode = this.myNode;
        if (aSTNode == null) {
            PyBlock.$$$reportNull$$$0(3);
        }
        return aSTNode;
    }

    @NotNull
    public TextRange getTextRange() {
        TextRange textRange = this.myNode.getTextRange();
        if (textRange == null) {
            PyBlock.$$$reportNull$$$0(4);
        }
        return textRange;
    }

    private Alignment getAlignmentForChildren() {
        if (this.myChildAlignment == null) {
            this.myChildAlignment = Alignment.createAlignment();
        }
        return this.myChildAlignment;
    }

    @NotNull
    public List<Block> getSubBlocks() {
        if (this.mySubBlocks == null) {
            this.mySubBlockByNode = this.buildSubBlocks();
            this.mySubBlocks = new ArrayList<PyBlock>(this.mySubBlockByNode.values());
        }
        List<PyBlock> list = Collections.unmodifiableList(this.mySubBlocks);
        if (list == null) {
            PyBlock.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Nullable
    private PyBlock getSubBlockByNode(@NotNull ASTNode node) {
        if (node == null) {
            PyBlock.$$$reportNull$$$0(6);
        }
        return this.mySubBlockByNode.get(node);
    }

    @Nullable
    private PyBlock getSubBlockByIndex(int index) {
        return this.mySubBlocks.get(index);
    }

    @NotNull
    private Map<ASTNode, PyBlock> buildSubBlocks() {
        LinkedHashMap<ASTNode, PyBlock> blocks = new LinkedHashMap<ASTNode, PyBlock>();
        for (ASTNode child : this.getSubBlockNodes()) {
            IElementType childType = child.getElementType();
            if (child.getTextRange().isEmpty() || childType == TokenType.WHITE_SPACE) continue;
            blocks.put(child, this.buildSubBlock(child));
        }
        Map<ASTNode, PyBlock> map2 = Collections.unmodifiableMap(blocks);
        if (map2 == null) {
            PyBlock.$$$reportNull$$$0(7);
        }
        return map2;
    }

    @NotNull
    protected Iterable<ASTNode> getSubBlockNodes() {
        if (this.myNode.getElementType() == PyElementTypes.BINARY_EXPRESSION) {
            ArrayList<ASTNode> result = new ArrayList<ASTNode>();
            PyBlock.collectChildrenOperatorAndOperandNodes(this.myNode, result);
            ArrayList<ASTNode> arrayList = result;
            if (arrayList == null) {
                PyBlock.$$$reportNull$$$0(8);
            }
            return arrayList;
        }
        List<ASTNode> list = Arrays.asList(this.myNode.getChildren(null));
        if (list == null) {
            PyBlock.$$$reportNull$$$0(9);
        }
        return list;
    }

    private static void collectChildrenOperatorAndOperandNodes(@NotNull ASTNode node, @NotNull List<ASTNode> result) {
        if (node == null) {
            PyBlock.$$$reportNull$$$0(10);
        }
        if (result == null) {
            PyBlock.$$$reportNull$$$0(11);
        }
        if (node.getElementType() == PyElementTypes.BINARY_EXPRESSION) {
            for (ASTNode child : node.getChildren(null)) {
                PyBlock.collectChildrenOperatorAndOperandNodes(child, result);
            }
        } else {
            result.add(node);
        }
    }

    @NotNull
    private PyBlock buildSubBlock(@NotNull ASTNode child) {
        PyCodeStyleSettings settings;
        Alignment childAlignment;
        Indent childIndent;
        Wrap childWrap;
        IElementType childType;
        IElementType parentType;
        block57: {
            block65: {
                block66: {
                    block64: {
                        block62: {
                            block63: {
                                block61: {
                                    block60: {
                                        block59: {
                                            block58: {
                                                block56: {
                                                    if (child == null) {
                                                        PyBlock.$$$reportNull$$$0(12);
                                                    }
                                                    parentType = this.myNode.getElementType();
                                                    ASTNode grandParentNode = this.myNode.getTreeParent();
                                                    IElementType grandparentType = grandParentNode == null ? null : grandParentNode.getElementType();
                                                    childType = child.getElementType();
                                                    childWrap = null;
                                                    childIndent = Indent.getNoneIndent();
                                                    childAlignment = null;
                                                    settings = this.myContext.getPySettings();
                                                    if (childType == PyElementTypes.STATEMENT_LIST) {
                                                        if (PyBlock.hasLineBreaksBeforeInSameParent(child, 1) || this.needLineBreakInStatement()) {
                                                            childIndent = Indent.getNormalIndent();
                                                        }
                                                    } else if (childType == PyElementTypes.CASE_CLAUSE) {
                                                        childIndent = Indent.getNormalIndent();
                                                    } else if (childType == PyElementTypes.IMPORT_ELEMENT) {
                                                        childWrap = parentType == PyElementTypes.FROM_IMPORT_STATEMENT ? this.myFromImportWrapping : Wrap.createWrap((WrapType)WrapType.NORMAL, (boolean)true);
                                                        childIndent = Indent.getNormalIndent();
                                                    }
                                                    if (childType == PyTokenTypes.END_OF_LINE_COMMENT && (parentType == PyElementTypes.FROM_IMPORT_STATEMENT || parentType == PyElementTypes.MATCH_STATEMENT)) {
                                                        childIndent = Indent.getNormalIndent();
                                                    }
                                                    if (ourListElementTypes.contains(parentType)) {
                                                        if (!(parentType == PyElementTypes.TUPLE_EXPRESSION && grandparentType != PyElementTypes.PARENTHESIZED_EXPRESSION || PyTokenTypes.ALL_BRACES.contains(childType) || childType == PyTokenTypes.COMMA || this.isSliceOperand(child))) {
                                                            childWrap = Wrap.createWrap((WrapType)WrapType.NORMAL, (boolean)true);
                                                        }
                                                        if (this.needListAlignment(child) && !this.myEmptySequence) {
                                                            childAlignment = this.getAlignmentForChildren();
                                                        }
                                                        if (childType == PyTokenTypes.END_OF_LINE_COMMENT) {
                                                            childIndent = Indent.getNormalIndent();
                                                        }
                                                    }
                                                    if (parentType != PyElementTypes.BINARY_EXPRESSION) break block56;
                                                    if (childType != PyElementTypes.BINARY_EXPRESSION) {
                                                        boolean parenthesised;
                                                        PyBlock topmostBinary = this.findTopmostBinaryExpressionBlock(child);
                                                        assert (topmostBinary != null);
                                                        PyBlock binaryParentBlock = topmostBinary.myParent;
                                                        ASTNode binaryParentNode = binaryParentBlock.myNode;
                                                        IElementType binaryParentType = binaryParentNode.getElementType();
                                                        if (ourListElementTypes.contains(binaryParentType) && this.needListAlignment(child) && !this.myEmptySequence) {
                                                            childAlignment = binaryParentBlock.getChildAlignment();
                                                        }
                                                        boolean bl = parenthesised = binaryParentType == PyElementTypes.PARENTHESIZED_EXPRESSION;
                                                        if (!(childAlignment != null || topmostBinary == null || parenthesised && PyBlock.isIfCondition(binaryParentNode) || PyBlock.isCondition(topmostBinary.myNode))) {
                                                            childAlignment = topmostBinary.getAlignmentForChildren();
                                                        }
                                                        childIndent = parenthesised ? Indent.getContinuationIndent() : Indent.getContinuationWithoutFirstIndent();
                                                    }
                                                    break block57;
                                                }
                                                if (parentType != PyElementTypes.OR_PATTERN) break block58;
                                                childAlignment = this.getAlignmentForChildren();
                                                break block57;
                                            }
                                            if (parentType != PyElementTypes.SEQUENCE_PATTERN && parentType != PyElementTypes.MAPPING_PATTERN) break block59;
                                            childIndent = PyTokenTypes.CLOSE_BRACES.contains(childType) && !settings.HANG_CLOSING_BRACKETS || PyTokenTypes.OPEN_BRACES.contains(childType) ? Indent.getNoneIndent() : Indent.getNormalIndent();
                                            break block57;
                                        }
                                        if (!ourCollectionLiteralTypes.contains(parentType)) break block60;
                                        childIndent = PyTokenTypes.CLOSE_BRACES.contains(childType) && !settings.HANG_CLOSING_BRACKETS || PyTokenTypes.OPEN_BRACES.contains(childType) ? Indent.getNoneIndent() : (settings.USE_CONTINUATION_INDENT_FOR_COLLECTION_AND_COMPREHENSIONS ? Indent.getContinuationIndent() : Indent.getNormalIndent());
                                        break block57;
                                    }
                                    if (parentType != PyElementTypes.STRING_LITERAL_EXPRESSION) break block61;
                                    if (PyTokenTypes.STRING_NODES.contains(childType) || childType == PyElementTypes.FSTRING_NODE) {
                                        childAlignment = this.getAlignmentForChildren();
                                    }
                                    break block57;
                                }
                                if (parentType != PyElementTypes.FROM_IMPORT_STATEMENT) break block62;
                                if (this.myNode.findChildByType((IElementType)PyTokenTypes.LPAR) == null) break block57;
                                if (childType == PyElementTypes.IMPORT_ELEMENT) {
                                    if (settings.ALIGN_MULTILINE_IMPORTS) {
                                        childAlignment = this.getAlignmentForChildren();
                                    } else {
                                        childIndent = Indent.getNormalIndent();
                                    }
                                }
                                if (childType != PyTokenTypes.RPAR) break block57;
                                childIndent = Indent.getNoneIndent();
                                if (PyBlock.hasHangingIndent(this.myNode.getPsi()) || settings.FROM_IMPORT_NEW_LINE_AFTER_LEFT_PARENTHESIS) break block63;
                                childAlignment = this.getAlignmentForChildren();
                                break block57;
                            }
                            if (!settings.HANG_CLOSING_BRACKETS) break block57;
                            childIndent = Indent.getNormalIndent();
                            break block57;
                        }
                        if (!PyBlock.isValueOfKeyValuePair(child)) break block64;
                        childIndent = Indent.getNormalIndent();
                        break block57;
                    }
                    if (PyBlock.hasHangingIndent(this.myNode.getPsi()) || parentType != PyElementTypes.PARENTHESIZED_EXPRESSION && (parentType != PyElementTypes.ARGUMENT_LIST || !this.myContext.getSettings().ALIGN_MULTILINE_PARAMETERS_IN_CALLS) && (parentType != PyElementTypes.PARAMETER_LIST || !this.myContext.getSettings().ALIGN_MULTILINE_PARAMETERS) || PyBlock.isIndentNext(child) || PyBlock.hasLineBreaksBeforeInSameParent(this.myNode.getFirstChildNode(), 1) || ourListElementTypes.contains(childType)) break block65;
                    if (PyTokenTypes.ALL_BRACES.contains(childType)) break block66;
                    childAlignment = this.getAlignmentForChildren();
                    if (parentType != PyElementTypes.CALL_EXPRESSION) {
                        childIndent = Indent.getNormalIndent();
                    }
                    break block57;
                }
                if (childType != PyTokenTypes.RPAR) break block57;
                childIndent = Indent.getNoneIndent();
                break block57;
            }
            if (this.myNode.getElementType() == PyElementTypes.SLICE_ITEM) {
                childAlignment = this.getChildAlignment();
            } else if (parentType == PyElementTypes.GENERATOR_EXPRESSION || parentType == PyElementTypes.PARENTHESIZED_EXPRESSION) {
                boolean tupleOrGenerator;
                boolean bl = tupleOrGenerator = parentType == PyElementTypes.GENERATOR_EXPRESSION || ((PyParenthesizedExpression)this.myNode.getPsi(PyParenthesizedExpression.class)).getContainedExpression() instanceof PyTupleExpression;
                if (!((childType != PyTokenTypes.RPAR || tupleOrGenerator && settings.HANG_CLOSING_BRACKETS) && PyBlock.hasLineBreaksBeforeInSameParent(child, 1))) {
                    childIndent = Indent.getNoneIndent();
                } else if (childType == PyElementTypes.BINARY_EXPRESSION && parentType == PyElementTypes.PARENTHESIZED_EXPRESSION) {
                    childIndent = Indent.getNoneIndent();
                } else {
                    boolean useWiderIndent = PyBlock.isIndentNext(child) || settings.USE_CONTINUATION_INDENT_FOR_COLLECTION_AND_COMPREHENSIONS;
                    childIndent = useWiderIndent ? Indent.getContinuationIndent() : Indent.getNormalIndent();
                }
            } else if (parentType == PyElementTypes.ARGUMENT_LIST || parentType == PyElementTypes.PATTERN_ARGUMENT_LIST || parentType == PyElementTypes.PARAMETER_LIST) {
                childIndent = childType == PyTokenTypes.RPAR && !settings.HANG_CLOSING_BRACKETS ? Indent.getNoneIndent() : (parentType == PyElementTypes.PARAMETER_LIST && settings.USE_CONTINUATION_INDENT_FOR_PARAMETERS || parentType == PyElementTypes.ARGUMENT_LIST && settings.USE_CONTINUATION_INDENT_FOR_ARGUMENTS || this.argumentMayHaveSameIndentAsFollowingStatementList() ? Indent.getContinuationIndent() : Indent.getNormalIndent());
            } else if (parentType == PyElementTypes.SUBSCRIPTION_EXPRESSION) {
                PyExpression indexExpression = ((PySubscriptionExpression)this.myNode.getPsi()).getIndexExpression();
                if (indexExpression != null && child == indexExpression.getNode()) {
                    childIndent = Indent.getNormalIndent();
                }
            } else if (parentType == PyElementTypes.REFERENCE_EXPRESSION && child != this.myNode.getFirstChildNode()) {
                childIndent = Indent.getNoneIndent();
                if (PyBlock.hasLineBreaksBeforeInSameParent(child, 1)) {
                    if (this.isInControlStatement()) {
                        childIndent = Indent.getContinuationIndent();
                    } else {
                        PyBlock b = this.myParent;
                        while (b != null) {
                            if (b.getNode().getPsi() instanceof PyParenthesizedExpression || b.getNode().getPsi() instanceof PyArgumentList || b.getNode().getPsi() instanceof PyParameterList) {
                                childAlignment = PyBlock.getAlignmentOfChild(b, 1);
                                break;
                            }
                            b = b.myParent;
                        }
                    }
                }
            }
        }
        if (childType == PyElementTypes.KEY_VALUE_EXPRESSION && PyBlock.isChildOfDictLiteral(child)) {
            childWrap = this.myDictWrapping;
        }
        if (parentType == PyElementTypes.PARAMETER_LIST && childType != PyTokenTypes.COMMA && childType != PyTokenTypes.LPAR && childType != PyTokenTypes.RPAR) {
            childWrap = this.myParameterListWrapping;
        }
        if (parentType == PyElementTypes.ARGUMENT_LIST && childType != PyTokenTypes.COMMA && childType != PyTokenTypes.LPAR && childType != PyTokenTypes.RPAR) {
            childWrap = this.myArgumentListWrapping;
        }
        if (PyBlock.isAfterStatementList(child) && !PyBlock.hasLineBreaksBeforeInSameParent(child, 2) && child.getElementType() != PyTokenTypes.END_OF_LINE_COMMENT) {
            childIndent = Indent.getNormalIndent();
        }
        if (settings.DICT_ALIGNMENT == PyCodeStyleSettings.DICT_ALIGNMENT_ON_VALUE) {
            if (PyBlock.isValueOfKeyValuePairOfDictLiteral(child) && !PyBlock.isOpeningBracket(child.getFirstChildNode())) {
                childAlignment = this.myParent.myDictAlignment;
            } else if (PyBlock.isValueOfKeyValuePairOfDictLiteral(this.myNode) && PyBlock.isOpeningBracket(child)) {
                childAlignment = this.myParent.myParent.myDictAlignment;
            }
        } else if (this.myContext.getPySettings().DICT_ALIGNMENT == PyCodeStyleSettings.DICT_ALIGNMENT_ON_COLON && PyBlock.isChildOfKeyValuePairOfDictLiteral(child) && childType == PyTokenTypes.COLON) {
            childAlignment = this.myParent.myDictAlignment;
        }
        if (parentType == PyElementTypes.WITH_STATEMENT && PyBlock.isInsideWithStatementParentheses(this.myNode, child)) {
            if (this.needListAlignment(child)) {
                childAlignment = this.getAlignmentForChildren();
            } else {
                childIndent = Indent.getNormalIndent();
            }
            if (childType == PyTokenTypes.RPAR && !settings.HANG_CLOSING_BRACKETS) {
                childIndent = Indent.getNoneIndent();
            }
        }
        for (ASTNode prev = child.getTreePrev(); prev != null && prev.getElementType() == TokenType.WHITE_SPACE; prev = prev.getTreePrev()) {
            if (!prev.textContains('\\') || childIndent.equals(Indent.getContinuationIndent((boolean)false)) || childIndent.equals(Indent.getContinuationIndent((boolean)true))) continue;
            childIndent = PyBlock.isIndentNext(child) ? Indent.getContinuationIndent() : Indent.getNormalIndent();
            break;
        }
        if (TreeUtil.findParent((ASTNode)child, (IElementType)PyElementTypes.FSTRING_FRAGMENT) != null) {
            childWrap = Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false);
        }
        return new PyBlock(this, child, childAlignment, childIndent, childWrap, this.myContext);
    }

    private static boolean isInsideWithStatementParentheses(@NotNull ASTNode withStatement, @NotNull ASTNode node) {
        ASTNode openingParenthesis;
        if (withStatement == null) {
            PyBlock.$$$reportNull$$$0(13);
        }
        if (node == null) {
            PyBlock.$$$reportNull$$$0(14);
        }
        if ((openingParenthesis = withStatement.findChildByType((IElementType)PyTokenTypes.LPAR)) == null) {
            return false;
        }
        if (node.getStartOffset() < openingParenthesis.getStartOffset()) {
            return false;
        }
        ASTNode closingParenthesis = withStatement.findChildByType((IElementType)PyTokenTypes.RPAR);
        if (closingParenthesis != null) {
            return node.getStartOffset() <= closingParenthesis.getStartOffset();
        }
        ASTNode afterParentheses = (ASTNode)ObjectUtils.chooseNotNull((Object)withStatement.findChildByType((IElementType)PyTokenTypes.COLON), (Object)withStatement.findChildByType((IElementType)PyElementTypes.STATEMENT_LIST));
        return afterParentheses == null || node.getStartOffset() < afterParentheses.getStartOffset();
    }

    private static boolean isIfCondition(@NotNull ASTNode node) {
        PsiElement element;
        PyIfPart ifPart;
        if (node == null) {
            PyBlock.$$$reportNull$$$0(15);
        }
        return (ifPart = PyUtil.as((element = node.getPsi()).getParent(), PyIfPart.class)) != null && ifPart.getCondition() == element && !ifPart.isElif();
    }

    private static boolean isCondition(@NotNull ASTNode node) {
        PsiElement element;
        PyConditionalStatementPart conditionalStatement;
        if (node == null) {
            PyBlock.$$$reportNull$$$0(16);
        }
        return (conditionalStatement = PyUtil.as((element = node.getPsi()).getParent(), PyConditionalStatementPart.class)) != null && conditionalStatement.getCondition() == element;
    }

    @Nullable
    private PyBlock findTopmostBinaryExpressionBlock(@NotNull ASTNode child) {
        if (child == null) {
            PyBlock.$$$reportNull$$$0(17);
        }
        assert (child.getElementType() != PyElementTypes.BINARY_EXPRESSION);
        PyBlock parentBlock = this;
        PyBlock alignmentOwner = null;
        while (parentBlock != null && parentBlock.myNode.getElementType() == PyElementTypes.BINARY_EXPRESSION) {
            alignmentOwner = parentBlock;
            parentBlock = parentBlock.myParent;
        }
        return alignmentOwner;
    }

    private static boolean isOpeningBracket(@Nullable ASTNode node) {
        return node != null && PyTokenTypes.OPEN_BRACES.contains(node.getElementType()) && node == node.getTreeParent().getFirstChildNode();
    }

    private static boolean isValueOfKeyValuePairOfDictLiteral(@NotNull ASTNode node) {
        if (node == null) {
            PyBlock.$$$reportNull$$$0(18);
        }
        return PyBlock.isValueOfKeyValuePair(node) && PyBlock.isChildOfDictLiteral(node.getTreeParent());
    }

    private static boolean isChildOfKeyValuePairOfDictLiteral(@NotNull ASTNode node) {
        if (node == null) {
            PyBlock.$$$reportNull$$$0(19);
        }
        return PyBlock.isChildOfKeyValuePair(node) && PyBlock.isChildOfDictLiteral(node.getTreeParent());
    }

    private static boolean isChildOfDictLiteral(@NotNull ASTNode node) {
        ASTNode nodeParent;
        if (node == null) {
            PyBlock.$$$reportNull$$$0(20);
        }
        return (nodeParent = node.getTreeParent()) != null && nodeParent.getElementType() == PyElementTypes.DICT_LITERAL_EXPRESSION;
    }

    private static boolean isChildOfKeyValuePair(@NotNull ASTNode node) {
        ASTNode nodeParent;
        if (node == null) {
            PyBlock.$$$reportNull$$$0(21);
        }
        return (nodeParent = node.getTreeParent()) != null && nodeParent.getElementType() == PyElementTypes.KEY_VALUE_EXPRESSION;
    }

    private static boolean isValueOfKeyValuePair(@NotNull ASTNode node) {
        if (node == null) {
            PyBlock.$$$reportNull$$$0(22);
        }
        return PyBlock.isChildOfKeyValuePair(node) && ((PyKeyValueExpression)node.getTreeParent().getPsi(PyKeyValueExpression.class)).getValue() == node.getPsi();
    }

    private static boolean isEmptySequence(@NotNull ASTNode node) {
        if (node == null) {
            PyBlock.$$$reportNull$$$0(23);
        }
        return node.getPsi() instanceof PySequenceExpression && ((PySequenceExpression)node.getPsi()).isEmpty();
    }

    private boolean argumentMayHaveSameIndentAsFollowingStatementList() {
        if (this.myNode.getElementType() != PyElementTypes.ARGUMENT_LIST) {
            return false;
        }
        PsiElement header = PyBlock.getControlStatementHeader(this.myNode);
        if (header instanceof PyStatementListContainer) {
            PyStatementList statementList = ((PyStatementListContainer)header).getStatementList();
            return PyUtil.onSameLine(header, this.myNode.getPsi()) && !PyUtil.onSameLine(header, (PsiElement)statementList);
        }
        return false;
    }

    private static boolean hasHangingIndent(@NotNull PsiElement elem) {
        if (elem == null) {
            PyBlock.$$$reportNull$$$0(24);
        }
        if (elem instanceof PyCallExpression) {
            PyArgumentList argumentList = ((PyCallExpression)elem).getArgumentList();
            return argumentList != null && PyBlock.hasHangingIndent((PsiElement)argumentList);
        }
        if (elem instanceof PyFunction) {
            return PyBlock.hasHangingIndent((PsiElement)((PyFunction)elem).getParameterList());
        }
        PsiElement firstChild = elem instanceof PyFromImportStatement ? ((PyFromImportStatement)elem).getLeftParen() : (elem instanceof PyWithStatement ? PyPsiUtils.getFirstChildOfType(elem, PyTokenTypes.LPAR) : elem.getFirstChild());
        if (firstChild == null) {
            return false;
        }
        IElementType elementType = elem.getNode().getElementType();
        ASTNode firstChildNode = firstChild.getNode();
        if (ourHangingIndentOwners.contains(elementType) && PyTokenTypes.OPEN_BRACES.contains(firstChildNode.getElementType())) {
            if (PyBlock.hasLineBreakAfterIgnoringComments(firstChildNode)) {
                return true;
            }
            PsiElement firstItem = PyBlock.getFirstItem(elem);
            if (firstItem == null) {
                return !PyTokenTypes.CLOSE_BRACES.contains(elem.getLastChild().getNode().getElementType());
            }
            if (firstItem instanceof PyNamedParameter) {
                PyExpression defaultValue = ((PyNamedParameter)firstItem).getDefaultValue();
                return defaultValue != null && PyBlock.hasHangingIndent((PsiElement)defaultValue);
            }
            if (firstItem instanceof PyKeywordArgument) {
                PyExpression valueExpression = ((PyKeywordArgument)firstItem).getValueExpression();
                return valueExpression != null && PyBlock.hasHangingIndent((PsiElement)valueExpression);
            }
            if (firstItem instanceof PyKeyValueExpression) {
                PyExpression value = ((PyKeyValueExpression)firstItem).getValue();
                return value != null && PyBlock.hasHangingIndent((PsiElement)value);
            }
            if (firstItem instanceof PyWithItem) {
                PyExpression contextExpression = ((PyWithItem)firstItem).getExpression();
                return PyBlock.hasHangingIndent((PsiElement)contextExpression);
            }
            return PyBlock.hasHangingIndent(firstItem);
        }
        return false;
    }

    @Nullable
    private static PsiElement getFirstItem(@NotNull PsiElement elem) {
        if (elem == null) {
            PyBlock.$$$reportNull$$$0(25);
        }
        Object[] items = PsiElement.EMPTY_ARRAY;
        if (elem instanceof PySequenceExpression) {
            items = ((PySequenceExpression)elem).getElements();
        } else if (elem instanceof PyParameterList) {
            items = ((PyParameterList)elem).getParameters();
        } else if (elem instanceof PyArgumentList) {
            items = ((PyArgumentList)elem).getArguments();
        } else if (elem instanceof PyFromImportStatement) {
            items = ((PyFromImportStatement)elem).getImportElements();
        } else if (elem instanceof PyWithStatement) {
            items = ((PyWithStatement)elem).getWithItems();
        } else if (elem instanceof PyParenthesizedExpression) {
            PyExpression containedExpression = ((PyParenthesizedExpression)elem).getContainedExpression();
            if (containedExpression instanceof PyTupleExpression) {
                items = ((PyTupleExpression)containedExpression).getElements();
            } else if (containedExpression != null) {
                return containedExpression;
            }
        } else if (elem instanceof PyComprehensionElement) {
            return ((PyComprehensionElement)elem).getResultExpression();
        }
        return (PsiElement)ArrayUtil.getFirstElement((Object[])items);
    }

    private static boolean breaksAlignment(IElementType type) {
        return type != PyElementTypes.BINARY_EXPRESSION;
    }

    private static Alignment getAlignmentOfChild(@NotNull PyBlock b, int childNum) {
        if (b == null) {
            PyBlock.$$$reportNull$$$0(26);
        }
        if (b.getSubBlocks().size() > childNum) {
            ChildAttributes attributes = b.getChildAttributes(childNum);
            return attributes.getAlignment();
        }
        return null;
    }

    private static boolean isIndentNext(@NotNull ASTNode child) {
        PsiElement psi;
        if (child == null) {
            PyBlock.$$$reportNull$$$0(27);
        }
        return (psi = PsiTreeUtil.getParentOfType((PsiElement)child.getPsi(), PyStatement.class)) instanceof PyIfStatement || psi instanceof PyForStatement || psi instanceof PyWithStatement || psi instanceof PyClass || psi instanceof PyFunction || psi instanceof PyTryExceptStatement || psi instanceof PyElsePart || psi instanceof PyIfPart || psi instanceof PyWhileStatement;
    }

    private static boolean isSubscriptionOperand(@NotNull ASTNode child) {
        if (child == null) {
            PyBlock.$$$reportNull$$$0(28);
        }
        return child.getTreeParent().getElementType() == PyElementTypes.SUBSCRIPTION_EXPRESSION && child.getPsi() == ((PySubscriptionExpression)child.getTreeParent().getPsi()).getOperand();
    }

    private boolean isInControlStatement() {
        return PyBlock.getControlStatementHeader(this.myNode) != null;
    }

    @Nullable
    private static PsiElement getControlStatementHeader(@NotNull ASTNode node) {
        PyStatementPart statementPart;
        if (node == null) {
            PyBlock.$$$reportNull$$$0(29);
        }
        if ((statementPart = (PyStatementPart)PsiTreeUtil.getParentOfType((PsiElement)node.getPsi(), PyStatementPart.class, (boolean)false, (Class[])new Class[]{PyStatementList.class})) != null) {
            return statementPart;
        }
        PyWithItem withItem = (PyWithItem)PsiTreeUtil.getParentOfType((PsiElement)node.getPsi(), PyWithItem.class);
        if (withItem != null) {
            return withItem.getParent();
        }
        return null;
    }

    private boolean isSliceOperand(@NotNull ASTNode child) {
        if (child == null) {
            PyBlock.$$$reportNull$$$0(30);
        }
        if (this.myNode.getPsi() instanceof PySliceExpression) {
            PySliceExpression sliceExpression = (PySliceExpression)this.myNode.getPsi();
            PyExpression operand = sliceExpression.getOperand();
            return operand.getNode() == child;
        }
        return false;
    }

    private static boolean isAfterStatementList(@NotNull ASTNode child) {
        PsiElement prev;
        if (child == null) {
            PyBlock.$$$reportNull$$$0(31);
        }
        if (!((prev = child.getPsi().getPrevSibling()) instanceof PyStatement)) {
            return false;
        }
        PsiElement lastChild = PsiTreeUtil.getDeepestLast((PsiElement)prev);
        return lastChild.getParent() instanceof PyStatementList;
    }

    private boolean needListAlignment(@NotNull ASTNode child) {
        IElementType childType;
        if (child == null) {
            PyBlock.$$$reportNull$$$0(32);
        }
        if (PyTokenTypes.OPEN_BRACES.contains(childType = child.getElementType())) {
            return false;
        }
        if (PyTokenTypes.CLOSE_BRACES.contains(childType)) {
            ASTNode prevNonSpace = PyBlock.findPrevNonSpaceNode(child);
            if (prevNonSpace != null && prevNonSpace.getElementType() == PyTokenTypes.COMMA && this.myContext.getMode() == FormattingMode.ADJUST_INDENT) {
                return true;
            }
            return !PyBlock.hasHangingIndent(this.myNode.getPsi()) && (this.myNode.getElementType() != PyElementTypes.DICT_LITERAL_EXPRESSION || !this.myContext.getPySettings().DICT_NEW_LINE_AFTER_LEFT_BRACE);
        }
        if (this.myNode.getElementType() == PyElementTypes.ARGUMENT_LIST) {
            if (!this.myContext.getSettings().ALIGN_MULTILINE_PARAMETERS_IN_CALLS || PyBlock.hasHangingIndent(this.myNode.getPsi())) {
                return false;
            }
            return childType != PyTokenTypes.COMMA;
        }
        if (this.myNode.getElementType() == PyElementTypes.PARAMETER_LIST) {
            return !PyBlock.hasHangingIndent(this.myNode.getPsi()) && this.myContext.getSettings().ALIGN_MULTILINE_PARAMETERS;
        }
        if (this.myNode.getElementType() == PyElementTypes.SUBSCRIPTION_EXPRESSION) {
            return false;
        }
        if (childType == PyTokenTypes.COMMA) {
            return false;
        }
        if (this.myNode.getElementType() == PyElementTypes.PARENTHESIZED_EXPRESSION) {
            if (childType == PyElementTypes.STRING_LITERAL_EXPRESSION) {
                return true;
            }
            if (childType != PyElementTypes.TUPLE_EXPRESSION && childType != PyElementTypes.GENERATOR_EXPRESSION) {
                return false;
            }
        }
        if (this.myNode.getElementType() == PyElementTypes.WITH_STATEMENT) {
            return this.myNode.findChildByType((IElementType)PyTokenTypes.LPAR) != null && !PyBlock.hasHangingIndent(this.myNode.getPsi());
        }
        return this.myContext.getPySettings().ALIGN_COLLECTIONS_AND_COMPREHENSIONS && !PyBlock.hasHangingIndent(this.myNode.getPsi());
    }

    @Nullable
    private static ASTNode findPrevNonSpaceNode(@NotNull ASTNode node) {
        if (node == null) {
            PyBlock.$$$reportNull$$$0(33);
        }
        while (PyBlock.isWhitespace(node = node.getTreePrev())) {
        }
        return node;
    }

    private static boolean isWhitespace(@Nullable ASTNode node) {
        return node != null && (node.getElementType() == TokenType.WHITE_SPACE || PyTokenTypes.WHITESPACE.contains(node.getElementType()));
    }

    private static boolean hasLineBreaksBeforeInSameParent(@NotNull ASTNode node, int minCount) {
        ASTNode treePrev;
        if (node == null) {
            PyBlock.$$$reportNull$$$0(34);
        }
        return (treePrev = node.getTreePrev()) != null && PyBlock.isWhitespaceWithLineBreaks(TreeUtil.findLastLeaf((ASTNode)treePrev), minCount) || PyBlock.isWhitespaceWithLineBreaks(node.getFirstChildNode(), minCount);
    }

    private static boolean hasLineBreakAfterIgnoringComments(@NotNull ASTNode node) {
        if (node == null) {
            PyBlock.$$$reportNull$$$0(35);
        }
        ASTNode next = TreeUtil.nextLeaf((ASTNode)node);
        while (next != null) {
            if (PyBlock.isWhitespace(next)) {
                if (next.textContains('\n')) {
                    return true;
                }
            } else {
                if (next.getElementType() != PyTokenTypes.END_OF_LINE_COMMENT) break;
                return true;
            }
            next = TreeUtil.nextLeaf((ASTNode)next);
        }
        return false;
    }

    private static boolean isWhitespaceWithLineBreaks(@Nullable ASTNode node, int minCount) {
        if (PyBlock.isWhitespace(node)) {
            if (minCount == 1) {
                return node.textContains('\n');
            }
            String prevNodeText = node.getText();
            int count = 0;
            for (int i = 0; i < prevNodeText.length(); ++i) {
                if (prevNodeText.charAt(i) != '\n' || ++count != minCount) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public Wrap getWrap() {
        return this.myWrap;
    }

    @Nullable
    public Indent getIndent() {
        assert (this.myIndent != null);
        return this.myIndent;
    }

    @Nullable
    public Alignment getAlignment() {
        return this.myAlignment;
    }

    @Nullable
    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        if (child2 == null) {
            PyBlock.$$$reportNull$$$0(36);
        }
        CommonCodeStyleSettings settings = this.myContext.getSettings();
        PyCodeStyleSettings pySettings = this.myContext.getPySettings();
        if (child1 instanceof ASTBlock && child2 instanceof ASTBlock) {
            PyNamedParameter namedParameter;
            ASTNode lastLeaf;
            LeafElement firstLeaf;
            PsiElement nonCommentAfter;
            ASTNode node1 = ((ASTBlock)child1).getNode();
            ASTNode node2 = ((ASTBlock)child2).getNode();
            IElementType childType1 = node1.getElementType();
            PsiElement psi1 = node1.getPsi();
            PsiElement psi2 = node2.getPsi();
            if (psi2 instanceof PyStatementList) {
                PyStatement[] statements;
                if (this.myNode.getElementType() == PyElementTypes.CLASS_DECLARATION && (statements = ((PyStatementList)psi2).getStatements()).length > 0 && statements[0] instanceof PyFunction) {
                    return this.getBlankLinesForOption(pySettings.BLANK_LINES_BEFORE_FIRST_METHOD);
                }
                if (childType1 == PyTokenTypes.COLON && this.needLineBreakInStatement()) {
                    return Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)true, (int)settings.KEEP_BLANK_LINES_IN_CODE);
                }
            }
            if (psi1 instanceof PsiComment && this.myNode.getPsi() instanceof PsiFile) {
                return Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)true, (int)2);
            }
            if (psi2 instanceof PsiComment && PyBlock.hasLineBreaksBeforeInSameParent(node2, 1) && (nonCommentAfter = PyPsiUtils.getNextNonCommentSibling(psi2, true)) != null) {
                psi2 = nonCommentAfter;
            }
            node2 = psi2.getNode();
            IElementType childType2 = psi2.getNode().getElementType();
            child2 = this.getSubBlockByNode(node2);
            if (PyBlock.isInsideFStringFragmentWithEqualsSign(this.myNode)) {
                return Spacing.getReadOnlySpacing();
            }
            if (childType1 == PyTokenTypes.FSTRING_FRAGMENT_START && (firstLeaf = TreeUtil.findFirstLeaf((ASTNode)node2)) != null && firstLeaf.getElementType() == PyTokenTypes.LBRACE) {
                return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)false, (int)0);
            }
            if (childType2 == PyTokenTypes.FSTRING_FRAGMENT_END && (lastLeaf = TreeUtil.findLastLeaf((ASTNode)node1)) != null && lastLeaf.getElementType() == PyTokenTypes.RBRACE) {
                return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)false, (int)0);
            }
            if ((childType1 == PyTokenTypes.EQ || childType2 == PyTokenTypes.EQ) && (namedParameter = PyUtil.as(this.myNode.getPsi(), PyNamedParameter.class)) != null && namedParameter.getAnnotation() != null) {
                return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)settings.KEEP_LINE_BREAKS, (int)settings.KEEP_BLANK_LINES_IN_CODE);
            }
            if (psi1 instanceof PyImportStatementBase) {
                if (psi2 instanceof PyImportStatementBase) {
                    Boolean leftImportIsGroupStart = (Boolean)psi1.getCopyableUserData(PythonCodeStyleService.IMPORT_GROUP_BEGIN);
                    Boolean rightImportIsGroupStart = (Boolean)psi2.getCopyableUserData(PythonCodeStyleService.IMPORT_GROUP_BEGIN);
                    psi1.putCopyableUserData(PythonCodeStyleService.IMPORT_GROUP_BEGIN, null);
                    if (rightImportIsGroupStart != null) {
                        return Spacing.createSpacing((int)0, (int)0, (int)2, (boolean)true, (int)1);
                    }
                    if (leftImportIsGroupStart != null) {
                        return Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)false, (int)0);
                    }
                }
                if (psi2 instanceof PyStatement && !(psi2 instanceof PyImportStatementBase)) {
                    if (PyUtil.isTopLevel(psi1)) {
                        if (PyElementTypes.CLASS_OR_FUNCTION.contains(childType2)) {
                            return this.getBlankLinesForOption(Math.max(settings.BLANK_LINES_AFTER_IMPORTS, pySettings.BLANK_LINES_AROUND_TOP_LEVEL_CLASSES_FUNCTIONS));
                        }
                        return this.getBlankLinesForOption(settings.BLANK_LINES_AFTER_IMPORTS);
                    }
                    return this.getBlankLinesForOption(pySettings.BLANK_LINES_AFTER_LOCAL_IMPORTS);
                }
            }
            if (psi2 instanceof PyImportStatementBase && AddImportHelper.isAssignmentToModuleLevelDunderName(psi1)) {
                return Spacing.createSpacing((int)0, (int)0, (int)2, (boolean)settings.KEEP_LINE_BREAKS, (int)settings.KEEP_BLANK_LINES_IN_DECLARATIONS);
            }
            if ((PyElementTypes.CLASS_OR_FUNCTION.contains(childType1) && STATEMENT_OR_DECLARATION.contains(childType2) || STATEMENT_OR_DECLARATION.contains(childType1) && PyElementTypes.CLASS_OR_FUNCTION.contains(childType2)) && PyUtil.isTopLevel(psi1)) {
                return this.getBlankLinesForOption(pySettings.BLANK_LINES_AROUND_TOP_LEVEL_CLASSES_FUNCTIONS);
            }
        }
        return this.myContext.getSpacingBuilder().getSpacing((Block)this, child1, child2);
    }

    @NotNull
    private Spacing getBlankLinesForOption(int minBlankLines) {
        int lineFeeds = minBlankLines + 1;
        Spacing spacing = Spacing.createSpacing((int)0, (int)0, (int)lineFeeds, (boolean)this.myContext.getSettings().KEEP_LINE_BREAKS, (int)this.myContext.getSettings().KEEP_BLANK_LINES_IN_DECLARATIONS);
        if (spacing == null) {
            PyBlock.$$$reportNull$$$0(37);
        }
        return spacing;
    }

    private boolean needLineBreakInStatement() {
        PsiElement psiElement = this.myNode.getPsi();
        boolean isInStubFile = PyiUtil.isInsideStub(psiElement);
        if (psiElement instanceof PyStatementListContainer) {
            PyStatement statement = (PyStatement)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PyStatement.class);
            if (statement != null) {
                Collection parts = PsiTreeUtil.collectElementsOfType((PsiElement)statement, (Class[])new Class[]{PyStatementPart.class});
                return parts.size() == 1 && this.myContext.getPySettings().NEW_LINE_AFTER_COLON && !isInStubFile || parts.size() > 1 && this.myContext.getPySettings().NEW_LINE_AFTER_COLON_MULTI_CLAUSE;
            }
            return this.myContext.getPySettings().NEW_LINE_AFTER_COLON && !isInStubFile;
        }
        return false;
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        int statementListsBelow = 0;
        if (newChildIndex > 0) {
            if (this.myNode.getPsi() instanceof PyFile || this.myNode.getElementType() == PyTokenTypes.COLON) {
                ChildAttributes childAttributes = ChildAttributes.DELEGATE_TO_PREV_CHILD;
                if (childAttributes == null) {
                    PyBlock.$$$reportNull$$$0(38);
                }
                return childAttributes;
            }
            PyBlock insertAfterBlock = this.getSubBlockByIndex(newChildIndex - 1);
            ASTNode prevNode = insertAfterBlock.getNode();
            PsiElement prevElt = prevNode.getPsi();
            if (this.myNode.getElementType() == PyElementTypes.WITH_STATEMENT && PyBlock.isInsideWithStatementParentheses(this.myNode, prevNode)) {
                ASTNode openingParenthesis = this.myNode.findChildByType((IElementType)PyTokenTypes.LPAR);
                for (int i = newChildIndex - 1; i >= 0; --i) {
                    PyBlock prevBlock = this.mySubBlocks.get(i);
                    if (prevBlock.myNode == openingParenthesis) break;
                    if (prevBlock.getAlignment() == null) continue;
                    return new ChildAttributes(Indent.getNormalIndent(), prevBlock.getAlignment());
                }
                return new ChildAttributes(Indent.getNormalIndent(), null);
            }
            if (prevElt instanceof PyStatementList) {
                if (PyBlock.dedentAfterLastStatement((PyStatementList)prevElt)) {
                    return new ChildAttributes(Indent.getNoneIndent(), this.getChildAlignment());
                }
                ChildAttributes childAttributes = ChildAttributes.DELEGATE_TO_PREV_CHILD;
                if (childAttributes == null) {
                    PyBlock.$$$reportNull$$$0(39);
                }
                return childAttributes;
            }
            if (prevElt instanceof PyStatementPart) {
                ChildAttributes childAttributes = ChildAttributes.DELEGATE_TO_PREV_CHILD;
                if (childAttributes == null) {
                    PyBlock.$$$reportNull$$$0(40);
                }
                return childAttributes;
            }
            ASTNode lastChild = insertAfterBlock.getNode();
            while (lastChild != null) {
                IElementType lastType = lastChild.getElementType();
                if (lastType == PyElementTypes.STATEMENT_LIST && PyBlock.hasLineBreaksBeforeInSameParent(lastChild, 1)) {
                    if (PyBlock.dedentAfterLastStatement((PyStatementList)lastChild.getPsi())) break;
                    ++statementListsBelow;
                } else if (statementListsBelow > 0 && lastChild.getPsi() instanceof PsiErrorElement) {
                    ++statementListsBelow;
                }
                if (this.myNode.getElementType() == PyElementTypes.STATEMENT_LIST && lastChild.getPsi() instanceof PsiErrorElement) {
                    ChildAttributes childAttributes = ChildAttributes.DELEGATE_TO_PREV_CHILD;
                    if (childAttributes == null) {
                        PyBlock.$$$reportNull$$$0(41);
                    }
                    return childAttributes;
                }
                lastChild = PyBlock.getLastNonSpaceChild(lastChild, true);
            }
        }
        if (statementListsBelow > 0) {
            int indent = this.myContext.getSettings().getIndentOptions().INDENT_SIZE;
            return new ChildAttributes(Indent.getSpaceIndent((int)(indent * statementListsBelow)), null);
        }
        Indent childIndent = this.getChildIndent(newChildIndex);
        Alignment childAlignment = this.getChildAlignment();
        return new ChildAttributes(childIndent, childAlignment);
    }

    private static boolean dedentAfterLastStatement(@NotNull PyStatementList statementList) {
        PyStatement[] statements;
        if (statementList == null) {
            PyBlock.$$$reportNull$$$0(42);
        }
        if ((statements = statementList.getStatements()).length == 0) {
            return false;
        }
        PyStatement last = statements[statements.length - 1];
        return last instanceof PyReturnStatement || last instanceof PyRaiseStatement || last instanceof PyPassStatement || PyBlock.isEllipsis(last);
    }

    private static boolean isEllipsis(@NotNull PyStatement statement) {
        PyExpression expression;
        if (statement == null) {
            PyBlock.$$$reportNull$$$0(43);
        }
        if (statement instanceof PyExpressionStatement && (expression = ((PyExpressionStatement)statement).getExpression()) instanceof PyNoneLiteralExpression) {
            return ((PyNoneLiteralExpression)expression).isEllipsis();
        }
        return false;
    }

    @Nullable
    private Alignment getChildAlignment() {
        IElementType nodeType = this.myNode.getElementType();
        if (ourListElementTypes.contains(nodeType) || nodeType == PyElementTypes.SLICE_ITEM || nodeType == PyElementTypes.STRING_LITERAL_EXPRESSION) {
            PyKeyValueExpression lastElement;
            PyExpression parenthesized;
            if (this.isInControlStatement()) {
                return null;
            }
            PsiElement elem = this.myNode.getPsi();
            if (elem instanceof PyParameterList && !this.myContext.getSettings().ALIGN_MULTILINE_PARAMETERS) {
                return null;
            }
            if ((elem instanceof PySequenceExpression || elem instanceof PyComprehensionElement) && !this.myContext.getPySettings().ALIGN_COLLECTIONS_AND_COMPREHENSIONS) {
                return null;
            }
            if (elem instanceof PyParenthesizedExpression && (parenthesized = ((PyParenthesizedExpression)elem).getContainedExpression()) instanceof PyTupleExpression && !this.myContext.getPySettings().ALIGN_COLLECTIONS_AND_COMPREHENSIONS) {
                return null;
            }
            if (elem instanceof PyDictLiteralExpression && ((lastElement = (PyKeyValueExpression)ArrayUtil.getLastElement((Object[])((PyDictLiteralExpression)elem).getElements())) == null || lastElement.getValue() == null)) {
                return null;
            }
            if (elem instanceof PyWithStatement && PyPsiUtils.getFirstChildOfType(elem, PyTokenTypes.LPAR) == null) {
                return null;
            }
            return this.getAlignmentForChildren();
        }
        return null;
    }

    @NotNull
    private Indent getChildIndent(int newChildIndex) {
        PyKeyValueExpression keyValue;
        IElementType parentType = this.myNode.getElementType();
        ASTNode afterNode = this.getAfterNode(newChildIndex);
        ASTNode lastChild = PyBlock.getLastNonSpaceChild(this.myNode, false);
        if (lastChild != null && lastChild.getElementType() == PyElementTypes.STATEMENT_LIST && this.mySubBlocks.size() >= newChildIndex) {
            if (afterNode == null) {
                Indent indent = Indent.getNoneIndent();
                if (indent == null) {
                    PyBlock.$$$reportNull$$$0(44);
                }
                return indent;
            }
            if (afterNode.getElementType() == PyElementTypes.STATEMENT_LIST || afterNode.getElementType() == PyTokenTypes.COLON) {
                Indent indent = Indent.getNormalIndent();
                if (indent == null) {
                    PyBlock.$$$reportNull$$$0(45);
                }
                return indent;
            }
            ASTNode lastFirstChild = lastChild.getFirstChildNode();
            if (lastFirstChild != null && lastFirstChild == lastChild.getLastChildNode() && lastFirstChild.getPsi() instanceof PsiErrorElement) {
                Indent indent = Indent.getNormalIndent();
                if (indent == null) {
                    PyBlock.$$$reportNull$$$0(46);
                }
                return indent;
            }
        }
        if (parentType == PyElementTypes.MATCH_STATEMENT && afterNode != null && afterNode.getElementType() == PyTokenTypes.COLON) {
            Indent indent = Indent.getNormalIndent();
            if (indent == null) {
                PyBlock.$$$reportNull$$$0(47);
            }
            return indent;
        }
        if (afterNode != null && afterNode.getElementType() == PyElementTypes.KEY_VALUE_EXPRESSION && (keyValue = (PyKeyValueExpression)afterNode.getPsi()) != null && keyValue.getValue() == null) {
            Indent indent = Indent.getContinuationIndent();
            if (indent == null) {
                PyBlock.$$$reportNull$$$0(48);
            }
            return indent;
        }
        PyCodeStyleSettings settings = this.myContext.getPySettings();
        if (parentType == PyElementTypes.PARAMETER_LIST && settings.USE_CONTINUATION_INDENT_FOR_PARAMETERS || parentType == PyElementTypes.ARGUMENT_LIST && settings.USE_CONTINUATION_INDENT_FOR_ARGUMENTS) {
            Indent indent = Indent.getContinuationIndent();
            if (indent == null) {
                PyBlock.$$$reportNull$$$0(49);
            }
            return indent;
        }
        if (ourCollectionLiteralTypes.contains(parentType) || parentType == PyElementTypes.TUPLE_EXPRESSION) {
            Indent indent = settings.USE_CONTINUATION_INDENT_FOR_COLLECTION_AND_COMPREHENSIONS ? Indent.getContinuationIndent() : Indent.getNormalIndent();
            if (indent == null) {
                PyBlock.$$$reportNull$$$0(50);
            }
            return indent;
        }
        if (ourListElementTypes.contains(parentType) || this.myNode.getPsi() instanceof PyStatementPart) {
            Indent indent = Indent.getNormalIndent();
            if (indent == null) {
                PyBlock.$$$reportNull$$$0(51);
            }
            return indent;
        }
        if (afterNode != null) {
            for (ASTNode wsAfter = afterNode.getTreeNext(); wsAfter != null && wsAfter.getElementType() == TokenType.WHITE_SPACE; wsAfter = wsAfter.getTreeNext()) {
                if (wsAfter.getText().indexOf(92) < 0) continue;
                Indent indent = Indent.getNormalIndent();
                if (indent == null) {
                    PyBlock.$$$reportNull$$$0(52);
                }
                return indent;
            }
        }
        Indent indent = Indent.getNoneIndent();
        if (indent == null) {
            PyBlock.$$$reportNull$$$0(53);
        }
        return indent;
    }

    @Nullable
    private ASTNode getAfterNode(int newChildIndex) {
        int prevIndex;
        if (newChildIndex == 0) {
            return null;
        }
        for (prevIndex = newChildIndex - 1; prevIndex > 0 && this.getSubBlockByIndex(prevIndex).getNode().getElementType() == PyTokenTypes.END_OF_LINE_COMMENT; --prevIndex) {
        }
        return this.getSubBlockByIndex(prevIndex).getNode();
    }

    private static ASTNode getLastNonSpaceChild(@NotNull ASTNode node, boolean acceptError) {
        ASTNode lastChild;
        if (node == null) {
            PyBlock.$$$reportNull$$$0(54);
        }
        for (lastChild = node.getLastChildNode(); lastChild != null && (lastChild.getElementType() == TokenType.WHITE_SPACE || !acceptError && lastChild.getPsi() instanceof PsiErrorElement); lastChild = lastChild.getTreePrev()) {
        }
        return lastChild;
    }

    public boolean isIncomplete() {
        ASTNode lastChild;
        if (!PsiTreeUtil.hasErrorElements((PsiElement)this.myNode.getPsi())) {
            if (this.myNode.getPsi() instanceof PsiFile) {
                return false;
            }
            PsiElement element = this.myNode.getPsi().getNextSibling();
            while (element instanceof PsiWhiteSpace) {
                element = element.getNextSibling();
            }
            if (element != null) {
                return false;
            }
        }
        if ((lastChild = PyBlock.getLastNonSpaceChild(this.myNode, false)) != null) {
            PyBinaryExpression binaryExpression;
            ASTNode statementListPrev;
            if (lastChild.getElementType() == PyElementTypes.STATEMENT_LIST && (statementListPrev = lastChild.getTreePrev()) != null && statementListPrev.getText().indexOf(10) >= 0) {
                return true;
            }
            if (lastChild.getElementType() == PyElementTypes.BINARY_EXPRESSION && (binaryExpression = (PyBinaryExpression)lastChild.getPsi()).getRightExpression() == null) {
                return true;
            }
            if (PyBlock.isIncompleteCall(lastChild)) {
                return true;
            }
        }
        if (this.myNode.getPsi() instanceof PyArgumentList) {
            PyArgumentList argumentList = (PyArgumentList)this.myNode.getPsi();
            return argumentList.getClosingParen() == null;
        }
        return PyBlock.isIncompleteCall(this.myNode) || PyBlock.isIncompleteExpressionWithBrackets(this.myNode.getPsi());
    }

    private static boolean isIncompleteCall(@NotNull ASTNode node) {
        PyCallExpression callExpression;
        PyArgumentList argumentList;
        if (node == null) {
            PyBlock.$$$reportNull$$$0(55);
        }
        return node.getElementType() == PyElementTypes.CALL_EXPRESSION && ((argumentList = (callExpression = (PyCallExpression)node.getPsi()).getArgumentList()) == null || argumentList.getClosingParen() == null);
    }

    private static boolean isIncompleteExpressionWithBrackets(@NotNull PsiElement elem) {
        if (elem == null) {
            PyBlock.$$$reportNull$$$0(56);
        }
        if (elem instanceof PySequenceExpression || elem instanceof PyComprehensionElement || elem instanceof PyParenthesizedExpression) {
            return PyTokenTypes.OPEN_BRACES.contains(elem.getFirstChild().getNode().getElementType()) && !PyTokenTypes.CLOSE_BRACES.contains(elem.getLastChild().getNode().getElementType());
        }
        return false;
    }

    public boolean isLeaf() {
        return this.myNode.getFirstChildNode() == null;
    }

    private static boolean isInsideFStringFragmentWithEqualsSign(@NotNull ASTNode node) {
        ASTNode fStringFragmentParent;
        if (node == null) {
            PyBlock.$$$reportNull$$$0(57);
        }
        ASTNode aSTNode = fStringFragmentParent = node.getElementType() == PyElementTypes.FSTRING_FRAGMENT ? node : TreeUtil.findParent((ASTNode)node, (TokenSet)TokenSet.create((IElementType[])new IElementType[]{PyElementTypes.FSTRING_FRAGMENT}), (TokenSet)stopAtTokens);
        if (fStringFragmentParent == null) {
            return false;
        }
        return fStringFragmentParent.findChildByType((IElementType)PyTokenTypes.EQ) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/formatter/PyBlock";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 12: 
            case 17: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "withStatement";
                break;
            }
            case 24: 
            case 25: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elem";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child2";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statementList";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/formatter/PyBlock";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNode";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRange";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubBlocks";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "buildSubBlocks";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubBlockNodes";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getBlankLinesForOption";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildAttributes";
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildIndent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSubBlockByNode";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "collectChildrenOperatorAndOperandNodes";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "buildSubBlock";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isInsideWithStatementParentheses";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isIfCondition";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isCondition";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findTopmostBinaryExpressionBlock";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isValueOfKeyValuePairOfDictLiteral";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isChildOfKeyValuePairOfDictLiteral";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isChildOfDictLiteral";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isChildOfKeyValuePair";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isValueOfKeyValuePair";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isEmptySequence";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "hasHangingIndent";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getFirstItem";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getAlignmentOfChild";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isIndentNext";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isSubscriptionOperand";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getControlStatementHeader";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isSliceOperand";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isAfterStatementList";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "needListAlignment";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "findPrevNonSpaceNode";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "hasLineBreaksBeforeInSameParent";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "hasLineBreakAfterIgnoringComments";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getSpacing";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "dedentAfterLastStatement";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "isEllipsis";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getLastNonSpaceChild";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "isIncompleteCall";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "isIncompleteExpressionWithBrackets";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "isInsideFStringFragmentWithEqualsSign";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

