/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.ift;

import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PySdkBundle;
import com.jetbrains.python.configuration.PyConfigurableInterpreterList;
import com.jetbrains.python.ift.PythonBasedLangSupport;
import com.jetbrains.python.ift.PythonLessonsBundle;
import com.jetbrains.python.inspections.PyInterpreterInspection;
import com.jetbrains.python.newProject.steps.ProjectSpecificSettingsStep;
import com.jetbrains.python.sdk.PreferredSdkComparator;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PySdkSettings;
import com.jetbrains.python.sdk.PySdkToInstall;
import com.jetbrains.python.sdk.add.PyAddSdkPanelKt;
import com.jetbrains.python.sdk.add.PySdkPathChoosingComboBox;
import com.jetbrains.python.sdk.configuration.PyProjectSdkConfiguration;
import com.jetbrains.python.sdk.configuration.PyProjectVirtualEnvConfiguration;
import com.jetbrains.python.statistics.PyStatisticToolsKt;
import java.awt.Dimension;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.dsl.LessonContext;
import training.dsl.TaskContext;
import training.dsl.TaskRuntimeContext;
import training.lang.AbstractLangSupport;
import training.lang.LangSupport;
import training.learn.CourseManager;
import training.learn.course.KLesson;
import training.learn.course.Lesson;
import training.project.ProjectUtils;
import training.project.ReadMeCreator;
import training.statistic.LearningInternalProblems;
import training.statistic.LessonStartingWay;
import training.ui.LearningUiManager;
import training.util.UtilsKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u00172\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00170\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J\u0018\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u001a\u0010!\u001a\u00020\u00122\b\u0010 \u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0012\u0010\"\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00170\u001cH\u0002J\u001c\u0010$\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010%\u001a\u0004\u0018\u00010\u0017H\u0016J=\u0010&\u001a\u00020\u00122\u0006\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010\u00192!\u0010*\u001a\u001d\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(,\u0012\u0004\u0012\u00020\u00120+H\u0016J\u0010\u0010-\u001a\u00020.2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u001e\u0010/\u001a\u00020\u00122\u0014\u00100\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0017\u0012\u0004\u0012\u00020\u00120+H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR:\u0010\u000b\u001a(\u0012\u0004\u0012\u00020\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00120\f\u00a2\u0006\u0002\b\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u00061"}, d2={"Lcom/jetbrains/python/ift/PythonBasedLangSupport;", "Ltraining/lang/AbstractLangSupport;", "()V", "readMeCreator", "Ltraining/project/ReadMeCreator;", "getReadMeCreator", "()Ltraining/project/ReadMeCreator;", "sampleFilePath", "", "getSampleFilePath", "()Ljava/lang/String;", "sdkConfigurationTasks", "Lkotlin/Function2;", "Ltraining/dsl/LessonContext;", "Ltraining/learn/course/KLesson;", "Lkotlin/ParameterName;", "name", "lesson", "", "Lkotlin/ExtensionFunctionType;", "getSdkConfigurationTasks", "()Lkotlin/jvm/functions/Function2;", "applyBaseSdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "project", "Lcom/intellij/openapi/project/Project;", "preferredSdk", "existingSdks", "", "module", "Lcom/intellij/openapi/module/Module;", "applyProjectSdk", "sdk", "checkSdk", "createVenv", "getExistingSdks", "getSdkForProject", "selectedSdk", "installAndOpenLearningProject", "contentRoot", "Ljava/nio/file/Path;", "projectToClose", "postInitCallback", "Lkotlin/Function1;", "learnProject", "isSdkConfigured", "", "startFromWelcomeFrame", "startCallback", "intellij.python.featuresTrainer"})
public abstract class PythonBasedLangSupport
extends AbstractLangSupport {
    @NotNull
    private final ReadMeCreator readMeCreator = new ReadMeCreator();
    @NotNull
    private final String sampleFilePath;
    @NotNull
    private final Function2<LessonContext, KLesson, Unit> sdkConfigurationTasks = (Function2)new Function2<LessonContext, KLesson, Unit>(this){
        final /* synthetic */ PythonBasedLangSupport this$0;

        public final void invoke(@NotNull LessonContext $receiver, @NotNull KLesson lesson) {
            Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
            Intrinsics.checkNotNullParameter((Object)lesson, (String)"lesson");
            $receiver.task((Function1)new Function1<TaskContext, Unit>(this, lesson){
                final /* synthetic */ sdkConfigurationTasks.1 this$0;
                final /* synthetic */ KLesson $lesson;

                public final void invoke(@NotNull TaskContext $this$task) {
                    Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$receiver");
                    $this$task.stateCheck((Function1)new Function1<TaskRuntimeContext, Boolean>(this){
                        final /* synthetic */ sdkConfigurationTasks.1 this$0;

                        public final boolean invoke(@NotNull TaskRuntimeContext $this$stateCheck) {
                            Intrinsics.checkNotNullParameter((Object)$this$stateCheck, (String)"$receiver");
                            return this.this$0.this$0.this$0.isSdkConfigured($this$stateCheck.getProject());
                        }
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }
                    });
                    int configureCallbackId2 = LearningUiManager.INSTANCE.addCallback((Function0)new Function0<Unit>($this$task){
                        final /* synthetic */ TaskContext $this_task;

                        public final void invoke() {
                            Object[] objectArray = PyStatisticToolsKt.getModules(this.$this_task.getProject());
                            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"project.modules");
                            Module module = (Module)ArraysKt.singleOrNull((Object[])objectArray);
                            if (module == null) {
                                return;
                            }
                            Module module2 = module;
                            PyInterpreterInspection.InterpreterSettingsQuickFix.showPythonInterpreterSettings(this.$this_task.getProject(), module2);
                        }
                        {
                            this.$this_task = taskContext;
                            super(0);
                        }
                    });
                    if (this.this$0.this$0.getUseUserProjects() || UtilsKt.isLearningProject((Project)$this$task.getProject(), (LangSupport)((LangSupport)this.this$0.this$0))) {
                        TaskContext.showWarning$default((TaskContext)$this$task, (String)PythonLessonsBundle.INSTANCE.message("no.interpreter.in.learning.project", configureCallbackId2), (boolean)false, (LearningInternalProblems)LearningInternalProblems.NO_SDK_CONFIGURED, (Function1)((Function1)new Function1<TaskRuntimeContext, Boolean>(this){
                            final /* synthetic */ sdkConfigurationTasks.1 this$0;

                            public final boolean invoke(@NotNull TaskRuntimeContext $this$showWarning) {
                                Intrinsics.checkNotNullParameter((Object)$this$showWarning, (String)"$receiver");
                                return !this.this$0.this$0.this$0.isSdkConfigured($this$showWarning.getProject());
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        }), (int)2, null);
                    } else {
                        int openCallbackId2 = LearningUiManager.INSTANCE.addCallback((Function0)new Function0<Unit>(this, $this$task){
                            final /* synthetic */ sdkConfigurationTasks.1 this$0;
                            final /* synthetic */ TaskContext $this_task;

                            public final void invoke() {
                                CourseManager.Companion.getInstance().openLesson(this.$this_task.getProject(), (Lesson)this.this$0.$lesson, LessonStartingWay.NO_SDK_RESTART, true, true);
                            }
                            {
                                this.this$0 = var1_1;
                                this.$this_task = taskContext;
                                super(0);
                            }
                        });
                        TaskContext.showWarning$default((TaskContext)$this$task, (String)PythonLessonsBundle.INSTANCE.message("no.interpreter.in.user.project", openCallbackId2, configureCallbackId2), (boolean)false, null, (Function1)((Function1)new Function1<TaskRuntimeContext, Boolean>(this){
                            final /* synthetic */ sdkConfigurationTasks.1 this$0;

                            public final boolean invoke(@NotNull TaskRuntimeContext $this$showWarning) {
                                Intrinsics.checkNotNullParameter((Object)$this$showWarning, (String)"$receiver");
                                return !this.this$0.this$0.this$0.isSdkConfigured($this$showWarning.getProject());
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        }), (int)6, null);
                    }
                }
                {
                    this.this$0 = var1_1;
                    this.$lesson = kLesson;
                    super(1);
                }
            });
        }
        {
            this.this$0 = pythonBasedLangSupport;
            super(2);
        }
    };

    @NotNull
    public ReadMeCreator getReadMeCreator() {
        return this.readMeCreator;
    }

    public void installAndOpenLearningProject(@NotNull Path contentRoot, @Nullable Project projectToClose, @NotNull Function1<? super Project, Unit> postInitCallback) {
        Intrinsics.checkNotNullParameter((Object)contentRoot, (String)"contentRoot");
        Intrinsics.checkNotNullParameter(postInitCallback, (String)"postInitCallback");
        OpenProjectTask openProjectTask = new OpenProjectTask(false, projectToClose, false, false, null, null, false, null, null, 0, 0, false, false, false, null, true, false, null, null, null, 1015805, null);
        ProjectUtils.INSTANCE.simpleInstallAndOpenLearningProject(contentRoot, (LangSupport)this, openProjectTask, postInitCallback);
    }

    @Nullable
    public Sdk getSdkForProject(@NotNull Project project, @Nullable Sdk selectedSdk) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (selectedSdk != null) {
            Object[] objectArray = PyStatisticToolsKt.getModules(project);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"project.modules");
            Module module = (Module)ArraysKt.first((Object[])objectArray);
            List<Sdk> existingSdks2 = this.getExistingSdks();
            return this.applyBaseSdk(project, selectedSdk, existingSdks2, module);
        }
        if (PySdkExtKt.getPythonSdk(project) != null) {
            return null;
        }
        return this.createVenv(project);
    }

    private final Sdk createVenv(Project project) {
        Object[] objectArray = PyStatisticToolsKt.getModules(project);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"project.modules");
        Module module = (Module)ArraysKt.first((Object[])objectArray);
        List<Sdk> existingSdks2 = this.getExistingSdks();
        List<Sdk> baseSdks = PySdkExtKt.findBaseSdks(existingSdks2, module, (UserDataHolder)project);
        Sdk preferredSdk = PyProjectVirtualEnvConfiguration.INSTANCE.findPreferredVirtualEnvBaseSdk(baseSdks);
        return this.applyBaseSdk(project, preferredSdk, existingSdks2, module);
    }

    private final Sdk applyBaseSdk(Project project, Sdk preferredSdk, List<? extends Sdk> existingSdks2, Module module) {
        Sdk sdk;
        Sdk venvSdk;
        String string = FileUtil.toSystemDependentName((String)PySdkSettings.Companion.getInstance().getPreferredVirtualEnvBasePath(project.getBasePath()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FileUtil.toSystemDepende\u2026sePath(project.basePath))");
        String venvRoot = string;
        Sdk sdk2 = venvSdk = PyProjectVirtualEnvConfiguration.createVirtualEnvSynchronously$default(PyProjectVirtualEnvConfiguration.INSTANCE, preferredSdk, existingSdks2, venvRoot, project.getBasePath(), project, module, (UserDataHolder)project, false, false, 384, null);
        if (sdk2 != null) {
            Sdk sdk3;
            Sdk it = sdk3 = sdk2;
            boolean bl = false;
            SdkConfigurationUtil.addSdk((Sdk)it);
            sdk = sdk3;
        } else {
            sdk = null;
        }
        return sdk;
    }

    public void applyProjectSdk(@NotNull Sdk sdk, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object[] objectArray = PyStatisticToolsKt.getModules(project);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"project.modules");
        Object object = ArraysKt.first((Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.modules.first()");
        PyProjectSdkConfiguration.INSTANCE.setReadyToUseSdk(project, (Module)object, sdk);
    }

    private final List<Sdk> getExistingSdks() {
        PyConfigurableInterpreterList pyConfigurableInterpreterList = PyConfigurableInterpreterList.getInstance(null);
        Intrinsics.checkNotNullExpressionValue((Object)pyConfigurableInterpreterList, (String)"PyConfigurableInterpreterList.getInstance(null)");
        List<Sdk> list = pyConfigurableInterpreterList.getAllPythonSdks();
        Intrinsics.checkNotNullExpressionValue(list, (String)"PyConfigurableInterprete\u2026tance(null).allPythonSdks");
        Iterable iterable = list;
        PreferredSdkComparator preferredSdkComparator = PreferredSdkComparator.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)preferredSdkComparator, (String)"PreferredSdkComparator.INSTANCE");
        return CollectionsKt.sortedWith((Iterable)iterable, (Comparator)preferredSdkComparator);
    }

    public void checkSdk(@Nullable Sdk sdk, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
    }

    @NotNull
    public String getSampleFilePath() {
        return this.sampleFilePath;
    }

    public void startFromWelcomeFrame(@NotNull Function1<? super Sdk, Unit> startCallback) {
        Intrinsics.checkNotNullParameter(startCallback, (String)"startCallback");
        PyConfigurableInterpreterList pyConfigurableInterpreterList = PyConfigurableInterpreterList.getInstance(null);
        Intrinsics.checkNotNullExpressionValue((Object)pyConfigurableInterpreterList, (String)"PyConfigurableInterpreterList.getInstance(null)");
        ProjectSdksModel projectSdksModel = pyConfigurableInterpreterList.getModel();
        Intrinsics.checkNotNullExpressionValue((Object)projectSdksModel, (String)"PyConfigurableInterprete\u2026t.getInstance(null).model");
        Sdk[] sdkArray = projectSdksModel.getSdks();
        Intrinsics.checkNotNullExpressionValue((Object)sdkArray, (String)"PyConfigurableInterprete\u2026Instance(null).model.sdks");
        List allExistingSdks = CollectionsKt.listOf((Object[])Arrays.copyOf(sdkArray, sdkArray.length));
        List<Sdk> list = ProjectSpecificSettingsStep.getValidPythonSdks(allExistingSdks);
        Intrinsics.checkNotNullExpressionValue(list, (String)"ProjectSpecificSettingsS\u2026thonSdks(allExistingSdks)");
        List<Sdk> existingSdks2 = list;
        UserDataHolderBase context2 = new UserDataHolderBase();
        List<Sdk> baseSdks = PySdkExtKt.findBaseSdks(existingSdks2, null, (UserDataHolder)context2);
        if (baseSdks.isEmpty()) {
            JPanel formPanel;
            PySdkPathChoosingComboBox baseSdkField = new PySdkPathChoosingComboBox(null, null, null, null, 15, null);
            JLabel warningPlaceholder = new JLabel();
            FormBuilder formBuilder = FormBuilder.createFormBuilder().addComponent((JComponent)warningPlaceholder).addLabeledComponent(PySdkBundle.message("python.venv.base.label", new Object[0]), (JComponent)((Object)baseSdkField));
            Intrinsics.checkNotNullExpressionValue((Object)formBuilder, (String)"FormBuilder.createFormBu\u2026se.label\"), baseSdkField)");
            JPanel jPanel = formPanel = formBuilder.getPanel();
            Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"formPanel");
            int n = formPanel.getPreferredSize().width;
            int n2 = 500;
            jPanel.setPreferredSize(new Dimension(Math.max(n, n2), formPanel.getPreferredSize().height));
            ProjectManager projectManager = ProjectManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)projectManager, (String)"ProjectManager.getInstance()");
            DialogWrapper dialog2 = new DialogWrapper(formPanel, projectManager.getDefaultProject()){
                final /* synthetic */ JPanel $formPanel;

                @NotNull
                protected JComponent createCenterPanel() {
                    JPanel jPanel = this.$formPanel;
                    Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"formPanel");
                    return jPanel;
                }
                {
                    this.$formPanel = $captured_local_variable$0;
                    super($super_call_param$1);
                    this.setTitle(PyBundle.message("sdk.select.path", new Object[0]));
                    this.init();
                }
            };
            PyAddSdkPanelKt.addBaseInterpretersAsync(baseSdkField, existingSdks2, null, (UserDataHolder)context2, (Function0<Unit>)((Function0)new Function0<Unit>(baseSdkField, warningPlaceholder){
                final /* synthetic */ PySdkPathChoosingComboBox $baseSdkField;
                final /* synthetic */ JLabel $warningPlaceholder;

                public final void invoke() {
                    Sdk selectedSdk = this.$baseSdkField.getSelectedSdk();
                    if (selectedSdk instanceof PySdkToInstall) {
                        PySdkToInstall pySdkToInstall = (PySdkToInstall)selectedSdk;
                        String string = Messages.getOkButton();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Messages.getOkButton()");
                        String installationWarning = pySdkToInstall.getInstallationWarning(string);
                        this.$warningPlaceholder.setText("<html>" + installationWarning + "</html>");
                    } else {
                        this.$warningPlaceholder.setText("");
                    }
                }
                {
                    this.$baseSdkField = pySdkPathChoosingComboBox;
                    this.$warningPlaceholder = jLabel;
                    super(0);
                }
            }));
            dialog2.setTitle(PythonLessonsBundle.INSTANCE.message("choose.python.sdk.to.start.learning.header", new Object[0]));
            if (dialog2.showAndGet()) {
                Sdk selectedSdk = baseSdkField.getSelectedSdk();
                if (selectedSdk == null) {
                    return;
                }
                startCallback.invoke((Object)selectedSdk);
            }
        } else {
            startCallback.invoke(null);
        }
    }

    public boolean isSdkConfigured(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return PySdkExtKt.getPythonSdk(project) != null;
    }

    @NotNull
    public Function2<LessonContext, KLesson, Unit> getSdkConfigurationTasks() {
        return this.sdkConfigurationTasks;
    }

    public PythonBasedLangSupport() {
        this.sampleFilePath = "src/sandbox.py";
    }
}

