/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.google.common.collect.Lists;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.ASTNode;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlStringUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonUiService;
import com.jetbrains.python.codeInsight.PyPsiIndexUtil;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.PyRemoveArgumentQuickFix;
import com.jetbrains.python.inspections.quickfix.PyRenameArgumentQuickFix;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyKnownDecoratorUtil;
import com.jetbrains.python.psi.PyPossibleClassMember;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySingleStarParameter;
import com.jetbrains.python.psi.PySlashParameter;
import com.jetbrains.python.psi.PyStarArgument;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.ParamHelper;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.types.PyABCUtil;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyArgumentListInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyArgumentListInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PyArgumentListInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(holder, PyInspectionVisitor.getContext(session));
    }

    private static void inspectPyArgumentList(@NotNull PyArgumentList node, @NotNull ProblemsHolder holder, @NotNull PyResolveContext resolveContext) {
        if (node == null) {
            PyArgumentListInspection.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            PyArgumentListInspection.$$$reportNull$$$0(3);
        }
        if (resolveContext == null) {
            PyArgumentListInspection.$$$reportNull$$$0(4);
        }
        if (node.getParent() instanceof PyClass) {
            return;
        }
        PyCallExpression call = node.getCallExpression();
        if (call == null) {
            return;
        }
        TypeEvalContext context2 = resolveContext.getTypeEvalContext();
        List<PyCallExpression.PyArgumentsMapping> mappings = call.multiMapArguments(resolveContext);
        for (PyCallExpression.PyArgumentsMapping mapping : mappings) {
            PyCallable callable;
            PyCallableType callableType = mapping.getCallableType();
            if (callableType == null || !((callable = callableType.getCallable()) instanceof PyFunction)) continue;
            PyFunction function = (PyFunction)callable;
            if (PyKnownDecoratorUtil.hasUnknownOrChangingSignatureDecorator(function, context2) || PyArgumentListInspection.decoratedClassInitCall(call.getCallee(), function, resolveContext)) {
                return;
            }
            if (!PyArgumentListInspection.objectMethodCallViaSuper(call, function)) continue;
            return;
        }
        PyArgumentListInspection.highlightUnexpectedArguments(node, holder, mappings, context2);
        PyArgumentListInspection.highlightUnfilledParameters(node, holder, mappings, context2);
        PyArgumentListInspection.highlightStarArgumentTypeMismatch(node, holder, context2);
    }

    private static boolean decoratedClassInitCall(@Nullable PyExpression callee, @NotNull PyFunction function, @NotNull PyResolveContext resolveContext) {
        if (function == null) {
            PyArgumentListInspection.$$$reportNull$$$0(5);
        }
        if (resolveContext == null) {
            PyArgumentListInspection.$$$reportNull$$$0(6);
        }
        if (callee instanceof PyReferenceExpression && PyUtil.isInitMethod(function)) {
            PsiPolyVariantReference classReference = ((PyReferenceExpression)callee).getReference(resolveContext);
            return Arrays.stream(classReference.multiResolve(false)).map(ResolveResult::getElement).anyMatch(element -> element instanceof PyClass && PyKnownDecoratorUtil.hasUnknownOrChangingReturnTypeDecorator((PyClass)element, resolveContext.getTypeEvalContext()));
        }
        return false;
    }

    private static boolean objectMethodCallViaSuper(@NotNull PyCallExpression call, @NotNull PyFunction function) {
        PyExpression receiverExpression;
        PyClass receiverClass;
        if (call == null) {
            PyArgumentListInspection.$$$reportNull$$$0(7);
        }
        if (function == null) {
            PyArgumentListInspection.$$$reportNull$$$0(8);
        }
        return (receiverClass = function.getContainingClass()) != null && PyUtil.isObjectClass(receiverClass) && (receiverExpression = call.getReceiver(null)) instanceof PyCallExpression && PyUtil.isSuperCall((PyCallExpression)receiverExpression);
    }

    private static void highlightStarArgumentTypeMismatch(PyArgumentList node, ProblemsHolder holder, TypeEvalContext context2) {
        for (PyExpression arg : node.getArguments()) {
            PyType inside_type;
            PyExpression content2;
            if (!(arg instanceof PyStarArgument) || (content2 = PyUtil.peelArgument((PyExpression)PsiTreeUtil.findChildOfType((PsiElement)arg, PyExpression.class))) == null || (inside_type = context2.getType(content2)) == null || PyTypeChecker.isUnknown(inside_type, context2)) continue;
            if (((PyStarArgument)arg).isKeyword()) {
                if (PyABCUtil.isSubtype(inside_type, "Mapping", context2)) continue;
                holder.registerProblem((PsiElement)arg, PyPsiBundle.message("INSP.expected.dict.got.type", inside_type.getName()), new LocalQuickFix[0]);
                continue;
            }
            if (PyABCUtil.isSubtype(inside_type, "Iterable", context2)) continue;
            holder.registerProblem((PsiElement)arg, PyPsiBundle.message("INSP.expected.iterable.got.type", inside_type.getName()), new LocalQuickFix[0]);
        }
    }

    private static Set<String> getDuplicateKeywordArguments(@NotNull PyArgumentList node) {
        if (node == null) {
            PyArgumentListInspection.$$$reportNull$$$0(9);
        }
        HashSet<String> keywordArgumentNames = new HashSet<String>();
        HashSet<String> results = new HashSet<String>();
        for (PyExpression argument : node.getArguments()) {
            if (!(argument instanceof PyKeywordArgument)) continue;
            String keyword = ((PyKeywordArgument)argument).getKeyword();
            if (keywordArgumentNames.contains(keyword)) {
                results.add(keyword);
            }
            keywordArgumentNames.add(keyword);
        }
        return results;
    }

    private static void highlightUnexpectedArguments(@NotNull PyArgumentList node, @NotNull ProblemsHolder holder, @NotNull List<PyCallExpression.PyArgumentsMapping> mappings, @NotNull TypeEvalContext context2) {
        if (node == null) {
            PyArgumentListInspection.$$$reportNull$$$0(10);
        }
        if (holder == null) {
            PyArgumentListInspection.$$$reportNull$$$0(11);
        }
        if (mappings == null) {
            PyArgumentListInspection.$$$reportNull$$$0(12);
        }
        if (context2 == null) {
            PyArgumentListInspection.$$$reportNull$$$0(13);
        }
        if (mappings.isEmpty() || mappings.stream().anyMatch(mapping -> mapping.getUnmappedArguments().isEmpty())) {
            return;
        }
        if (mappings.size() == 1) {
            PyCallableType callableType;
            Set<String> duplicateKeywords = PyArgumentListInspection.getDuplicateKeywordArguments(node);
            PyCallExpression.PyArgumentsMapping mapping2 = mappings.get(0);
            if (holder.isOnTheFly() && !mapping2.getUnmappedArguments().isEmpty() && mapping2.getUnmappedParameters().isEmpty() && (callableType = mapping2.getCallableType()) != null) {
                PyCallable callable = callableType.getCallable();
                Project project = node.getProject();
                if (callable instanceof PyFunction && !PyPsiIndexUtil.isNotUnderSourceRoot(project, callable.getContainingFile())) {
                    String message = PyPsiBundle.message("INSP.unexpected.arg(s)", new Object[0]);
                    holder.registerProblem((PsiElement)node, message, ProblemHighlightType.INFORMATION, new LocalQuickFix[]{PythonUiService.getInstance().createPyChangeSignatureQuickFixForMismatchedCall(mapping2)});
                }
            }
            for (PyExpression argument : mapping2.getUnmappedArguments()) {
                ArrayList quickFixes = Lists.newArrayList((Object[])new LocalQuickFix[]{new PyRemoveArgumentQuickFix()});
                if (argument instanceof PyKeywordArgument) {
                    if (duplicateKeywords.contains(((PyKeywordArgument)argument).getKeyword())) continue;
                    quickFixes.add(new PyRenameArgumentQuickFix());
                }
                holder.registerProblem((PsiElement)argument, PyPsiBundle.message("INSP.unexpected.arg", new Object[0]), quickFixes.toArray(new LocalQuickFix[quickFixes.size() - 1]));
            }
        } else {
            holder.registerProblem((PsiElement)node, PyArgumentListInspection.addPossibleCalleesRepresentation(PyPsiBundle.message("INSP.unexpected.arg(s)", new Object[0]), mappings, context2, holder.isOnTheFly()), new LocalQuickFix[0]);
        }
    }

    private static void highlightUnfilledParameters(@NotNull PyArgumentList node, @NotNull ProblemsHolder holder, @NotNull List<PyCallExpression.PyArgumentsMapping> mappings, @NotNull TypeEvalContext context2) {
        if (node == null) {
            PyArgumentListInspection.$$$reportNull$$$0(14);
        }
        if (holder == null) {
            PyArgumentListInspection.$$$reportNull$$$0(15);
        }
        if (mappings == null) {
            PyArgumentListInspection.$$$reportNull$$$0(16);
        }
        if (context2 == null) {
            PyArgumentListInspection.$$$reportNull$$$0(17);
        }
        if (mappings.isEmpty() || mappings.stream().anyMatch(mapping -> mapping.getUnmappedParameters().isEmpty())) {
            return;
        }
        Optional.ofNullable(node.getNode()).map(astNode -> astNode.findChildByType((IElementType)PyTokenTypes.RPAR)).map(ASTNode::getPsi).ifPresent(psi -> {
            if (mappings.size() != 1 || ContainerUtil.exists(((PyCallExpression.PyArgumentsMapping)mappings.get(0)).getUnmappedParameters(), parameter -> parameter.getName() == null)) {
                holder.registerProblem(psi, PyArgumentListInspection.addPossibleCalleesRepresentation(PyPsiBundle.message("INSP.parameter(s).unfilled", new Object[0]), mappings, context2, holder.isOnTheFly()), new LocalQuickFix[0]);
            } else {
                ((StreamEx)StreamEx.of(((PyCallExpression.PyArgumentsMapping)mappings.get(0)).getUnmappedParameters()).map(PyCallableParameter::getName).filter(Objects::nonNull)).forEach(name2 -> holder.registerProblem(psi, PyPsiBundle.message("INSP.parameter.unfilled", name2), new LocalQuickFix[0]));
            }
        });
    }

    @NlsSafe
    @NotNull
    private static String addPossibleCalleesRepresentation(@NotNull @InspectionMessage String prefix, @NotNull List<PyCallExpression.PyArgumentsMapping> mappings, @NotNull TypeEvalContext context2, boolean isOnTheFly) {
        if (prefix == null) {
            PyArgumentListInspection.$$$reportNull$$$0(18);
        }
        if (mappings == null) {
            PyArgumentListInspection.$$$reportNull$$$0(19);
        }
        if (context2 == null) {
            PyArgumentListInspection.$$$reportNull$$$0(20);
        }
        @NlsSafe String separator = isOnTheFly ? "<br>" : " ";
        @NlsSafe String possibleCalleesRepresentation = PyArgumentListInspection.calculatePossibleCalleesRepresentation(mappings, context2, isOnTheFly);
        if (isOnTheFly) {
            String string = XmlStringUtil.wrapInHtml((CharSequence)(prefix + separator + PyPsiBundle.message("INSP.possible.callees", new Object[0]) + ":" + separator + possibleCalleesRepresentation));
            if (string == null) {
                PyArgumentListInspection.$$$reportNull$$$0(21);
            }
            return string;
        }
        String string = prefix + "." + separator + PyPsiBundle.message("INSP.possible.callees", new Object[0]) + ":" + separator + possibleCalleesRepresentation;
        if (string == null) {
            PyArgumentListInspection.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    private static String calculatePossibleCalleesRepresentation(@NotNull List<PyCallExpression.PyArgumentsMapping> mappings, @NotNull TypeEvalContext context2, boolean isOnTheFly) {
        if (mappings == null) {
            PyArgumentListInspection.$$$reportNull$$$0(23);
        }
        if (context2 == null) {
            PyArgumentListInspection.$$$reportNull$$$0(24);
        }
        String string = (String)StreamEx.of(mappings).map(PyCallExpression.PyArgumentsMapping::getCallableType).nonNull().map(callableType -> XmlStringUtil.escapeString((String)PyArgumentListInspection.calculatePossibleCalleeRepresentation(callableType, context2))).nonNull().collect(Collectors.joining(isOnTheFly ? "<br>" : " "));
        if (string == null) {
            PyArgumentListInspection.$$$reportNull$$$0(25);
        }
        return string;
    }

    @Nullable
    @NlsSafe
    private static String calculatePossibleCalleeRepresentation(@NotNull PyCallableType callableType, @NotNull TypeEvalContext context2) {
        if (callableType == null) {
            PyArgumentListInspection.$$$reportNull$$$0(26);
        }
        if (context2 == null) {
            PyArgumentListInspection.$$$reportNull$$$0(27);
        }
        String name2 = callableType.getCallable() != null ? callableType.getCallable().getName() : "";
        List<PyCallableParameter> callableParameters = callableType.getParameters(context2);
        if (callableParameters == null) {
            return null;
        }
        String parameters = ParamHelper.getPresentableText(callableParameters, true, context2);
        String callableNameAndParameters = name2 + parameters;
        return Optional.ofNullable(PyUtil.as(callableType.getCallable(), PyFunction.class)).map(PyPossibleClassMember::getContainingClass).map(NavigationItem::getName).map(className -> "__init__".equals(name2) ? className + parameters : className + "." + callableNameAndParameters).orElse(callableNameAndParameters);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 21: 
            case 22: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 21: 
            case 22: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 9: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveContext";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 12: 
            case 16: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappings";
                break;
            }
            case 13: 
            case 17: 
            case 20: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 21: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyArgumentListInspection";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callableType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyArgumentListInspection";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "addPossibleCalleesRepresentation";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "calculatePossibleCalleesRepresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "inspectPyArgumentList";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "decoratedClassInitCall";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "objectMethodCallViaSuper";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDuplicateKeywordArguments";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "highlightUnexpectedArguments";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "highlightUnfilledParameters";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addPossibleCalleesRepresentation";
                break;
            }
            case 21: 
            case 22: 
            case 25: {
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "calculatePossibleCalleesRepresentation";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "calculatePossibleCalleeRepresentation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 21: 
            case 22: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Visitor
    extends PyInspectionVisitor {
        Visitor(@NotNull ProblemsHolder holder, @NotNull TypeEvalContext context2) {
            if (holder == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            if (context2 == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            super(holder, context2);
        }

        @Override
        @NotNull
        protected ProblemsHolder getHolder() {
            ProblemsHolder problemsHolder = super.getHolder();
            if (problemsHolder == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            return problemsHolder;
        }

        @Override
        public void visitPyArgumentList(@NotNull PyArgumentList node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(3);
            }
            PyArgumentListInspection.inspectPyArgumentList(node, this.getHolder(), this.getResolveContext());
        }

        @Override
        public void visitPyDecorator(@NotNull PyDecorator deco) {
            if (deco == null) {
                Visitor.$$$reportNull$$$0(4);
            }
            if (deco.hasArgumentList()) {
                return;
            }
            PyCallableType callableType = (PyCallableType)ContainerUtil.getFirstItem(deco.multiResolveCallee(this.getResolveContext()));
            if (callableType != null) {
                PyCallable callable = callableType.getCallable();
                if (callable == null) {
                    return;
                }
                int firstParamOffset = callableType.getImplicitOffset();
                List<PyCallableParameter> params = callableType.getParameters(this.myTypeEvalContext);
                if (params == null) {
                    return;
                }
                PyCallableParameter allegedFirstParam = (PyCallableParameter)ContainerUtil.getOrElse(params, (int)(firstParamOffset - 1), null);
                if (allegedFirstParam == null || allegedFirstParam.isKeywordContainer()) {
                    this.registerProblem((PsiElement)deco, PyPsiBundle.message("INSP.function.lacks.positional.argument", callable.getName()));
                } else {
                    for (int i = firstParamOffset; i < params.size(); ++i) {
                        PyCallableParameter parameter = params.get(i);
                        if (parameter.getParameter() instanceof PySingleStarParameter || parameter.getParameter() instanceof PySlashParameter || parameter.isKeywordContainer() || parameter.isPositionalContainer() || parameter.hasDefaultValue()) continue;
                        String parameterName = parameter.getName();
                        this.registerProblem((PsiElement)deco, PyPsiBundle.message("INSP.parameter.unfilled", parameterName == null ? "(...)" : parameterName));
                    }
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyArgumentListInspection$Visitor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "deco";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyArgumentListInspection$Visitor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHolder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "visitPyArgumentList";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "visitPyDecorator";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

