/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyAnnotationOwner;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTypeCommentOwner;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/python/inspections/PyClassVarInspection;", "Lcom/jetbrains/python/inspections/PyInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "Visitor", "intellij.python.psi.impl"})
public final class PyClassVarInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        TypeEvalContext typeEvalContext = PyInspectionVisitor.getContext(session);
        Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"PyInspectionVisitor.getContext(session)");
        return new Visitor(holder, typeEvalContext);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\nH\u0016J\f\u0010\u001b\u001a\u00020\u0012*\u00020\nH\u0002J\u001f\u0010\u001c\u001a\u00020\u0012\"\f\b\u0000\u0010\u001d*\u00020\u001e*\u00020\u001f*\u0002H\u001dH\u0002\u00a2\u0006\u0002\u0010 \u00a8\u0006!"}, d2={"Lcom/jetbrains/python/inspections/PyClassVarInspection$Visitor;", "Lcom/jetbrains/python/inspections/PyInspectionVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "context", "Lcom/jetbrains/python/psi/types/TypeEvalContext;", "(Lcom/intellij/codeInspection/ProblemsHolder;Lcom/jetbrains/python/psi/types/TypeEvalContext;)V", "checkClassVarDeclaration", "", "target", "Lcom/jetbrains/python/psi/PyTargetExpression;", "checkClassVarReassignment", "checkInheritedClassClassVarReassignmentOnClassLevel", "cls", "Lcom/jetbrains/python/psi/PyClass;", "checkInstanceClassVarReassignment", "Lcom/jetbrains/python/psi/PyQualifiedExpression;", "resolvesToClassVar", "", "expression", "Lcom/jetbrains/python/psi/PyExpression;", "visitPyFunction", "node", "Lcom/jetbrains/python/psi/PyFunction;", "visitPyNamedParameter", "Lcom/jetbrains/python/psi/PyNamedParameter;", "visitPyTargetExpression", "hasExplicitType", "isClassVar", "T", "Lcom/jetbrains/python/psi/PyAnnotationOwner;", "Lcom/jetbrains/python/psi/PyTypeCommentOwner;", "(Lcom/jetbrains/python/psi/PyAnnotationOwner;)Z", "intellij.python.psi.impl"})
    private static final class Visitor
    extends PyInspectionVisitor {
        @Override
        public void visitPyTargetExpression(@NotNull PyTargetExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            super.visitPyTargetExpression(node);
            if (node.hasAssignedValue()) {
                if (node.isQualified()) {
                    this.checkClassVarReassignment(node);
                } else {
                    this.checkClassVarDeclaration(node);
                }
            }
        }

        @Override
        public void visitPyNamedParameter(@NotNull PyNamedParameter node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            super.visitPyNamedParameter(node);
            if (this.isClassVar((PyAnnotationOwner)node)) {
                PyElement pyElement = node.getAnnotation();
                this.registerProblem(pyElement != null && (pyElement = pyElement.getValue()) != null ? (PsiElement)pyElement : (PsiElement)node.getTypeComment(), PyPsiBundle.message("INSP.class.var.can.not.be.used.in.annotations.for.function.parameters", new Object[0]));
            }
        }

        @Override
        public void visitPyFunction(@NotNull PyFunction node) {
            block3: {
                PyExpression pyExpression;
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                super.visitPyFunction(node);
                PyExpression pyExpression2 = PyTypingTypeProvider.getReturnTypeAnnotation(node, this.myTypeEvalContext);
                if (pyExpression2 == null) break block3;
                PyExpression it = pyExpression = pyExpression2;
                boolean bl = false;
                PyExpression pyExpression3 = it instanceof PySubscriptionExpression ? ((PySubscriptionExpression)it).getOperand() : it;
                Intrinsics.checkNotNullExpressionValue((Object)pyExpression3, (String)"if (it is PySubscription\u2026ssion) it.operand else it");
                if (this.resolvesToClassVar(pyExpression3)) {
                    PsiElement psiElement;
                    PsiComment psiComment = node.getTypeComment();
                    if (psiComment != null) {
                        psiElement = (PsiElement)psiComment;
                    } else {
                        PyAnnotation pyAnnotation = node.getAnnotation();
                        psiElement = (PsiElement)(pyAnnotation != null ? pyAnnotation.getValue() : null);
                    }
                    this.registerProblem(psiElement, PyPsiBundle.message("INSP.class.var.can.not.be.used.in.annotation.for.function.return.value", new Object[0]));
                }
            }
        }

        private final void checkClassVarDeclaration(PyTargetExpression target) {
            block5: {
                ScopeOwner scopeOwner;
                block6: {
                    PsiElement psiElement;
                    block4: {
                        PsiElement psiElement2;
                        scopeOwner = ScopeUtil.getScopeOwner(target);
                        if (!(scopeOwner instanceof PyFile)) break block4;
                        if (!PyUtil.isTopLevel(target) || !this.isClassVar((PyAnnotationOwner)target)) break block5;
                        PsiComment psiComment = target.getTypeComment();
                        if (psiComment != null) {
                            psiElement2 = (PsiElement)psiComment;
                        } else {
                            PyAnnotation pyAnnotation = target.getAnnotation();
                            psiElement2 = (PsiElement)(pyAnnotation != null ? pyAnnotation.getValue() : null);
                        }
                        this.registerProblem(psiElement2, PyPsiBundle.message("INSP.class.var.can.be.used.only.in.class.body", new Object[0]));
                        break block5;
                    }
                    if (!(scopeOwner instanceof PyFunction)) break block6;
                    if (!this.isClassVar((PyAnnotationOwner)target)) break block5;
                    PsiComment psiComment = target.getTypeComment();
                    if (psiComment != null) {
                        psiElement = (PsiElement)psiComment;
                    } else {
                        PyAnnotation pyAnnotation = target.getAnnotation();
                        psiElement = (PsiElement)(pyAnnotation != null ? pyAnnotation.getValue() : null);
                    }
                    this.registerProblem(psiElement, PyPsiBundle.message("INSP.class.var.can.not.be.used.in.function.body", new Object[0]));
                    break block5;
                }
                if (!(scopeOwner instanceof PyClass)) break block5;
                this.checkInheritedClassClassVarReassignmentOnClassLevel(target, (PyClass)scopeOwner);
            }
        }

        private final void checkClassVarReassignment(PyTargetExpression target) {
            PyType qualifierType;
            PyType pyType;
            PyExpression pyExpression = target.getQualifier();
            if (pyExpression != null) {
                PyExpression pyExpression2;
                PyExpression it = pyExpression2 = pyExpression;
                boolean bl = false;
                pyType = this.myTypeEvalContext.getType(it);
            } else {
                pyType = qualifierType = null;
            }
            if (qualifierType instanceof PyClassType && !((PyClassType)qualifierType).isDefinition()) {
                PyQualifiedExpression pyQualifiedExpression = target;
                PyClass pyClass = ((PyClassType)qualifierType).getPyClass();
                Intrinsics.checkNotNullExpressionValue((Object)pyClass, (String)"qualifierType.pyClass");
                this.checkInstanceClassVarReassignment(pyQualifiedExpression, pyClass);
            }
        }

        private final void checkInheritedClassClassVarReassignmentOnClassLevel(PyTargetExpression target, PyClass cls) {
            String string = target.getName();
            if (string == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"target.name ?: return");
            String name2 = string;
            for (PyClass ancestor : cls.getAncestorClasses(this.myTypeEvalContext)) {
                PyTargetExpression ancestorClassAttribute = ancestor.findClassAttribute(name2, false, this.myTypeEvalContext);
                if (ancestorClassAttribute == null || !this.hasExplicitType(ancestorClassAttribute) || !this.hasExplicitType(target)) continue;
                if (this.isClassVar((PyAnnotationOwner)ancestorClassAttribute) && !this.isClassVar((PyAnnotationOwner)target)) {
                    PsiElement psiElement = target;
                    Object[] objectArray = new Object[2];
                    objectArray[0] = name2;
                    PyClass pyClass = ancestor;
                    Intrinsics.checkNotNullExpressionValue((Object)pyClass, (String)"ancestor");
                    objectArray[1] = pyClass.getName();
                    this.registerProblem(psiElement, PyPsiBundle.message("INSP.class.var.can.not.override.class.variable", objectArray));
                    break;
                }
                if (this.isClassVar((PyAnnotationOwner)ancestorClassAttribute) || !this.isClassVar((PyAnnotationOwner)target)) continue;
                PsiElement psiElement = target;
                Object[] objectArray = new Object[2];
                objectArray[0] = name2;
                PyClass pyClass = ancestor;
                Intrinsics.checkNotNullExpressionValue((Object)pyClass, (String)"ancestor");
                objectArray[1] = pyClass.getName();
                this.registerProblem(psiElement, PyPsiBundle.message("INSP.class.var.can.not.override.instance.variable", objectArray));
                break;
            }
        }

        private final void checkInstanceClassVarReassignment(PyQualifiedExpression target, PyClass cls) {
            String string = target.getName();
            if (string == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"target.name ?: return");
            String name2 = string;
            Collection collection = CollectionsKt.listOf((Object)cls);
            List<PyClass> list = cls.getAncestorClasses(this.myTypeEvalContext);
            Intrinsics.checkNotNullExpressionValue(list, (String)"cls.getAncestorClasses(myTypeEvalContext)");
            for (PyClass ancestor : CollectionsKt.plus((Collection)collection, (Iterable)list)) {
                PyTargetExpression inheritedClassAttribute = ancestor.findClassAttribute(name2, false, this.myTypeEvalContext);
                if (inheritedClassAttribute == null || !this.isClassVar((PyAnnotationOwner)inheritedClassAttribute)) continue;
                this.registerProblem((PsiElement)target, PyPsiBundle.message("INSP.class.var.can.not.be.assigned.to.instance", name2));
                return;
            }
        }

        private final boolean hasExplicitType(PyTargetExpression $this$hasExplicitType) {
            return $this$hasExplicitType.getAnnotationValue() != null || $this$hasExplicitType.getTypeCommentAnnotation() != null;
        }

        private final <T extends PyAnnotationOwner & PyTypeCommentOwner> boolean isClassVar(T $this$isClassVar) {
            return PyTypingTypeProvider.isClassVar($this$isClassVar, this.myTypeEvalContext);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean resolvesToClassVar(PyExpression expression) {
            String it;
            if (!(expression instanceof PyReferenceExpression)) return false;
            Collection<String> collection = PyTypingTypeProvider.resolveToQualifiedNames(expression, this.myTypeEvalContext);
            Intrinsics.checkNotNullExpressionValue(collection, (String)"PyTypingTypeProvider.res\u2026ssion, myTypeEvalContext)");
            Iterable $this$any$iv = collection;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator = $this$any$iv.iterator();
            do {
                if (!iterator.hasNext()) return false;
                Object element$iv = iterator.next();
                it = (String)element$iv;
                boolean bl = false;
            } while (!Intrinsics.areEqual((Object)it, (Object)"typing.ClassVar"));
            return true;
        }

        public Visitor(@NotNull ProblemsHolder holder, @NotNull TypeEvalContext context2) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            super(holder, context2);
        }
    }
}

