/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.namespacePackages.PyNamespacePackagesService;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003\u000b\f\rB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/python/inspections/PyRelativeImportInspection;", "Lcom/jetbrains/python/inspections/PyInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "PyChangeToSameDirectoryImportQuickFix", "PyMarkAsNamespacePackageQuickFix", "Visitor", "intellij.python.community.impl"})
public final class PyRelativeImportInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        if (!PyNamespacePackagesService.isEnabled() || LanguageLevel.forElement((PsiElement)holder.getFile()).isOlderThan(LanguageLevel.PYTHON34)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"PsiElementVisitor.EMPTY_VISITOR");
            return psiElementVisitor;
        }
        TypeEvalContext typeEvalContext = PyInspectionVisitor.getContext(session);
        Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"PyInspectionVisitor.getContext(session)");
        return new Visitor(holder, typeEvalContext);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/python/inspections/PyRelativeImportInspection$Visitor;", "Lcom/jetbrains/python/inspections/PyInspectionVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "context", "Lcom/jetbrains/python/psi/types/TypeEvalContext;", "(Lcom/intellij/codeInspection/ProblemsHolder;Lcom/jetbrains/python/psi/types/TypeEvalContext;)V", "getMarkAsNamespacePackageQuickFix", "Lcom/jetbrains/python/inspections/PyRelativeImportInspection$PyMarkAsNamespacePackageQuickFix;", "directory", "Lcom/intellij/psi/PsiDirectory;", "handleRelativeImportNotInsidePackage", "", "node", "Lcom/jetbrains/python/psi/PyFromImportStatement;", "isInsideOrdinaryPackage", "", "visitPyFromImportStatement", "intellij.python.community.impl"})
    private static final class Visitor
    extends PyInspectionVisitor {
        @Override
        public void visitPyFromImportStatement(@NotNull PyFromImportStatement node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            PsiFile psiFile = node.getContainingFile();
            if (psiFile == null || (psiFile = psiFile.getContainingDirectory()) == null) {
                return;
            }
            PsiFile directory2 = psiFile;
            if (node.getRelativeLevel() > 0 && !PyUtil.isExplicitPackage((PsiDirectory)directory2) && !this.isInsideOrdinaryPackage((PsiDirectory)directory2)) {
                this.handleRelativeImportNotInsidePackage(node, (PsiDirectory)directory2);
            }
        }

        private final boolean isInsideOrdinaryPackage(PsiDirectory directory2) {
            for (PsiDirectory curDir = directory2; curDir != null; curDir = curDir.getParentDirectory()) {
                if (!PyUtil.isOrdinaryPackage(curDir)) continue;
                return true;
            }
            return false;
        }

        private final void handleRelativeImportNotInsidePackage(PyFromImportStatement node, PsiDirectory directory2) {
            List fixes = new ArrayList();
            PyMarkAsNamespacePackageQuickFix pyMarkAsNamespacePackageQuickFix = this.getMarkAsNamespacePackageQuickFix(directory2);
            if (pyMarkAsNamespacePackageQuickFix != null) {
                PyMarkAsNamespacePackageQuickFix pyMarkAsNamespacePackageQuickFix2;
                PyMarkAsNamespacePackageQuickFix it = pyMarkAsNamespacePackageQuickFix2 = pyMarkAsNamespacePackageQuickFix;
                boolean bl = false;
                fixes.add(it);
            }
            if (node.getRelativeLevel() == 1) {
                fixes.add(new PyChangeToSameDirectoryImportQuickFix());
            }
            String string = PyPsiBundle.message("INSP.relative.import.relative.import.outside.package", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PyPsiBundle.message(\"INS\u2026.import.outside.package\")");
            String message = string;
            Collection $this$toTypedArray$iv = fixes;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            LocalQuickFix[] localQuickFixArray = thisCollection$iv.toArray(new LocalQuickFix[0]);
            if (localQuickFixArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            this.registerProblem((PsiElement)node, message, Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
        }

        private final PyMarkAsNamespacePackageQuickFix getMarkAsNamespacePackageQuickFix(PsiDirectory directory2) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)directory2));
            if (module == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)module, (String)"ModuleUtilCore.findModul\u2026directory) ?: return null");
            Module module2 = module;
            PsiDirectory curDir = directory2;
            while (curDir != null) {
                Intrinsics.checkNotNullExpressionValue((Object)curDir.getVirtualFile(), (String)"curDir.virtualFile");
                if (PyUtil.isRoot((PsiFileSystemItem)curDir)) {
                    return null;
                }
                PsiDirectory parentDir = curDir.getParentDirectory();
                if (parentDir != null && (PyUtil.isRoot((PsiFileSystemItem)parentDir) || PyUtil.isOrdinaryPackage(parentDir))) {
                    VirtualFile virtualFile;
                    return new PyMarkAsNamespacePackageQuickFix(module2, virtualFile);
                }
                curDir = parentDir;
            }
            return null;
        }

        public Visitor(@NotNull ProblemsHolder holder, @NotNull TypeEvalContext context2) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            super(holder, context2);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/python/inspections/PyRelativeImportInspection$PyMarkAsNamespacePackageQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "module", "Lcom/intellij/openapi/module/Module;", "directory", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/module/Module;Lcom/intellij/openapi/vfs/VirtualFile;)V", "getDirectory", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getModule", "()Lcom/intellij/openapi/module/Module;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "intellij.python.community.impl"})
    private static final class PyMarkAsNamespacePackageQuickFix
    implements LocalQuickFix {
        @NotNull
        private final Module module;
        @NotNull
        private final VirtualFile directory;

        @NotNull
        public String getFamilyName() {
            String string = PyBundle.message("QFIX.mark.as.namespace.package", this.directory.getName());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PyBundle.message(\"QFIX.m\u2026package\", directory.name)");
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
            PsiElement psiElement = descriptor2.getPsiElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"descriptor.psiElement");
            Document document = psiDocumentManager.getDocument(psiElement.getContainingFile());
            var undoableAction2 = new BasicUndoableAction(this, document, new Document[]{document}){
                final /* synthetic */ PyMarkAsNamespacePackageQuickFix this$0;
                final /* synthetic */ Document $document;

                public void undo() {
                    PyNamespacePackagesService.getInstance(this.this$0.getModule()).toggleMarkingAsNamespacePackage(this.this$0.getDirectory());
                }

                public void redo() {
                    PyNamespacePackagesService.getInstance(this.this$0.getModule()).toggleMarkingAsNamespacePackage(this.this$0.getDirectory());
                }
                {
                    this.this$0 = this$0;
                    this.$document = $captured_local_variable$1;
                    super($super_call_param$2);
                }
            };
            undoableAction2.redo();
            UndoManager.getInstance((Project)project).undoableActionPerformed((UndoableAction)undoableAction2);
        }

        @NotNull
        public final Module getModule() {
            return this.module;
        }

        @NotNull
        public final VirtualFile getDirectory() {
            return this.directory;
        }

        public PyMarkAsNamespacePackageQuickFix(@NotNull Module module, @NotNull VirtualFile directory2) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)directory2, (String)"directory");
            this.module = module;
            this.directory = directory2;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/python/inspections/PyRelativeImportInspection$PyChangeToSameDirectoryImportQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "replaceByImportStatements", "oldImport", "Lcom/jetbrains/python/psi/PyFromImportStatement;", "intellij.python.community.impl"})
    private static final class PyChangeToSameDirectoryImportQuickFix
    implements LocalQuickFix {
        @NotNull
        public String getFamilyName() {
            String string = PyBundle.message("QFIX.change.to.same.directory.import", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PyBundle.message(\"QFIX.c\u2026o.same.directory.import\")");
            return string;
        }

        /*
         * Unable to fully structure code
         */
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            block8: {
                block7: {
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                    v0 = descriptor.getPsiElement();
                    if (!(v0 instanceof PyFromImportStatement)) {
                        v0 = null;
                    }
                    v1 = (PyFromImportStatement)v0;
                    if (v1 == null) {
                        return;
                    }
                    oldImport = v1;
                    v2 = var4_4 = oldImport.getRelativeLevel() == 1;
                    if (_Assertions.ENABLED && !var4_4) {
                        var5_6 = "Assertion failed";
                        throw new AssertionError((Object)var5_6);
                    }
                    qualifier = oldImport.getImportSource();
                    if (qualifier == null) break block7;
                    possibleDot = PsiTreeUtil.prevVisibleLeaf((PsiElement)((PsiElement)qualifier));
                    if (possibleDot == null) ** GOTO lbl-1000
                    v3 = possibleDot.getNode();
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"possibleDot.node");
                    if (Intrinsics.areEqual((Object)v3.getElementType(), (Object)PyTokenTypes.DOT)) {
                        v4 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v4 = var6_8 = false;
                    }
                    if (_Assertions.ENABLED && !var6_8) {
                        var7_9 = "Assertion failed";
                        throw new AssertionError((Object)var7_9);
                    }
                    v5 = possibleDot;
                    if (v5 != null) {
                        v5.delete();
                    }
                    break block8;
                }
                this.replaceByImportStatements(oldImport);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void replaceByImportStatements(PyFromImportStatement oldImport) {
            void $this$mapTo$iv$iv;
            Project project = oldImport.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"oldImport.project");
            Project project2 = project;
            PyElementGenerator generator = PyElementGenerator.getInstance(project2);
            PyImportElement[] pyImportElementArray = oldImport.getImportElements();
            Intrinsics.checkNotNullExpressionValue((Object)pyImportElementArray, (String)"oldImport.importElements");
            PyImportElement[] $this$map$iv = pyImportElementArray;
            boolean $i$f$map = false;
            PyImportElement[] pyImportElementArray2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var13_13 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void v2 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"it");
                String string = v2.getText();
                collection.add(string);
            }
            List names2 = (List)destination$iv$iv;
            if (names2.isEmpty()) {
                return;
            }
            LanguageLevel languageLevel = LanguageLevel.forElement((PsiElement)oldImport);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)languageLevel), (String)"LanguageLevel.forElement(oldImport)");
            LanguageLevel langLevel = languageLevel;
            for (String name2 : CollectionsKt.reversed((Iterable)names2)) {
                PyImportStatement newImport;
                Intrinsics.checkNotNullExpressionValue((Object)generator.createImportStatement(langLevel, name2, null), (String)"generator.createImportSt\u2026nt(langLevel, name, null)");
                oldImport.getParent().addAfter((PsiElement)newImport, (PsiElement)oldImport);
            }
            oldImport.delete();
        }
    }
}

