/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.flake8;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Sets;
import com.intellij.codeInspection.InspectionSuppressor;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import one.util.streamex.StreamEx;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Flake8InspectionSuppressor
implements InspectionSuppressor {
    @NonNls
    public static final String NOQA = "noqa";
    private static final Pattern NOQA_COMMENT_PATTERN = Pattern.compile("# noqa(?::[\\s]?(?<codes>([A-Z]+[0-9]+(?:[,\\s]+)?)+))?.*", 2);
    private static final ImmutableSetMultimap<String, String> ourInspectionToFlake8Code = ImmutableSetMultimap.builder().put((Object)"F401", (Object)"PyUnresolvedReferences").put((Object)"F402", (Object)"PyShadowingNames").put((Object)"F404", (Object)"PyFromFutureImport").put((Object)"F407", (Object)"PyUnresolvedReferences").put((Object)"F601", (Object)"PyDictDuplicateKeys").put((Object)"F602", (Object)"PyDictDuplicateKeys").put((Object)"F622", (Object)"PyTupleAssignmentBalance").put((Object)"F811", (Object)"PyRedeclaration").put((Object)"F812", (Object)"PyRedeclaration").put((Object)"F821", (Object)"PyUnresolvedReferences").put((Object)"F822", (Object)"PyUnresolvedReferences").putAll((Object)"F823", (Object[])new String[]{"PyUnresolvedReferences", "PyUnboundLocalVariable"}).put((Object)"F831", (Object)"PyUnusedLocal").put((Object)"F841", (Object)"PyUnusedLocal").put((Object)"C90", (Object)"PyUnusedLocal").put((Object)"E711", (Object)"PyComparisonWithNone").build().inverse();

    public boolean isSuppressedFor(@NotNull PsiElement element, @NotNull String toolId) {
        Set<String> givenCodes;
        if (element == null) {
            Flake8InspectionSuppressor.$$$reportNull$$$0(0);
        }
        if (toolId == null) {
            Flake8InspectionSuppressor.$$$reportNull$$$0(1);
        }
        if (element instanceof PsiFileSystemItem || !(element.getContainingFile() instanceof PyFile)) {
            return false;
        }
        PsiComment comment = PyPsiUtils.findSameLineComment(element);
        if (comment != null && (givenCodes = Flake8InspectionSuppressor.extractNoqaCodes(comment)) != null) {
            ImmutableSet knownCodes = ourInspectionToFlake8Code.get((Object)toolId);
            return givenCodes.isEmpty() || StreamEx.of((Collection)knownCodes).cross(givenCodes).anyMatch((known, given) -> known.startsWith((String)given));
        }
        return false;
    }

    @Nullable
    public static Set<String> extractNoqaCodes(@NotNull PsiComment comment) {
        String commentText;
        if (comment == null) {
            Flake8InspectionSuppressor.$$$reportNull$$$0(2);
        }
        if ((commentText = comment.getText()) == null) {
            return null;
        }
        int noqaOffset = StringUtils.lowerCase((String)commentText).indexOf("# noqa");
        String noqaSuffix = StringUtils.substring((String)commentText, (int)noqaOffset);
        Matcher matcher = NOQA_COMMENT_PATTERN.matcher(noqaSuffix);
        if (matcher.matches()) {
            String codeList = matcher.group("codes");
            if (codeList != null) {
                return Sets.newHashSet((Object[])codeList.split("[,\\s]+"));
            }
            return Collections.emptySet();
        }
        return null;
    }

    @NotNull
    public SuppressQuickFix[] getSuppressActions(@Nullable PsiElement element, @NotNull String toolId) {
        if (toolId == null) {
            Flake8InspectionSuppressor.$$$reportNull$$$0(3);
        }
        if (SuppressQuickFix.EMPTY_ARRAY == null) {
            Flake8InspectionSuppressor.$$$reportNull$$$0(4);
        }
        return SuppressQuickFix.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/flake8/Flake8InspectionSuppressor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/flake8/Flake8InspectionSuppressor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuppressActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedFor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "extractNoqaCodes";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressActions";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

