/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.parsing;

import com.intellij.lang.SyntaxTreeBuilder;
import com.intellij.lang.WhitespacesAndCommentsBinder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.parsing.Parsing;
import com.jetbrains.python.parsing.ParsingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpressionParsing
extends Parsing {
    private static final Logger LOG = Logger.getInstance(ExpressionParsing.class);
    public static final WhitespacesAndCommentsBinder CONSUME_COMMENTS_AND_SPACES_TO_LEFT = (tokens, atStreamEdge, getter) -> tokens.size();
    private static final TokenSet BRACKET_OR_COMMA = TokenSet.create((IElementType[])new IElementType[]{PyTokenTypes.RBRACKET, PyTokenTypes.COMMA});
    private static final TokenSet BRACKET_COLON_COMMA = TokenSet.create((IElementType[])new IElementType[]{PyTokenTypes.RBRACKET, PyTokenTypes.COLON, PyTokenTypes.COMMA});

    public ExpressionParsing(ParsingContext context2) {
        super(context2);
    }

    public boolean parsePrimaryExpression(boolean isTargetExpression) {
        IElementType firstToken = this.myBuilder.getTokenType();
        if (ExpressionParsing.isIdentifier(this.myBuilder)) {
            if (isTargetExpression) {
                ExpressionParsing.buildTokenElement(PyElementTypes.TARGET_EXPRESSION, this.myBuilder);
            } else {
                ExpressionParsing.buildTokenElement(this.getReferenceType(), this.myBuilder);
            }
            return true;
        }
        if (firstToken == PyTokenTypes.INTEGER_LITERAL) {
            ExpressionParsing.buildTokenElement(PyElementTypes.INTEGER_LITERAL_EXPRESSION, this.myBuilder);
            return true;
        }
        if (firstToken == PyTokenTypes.FLOAT_LITERAL) {
            ExpressionParsing.buildTokenElement(PyElementTypes.FLOAT_LITERAL_EXPRESSION, this.myBuilder);
            return true;
        }
        if (firstToken == PyTokenTypes.IMAGINARY_LITERAL) {
            ExpressionParsing.buildTokenElement(PyElementTypes.IMAGINARY_LITERAL_EXPRESSION, this.myBuilder);
            return true;
        }
        if (firstToken == PyTokenTypes.NONE_KEYWORD) {
            ExpressionParsing.buildTokenElement(PyElementTypes.NONE_LITERAL_EXPRESSION, this.myBuilder);
            return true;
        }
        if (firstToken == PyTokenTypes.TRUE_KEYWORD || firstToken == PyTokenTypes.FALSE_KEYWORD || firstToken == PyTokenTypes.DEBUG_KEYWORD) {
            ExpressionParsing.buildTokenElement(PyElementTypes.BOOL_LITERAL_EXPRESSION, this.myBuilder);
            return true;
        }
        if (PyTokenTypes.STRING_NODES.contains(firstToken) || firstToken == PyTokenTypes.FSTRING_START) {
            return this.parseStringLiteralExpression();
        }
        if (firstToken == PyTokenTypes.LPAR) {
            this.parseParenthesizedExpression(isTargetExpression);
            return true;
        }
        if (firstToken == PyTokenTypes.LBRACKET) {
            this.parseListLiteralExpression(this.myBuilder, isTargetExpression);
            return true;
        }
        if (firstToken == PyTokenTypes.LBRACE) {
            this.parseDictOrSetDisplay();
            return true;
        }
        if (firstToken == PyTokenTypes.TICK) {
            this.parseReprExpression(this.myBuilder);
            return true;
        }
        return this.parseEllipsis();
    }

    public boolean parseStringLiteralExpression() {
        SyntaxTreeBuilder builder = this.myContext.getBuilder();
        IElementType tokenType = builder.getTokenType();
        if (PyTokenTypes.STRING_NODES.contains(tokenType) || tokenType == PyTokenTypes.FSTRING_START) {
            SyntaxTreeBuilder.Marker marker = builder.mark();
            while (true) {
                if (PyTokenTypes.STRING_NODES.contains(tokenType = builder.getTokenType())) {
                    this.nextToken();
                    continue;
                }
                if (tokenType != PyTokenTypes.FSTRING_START) break;
                this.parseFormattedStringNode();
            }
            marker.done((IElementType)PyElementTypes.STRING_LITERAL_EXPRESSION);
            return true;
        }
        return false;
    }

    private void parseFormattedStringNode() {
        SyntaxTreeBuilder builder = this.myContext.getBuilder();
        if (this.atToken(PyTokenTypes.FSTRING_START)) {
            String prefixThenQuotes = builder.getTokenText();
            assert (prefixThenQuotes != null);
            String openingQuotes = prefixThenQuotes.replaceFirst("^[UuBbCcRrFf]*", "");
            SyntaxTreeBuilder.Marker marker = builder.mark();
            this.nextToken();
            while (true) {
                if (this.atAnyOfTokens(PyTokenTypes.FSTRING_TEXT_TOKENS)) {
                    this.nextToken();
                    continue;
                }
                if (!this.atToken(PyTokenTypes.FSTRING_FRAGMENT_START)) break;
                this.parseFStringFragment();
            }
            if (this.atToken(PyTokenTypes.FSTRING_END)) {
                if (builder.getTokenText().equals(openingQuotes)) {
                    this.nextToken();
                } else {
                    builder.mark().error(PyPsiBundle.message("PARSE.expected.fstring.quote", openingQuotes));
                }
            } else if (this.atToken(PyTokenTypes.STATEMENT_BREAK)) {
                builder.mark().error(PyPsiBundle.message("PARSE.expected.fstring.quote", openingQuotes));
            } else {
                builder.error(PyPsiBundle.message("unexpected.f.string.token", new Object[0]));
            }
            marker.done((IElementType)PyElementTypes.FSTRING_NODE);
        }
    }

    private void parseFStringFragment() {
        SyntaxTreeBuilder builder = this.myContext.getBuilder();
        if (this.atToken(PyTokenTypes.FSTRING_FRAGMENT_START)) {
            boolean recovery;
            SyntaxTreeBuilder.Marker marker = builder.mark();
            this.nextToken();
            SyntaxTreeBuilder.Marker recoveryMarker = builder.mark();
            boolean parsedExpression = this.myContext.getExpressionParser().parseExpressionOptional();
            if (parsedExpression) {
                recoveryMarker.drop();
                recoveryMarker = builder.mark();
            }
            boolean bl = recovery = !parsedExpression;
            while (!builder.eof() && !this.atAnyOfTokens(PyTokenTypes.FSTRING_FRAGMENT_TYPE_CONVERSION, PyTokenTypes.FSTRING_FRAGMENT_FORMAT_START, PyTokenTypes.FSTRING_FRAGMENT_END, PyTokenTypes.FSTRING_END, PyTokenTypes.STATEMENT_BREAK, PyTokenTypes.EQ)) {
                this.nextToken();
                recovery = true;
            }
            if (recovery) {
                recoveryMarker.error(parsedExpression ? PyPsiBundle.message("unexpected.expression.part", new Object[0]) : PyPsiBundle.message("PARSE.expected.expression", new Object[0]));
                recoveryMarker.setCustomEdgeTokenBinders(null, CONSUME_COMMENTS_AND_SPACES_TO_LEFT);
            } else {
                recoveryMarker.drop();
            }
            this.matchToken(PyTokenTypes.EQ);
            boolean hasTypeConversion = this.matchToken(PyTokenTypes.FSTRING_FRAGMENT_TYPE_CONVERSION);
            boolean hasFormatPart = this.atToken(PyTokenTypes.FSTRING_FRAGMENT_FORMAT_START);
            if (hasFormatPart) {
                this.parseFStringFragmentFormatPart();
            }
            @NlsContexts.ParsingError String errorMessage = PyPsiBundle.message("PARSE.expected.fstring.rbrace", new Object[0]);
            if (!hasFormatPart && !this.atToken(PyTokenTypes.FSTRING_END)) {
                errorMessage = PyPsiBundle.message("PARSE.expected.fstring.colon.or.rbrace", new Object[0]);
                if (!hasTypeConversion) {
                    errorMessage = PyPsiBundle.message("PARSE.expected.fstring.type.conversion.or.colon.or.rbrace", new Object[0]);
                }
            }
            this.checkMatches(PyTokenTypes.FSTRING_FRAGMENT_END, errorMessage);
            marker.setCustomEdgeTokenBinders(null, CONSUME_COMMENTS_AND_SPACES_TO_LEFT);
            marker.done((IElementType)PyElementTypes.FSTRING_FRAGMENT);
        }
    }

    private void parseFStringFragmentFormatPart() {
        if (this.atToken(PyTokenTypes.FSTRING_FRAGMENT_FORMAT_START)) {
            SyntaxTreeBuilder.Marker marker = this.myContext.getBuilder().mark();
            this.nextToken();
            while (true) {
                if (this.atAnyOfTokens(PyTokenTypes.FSTRING_TEXT_TOKENS)) {
                    this.nextToken();
                    continue;
                }
                if (!this.atToken(PyTokenTypes.FSTRING_FRAGMENT_START)) break;
                this.parseFStringFragment();
            }
            marker.done((IElementType)PyElementTypes.FSTRING_FRAGMENT_FORMAT_PART);
        }
    }

    private void parseListLiteralExpression(SyntaxTreeBuilder builder, boolean isTargetExpression) {
        LOG.assertTrue(builder.getTokenType() == PyTokenTypes.LBRACKET);
        SyntaxTreeBuilder.Marker expr = builder.mark();
        builder.advanceLexer();
        if (builder.getTokenType() == PyTokenTypes.RBRACKET) {
            builder.advanceLexer();
            expr.done((IElementType)PyElementTypes.LIST_LITERAL_EXPRESSION);
            return;
        }
        if (!this.parseNamedTestExpression(false, isTargetExpression)) {
            builder.error(PyPsiBundle.message("PARSE.expected.expression", new Object[0]));
        }
        if (this.atForOrAsyncFor()) {
            this.parseComprehension(expr, PyTokenTypes.RBRACKET, PyElementTypes.LIST_COMP_EXPRESSION);
        } else {
            while (builder.getTokenType() != PyTokenTypes.RBRACKET) {
                if (!this.matchToken(PyTokenTypes.COMMA)) {
                    builder.error(PyPsiBundle.message("rbracket.or.comma.expected", new Object[0]));
                }
                if (this.atToken(PyTokenTypes.RBRACKET)) break;
                if (this.parseNamedTestExpression(false, isTargetExpression)) continue;
                builder.error(PyPsiBundle.message("PARSE.expected.expr.or.comma.or.bracket", new Object[0]));
                break;
            }
            this.checkMatches(PyTokenTypes.RBRACKET, PyPsiBundle.message("PARSE.expected.rbracket", new Object[0]));
            expr.done((IElementType)PyElementTypes.LIST_LITERAL_EXPRESSION);
        }
    }

    private void parseComprehension(SyntaxTreeBuilder.Marker expr, @Nullable IElementType endToken, IElementType exprType) {
        this.assertCurrentToken(PyTokenTypes.FOR_KEYWORD);
        do {
            this.myBuilder.advanceLexer();
            this.parseStarTargets();
            this.parseComprehensionRange(exprType == PyElementTypes.GENERATOR_EXPRESSION);
            while (this.myBuilder.getTokenType() == PyTokenTypes.IF_KEYWORD) {
                this.myBuilder.advanceLexer();
                if (this.parseOldExpression()) continue;
                this.myBuilder.error(PyPsiBundle.message("PARSE.expected.expression", new Object[0]));
            }
        } while (this.atForOrAsyncFor());
        if (endToken != null && !this.matchToken(endToken)) {
            this.myBuilder.error(PyPsiBundle.message("PARSE.expected.for.or.bracket", new Object[0]));
        }
        expr.done(exprType);
    }

    public boolean parseStarTargets() {
        SyntaxTreeBuilder.Marker expr = this.myBuilder.mark();
        if (!this.parseStarExpression(true)) {
            this.myBuilder.error(PyPsiBundle.message("PARSE.expected.expression", new Object[0]));
            expr.drop();
            return false;
        }
        if (this.myBuilder.getTokenType() == PyTokenTypes.COMMA) {
            while (this.myBuilder.getTokenType() == PyTokenTypes.COMMA) {
                this.myBuilder.advanceLexer();
                SyntaxTreeBuilder.Marker expr2 = this.myBuilder.mark();
                if (!this.parseStarExpression(true)) {
                    this.myBuilder.error(PyPsiBundle.message("PARSE.expected.expression", new Object[0]));
                    expr2.rollbackTo();
                    break;
                }
                expr2.drop();
            }
            expr.done((IElementType)PyElementTypes.TUPLE_EXPRESSION);
        } else {
            expr.drop();
        }
        return true;
    }

    protected void parseComprehensionRange(boolean generatorExpression) {
        this.checkMatches(PyTokenTypes.IN_KEYWORD, PyPsiBundle.message("PARSE.expected.in", new Object[0]));
        boolean result = generatorExpression ? this.parseORTestExpression(false, false) : this.parseTupleExpression(false, false, true);
        if (!result) {
            this.myBuilder.error(PyPsiBundle.message("PARSE.expected.expression", new Object[0]));
        }
    }

    private void parseDictOrSetDisplay() {
        LOG.assertTrue(this.myBuilder.getTokenType() == PyTokenTypes.LBRACE);
        SyntaxTreeBuilder.Marker expr = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        if (this.matchToken(PyTokenTypes.RBRACE)) {
            expr.done((IElementType)PyElementTypes.DICT_LITERAL_EXPRESSION);
            return;
        }
        if (this.atToken(PyTokenTypes.EXP)) {
            if (!this.parseDoubleStarExpression(false)) {
                this.myBuilder.error(PyPsiBundle.message("PARSE.expected.expression", new Object[0]));
                expr.done((IElementType)PyElementTypes.DICT_LITERAL_EXPRESSION);
                return;
            }
            this.parseDictLiteralContentTail(expr);
            return;
        }
        this.parseDictOrSetTail(expr, false);
    }

    private void parseDictOrSetTail(@NotNull SyntaxTreeBuilder.Marker expr, boolean isDict) {
        if (expr == null) {
            ExpressionParsing.$$$reportNull$$$0(0);
        }
        SyntaxTreeBuilder.Marker firstExprMarker = this.myBuilder.mark();
        if (isDict && !this.parseSingleExpression(false) || !isDict && !this.parseNamedTestExpression(false, false)) {
            this.myBuilder.error(PyPsiBundle.message("PARSE.expected.expression", new Object[0]));
            firstExprMarker.drop();
            expr.done((IElementType)PyElementTypes.DICT_LITERAL_EXPRESSION);
            return;
        }
        if (this.matchToken(PyTokenTypes.COLON)) {
            if (!isDict) {
                firstExprMarker.rollbackTo();
                this.parseDictOrSetTail(expr, true);
                return;
            }
            this.parseDictLiteralTail(expr, firstExprMarker);
        } else if (this.atToken(PyTokenTypes.COMMA) || this.atToken(PyTokenTypes.RBRACE)) {
            firstExprMarker.drop();
            this.parseSetLiteralTail(expr);
        } else if (this.atForOrAsyncFor()) {
            firstExprMarker.drop();
            this.parseComprehension(expr, PyTokenTypes.RBRACE, PyElementTypes.SET_COMP_EXPRESSION);
        } else {
            this.myBuilder.error(PyPsiBundle.message("PARSE.expected.expression", new Object[0]));
            firstExprMarker.drop();
            expr.done((IElementType)PyElementTypes.DICT_LITERAL_EXPRESSION);
        }
    }

    private void parseDictLiteralTail(SyntaxTreeBuilder.Marker startMarker, SyntaxTreeBuilder.Marker firstKeyValueMarker) {
        if (!this.parseSingleExpression(false)) {
            this.myBuilder.error(PyPsiBundle.message("PARSE.expected.expression", new Object[0]));
            firstKeyValueMarker.done((IElementType)PyElementTypes.KEY_VALUE_EXPRESSION);
            if (this.atToken(PyTokenTypes.RBRACE)) {
                this.myBuilder.advanceLexer();
            }
            startMarker.done((IElementType)PyElementTypes.DICT_LITERAL_EXPRESSION);
            return;
        }
        firstKeyValueMarker.done((IElementType)PyElementTypes.KEY_VALUE_EXPRESSION);
        if (this.atForOrAsyncFor()) {
            this.parseComprehension(startMarker, PyTokenTypes.RBRACE, PyElementTypes.DICT_COMP_EXPRESSION);
        } else {
            this.parseDictLiteralContentTail(startMarker);
        }
    }

    private void parseDictLiteralContentTail(SyntaxTreeBuilder.Marker startMarker) {
        while (this.myBuilder.getTokenType() != PyTokenTypes.RBRACE) {
            this.checkMatches(PyTokenTypes.COMMA, PyPsiBundle.message("PARSE.expected.comma", new Object[0]));
            if (!(this.atToken(PyTokenTypes.EXP) ? !this.parseDoubleStarExpression(false) : !this.parseKeyValueExpression())) continue;
        }
        this.checkMatches(PyTokenTypes.RBRACE, PyPsiBundle.message("PARSE.expected.rbrace", new Object[0]));
        startMarker.done((IElementType)PyElementTypes.DICT_LITERAL_EXPRESSION);
    }

    private boolean parseKeyValueExpression() {
        SyntaxTreeBuilder.Marker marker = this.myBuilder.mark();
        if (!this.parseSingleExpression(false)) {
            marker.drop();
            return false;
        }
        this.checkMatches(PyTokenTypes.COLON, PyPsiBundle.message("PARSE.expected.colon", new Object[0]));
        if (!this.parseSingleExpression(false)) {
            this.myBuilder.error(PyPsiBundle.message("value.expression.expected", new Object[0]));
            marker.drop();
            return false;
        }
        marker.done((IElementType)PyElementTypes.KEY_VALUE_EXPRESSION);
        return true;
    }

    private void parseSetLiteralTail(SyntaxTreeBuilder.Marker startMarker) {
        while (this.myBuilder.getTokenType() != PyTokenTypes.RBRACE) {
            this.checkMatches(PyTokenTypes.COMMA, PyPsiBundle.message("PARSE.expected.comma", new Object[0]));
            if (this.parseNamedTestExpression(false, false)) continue;
        }
        this.checkMatches(PyTokenTypes.RBRACE, PyPsiBundle.message("PARSE.expected.rbrace", new Object[0]));
        startMarker.done((IElementType)PyElementTypes.SET_LITERAL_EXPRESSION);
    }

    private void parseParenthesizedExpression(boolean isTargetExpression) {
        LOG.assertTrue(this.myBuilder.getTokenType() == PyTokenTypes.LPAR);
        SyntaxTreeBuilder.Marker expr = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        if (this.myBuilder.getTokenType() == PyTokenTypes.RPAR) {
            this.myBuilder.advanceLexer();
            expr.done((IElementType)PyElementTypes.TUPLE_EXPRESSION);
        } else {
            this.parseYieldOrTupleExpression(isTargetExpression);
            if (this.atForOrAsyncFor()) {
                this.parseComprehension(expr, PyTokenTypes.RPAR, PyElementTypes.GENERATOR_EXPRESSION);
            } else {
                SyntaxTreeBuilder.Marker err = this.myBuilder.mark();
                boolean empty = true;
                while (!this.myBuilder.eof() && this.myBuilder.getTokenType() != PyTokenTypes.RPAR && this.myBuilder.getTokenType() != PyTokenTypes.LINE_BREAK && this.myBuilder.getTokenType() != PyTokenTypes.STATEMENT_BREAK && this.myBuilder.getTokenType() != PyTokenTypes.FSTRING_END) {
                    this.myBuilder.advanceLexer();
                    empty = false;
                }
                if (!empty) {
                    err.error(PyPsiBundle.message("unexpected.expression.syntax", new Object[0]));
                } else {
                    err.drop();
                }
                this.checkMatches(PyTokenTypes.RPAR, PyPsiBundle.message("PARSE.expected.rpar", new Object[0]));
                expr.done((IElementType)PyElementTypes.PARENTHESIZED_EXPRESSION);
            }
        }
    }

    private void parseReprExpression(SyntaxTreeBuilder builder) {
        LOG.assertTrue(builder.getTokenType() == PyTokenTypes.TICK);
        SyntaxTreeBuilder.Marker expr = builder.mark();
        builder.advanceLexer();
        this.parseExpression();
        this.checkMatches(PyTokenTypes.TICK, PyPsiBundle.message("PARSE.expected.tick", new Object[0]));
        expr.done((IElementType)PyElementTypes.REPR_EXPRESSION);
    }

    public boolean parseMemberExpression(boolean isTargetExpression) {
        boolean recastFirstIdentifier = false;
        boolean recastQualifier = false;
        block0: do {
            boolean firstIdentifierIsTarget = isTargetExpression && !recastFirstIdentifier;
            SyntaxTreeBuilder.Marker expr = this.myBuilder.mark();
            if (!this.parsePrimaryExpression(firstIdentifierIsTarget)) {
                expr.drop();
                return false;
            }
            while (true) {
                IElementType tokenType;
                if ((tokenType = this.myBuilder.getTokenType()) == PyTokenTypes.DOT) {
                    if (firstIdentifierIsTarget) {
                        recastFirstIdentifier = true;
                        expr.rollbackTo();
                        continue block0;
                    }
                    this.myBuilder.advanceLexer();
                    this.checkMatches(PyTokenTypes.IDENTIFIER, PyPsiBundle.message("PARSE.expected.name", new Object[0]));
                    if (isTargetExpression && !recastQualifier && !this.atAnyOfTokens(PyTokenTypes.DOT, PyTokenTypes.LPAR, PyTokenTypes.LBRACKET)) {
                        expr.done(PyElementTypes.TARGET_EXPRESSION);
                    } else {
                        expr.done(this.getReferenceType());
                    }
                    expr = expr.precede();
                } else if (tokenType == PyTokenTypes.LPAR) {
                    this.parseArgumentList();
                    expr.done((IElementType)PyElementTypes.CALL_EXPRESSION);
                    expr = expr.precede();
                } else if (tokenType == PyTokenTypes.LBRACKET) {
                    this.myBuilder.advanceLexer();
                    this.parseSliceOrSubscriptionExpression(expr, false);
                    if (isTargetExpression && !recastQualifier) {
                        recastFirstIdentifier = true;
                        recastQualifier = true;
                        expr.rollbackTo();
                        continue block0;
                    }
                    expr = expr.precede();
                } else {
                    expr.drop();
                    continue block0;
                }
                recastFirstIdentifier = false;
            }
        } while (recastFirstIdentifier);
        return true;
    }

    private void parseSliceOrSubscriptionExpression(@NotNull SyntaxTreeBuilder.Marker expr, boolean isSlice) {
        if (expr == null) {
            ExpressionParsing.$$$reportNull$$$0(1);
        }
        SyntaxTreeBuilder.Marker sliceOrTupleStart = this.myBuilder.mark();
        SyntaxTreeBuilder.Marker sliceItemStart = this.myBuilder.mark();
        if (this.atToken(PyTokenTypes.COLON)) {
            sliceOrTupleStart.drop();
            SyntaxTreeBuilder.Marker sliceMarker = this.myBuilder.mark();
            sliceMarker.done((IElementType)PyElementTypes.EMPTY_EXPRESSION);
            this.parseSliceEnd(expr, sliceItemStart);
        } else {
            boolean hadExpression;
            boolean bl = hadExpression = isSlice ? this.parseSingleExpression(false) : this.parseNamedTestExpression(false, false);
            if (this.atToken(PyTokenTypes.COLON)) {
                if (!isSlice) {
                    sliceOrTupleStart.rollbackTo();
                    this.parseSliceOrSubscriptionExpression(expr, true);
                    return;
                }
                sliceOrTupleStart.drop();
                this.parseSliceEnd(expr, sliceItemStart);
            } else if (this.atToken(PyTokenTypes.COMMA)) {
                sliceItemStart.done((IElementType)PyElementTypes.SLICE_ITEM);
                if (!this.parseSliceListTail(expr, sliceOrTupleStart)) {
                    sliceOrTupleStart.rollbackTo();
                    if (!this.parseTupleExpression(false, false, false)) {
                        this.myBuilder.error(PyPsiBundle.message("tuple.expression.expected", new Object[0]));
                    }
                    this.checkMatches(PyTokenTypes.RBRACKET, PyPsiBundle.message("PARSE.expected.rbracket", new Object[0]));
                    expr.done((IElementType)PyElementTypes.SUBSCRIPTION_EXPRESSION);
                }
            } else {
                if (!hadExpression) {
                    this.myBuilder.error(PyPsiBundle.message("PARSE.expected.expression", new Object[0]));
                }
                sliceOrTupleStart.drop();
                sliceItemStart.drop();
                this.checkMatches(PyTokenTypes.RBRACKET, PyPsiBundle.message("PARSE.expected.rbracket", new Object[0]));
                expr.done((IElementType)PyElementTypes.SUBSCRIPTION_EXPRESSION);
            }
        }
    }

    private boolean parseEllipsis() {
        if (this.atToken(PyTokenTypes.DOT)) {
            SyntaxTreeBuilder.Marker maybeEllipsis = this.myBuilder.mark();
            this.myBuilder.advanceLexer();
            if (this.matchToken(PyTokenTypes.DOT) && this.matchToken(PyTokenTypes.DOT)) {
                maybeEllipsis.done((IElementType)PyElementTypes.NONE_LITERAL_EXPRESSION);
                return true;
            }
            maybeEllipsis.rollbackTo();
        }
        return false;
    }

    public void parseSliceEnd(SyntaxTreeBuilder.Marker exprStart, SyntaxTreeBuilder.Marker sliceItemStart) {
        this.myBuilder.advanceLexer();
        if (this.atToken(PyTokenTypes.RBRACKET)) {
            SyntaxTreeBuilder.Marker sliceMarker = this.myBuilder.mark();
            sliceMarker.done((IElementType)PyElementTypes.EMPTY_EXPRESSION);
            sliceItemStart.done((IElementType)PyElementTypes.SLICE_ITEM);
            this.nextToken();
            exprStart.done((IElementType)PyElementTypes.SLICE_EXPRESSION);
            return;
        }
        if (this.atToken(PyTokenTypes.COLON)) {
            SyntaxTreeBuilder.Marker sliceMarker = this.myBuilder.mark();
            sliceMarker.done((IElementType)PyElementTypes.EMPTY_EXPRESSION);
        } else {
            this.parseSingleExpression(false);
        }
        if (!BRACKET_COLON_COMMA.contains(this.myBuilder.getTokenType())) {
            this.myBuilder.error(PyPsiBundle.message("PARSE.expected.colon.or.rbracket", new Object[0]));
        }
        if (this.matchToken(PyTokenTypes.COLON)) {
            this.parseSingleExpression(false);
        }
        sliceItemStart.done((IElementType)PyElementTypes.SLICE_ITEM);
        if (!BRACKET_OR_COMMA.contains(this.myBuilder.getTokenType())) {
            this.myBuilder.error(PyPsiBundle.message("rbracket.or.comma.expected", new Object[0]));
        }
        this.parseSliceListTail(exprStart, null);
    }

    private boolean parseSliceListTail(SyntaxTreeBuilder.Marker exprStart, @Nullable SyntaxTreeBuilder.Marker sliceOrTupleStart) {
        boolean inSlice;
        boolean bl = inSlice = sliceOrTupleStart == null;
        while (this.atToken(PyTokenTypes.COMMA)) {
            this.nextToken();
            SyntaxTreeBuilder.Marker sliceItemStart = this.myBuilder.mark();
            this.parseTestExpression(false, false);
            if (this.matchToken(PyTokenTypes.COLON)) {
                inSlice = true;
                this.parseTestExpression(false, false);
                if (this.matchToken(PyTokenTypes.COLON)) {
                    this.parseTestExpression(false, false);
                }
            }
            sliceItemStart.done((IElementType)PyElementTypes.SLICE_ITEM);
            if (BRACKET_OR_COMMA.contains(this.myBuilder.getTokenType())) continue;
            this.myBuilder.error(PyPsiBundle.message("rbracket.or.comma.expected", new Object[0]));
            break;
        }
        this.checkMatches(PyTokenTypes.RBRACKET, PyPsiBundle.message("PARSE.expected.rbracket", new Object[0]));
        if (inSlice) {
            if (sliceOrTupleStart != null) {
                sliceOrTupleStart.drop();
            }
            exprStart.done((IElementType)PyElementTypes.SLICE_EXPRESSION);
        }
        return inSlice;
    }

    public void parseArgumentList() {
        LOG.assertTrue(this.myBuilder.getTokenType() == PyTokenTypes.LPAR);
        SyntaxTreeBuilder.Marker arglist = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        SyntaxTreeBuilder.Marker genexpr = this.myBuilder.mark();
        int argNumber = 0;
        while (this.myBuilder.getTokenType() != PyTokenTypes.RPAR) {
            if (++argNumber > 1) {
                if (argNumber == 2 && this.atForOrAsyncFor() && genexpr != null) {
                    this.parseComprehension(genexpr, null, PyElementTypes.GENERATOR_EXPRESSION);
                    genexpr = null;
                    continue;
                }
                if (this.matchToken(PyTokenTypes.COMMA)) {
                    if (this.atToken(PyTokenTypes.RPAR)) {
                        break;
                    }
                } else {
                    this.myBuilder.error(PyPsiBundle.message("PARSE.expected.comma.or.rpar", new Object[0]));
                    break;
                }
            }
            if (this.myBuilder.getTokenType() == PyTokenTypes.MULT || this.myBuilder.getTokenType() == PyTokenTypes.EXP) {
                SyntaxTreeBuilder.Marker starArgMarker = this.myBuilder.mark();
                this.myBuilder.advanceLexer();
                if (!this.parseSingleExpression(false)) {
                    this.myBuilder.error(PyPsiBundle.message("PARSE.expected.expression", new Object[0]));
                }
                starArgMarker.done((IElementType)PyElementTypes.STAR_ARGUMENT_EXPRESSION);
                continue;
            }
            if (ExpressionParsing.isIdentifier(this.myBuilder)) {
                SyntaxTreeBuilder.Marker keywordArgMarker = this.myBuilder.mark();
                ExpressionParsing.advanceIdentifierLike(this.myBuilder);
                if (this.myBuilder.getTokenType() == PyTokenTypes.EQ) {
                    this.myBuilder.advanceLexer();
                    if (!this.parseSingleExpression(false)) {
                        this.myBuilder.error(PyPsiBundle.message("PARSE.expected.expression", new Object[0]));
                    }
                    keywordArgMarker.done((IElementType)PyElementTypes.KEYWORD_ARGUMENT_EXPRESSION);
                    continue;
                }
                keywordArgMarker.rollbackTo();
            }
            if (this.parseNamedTestExpression(false, false)) continue;
            this.myBuilder.error(PyPsiBundle.message("PARSE.expected.expression", new Object[0]));
            break;
        }
        if (genexpr != null) {
            genexpr.drop();
        }
        this.checkMatches(PyTokenTypes.RPAR, PyPsiBundle.message("PARSE.expected.rpar", new Object[0]));
        arglist.done((IElementType)PyElementTypes.ARGUMENT_LIST);
    }

    public boolean parseExpressionOptional() {
        return this.parseTupleExpression(false, false, false);
    }

    public boolean parseExpressionOptional(boolean isTargetExpression) {
        return this.parseTupleExpression(false, isTargetExpression, false);
    }

    public void parseExpression() {
        if (!this.parseExpressionOptional()) {
            this.myBuilder.error(PyPsiBundle.message("PARSE.expected.expression", new Object[0]));
        }
    }

    public void parseExpression(boolean stopOnIn, boolean isTargetExpression) {
        if (!this.parseTupleExpression(stopOnIn, isTargetExpression, false)) {
            this.myBuilder.error(PyPsiBundle.message("PARSE.expected.expression", new Object[0]));
        }
    }

    public boolean parseYieldOrTupleExpression(boolean isTargetExpression) {
        if (this.myBuilder.getTokenType() == PyTokenTypes.YIELD_KEYWORD) {
            SyntaxTreeBuilder.Marker yieldExpr = this.myBuilder.mark();
            this.myBuilder.advanceLexer();
            if (this.myBuilder.getTokenType() == PyTokenTypes.FROM_KEYWORD) {
                this.myBuilder.advanceLexer();
                boolean parsed = this.parseTupleExpression(false, isTargetExpression, false);
                if (!parsed) {
                    this.myBuilder.error(PyPsiBundle.message("PARSE.expected.expression", new Object[0]));
                }
                yieldExpr.done((IElementType)PyElementTypes.YIELD_EXPRESSION);
                return parsed;
            }
            this.parseTupleExpression(false, isTargetExpression, false);
            yieldExpr.done((IElementType)PyElementTypes.YIELD_EXPRESSION);
            return true;
        }
        return this.parseTupleExpression(false, isTargetExpression, false);
    }

    protected boolean parseTupleExpression(boolean stopOnIn, boolean isTargetExpression, boolean oldTest) {
        boolean exprParseResult;
        SyntaxTreeBuilder.Marker expr = this.myBuilder.mark();
        boolean bl = exprParseResult = oldTest ? this.parseOldTestExpression() : this.parseNamedTestExpression(stopOnIn, isTargetExpression);
        if (!exprParseResult) {
            expr.drop();
            return false;
        }
        if (this.myBuilder.getTokenType() == PyTokenTypes.COMMA) {
            while (this.myBuilder.getTokenType() == PyTokenTypes.COMMA) {
                this.myBuilder.advanceLexer();
                SyntaxTreeBuilder.Marker expr2 = this.myBuilder.mark();
                boolean bl2 = exprParseResult = oldTest ? this.parseOldTestExpression() : this.parseNamedTestExpression(stopOnIn, isTargetExpression);
                if (!exprParseResult) {
                    expr2.rollbackTo();
                    break;
                }
                expr2.drop();
            }
            expr.done((IElementType)PyElementTypes.TUPLE_EXPRESSION);
        } else {
            expr.drop();
        }
        return true;
    }

    public boolean parseSingleExpression(boolean isTargetExpression) {
        return this.parseTestExpression(false, isTargetExpression);
    }

    public boolean parseOldExpression() {
        if (this.myBuilder.getTokenType() == PyTokenTypes.LAMBDA_KEYWORD) {
            return this.parseLambdaExpression(false);
        }
        return this.parseORTestExpression(false, false);
    }

    public boolean parseNamedTestExpression(boolean stopOnIn, boolean isTargetExpression) {
        SyntaxTreeBuilder.Marker expr = this.myBuilder.mark();
        if (ExpressionParsing.isIdentifier(this.myBuilder) && this.myBuilder.lookAhead(1) == PyTokenTypes.COLONEQ) {
            ExpressionParsing.buildTokenElement(PyElementTypes.TARGET_EXPRESSION, this.myBuilder);
            this.myBuilder.advanceLexer();
            if (!this.parseTestExpression(stopOnIn, false)) {
                this.myBuilder.error(PyPsiBundle.message("PARSE.expected.expression", new Object[0]));
            }
            expr.done((IElementType)PyElementTypes.ASSIGNMENT_EXPRESSION);
            return true;
        }
        if (this.parseTestExpression(stopOnIn, isTargetExpression)) {
            if (!this.atToken(PyTokenTypes.COLONEQ)) {
                expr.drop();
                return true;
            }
            this.myBuilder.error(PyPsiBundle.message("PARSE.expected.identifier", new Object[0]));
            this.myBuilder.advanceLexer();
            if (!this.parseTestExpression(stopOnIn, false)) {
                this.myBuilder.error(PyPsiBundle.message("PARSE.expected.expression", new Object[0]));
            }
            expr.done((IElementType)PyElementTypes.ASSIGNMENT_EXPRESSION);
            return false;
        }
        expr.drop();
        return false;
    }

    private boolean parseTestExpression(boolean stopOnIn, boolean isTargetExpression) {
        if (this.myBuilder.getTokenType() == PyTokenTypes.LAMBDA_KEYWORD) {
            return this.parseLambdaExpression(false);
        }
        SyntaxTreeBuilder.Marker condExpr = this.myBuilder.mark();
        if (!this.parseORTestExpression(stopOnIn, isTargetExpression)) {
            condExpr.drop();
            return false;
        }
        if (this.myBuilder.getTokenType() == PyTokenTypes.IF_KEYWORD) {
            SyntaxTreeBuilder.Marker conditionMarker = this.myBuilder.mark();
            this.myBuilder.advanceLexer();
            if (!this.parseORTestExpression(stopOnIn, isTargetExpression)) {
                this.myBuilder.error(PyPsiBundle.message("PARSE.expected.expression", new Object[0]));
            } else if (this.myBuilder.getTokenType() != PyTokenTypes.ELSE_KEYWORD) {
                if (this.atToken(PyTokenTypes.COLON)) {
                    conditionMarker.rollbackTo();
                    condExpr.drop();
                    return true;
                }
                this.myBuilder.error(PyPsiBundle.message("PARSE.expected.else", new Object[0]));
            } else {
                this.myBuilder.advanceLexer();
                if (!this.parseTestExpression(stopOnIn, isTargetExpression)) {
                    this.myBuilder.error(PyPsiBundle.message("PARSE.expected.expression", new Object[0]));
                }
            }
            conditionMarker.drop();
            condExpr.done((IElementType)PyElementTypes.CONDITIONAL_EXPRESSION);
        } else {
            condExpr.drop();
        }
        return true;
    }

    private boolean parseOldTestExpression() {
        if (this.myBuilder.getTokenType() == PyTokenTypes.LAMBDA_KEYWORD) {
            return this.parseLambdaExpression(true);
        }
        return this.parseORTestExpression(false, false);
    }

    private boolean parseLambdaExpression(boolean oldTest) {
        boolean parseExpressionResult;
        SyntaxTreeBuilder.Marker expr = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        this.getFunctionParser().parseParameterListContents(PyTokenTypes.COLON, false, true);
        boolean bl = parseExpressionResult = oldTest ? this.parseOldTestExpression() : this.parseSingleExpression(false);
        if (!parseExpressionResult) {
            this.myBuilder.error(PyPsiBundle.message("PARSE.expected.expression", new Object[0]));
        }
        expr.done((IElementType)PyElementTypes.LAMBDA_EXPRESSION);
        return true;
    }

    protected boolean parseORTestExpression(boolean stopOnIn, boolean isTargetExpression) {
        SyntaxTreeBuilder.Marker expr = this.myBuilder.mark();
        if (!this.parseANDTestExpression(stopOnIn, isTargetExpression)) {
            expr.drop();
            return false;
        }
        while (this.myBuilder.getTokenType() == PyTokenTypes.OR_KEYWORD) {
            this.myBuilder.advanceLexer();
            if (!this.parseANDTestExpression(stopOnIn, isTargetExpression)) {
                this.myBuilder.error(PyPsiBundle.message("PARSE.expected.expression", new Object[0]));
            }
            expr.done((IElementType)PyElementTypes.BINARY_EXPRESSION);
            expr = expr.precede();
        }
        expr.drop();
        return true;
    }

    private boolean parseANDTestExpression(boolean stopOnIn, boolean isTargetExpression) {
        SyntaxTreeBuilder.Marker expr = this.myBuilder.mark();
        if (!this.parseNOTTestExpression(stopOnIn, isTargetExpression)) {
            expr.drop();
            return false;
        }
        while (this.myBuilder.getTokenType() == PyTokenTypes.AND_KEYWORD) {
            this.myBuilder.advanceLexer();
            if (!this.parseNOTTestExpression(stopOnIn, isTargetExpression)) {
                this.myBuilder.error(PyPsiBundle.message("PARSE.expected.expression", new Object[0]));
            }
            expr.done((IElementType)PyElementTypes.BINARY_EXPRESSION);
            expr = expr.precede();
        }
        expr.drop();
        return true;
    }

    private boolean parseNOTTestExpression(boolean stopOnIn, boolean isTargetExpression) {
        if (this.myBuilder.getTokenType() == PyTokenTypes.NOT_KEYWORD) {
            SyntaxTreeBuilder.Marker expr = this.myBuilder.mark();
            this.myBuilder.advanceLexer();
            if (!this.parseNOTTestExpression(stopOnIn, isTargetExpression)) {
                this.myBuilder.error(PyPsiBundle.message("PARSE.expected.expression", new Object[0]));
            }
            expr.done((IElementType)PyElementTypes.PREFIX_EXPRESSION);
            return true;
        }
        return this.parseComparisonExpression(stopOnIn, isTargetExpression);
    }

    private boolean parseComparisonExpression(boolean stopOnIn, boolean isTargetExpression) {
        SyntaxTreeBuilder.Marker expr = this.myBuilder.mark();
        if (!this.parseStarExpression(isTargetExpression)) {
            expr.drop();
            return false;
        }
        if (stopOnIn && this.atToken(PyTokenTypes.IN_KEYWORD)) {
            expr.drop();
            return true;
        }
        while (PyTokenTypes.COMPARISON_OPERATIONS.contains(this.myBuilder.getTokenType())) {
            if (this.atToken(PyTokenTypes.NOT_KEYWORD)) {
                SyntaxTreeBuilder.Marker notMarker = this.myBuilder.mark();
                this.myBuilder.advanceLexer();
                if (!this.atToken(PyTokenTypes.IN_KEYWORD)) {
                    notMarker.rollbackTo();
                    break;
                }
                notMarker.drop();
                this.myBuilder.advanceLexer();
            } else if (this.atToken(PyTokenTypes.IS_KEYWORD)) {
                this.myBuilder.advanceLexer();
                if (this.myBuilder.getTokenType() == PyTokenTypes.NOT_KEYWORD) {
                    this.myBuilder.advanceLexer();
                }
            } else {
                this.myBuilder.advanceLexer();
            }
            if (!this.parseBitwiseORExpression(isTargetExpression)) {
                this.myBuilder.error(PyPsiBundle.message("PARSE.expected.expression", new Object[0]));
            }
            expr.done((IElementType)PyElementTypes.BINARY_EXPRESSION);
            expr = expr.precede();
        }
        expr.drop();
        return true;
    }

    private boolean parseStarExpression(boolean isTargetExpression) {
        if (this.atToken(PyTokenTypes.MULT)) {
            SyntaxTreeBuilder.Marker starExpr = this.myBuilder.mark();
            this.nextToken();
            if (!this.parseBitwiseORExpression(isTargetExpression)) {
                this.myBuilder.error(PyPsiBundle.message("PARSE.expected.expression", new Object[0]));
                starExpr.drop();
                return false;
            }
            starExpr.done((IElementType)PyElementTypes.STAR_EXPRESSION);
            return true;
        }
        return this.parseBitwiseORExpression(isTargetExpression);
    }

    private boolean parseDoubleStarExpression(boolean isTargetExpression) {
        if (this.atToken(PyTokenTypes.EXP)) {
            SyntaxTreeBuilder.Marker starExpr = this.myBuilder.mark();
            this.nextToken();
            if (!this.parseBitwiseORExpression(isTargetExpression)) {
                this.myBuilder.error(PyPsiBundle.message("PARSE.expected.expression", new Object[0]));
                starExpr.drop();
                return false;
            }
            starExpr.done((IElementType)PyElementTypes.DOUBLE_STAR_EXPRESSION);
            return true;
        }
        return this.parseBitwiseORExpression(isTargetExpression);
    }

    private boolean parseBitwiseORExpression(boolean isTargetExpression) {
        SyntaxTreeBuilder.Marker expr = this.myBuilder.mark();
        if (!this.parseBitwiseXORExpression(isTargetExpression)) {
            expr.drop();
            return false;
        }
        while (this.atToken(PyTokenTypes.OR)) {
            this.myBuilder.advanceLexer();
            if (!this.parseBitwiseXORExpression(isTargetExpression)) {
                this.myBuilder.error(PyPsiBundle.message("PARSE.expected.expression", new Object[0]));
            }
            expr.done((IElementType)PyElementTypes.BINARY_EXPRESSION);
            expr = expr.precede();
        }
        expr.drop();
        return true;
    }

    private boolean parseBitwiseXORExpression(boolean isTargetExpression) {
        SyntaxTreeBuilder.Marker expr = this.myBuilder.mark();
        if (!this.parseBitwiseANDExpression(isTargetExpression)) {
            expr.drop();
            return false;
        }
        while (this.atToken(PyTokenTypes.XOR)) {
            this.myBuilder.advanceLexer();
            if (!this.parseBitwiseANDExpression(isTargetExpression)) {
                this.myBuilder.error(PyPsiBundle.message("PARSE.expected.expression", new Object[0]));
            }
            expr.done((IElementType)PyElementTypes.BINARY_EXPRESSION);
            expr = expr.precede();
        }
        expr.drop();
        return true;
    }

    private boolean parseBitwiseANDExpression(boolean isTargetExpression) {
        SyntaxTreeBuilder.Marker expr = this.myBuilder.mark();
        if (!this.parseShiftExpression(isTargetExpression)) {
            expr.drop();
            return false;
        }
        while (this.atToken(PyTokenTypes.AND)) {
            this.myBuilder.advanceLexer();
            if (!this.parseShiftExpression(isTargetExpression)) {
                this.myBuilder.error(PyPsiBundle.message("PARSE.expected.expression", new Object[0]));
            }
            expr.done((IElementType)PyElementTypes.BINARY_EXPRESSION);
            expr = expr.precede();
        }
        expr.drop();
        return true;
    }

    private boolean parseShiftExpression(boolean isTargetExpression) {
        SyntaxTreeBuilder.Marker expr = this.myBuilder.mark();
        if (!this.parseAdditiveExpression(this.myBuilder, isTargetExpression)) {
            expr.drop();
            return false;
        }
        while (PyTokenTypes.SHIFT_OPERATIONS.contains(this.myBuilder.getTokenType())) {
            this.myBuilder.advanceLexer();
            if (!this.parseAdditiveExpression(this.myBuilder, isTargetExpression)) {
                this.myBuilder.error(PyPsiBundle.message("PARSE.expected.expression", new Object[0]));
            }
            expr.done((IElementType)PyElementTypes.BINARY_EXPRESSION);
            expr = expr.precede();
        }
        expr.drop();
        return true;
    }

    private boolean parseAdditiveExpression(SyntaxTreeBuilder myBuilder, boolean isTargetExpression) {
        SyntaxTreeBuilder.Marker expr = myBuilder.mark();
        if (!this.parseMultiplicativeExpression(isTargetExpression)) {
            expr.drop();
            return false;
        }
        while (PyTokenTypes.ADDITIVE_OPERATIONS.contains(myBuilder.getTokenType())) {
            myBuilder.advanceLexer();
            if (!this.parseMultiplicativeExpression(isTargetExpression)) {
                myBuilder.error(PyPsiBundle.message("PARSE.expected.expression", new Object[0]));
            }
            expr.done((IElementType)PyElementTypes.BINARY_EXPRESSION);
            expr = expr.precede();
        }
        expr.drop();
        return true;
    }

    private boolean parseMultiplicativeExpression(boolean isTargetExpression) {
        SyntaxTreeBuilder.Marker expr = this.myBuilder.mark();
        if (!this.parseUnaryExpression(isTargetExpression)) {
            expr.drop();
            return false;
        }
        while (PyTokenTypes.MULTIPLICATIVE_OPERATIONS.contains(this.myBuilder.getTokenType())) {
            this.myBuilder.advanceLexer();
            if (!this.parseUnaryExpression(isTargetExpression)) {
                this.myBuilder.error(PyPsiBundle.message("PARSE.expected.expression", new Object[0]));
            }
            expr.done((IElementType)PyElementTypes.BINARY_EXPRESSION);
            expr = expr.precede();
        }
        expr.drop();
        return true;
    }

    protected boolean parseUnaryExpression(boolean isTargetExpression) {
        IElementType tokenType = this.myBuilder.getTokenType();
        if (PyTokenTypes.UNARY_OPERATIONS.contains(tokenType)) {
            SyntaxTreeBuilder.Marker expr = this.myBuilder.mark();
            this.myBuilder.advanceLexer();
            if (!this.parseUnaryExpression(isTargetExpression)) {
                this.myBuilder.error(PyPsiBundle.message("PARSE.expected.expression", new Object[0]));
            }
            expr.done((IElementType)PyElementTypes.PREFIX_EXPRESSION);
            return true;
        }
        return this.parsePowerExpression(isTargetExpression);
    }

    private boolean parsePowerExpression(boolean isTargetExpression) {
        SyntaxTreeBuilder.Marker expr = this.myBuilder.mark();
        if (!this.parseAwaitExpression(isTargetExpression)) {
            expr.drop();
            return false;
        }
        if (this.myBuilder.getTokenType() == PyTokenTypes.EXP) {
            this.myBuilder.advanceLexer();
            if (!this.parseUnaryExpression(isTargetExpression)) {
                this.myBuilder.error(PyPsiBundle.message("PARSE.expected.expression", new Object[0]));
            }
            expr.done((IElementType)PyElementTypes.BINARY_EXPRESSION);
        } else {
            expr.drop();
        }
        return true;
    }

    private boolean parseAwaitExpression(boolean isTargetExpression) {
        if (this.atToken(PyTokenTypes.AWAIT_KEYWORD)) {
            SyntaxTreeBuilder.Marker expr = this.myBuilder.mark();
            this.myBuilder.advanceLexer();
            if (!this.parseMemberExpression(isTargetExpression)) {
                this.myBuilder.error(PyPsiBundle.message("PARSE.expected.expression", new Object[0]));
                expr.done((IElementType)PyElementTypes.PREFIX_EXPRESSION);
            } else if (isTargetExpression) {
                expr.error(PyPsiBundle.message("can.t.assign.to.await.expression", new Object[0]));
            } else {
                expr.done((IElementType)PyElementTypes.PREFIX_EXPRESSION);
            }
            return true;
        }
        return this.parseMemberExpression(isTargetExpression);
    }

    private boolean atForOrAsyncFor() {
        if (this.atToken(PyTokenTypes.FOR_KEYWORD)) {
            return true;
        }
        if (this.matchToken(PyTokenTypes.ASYNC_KEYWORD)) {
            if (this.atToken(PyTokenTypes.FOR_KEYWORD)) {
                return true;
            }
            this.myBuilder.error(PyPsiBundle.message("for.expected", new Object[0]));
            return false;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "expr";
        objectArray2[1] = "com/jetbrains/python/parsing/ExpressionParsing";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "parseDictOrSetTail";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "parseSliceOrSubscriptionExpression";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

