/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.types;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyUnionType
implements PyType {
    private final @NotNull LinkedHashSet<@Nullable PyType> myMembers;

    PyUnionType(@NotNull LinkedHashSet<@Nullable PyType> members2) {
        if (members2 == null) {
            PyUnionType.$$$reportNull$$$0(0);
        }
        this.myMembers = new LinkedHashSet<PyType>(members2);
    }

    @Override
    @Nullable
    public List<? extends RatedResolveResult> resolveMember(@NotNull String name2, @Nullable PyExpression location, @NotNull AccessDirection direction, @NotNull PyResolveContext resolveContext) {
        if (name2 == null) {
            PyUnionType.$$$reportNull$$$0(1);
        }
        if (direction == null) {
            PyUnionType.$$$reportNull$$$0(2);
        }
        if (resolveContext == null) {
            PyUnionType.$$$reportNull$$$0(3);
        }
        SmartList ret = new SmartList();
        boolean allNulls = true;
        for (PyType member : this.myMembers) {
            List<? extends RatedResolveResult> result;
            if (member == null || (result = member.resolveMember(name2, location, direction, resolveContext)) == null) continue;
            allNulls = false;
            ret.addAll(result);
        }
        return allNulls ? null : ret;
    }

    @Override
    public Object[] getCompletionVariants(String completionPrefix, PsiElement location, ProcessingContext context2) {
        HashSet variants = new HashSet();
        for (PyType member : this.myMembers) {
            if (member == null) continue;
            Collections.addAll(variants, member.getCompletionVariants(completionPrefix, location, context2));
        }
        return ArrayUtil.toObjectArray(variants);
    }

    @Override
    public String getName() {
        return StringUtil.join(this.myMembers, (Function)((NullableFunction)type -> type != null ? type.getName() : null), (String)" | ");
    }

    @Override
    public boolean isBuiltin() {
        for (PyType one : this.myMembers) {
            if (one != null && one.isBuiltin()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void assertValid(String message) {
        for (PyType member : this.myMembers) {
            if (member == null) continue;
            member.assertValid(message);
        }
    }

    @Nullable
    public static PyType union(@Nullable PyType type1, @Nullable PyType type2) {
        return PyUnionType.union(Arrays.asList(type1, type2));
    }

    @Nullable
    public static PyType union(@NotNull Collection<@Nullable PyType> members2) {
        if (members2 == null) {
            PyUnionType.$$$reportNull$$$0(4);
        }
        if (members2.size() < 2) {
            return (PyType)ContainerUtil.getFirstItem(members2);
        }
        LinkedHashSet<PyType> newMembers = new LinkedHashSet<PyType>();
        for (PyType member : members2) {
            if (member instanceof PyUnionType) {
                newMembers.addAll(((PyUnionType)member).getMembers());
                continue;
            }
            newMembers.add(member);
        }
        return newMembers.size() < 2 ? (PyType)ContainerUtil.getFirstItem(newMembers) : new PyUnionType(newMembers);
    }

    @Nullable
    public static PyType createWeakType(@Nullable PyType type) {
        PyUnionType unionType;
        if (type == null) {
            return null;
        }
        if (type instanceof PyUnionType && (unionType = (PyUnionType)type).isWeak()) {
            return unionType;
        }
        return PyUnionType.union(type, null);
    }

    @Nullable
    public static PyType toNonWeakType(@Nullable PyType type) {
        return type instanceof PyUnionType ? ((PyUnionType)type).excludeNull() : type;
    }

    public boolean isWeak() {
        return this.myMembers.contains(null);
    }

    @NotNull
    public Collection<PyType> getMembers() {
        Collection<PyType> collection = Collections.unmodifiableCollection(this.myMembers);
        if (collection == null) {
            PyUnionType.$$$reportNull$$$0(5);
        }
        return collection;
    }

    @Nullable
    public PyType map(@NotNull java.util.function.Function<@Nullable PyType, @Nullable PyType> mapper) {
        if (mapper == null) {
            PyUnionType.$$$reportNull$$$0(6);
        }
        return PyUnionType.union(ContainerUtil.map(this.getMembers(), t -> (PyType)mapper.apply((PyType)t)));
    }

    @Nullable
    public PyType exclude(@Nullable PyType type, @NotNull TypeEvalContext context2) {
        if (context2 == null) {
            PyUnionType.$$$reportNull$$$0(7);
        }
        if (type == null) {
            return this.excludeNull();
        }
        ArrayList<PyType> members2 = new ArrayList<PyType>();
        for (PyType m : this.getMembers()) {
            if (PyTypeChecker.match(type, m, context2)) continue;
            members2.add(m);
        }
        return PyUnionType.union(members2);
    }

    @Nullable
    public PyType excludeNull() {
        return !this.isWeak() ? this : PyUnionType.union(ContainerUtil.skipNulls(this.getMembers()));
    }

    public boolean equals(Object other) {
        if (other instanceof PyUnionType) {
            PyUnionType otherType = (PyUnionType)other;
            return this.myMembers.equals(otherType.myMembers);
        }
        return false;
    }

    public int hashCode() {
        return this.myMembers.hashCode();
    }

    public String toString() {
        return "PyUnionType: " + this.getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "members";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "direction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveContext";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/types/PyUnionType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapper";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/types/PyUnionType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMembers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resolveMember";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "union";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "map";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "exclude";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

