/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.move.makeFunctionTopLevel;

import com.intellij.codeInsight.controlflow.ControlFlow;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.ui.UsageViewDescriptorAdapter;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.PyPsiIndexUtil;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ReadWriteInstruction;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNonlocalStatement;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.refactoring.PyPsiRefactoringUtil;
import com.jetbrains.python.refactoring.classes.PyClassRefactoringUtil;
import com.jetbrains.python.refactoring.move.PyMoveRefactoringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PyBaseMakeFunctionTopLevelProcessor
extends BaseRefactoringProcessor {
    protected final PyFunction myFunction;
    protected final PsiFile mySourceFile;
    protected final PyResolveContext myResolveContext;
    protected final PyElementGenerator myGenerator;
    protected final String myDestinationPath;
    protected final List<PsiElement> myExternalReads;

    public PyBaseMakeFunctionTopLevelProcessor(@NotNull PyFunction targetFunction, @NotNull String destinationPath) {
        if (targetFunction == null) {
            PyBaseMakeFunctionTopLevelProcessor.$$$reportNull$$$0(0);
        }
        if (destinationPath == null) {
            PyBaseMakeFunctionTopLevelProcessor.$$$reportNull$$$0(1);
        }
        super(targetFunction.getProject());
        this.myExternalReads = new ArrayList<PsiElement>();
        this.myFunction = targetFunction;
        this.myDestinationPath = destinationPath;
        TypeEvalContext typeEvalContext = TypeEvalContext.userInitiated(this.myProject, targetFunction.getContainingFile());
        this.myResolveContext = PyResolveContext.defaultContext(typeEvalContext);
        this.myGenerator = PyElementGenerator.getInstance(this.myProject);
        this.mySourceFile = this.myFunction.getContainingFile();
    }

    @NotNull
    protected final UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            PyBaseMakeFunctionTopLevelProcessor.$$$reportNull$$$0(2);
        }
        return new UsageViewDescriptorAdapter(){

            public PsiElement @NotNull [] getElements() {
                PsiElement[] psiElementArray = new PsiElement[]{PyBaseMakeFunctionTopLevelProcessor.this.myFunction};
                if (psiElementArray == null) {
                    1.$$$reportNull$$$0(0);
                }
                return psiElementArray;
            }

            public String getProcessedElementsHeader() {
                return PyBaseMakeFunctionTopLevelProcessor.this.getRefactoringName();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/move/makeFunctionTopLevel/PyBaseMakeFunctionTopLevelProcessor$1", "getElements"));
            }
        };
    }

    protected final UsageInfo @NotNull [] findUsages() {
        UsageInfo[] usageInfoArray = PyPsiIndexUtil.findUsages(this.myFunction, false).toArray(UsageInfo.EMPTY_ARRAY);
        if (usageInfoArray == null) {
            PyBaseMakeFunctionTopLevelProcessor.$$$reportNull$$$0(3);
        }
        return usageInfoArray;
    }

    @NotNull
    protected final String getCommandName() {
        String string = this.getRefactoringName();
        if (string == null) {
            PyBaseMakeFunctionTopLevelProcessor.$$$reportNull$$$0(4);
        }
        return string;
    }

    protected final void performRefactoring(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            PyBaseMakeFunctionTopLevelProcessor.$$$reportNull$$$0(5);
        }
        List<String> newParameters = this.collectNewParameterNames();
        assert (ApplicationManager.getApplication().isWriteAccessAllowed());
        PyFile targetFile = PyClassRefactoringUtil.getOrCreateFile(this.myDestinationPath, this.myProject);
        if (targetFile.findTopLevelFunction(this.myFunction.getName()) != null) {
            throw new IncorrectOperationException(PyBundle.message("refactoring.move.error.destination.file.contains.function", this.myFunction.getName()));
        }
        if (this.importsRequired(usages, targetFile)) {
            PyMoveRefactoringUtil.checkValidImportableFile((PsiElement)targetFile, targetFile.getVirtualFile());
        }
        PsiElement position = PyMoveRefactoringUtil.findLowestPossibleTopLevelInsertionPosition(Arrays.asList(usages), targetFile);
        this.updateUsages(newParameters, usages);
        PyFunction newFunction = this.insertFunction(this.createNewFunction(newParameters), targetFile, position);
        this.myFunction.delete();
        this.updateImports(newFunction, usages);
    }

    private boolean importsRequired(UsageInfo @NotNull [] usages, PyFile targetFile) {
        if (usages == null) {
            PyBaseMakeFunctionTopLevelProcessor.$$$reportNull$$$0(6);
        }
        return ContainerUtil.exists((Object[])usages, info -> {
            PsiElement element = info.getElement();
            if (element == null) {
                return false;
            }
            return !this.belongsToFunction(element) && info.getFile() != targetFile;
        });
    }

    private boolean belongsToFunction(PsiElement element) {
        return PsiTreeUtil.isAncestor((PsiElement)this.myFunction, (PsiElement)element, (boolean)false);
    }

    private void updateImports(@NotNull PyFunction newFunction, UsageInfo @NotNull [] usages) {
        if (newFunction == null) {
            PyBaseMakeFunctionTopLevelProcessor.$$$reportNull$$$0(7);
        }
        if (usages == null) {
            PyBaseMakeFunctionTopLevelProcessor.$$$reportNull$$$0(8);
        }
        HashSet<PsiFile> usageFiles = new HashSet<PsiFile>();
        for (UsageInfo usage : usages) {
            usageFiles.add(usage.getFile());
        }
        for (PsiFile file : usageFiles) {
            if (file == newFunction.getContainingFile()) continue;
            PyPsiRefactoringUtil.insertImport((PsiElement)file, newFunction, null, true);
        }
        if (newFunction.getContainingFile() != this.mySourceFile) {
            for (PsiElement read : this.myExternalReads) {
                if (!(read instanceof PsiNamedElement) || !read.isValid()) continue;
                PyPsiRefactoringUtil.insertImport(newFunction, (PsiNamedElement)read, null, true);
            }
            PyClassRefactoringUtil.optimizeImports(this.mySourceFile);
        }
    }

    @NotNull
    @Nls
    protected abstract String getRefactoringName();

    @NotNull
    protected abstract List<String> collectNewParameterNames();

    protected abstract void updateUsages(@NotNull Collection<String> var1, UsageInfo @NotNull [] var2);

    @NotNull
    protected abstract PyFunction createNewFunction(@NotNull Collection<String> var1);

    @NotNull
    protected final PyParameterList addParameters(@NotNull PyParameterList paramList, @NotNull Collection<String> newParameters) {
        if (paramList == null) {
            PyBaseMakeFunctionTopLevelProcessor.$$$reportNull$$$0(9);
        }
        if (newParameters == null) {
            PyBaseMakeFunctionTopLevelProcessor.$$$reportNull$$$0(10);
        }
        if (!newParameters.isEmpty()) {
            String commaSeparatedNames = StringUtil.join(newParameters, (String)", ");
            StringBuilder paramListText = new StringBuilder(paramList.getText());
            paramListText.insert(1, commaSeparatedNames + (paramList.getParameters().length > 0 ? ", " : ""));
            PyParameterList newElement = this.myGenerator.createParameterList(LanguageLevel.forElement(this.myFunction), paramListText.toString());
            PyParameterList pyParameterList = (PyParameterList)paramList.replace((PsiElement)newElement);
            if (pyParameterList == null) {
                PyBaseMakeFunctionTopLevelProcessor.$$$reportNull$$$0(11);
            }
            return pyParameterList;
        }
        PyParameterList pyParameterList = paramList;
        if (pyParameterList == null) {
            PyBaseMakeFunctionTopLevelProcessor.$$$reportNull$$$0(12);
        }
        return pyParameterList;
    }

    @NotNull
    protected PyArgumentList addArguments(@NotNull PyArgumentList argList, @NotNull Collection<String> newArguments) {
        if (argList == null) {
            PyBaseMakeFunctionTopLevelProcessor.$$$reportNull$$$0(13);
        }
        if (newArguments == null) {
            PyBaseMakeFunctionTopLevelProcessor.$$$reportNull$$$0(14);
        }
        if (!newArguments.isEmpty()) {
            String commaSeparatedNames = StringUtil.join(newArguments, (String)", ");
            StringBuilder argListText = new StringBuilder(argList.getText());
            argListText.insert(1, commaSeparatedNames + (argList.getArguments().length > 0 ? ", " : ""));
            PyArgumentList newElement = this.myGenerator.createArgumentList(LanguageLevel.forElement((PsiElement)argList), argListText.toString());
            PyArgumentList pyArgumentList = (PyArgumentList)argList.replace((PsiElement)newElement);
            if (pyArgumentList == null) {
                PyBaseMakeFunctionTopLevelProcessor.$$$reportNull$$$0(15);
            }
            return pyArgumentList;
        }
        PyArgumentList pyArgumentList = argList;
        if (pyArgumentList == null) {
            PyBaseMakeFunctionTopLevelProcessor.$$$reportNull$$$0(16);
        }
        return pyArgumentList;
    }

    @NotNull
    protected PyFunction insertFunction(@NotNull PyFunction newFunction, @NotNull PyFile newFile, @Nullable PsiElement anchor) {
        if (newFunction == null) {
            PyBaseMakeFunctionTopLevelProcessor.$$$reportNull$$$0(17);
        }
        if (newFile == null) {
            PyBaseMakeFunctionTopLevelProcessor.$$$reportNull$$$0(18);
        }
        if (this.mySourceFile == newFile) {
            PsiElement surroundingStatement = PyPsiUtils.getParentRightBefore(this.myFunction, (PsiElement)this.mySourceFile);
            if (anchor == null || surroundingStatement.getTextRange().getEndOffset() < anchor.getTextRange().getStartOffset()) {
                PyFunction pyFunction = (PyFunction)this.mySourceFile.addAfter((PsiElement)newFunction, surroundingStatement);
                if (pyFunction == null) {
                    PyBaseMakeFunctionTopLevelProcessor.$$$reportNull$$$0(19);
                }
                return pyFunction;
            }
        }
        PyFunction pyFunction = (PyFunction)newFile.addBefore(newFunction, anchor);
        if (pyFunction == null) {
            PyBaseMakeFunctionTopLevelProcessor.$$$reportNull$$$0(20);
        }
        return pyFunction;
    }

    @NotNull
    protected AnalysisResult analyseScope(@NotNull ScopeOwner owner) {
        if (owner == null) {
            PyBaseMakeFunctionTopLevelProcessor.$$$reportNull$$$0(21);
        }
        ControlFlow controlFlow = ControlFlowCache.getControlFlow(owner);
        AnalysisResult result = new AnalysisResult();
        for (Instruction instruction : controlFlow.getInstructions()) {
            ReadWriteInstruction readWriteInstruction;
            PsiElement element;
            if (!(instruction instanceof ReadWriteInstruction) || (element = (readWriteInstruction = (ReadWriteInstruction)instruction).getElement()) == null) continue;
            if (readWriteInstruction.getAccess().isReadAccess()) {
                for (PsiElement resolved : PyUtil.multiResolveTopPriority(element, this.myResolveContext)) {
                    if ((resolved = (PsiElement)ObjectUtils.chooseNotNull((Object)PyUtil.turnConstructorIntoClass(PyUtil.as(resolved, PyFunction.class)), (Object)resolved)) == null) continue;
                    if (this.isFromEnclosingScope(resolved)) {
                        result.readsFromEnclosingScope.add(element);
                    } else if (!this.belongsToFunction(resolved)) {
                        this.myExternalReads.add(resolved);
                    }
                    if (!(resolved instanceof PyParameter) || !((PyParameter)resolved).isSelf()) continue;
                    if (PsiTreeUtil.getParentOfType((PsiElement)resolved, PyFunction.class) == this.myFunction) {
                        result.readsOfSelfParameter.add(element);
                        continue;
                    }
                    if (PsiTreeUtil.isAncestor((PsiElement)this.myFunction, (PsiElement)resolved, (boolean)true)) continue;
                    result.readsOfSelfParametersFromEnclosingScope.add(element);
                }
            }
            if (!readWriteInstruction.getAccess().isWriteAccess() || !(element instanceof PyTargetExpression)) continue;
            for (PsiElement resolved : PyUtil.multiResolveTopPriority(element, this.myResolveContext)) {
                if (resolved == null) continue;
                if (element.getParent() instanceof PyNonlocalStatement && this.isFromEnclosingScope(resolved)) {
                    result.nonlocalWritesToEnclosingScope.add((PyTargetExpression)element);
                }
                if (!(resolved instanceof PyParameter) || !((PyParameter)resolved).isSelf() || PsiTreeUtil.getParentOfType((PsiElement)resolved, PyFunction.class) != this.myFunction) continue;
                result.writesToSelfParameter.add((PyTargetExpression)element);
            }
        }
        AnalysisResult analysisResult = result;
        if (analysisResult == null) {
            PyBaseMakeFunctionTopLevelProcessor.$$$reportNull$$$0(22);
        }
        return analysisResult;
    }

    private boolean isFromEnclosingScope(@NotNull PsiElement element) {
        if (element == null) {
            PyBaseMakeFunctionTopLevelProcessor.$$$reportNull$$$0(23);
        }
        return PyUtil.inSameFile(element, this.myFunction) && !this.belongsToFunction(element) && !(ScopeUtil.getScopeOwner(element) instanceof PsiFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFunction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destinationPath";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 3: 
            case 4: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/refactoring/move/makeFunctionTopLevel/PyBaseMakeFunctionTopLevelProcessor";
                break;
            }
            case 7: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFunction";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramList";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParameters";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argList";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newArguments";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFile";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/refactoring/move/makeFunctionTopLevel/PyBaseMakeFunctionTopLevelProcessor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "addParameters";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "addArguments";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "insertFunction";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "analyseScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 3: 
            case 4: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 22: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "importsRequired";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updateImports";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addParameters";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addArguments";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "insertFunction";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "analyseScope";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isFromEnclosingScope";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class AnalysisResult {
        final List<PsiElement> readsFromEnclosingScope = new ArrayList<PsiElement>();
        final List<PyTargetExpression> nonlocalWritesToEnclosingScope = new ArrayList<PyTargetExpression>();
        final List<PsiElement> readsOfSelfParametersFromEnclosingScope = new ArrayList<PsiElement>();
        final List<PsiElement> readsOfSelfParameter = new ArrayList<PsiElement>();
        final List<PyTargetExpression> writesToSelfParameter = new ArrayList<PyTargetExpression>();

        protected AnalysisResult() {
        }
    }
}

