/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.execution.ExecutionException;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remote.RemoteSdkProperties;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.Processor;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.typing.PyTypeShed;
import com.jetbrains.python.codeInsight.userSkeletons.PyUserSkeletonsUtil;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.remote.UnsupportedPythonSdkTypeException;
import com.jetbrains.python.sdk.InvalidSdkException;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PyTargetsIntrospectionFacade;
import com.jetbrains.python.sdk.PyTransferredSdkRootsKt;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.skeletons.PySkeletonRefresher;
import java.awt.Component;
import java.io.File;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class PythonSdkUpdater
implements StartupActivity.Background {
    private static final Logger LOG = Logger.getInstance(PythonSdkUpdater.class);
    private static final Object ourLock = new Object();
    private static final Set<Sdk> ourUnderRefresh = new HashSet<Sdk>();
    private static final Map<Sdk, PyUpdateSdkRequestData> ourToBeRefreshed = new HashMap<Sdk, PyUpdateSdkRequestData>();
    private static volatile boolean ourEnabledInTests = false;
    static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.balloonGroup((String)"Python SDK Updater", (String)PyBundle.message("python.sdk.updater.notifications.group.title", new Object[0]));

    @ApiStatus.Internal
    @TestOnly
    public static void setEnabledInTests(boolean enabled) {
        ourEnabledInTests = enabled;
    }

    public void runActivity(@NotNull Project project) {
        Application application;
        if (project == null) {
            PythonSdkUpdater.$$$reportNull$$$0(0);
        }
        if ((application = ApplicationManager.getApplication()).isUnitTestMode()) {
            return;
        }
        if (application.isHeadlessEnvironment()) {
            return;
        }
        if (project.isDisposed()) {
            return;
        }
        for (Sdk sdk : PythonSdkUpdater.getPythonSdks(project)) {
            PythonSdkUpdater.scheduleUpdate(sdk, project);
        }
    }

    @Deprecated(forRemoval=true)
    public static boolean update(@NotNull Sdk sdk, @Nullable Project project, @Nullable Component ownerComponent) {
        if (sdk == null) {
            PythonSdkUpdater.$$$reportNull$$$0(1);
        }
        return PythonSdkUpdater.updateVersionAndPathsSynchronouslyAndScheduleRemaining(sdk, project);
    }

    @ApiStatus.Internal
    public static boolean updateVersionAndPathsSynchronouslyAndScheduleRemaining(@NotNull Sdk sdk, @Nullable Project project) {
        boolean isSavedSdk;
        if (sdk == null) {
            PythonSdkUpdater.$$$reportNull$$$0(2);
        }
        Application application = ApplicationManager.getApplication();
        try {
            if (application.isDispatchThread()) {
                ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                    PythonSdkUpdater.updateLocalSdkVersionAndPaths(sdk, project);
                    return null;
                }, PyBundle.message("sdk.gen.updating.interpreter", new Object[0]), false, project);
            } else {
                LOG.assertTrue(!application.isReadAccessAllowed(), (Object)"Synchronous SDK update should not be run under read action");
                PythonSdkUpdater.updateLocalSdkVersionAndPaths(sdk, project);
            }
        }
        catch (InvalidSdkException e) {
            LOG.warn("Error while evaluating path and version: ", (Throwable)e);
            return false;
        }
        if (project == null) {
            return true;
        }
        PyUpdateSdkRequestData request = new PyUpdateSdkRequestData();
        boolean bl = isSavedSdk = PythonSdkUtil.findSdkByKey(PythonSdkType.getSdkKey(sdk)) != null;
        if (application.isWriteThread() && !isSavedSdk) {
            application.invokeLaterOnWriteThread(() -> PythonSdkUpdater.scheduleUpdate(sdk, project, request));
        } else {
            PythonSdkUpdater.scheduleUpdate(sdk, project, request);
        }
        return true;
    }

    public static void scheduleUpdate(@NotNull Sdk sdk, @NotNull Project project) {
        if (sdk == null) {
            PythonSdkUpdater.$$$reportNull$$$0(3);
        }
        if (project == null) {
            PythonSdkUpdater.$$$reportNull$$$0(4);
        }
        PythonSdkUpdater.scheduleUpdate(sdk, project, new PyUpdateSdkRequestData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ensureUpdateScheduled(@NotNull Sdk sdk, @NotNull Project project) {
        if (sdk == null) {
            PythonSdkUpdater.$$$reportNull$$$0(5);
        }
        if (project == null) {
            PythonSdkUpdater.$$$reportNull$$$0(6);
        }
        Object object = ourLock;
        synchronized (object) {
            if (ourUnderRefresh.contains(sdk) || ourToBeRefreshed.containsKey(sdk)) {
                return;
            }
            ourUnderRefresh.add(sdk);
        }
        ProgressManager.getInstance().run((Task)new PyUpdateSdkTask(project, sdk, new PyUpdateSdkRequestData()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isUpdateScheduled(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkUpdater.$$$reportNull$$$0(7);
        }
        Object object = ourLock;
        synchronized (object) {
            return ourUnderRefresh.contains(sdk) || ourToBeRefreshed.containsKey(sdk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void scheduleUpdate(@NotNull Sdk sdk, @NotNull Project project, @NotNull PyUpdateSdkRequestData requestData) {
        if (sdk == null) {
            PythonSdkUpdater.$$$reportNull$$$0(8);
        }
        if (project == null) {
            PythonSdkUpdater.$$$reportNull$$$0(9);
        }
        if (requestData == null) {
            PythonSdkUpdater.$$$reportNull$$$0(10);
        }
        if (!ourEnabledInTests && ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.info("Skipping background update for '" + sdk + "' in unit test mode");
            return;
        }
        Object object = ourLock;
        synchronized (object) {
            if (ourUnderRefresh.contains(sdk)) {
                PyUpdateSdkRequestData previousRequest;
                if (Trigger.LOG.isDebugEnabled() && (previousRequest = ourToBeRefreshed.get(sdk)) != null) {
                    String cause = Trigger.getCauseByTrace(previousRequest.myTraceback);
                    Trigger.LOG.debug("Discarding previous update for " + sdk + " triggered by " + cause);
                }
                ourToBeRefreshed.merge(sdk, requestData, (x$0, x$1) -> PyUpdateSdkRequestData.merge(x$0, x$1));
                return;
            }
            ourUnderRefresh.add(sdk);
        }
        ProgressManager.getInstance().run((Task)new PyUpdateSdkTask(project, sdk, requestData));
    }

    @ApiStatus.Internal
    public static void updateOrShowError(@NotNull Sdk sdk, @Nullable Project project, @Nullable Component ownerComponent) {
        boolean versionAndPathsUpdated;
        if (sdk == null) {
            PythonSdkUpdater.$$$reportNull$$$0(11);
        }
        if (!(versionAndPathsUpdated = PythonSdkUpdater.updateVersionAndPathsSynchronouslyAndScheduleRemaining(sdk, project))) {
            ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((Project)project, (String)PyBundle.message("python.sdk.cannot.setup.sdk", PythonSdkUpdater.getSdkPresentableName(sdk)), (String)PyBundle.message("python.sdk.invalid.python.sdk", new Object[0])));
        }
    }

    private static void updateLocalSdkVersionAndPaths(@NotNull Sdk sdk, @Nullable Project project) throws InvalidSdkException {
        if (sdk == null) {
            PythonSdkUpdater.$$$reportNull$$$0(12);
        }
        PythonSdkUpdater.updateLocalSdkVersion(sdk);
        if (!PythonSdkUtil.isRemote(sdk)) {
            PythonSdkUpdater.updateSdkPaths(sdk, PythonSdkUpdater.evaluateSysPath(sdk), project);
        }
    }

    private static void updateLocalSdkVersion(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkUpdater.$$$reportNull$$$0(13);
        }
        if (!PythonSdkUtil.isRemote(sdk)) {
            ProgressManager.progress((String)PyBundle.message("sdk.updating.interpreter.version", new Object[0]));
            String versionString = sdk.getSdkType().getVersionString(sdk);
            PythonSdkUpdater.commitSdkVersionIfChanged(sdk, versionString);
        }
    }

    private static void commitSdkVersionIfChanged(@NotNull Sdk sdk, @Nullable String versionString) {
        if (sdk == null) {
            PythonSdkUpdater.$$$reportNull$$$0(14);
        }
        if (!StringUtil.equals((CharSequence)versionString, (CharSequence)sdk.getVersionString())) {
            PythonSdkUpdater.changeSdkModificator(sdk, (Processor<? super SdkModificator>)((Processor)modificatorToWrite -> {
                modificatorToWrite.setVersionString(versionString);
                return true;
            }));
        }
    }

    private static void updateSdkPaths(@NotNull Sdk sdk, @NotNull List<String> paths, @Nullable Project project) {
        if (sdk == null) {
            PythonSdkUpdater.$$$reportNull$$$0(15);
        }
        if (paths == null) {
            PythonSdkUpdater.$$$reportNull$$$0(16);
        }
        Set<VirtualFile> moduleRoots = PythonSdkUpdater.getModuleRoots(project);
        Collection<VirtualFile> excludedPaths = PythonSdkUpdater.getExcludedPaths(sdk);
        Pair<List<VirtualFile>, List<VirtualFile>> sdkRoots = PythonSdkUpdater.splitIntoLibraryAndSourceRoots(sdk, paths, moduleRoots, excludedPaths, it -> PythonSdkUpdater.sdkPathToRoot(sdk, it));
        Pair<List<VirtualFile>, List<VirtualFile>> userAddedRoots = PythonSdkUpdater.splitIntoLibraryAndSourceRoots(sdk, PythonSdkUpdater.getUserAddedPaths(sdk), moduleRoots, excludedPaths, Function.identity());
        boolean forceCommit = PythonSdkUpdater.ensureBinarySkeletonsDirectoryExists(sdk);
        List<VirtualFile> localSdkPaths = PythonSdkUpdater.buildSdkPaths(sdk, (List)sdkRoots.first, (List)userAddedRoots.first);
        PythonSdkUpdater.commitSdkPathsIfChanged(sdk, localSdkPaths, forceCommit);
        HashSet pathsToTransfer = new HashSet();
        pathsToTransfer.addAll((Collection)sdkRoots.second);
        pathsToTransfer.addAll((Collection)userAddedRoots.second);
        HashSet<VirtualFile> nonTransferredModuleRoots = new HashSet<VirtualFile>(moduleRoots);
        nonTransferredModuleRoots.removeAll(PyTransferredSdkRootsKt.getPathsToTransfer(sdk));
        pathsToTransfer.removeAll(nonTransferredModuleRoots);
        if (ArrayUtil.contains((Object)sdk, (Object[])ProjectJdkTable.getInstance().getAllJdks()) && !pathsToTransfer.equals(PyTransferredSdkRootsKt.getPathsToTransfer(sdk))) {
            if (project != null) {
                PyTransferredSdkRootsKt.removeTransferredRootsFromModulesWithSdk(project, sdk);
            }
            PyTransferredSdkRootsKt.setPathsToTransfer(sdk, pathsToTransfer);
            if (project != null) {
                PyTransferredSdkRootsKt.transferRootsToModulesWithSdk(project, sdk);
            }
        }
    }

    private static boolean ensureBinarySkeletonsDirectoryExists(Sdk sdk) {
        String skeletonsPath = PythonSdkUtil.getSkeletonsPath(sdk);
        return skeletonsPath != null && new File(skeletonsPath).mkdirs();
    }

    @NotNull
    private static List<VirtualFile> buildSdkPaths(@NotNull Sdk sdk, @NotNull List<VirtualFile> sdkRoots, @NotNull List<VirtualFile> userAddedRoots) {
        if (sdk == null) {
            PythonSdkUpdater.$$$reportNull$$$0(17);
        }
        if (sdkRoots == null) {
            PythonSdkUpdater.$$$reportNull$$$0(18);
        }
        if (userAddedRoots == null) {
            PythonSdkUpdater.$$$reportNull$$$0(19);
        }
        ImmutableList immutableList = ImmutableList.builder().addAll(sdkRoots).addAll(PythonSdkUpdater.getSkeletonsPaths(sdk)).addAll(userAddedRoots).addAll(PyTypeShed.INSTANCE.findRootsForSdk(sdk)).build();
        if (immutableList == null) {
            PythonSdkUpdater.$$$reportNull$$$0(20);
        }
        return immutableList;
    }

    @NotNull
    private static List<VirtualFile> getUserAddedPaths(@NotNull Sdk sdk) {
        SdkAdditionalData additionalData;
        PythonSdkAdditionalData pythonAdditionalData;
        if (sdk == null) {
            PythonSdkUpdater.$$$reportNull$$$0(21);
        }
        ArrayList arrayList = (pythonAdditionalData = PyUtil.as(additionalData = sdk.getSdkAdditionalData(), PythonSdkAdditionalData.class)) != null ? Lists.newArrayList(pythonAdditionalData.getAddedPathFiles()) : Collections.emptyList();
        if (arrayList == null) {
            PythonSdkUpdater.$$$reportNull$$$0(22);
        }
        return arrayList;
    }

    @NotNull
    private static List<String> getRemoteSdkMappedPaths(@NotNull Sdk sdk) {
        SdkAdditionalData additionalData;
        if (sdk == null) {
            PythonSdkUpdater.$$$reportNull$$$0(23);
        }
        if ((additionalData = sdk.getSdkAdditionalData()) instanceof RemoteSdkProperties) {
            RemoteSdkProperties remoteSdkData = (RemoteSdkProperties)additionalData;
            ArrayList<String> paths = new ArrayList<String>();
            for (PathMappingSettings.PathMapping mapping : remoteSdkData.getPathMappings().getPathMappings()) {
                paths.add(mapping.getLocalRoot());
            }
            ArrayList<String> arrayList = paths;
            if (arrayList == null) {
                PythonSdkUpdater.$$$reportNull$$$0(24);
            }
            return arrayList;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            PythonSdkUpdater.$$$reportNull$$$0(25);
        }
        return list;
    }

    @NotNull
    private static <T> @NotNull Pair<@NotNull List<VirtualFile>, @NotNull List<VirtualFile>> splitIntoLibraryAndSourceRoots(@NotNull Sdk sdk, @NotNull List<T> paths, @NotNull Set<VirtualFile> moduleRoots, @NotNull Collection<VirtualFile> excludedPaths, @NotNull Function<T, @Nullable VirtualFile> mapper) {
        if (sdk == null) {
            PythonSdkUpdater.$$$reportNull$$$0(26);
        }
        if (paths == null) {
            PythonSdkUpdater.$$$reportNull$$$0(27);
        }
        if (moduleRoots == null) {
            PythonSdkUpdater.$$$reportNull$$$0(28);
        }
        if (excludedPaths == null) {
            PythonSdkUpdater.$$$reportNull$$$0(29);
        }
        if (mapper == null) {
            PythonSdkUpdater.$$$reportNull$$$0(30);
        }
        ArrayList<VirtualFile> lib = new ArrayList<VirtualFile>();
        ArrayList<VirtualFile> source = new ArrayList<VirtualFile>();
        for (T path2 : paths) {
            VirtualFile rootFile = mapper.apply(path2);
            if (rootFile != null && !excludedPaths.contains(rootFile)) {
                if (PythonSdkUpdater.isUnderModuleRootsButNotSdk(rootFile, moduleRoots, sdk)) {
                    source.add(rootFile);
                    continue;
                }
                lib.add(rootFile);
                continue;
            }
            LOG.info("Bogus sys.path entry " + path2);
        }
        Pair.NonNull nonNull = Pair.createNonNull(lib, source);
        if (nonNull == null) {
            PythonSdkUpdater.$$$reportNull$$$0(31);
        }
        return nonNull;
    }

    @NotNull
    private static Set<VirtualFile> getModuleRoots(@Nullable Project project) {
        if (project != null) {
            Module[] modules;
            HashSet<VirtualFile> moduleRoots = new HashSet<VirtualFile>();
            for (Module module : modules = ModuleManager.getInstance((Project)project).getModules()) {
                moduleRoots.addAll(PyUtil.getSourceRoots(module));
            }
            HashSet<VirtualFile> hashSet = moduleRoots;
            if (hashSet == null) {
                PythonSdkUpdater.$$$reportNull$$$0(32);
            }
            return hashSet;
        }
        Set<VirtualFile> set = Collections.emptySet();
        if (set == null) {
            PythonSdkUpdater.$$$reportNull$$$0(33);
        }
        return set;
    }

    @NotNull
    private static Collection<VirtualFile> getExcludedPaths(@NotNull Sdk sdk) {
        PythonSdkAdditionalData pythonAdditionalData;
        if (sdk == null) {
            PythonSdkUpdater.$$$reportNull$$$0(34);
        }
        Collection<Object> collection = (pythonAdditionalData = PyUtil.as(sdk.getSdkAdditionalData(), PythonSdkAdditionalData.class)) != null ? pythonAdditionalData.getExcludedPathFiles() : Collections.emptyList();
        if (collection == null) {
            PythonSdkUpdater.$$$reportNull$$$0(35);
        }
        return collection;
    }

    @Nullable
    private static VirtualFile sdkPathToRoot(@NotNull Sdk sdk, @Nullable String path2) {
        if (sdk == null) {
            PythonSdkUpdater.$$$reportNull$$$0(36);
        }
        if (path2 != null && !FileUtilRt.extensionEquals((String)path2, (String)"egg-info")) {
            VirtualFile condaFolder = PythonSdkUtil.isConda(sdk) ? PythonSdkUtil.getCondaDirectory(sdk) : null;
            VirtualFile virtualFile = StandardFileSystems.local().refreshAndFindFileByPath(path2);
            if (virtualFile != null && !virtualFile.equals(condaFolder)) {
                return PythonSdkType.getSdkRootVirtualFile(virtualFile);
            }
        }
        return null;
    }

    private static boolean isUnderModuleRootsButNotSdk(@NotNull VirtualFile file, @NotNull Set<VirtualFile> moduleRoots, @NotNull Sdk sdk) {
        if (file == null) {
            PythonSdkUpdater.$$$reportNull$$$0(37);
        }
        if (moduleRoots == null) {
            PythonSdkUpdater.$$$reportNull$$$0(38);
        }
        if (sdk == null) {
            PythonSdkUpdater.$$$reportNull$$$0(39);
        }
        if (VfsUtilCore.isUnder((VirtualFile)file, moduleRoots)) {
            VirtualFile envRoot = PySdkExtKt.getInnerVirtualEnvRoot(sdk);
            if (envRoot == null) {
                return true;
            }
            return !VfsUtilCore.isAncestor((VirtualFile)envRoot, (VirtualFile)file, (boolean)false);
        }
        return false;
    }

    @NotNull
    private static List<VirtualFile> getSkeletonsPaths(@NotNull Sdk sdk) {
        VirtualFile userSkeletonsDir;
        VirtualFile skeletonsDir;
        if (sdk == null) {
            PythonSdkUpdater.$$$reportNull$$$0(40);
        }
        ArrayList<VirtualFile> results = new ArrayList<VirtualFile>();
        String skeletonsPath = PythonSdkUtil.getSkeletonsPath(sdk);
        if (skeletonsPath != null && (skeletonsDir = StandardFileSystems.local().refreshAndFindFileByPath(skeletonsPath)) != null) {
            results.add(skeletonsDir);
            LOG.info("Binary skeletons directory for SDK " + PythonSdkUpdater.getSdkPresentableName(sdk) + "): " + skeletonsDir.getPath());
        }
        if ((userSkeletonsDir = PyUserSkeletonsUtil.getUserSkeletonsDirectory()) != null) {
            results.add(userSkeletonsDir);
            LOG.info("User skeletons directory for SDK " + PythonSdkUpdater.getSdkPresentableName(sdk) + "): " + userSkeletonsDir.getPath());
        }
        ArrayList<VirtualFile> arrayList = results;
        if (arrayList == null) {
            PythonSdkUpdater.$$$reportNull$$$0(41);
        }
        return arrayList;
    }

    @NotNull
    private static String getSdkPresentableName(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkUpdater.$$$reportNull$$$0(42);
        }
        String homePath2 = sdk.getHomePath();
        String name2 = sdk.getName();
        Object object = homePath2 != null ? name2 + " (" + homePath2 + ")" : name2;
        if (object == null) {
            PythonSdkUpdater.$$$reportNull$$$0(43);
        }
        return object;
    }

    @NotNull
    private static List<String> evaluateSysPath(@NotNull Sdk sdk) throws InvalidSdkException {
        if (sdk == null) {
            PythonSdkUpdater.$$$reportNull$$$0(44);
        }
        if (PythonSdkUtil.isRemote(sdk)) {
            throw new IllegalArgumentException("Cannot evaluate sys.path for remote Python interpreter " + sdk);
        }
        long startTime = System.currentTimeMillis();
        ProgressManager.progress((String)PyBundle.message("sdk.updating.interpreter.paths", new Object[0]));
        List<String> sysPath = PythonSdkType.getSysPath(sdk);
        LOG.info("Updating sys.path took " + (System.currentTimeMillis() - startTime) + " ms");
        List<String> list = sysPath;
        if (list == null) {
            PythonSdkUpdater.$$$reportNull$$$0(45);
        }
        return list;
    }

    private static void commitSdkPathsIfChanged(@NotNull Sdk sdk, @NotNull List<VirtualFile> sdkPaths, boolean forceCommit) {
        if (sdk == null) {
            PythonSdkUpdater.$$$reportNull$$$0(46);
        }
        if (sdkPaths == null) {
            PythonSdkUpdater.$$$reportNull$$$0(47);
        }
        List<VirtualFile> currentSdkPaths = Arrays.asList(sdk.getRootProvider().getFiles(OrderRootType.CLASSES));
        if (forceCommit || !Sets.newHashSet(sdkPaths).equals(Sets.newHashSet(currentSdkPaths))) {
            PythonSdkUpdater.changeSdkModificator(sdk, (Processor<? super SdkModificator>)((Processor)effectiveModificator -> {
                effectiveModificator.removeAllRoots();
                for (VirtualFile sdkPath : sdkPaths) {
                    effectiveModificator.addRoot(PythonSdkType.getSdkRootVirtualFile(sdkPath), OrderRootType.CLASSES);
                }
                return true;
            }));
        }
    }

    private static void changeSdkModificator(@NotNull Sdk sdk, @NotNull Processor<? super SdkModificator> processor2) {
        if (sdk == null) {
            PythonSdkUpdater.$$$reportNull$$$0(48);
        }
        if (processor2 == null) {
            PythonSdkUpdater.$$$reportNull$$$0(49);
        }
        TransactionGuard.getInstance().assertWriteSafeContext(ModalityState.defaultModalityState());
        ApplicationManager.getApplication().invokeAndWait(() -> {
            SdkModificator effectiveModificator = sdk.getSdkModificator();
            if (processor2.process((Object)effectiveModificator)) {
                effectiveModificator.commitChanges();
            }
        });
    }

    @NotNull
    static Set<Sdk> getPythonSdks(@NotNull Project project) {
        if (project == null) {
            PythonSdkUpdater.$$$reportNull$$$0(50);
        }
        LinkedHashSet<Sdk> pythonSdks = new LinkedHashSet<Sdk>();
        ReadAction.run(() -> {
            for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                Sdk sdk = PythonSdkUtil.findPythonSdk(module);
                if (sdk == null || !(sdk.getSdkType() instanceof PythonSdkType)) continue;
                pythonSdks.add(sdk);
            }
        });
        LinkedHashSet<Sdk> linkedHashSet = pythonSdks;
        if (linkedHashSet == null) {
            PythonSdkUpdater.$$$reportNull$$$0(51);
        }
        return linkedHashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 41: 
            case 43: 
            case 45: 
            case 51: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 41: 
            case 43: 
            case 45: 
            case 51: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 21: 
            case 23: 
            case 26: 
            case 34: 
            case 36: 
            case 39: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestData";
                break;
            }
            case 16: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkRoots";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userAddedRoots";
                break;
            }
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 41: 
            case 43: 
            case 45: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/sdk/PythonSdkUpdater";
                break;
            }
            case 28: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleRoots";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedPaths";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapper";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkPaths";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/sdk/PythonSdkUpdater";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "buildSdkPaths";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserAddedPaths";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteSdkMappedPaths";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "splitIntoLibraryAndSourceRoots";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleRoots";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedPaths";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getSkeletonsPaths";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkPresentableName";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluateSysPath";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getPythonSdks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runActivity";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateVersionAndPathsSynchronouslyAndScheduleRemaining";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "scheduleUpdate";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "ensureUpdateScheduled";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isUpdateScheduled";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updateOrShowError";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "updateLocalSdkVersionAndPaths";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "updateLocalSdkVersion";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "commitSdkVersionIfChanged";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "updateSdkPaths";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "buildSdkPaths";
                break;
            }
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 41: 
            case 43: 
            case 45: 
            case 51: {
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getUserAddedPaths";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteSdkMappedPaths";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "splitIntoLibraryAndSourceRoots";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getExcludedPaths";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "sdkPathToRoot";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isUnderModuleRootsButNotSdk";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getSkeletonsPaths";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getSdkPresentableName";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "evaluateSysPath";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "commitSdkPathsIfChanged";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "changeSdkModificator";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getPythonSdks";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 41: 
            case 43: 
            case 45: 
            case 51: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum Trigger {
        STARTUP_ACTIVITY("com.jetbrains.python.sdk.PythonSdkUpdater.runActivity"),
        CHANGE_UNDER_INTERPRETER_ROOTS("com.jetbrains.python.packaging.PyPackageManagerImpl.lambda$subscribeToLocalChanges"),
        REFRESH_AFTER_PACKAGING_OPERATION("com.jetbrains.python.packaging.PyPackageManagerImpl.lambda$refresh"),
        NEW_SDK_GENERATION("com.jetbrains.python.sdk.PySdkExtKt.createSdkByGenerateTask"),
        CHANGED_SDK_CONFIGURATION("com.jetbrains.python.configuration.PyActiveSdkConfigurable.apply"),
        SDK_RELOAD_IN_SETTINGS("com.jetbrains.python.configuration.PythonSdkDetailsDialog.reloadSdk"),
        START_SDK_UPDATES_ACTION("com.jetbrains.python.sdk.PyUpdateProjectSdkAction.lambda$actionPerformed");

        private static final Logger LOG;
        private final String myFrameMarker;

        private Trigger(String frameMarker) {
            if (frameMarker == null) {
                Trigger.$$$reportNull$$$0(0);
            }
            this.myFrameMarker = frameMarker;
        }

        @NotNull
        public static String getCauseByTrace(@NotNull Throwable trace) {
            Trigger trigger;
            if (trace == null) {
                Trigger.$$$reportNull$$$0(1);
            }
            if ((trigger = Trigger.findTriggerByTrace(trace)) != null) {
                String string = trigger.name();
                if (string == null) {
                    Trigger.$$$reportNull$$$0(2);
                }
                return string;
            }
            String string = "Unknown trigger:\n" + ExceptionUtil.getThrowableText((Throwable)trace);
            if (string == null) {
                Trigger.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Nullable
        public static Trigger findTriggerByTrace(@NotNull Throwable trace) {
            if (trace == null) {
                Trigger.$$$reportNull$$$0(4);
            }
            String traceText = ExceptionUtil.getThrowableText((Throwable)trace);
            for (Trigger value : Trigger.values()) {
                if (!traceText.contains(value.myFrameMarker)) continue;
                return value;
            }
            return null;
        }

        static {
            LOG = Logger.getInstance(Trigger.class);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "frameMarker";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "trace";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/sdk/PythonSdkUpdater$Trigger";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/sdk/PythonSdkUpdater$Trigger";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCauseByTrace";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getCauseByTrace";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "findTriggerByTrace";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PyUpdateSdkTask
    extends Task.Backgroundable {
        @NotNull
        private final Sdk mySdk;
        @NotNull
        private final PyUpdateSdkRequestData myRequestData;
        @NotNull
        private final Project myProject;

        PyUpdateSdkTask(@NotNull Project project, @NotNull Sdk sdk, @NotNull PyUpdateSdkRequestData requestData) {
            if (project == null) {
                PyUpdateSdkTask.$$$reportNull$$$0(0);
            }
            if (sdk == null) {
                PyUpdateSdkTask.$$$reportNull$$$0(1);
            }
            if (requestData == null) {
                PyUpdateSdkTask.$$$reportNull$$$0(2);
            }
            super(project, PyBundle.message("sdk.gen.updating.interpreter", new Object[0]), false);
            this.mySdk = sdk;
            this.myRequestData = requestData;
            this.myProject = project;
        }

        private boolean isSdkDisposed() {
            return this.mySdk instanceof Disposable && Disposer.isDisposed((Disposable)((Disposable)this.mySdk));
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                PyUpdateSdkTask.$$$reportNull$$$0(3);
            }
            if (this.myProject.isDisposed()) {
                return;
            }
            if (this.isSdkDisposed()) {
                return;
            }
            if (Trigger.LOG.isDebugEnabled()) {
                Trigger.LOG.debug("Starting SDK refresh for '" + this.mySdk.getName() + "' triggered by " + Trigger.getCauseByTrace(this.myRequestData.myTraceback));
            }
            try {
                if (Registry.get((String)"python.use.targets.api").asBoolean()) {
                    PyTargetsIntrospectionFacade targetsFacade = new PyTargetsIntrospectionFacade(this.mySdk, this.myProject);
                    String version = targetsFacade.getInterpreterVersion(indicator);
                    PythonSdkUpdater.commitSdkVersionIfChanged(this.mySdk, version);
                    if (targetsFacade.isLocalTarget()) {
                        List<String> paths = targetsFacade.getInterpreterPaths(indicator);
                        PythonSdkUpdater.updateSdkPaths(this.mySdk, paths, this.myProject);
                    } else {
                        targetsFacade.synchronizeRemoteSourcesAndSetupMappings(indicator);
                    }
                } else {
                    PythonSdkUpdater.updateLocalSdkVersionAndPaths(this.mySdk, this.myProject);
                }
                this.generateSkeletons(this.mySdk, indicator);
                this.refreshPackages(this.mySdk, indicator);
            }
            catch (ExecutionException | InvalidSdkException e) {
                LOG.warn("Update for SDK " + this.mySdk.getName() + " failed", e);
            }
            ApplicationManager.getApplication().invokeLater(() -> DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart(), this.myProject.getDisposed());
        }

        private void refreshPackages(@NotNull Sdk sdk, @NotNull ProgressIndicator indicator) {
            if (sdk == null) {
                PyUpdateSdkTask.$$$reportNull$$$0(4);
            }
            if (indicator == null) {
                PyUpdateSdkTask.$$$reportNull$$$0(5);
            }
            try {
                LOG.info("Performing background scan of packages for SDK " + PythonSdkUpdater.getSdkPresentableName(sdk));
                indicator.setIndeterminate(true);
                indicator.setText(PyBundle.message("python.sdk.scanning.installed.packages", new Object[0]));
                indicator.setText2("");
                PyPackageManager.getInstance(sdk).refreshAndGetPackages(true);
            }
            catch (ExecutionException e) {
                if (LOG.isDebugEnabled()) {
                    e.initCause(this.myRequestData.myTraceback);
                    LOG.debug((Throwable)e);
                }
                LOG.warn(e.getMessage());
            }
        }

        private void generateSkeletons(@NotNull Sdk sdk, @NotNull ProgressIndicator indicator) {
            if (sdk == null) {
                PyUpdateSdkTask.$$$reportNull$$$0(6);
            }
            if (indicator == null) {
                PyUpdateSdkTask.$$$reportNull$$$0(7);
            }
            String skeletonsPath = PythonSdkUtil.getSkeletonsPath(sdk);
            try {
                String sdkPresentableName = PythonSdkUpdater.getSdkPresentableName(sdk);
                LOG.info("Performing background update of skeletons for SDK " + sdkPresentableName);
                indicator.setText(PyBundle.message("python.sdk.updating.skeletons", new Object[0]));
                PySkeletonRefresher.refreshSkeletonsOfSdk(this.myProject, null, skeletonsPath, sdk);
                if (PythonSdkUtil.isRemote(sdk)) {
                    PythonSdkUpdater.updateSdkPaths(sdk, PythonSdkUpdater.getRemoteSdkMappedPaths(sdk), this.getProject());
                }
            }
            catch (UnsupportedPythonSdkTypeException | InvalidSdkException e) {
                this.notifyOfGenerationFailure(e, sdk);
            }
        }

        private void notifyOfGenerationFailure(@NotNull Exception exception, @NotNull Sdk sdk) {
            if (exception == null) {
                PyUpdateSdkTask.$$$reportNull$$$0(8);
            }
            if (sdk == null) {
                PyUpdateSdkTask.$$$reportNull$$$0(9);
            }
            if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
                LOG.warn((Throwable)exception);
                return;
            }
            if (exception instanceof UnsupportedPythonSdkTypeException) {
                NOTIFICATION_GROUP.createNotification(PyBundle.message("sdk.gen.failed.notification.title", new Object[0]), PyBundle.message("remote.interpreter.support.is.not.available", sdk.getName()), NotificationType.WARNING).notify(this.myProject);
            } else if (exception instanceof InvalidSdkException) {
                if (PythonSdkUtil.isRemote(this.mySdk)) {
                    PythonSdkType.notifyRemoteSdkSkeletonsFail((InvalidSdkException)exception, () -> {
                        if (!this.isSdkDisposed()) {
                            PythonSdkUpdater.update(this.mySdk, this.myProject, null);
                        }
                    });
                } else if (!PythonSdkUtil.isInvalid(sdk)) {
                    LOG.error((Throwable)exception);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onFinished() {
            PyUpdateSdkRequestData requestData;
            if (Trigger.LOG.isDebugEnabled()) {
                Trigger.LOG.debug("Finishing SDK refresh for '" + this.mySdk.getName() + "' originally scheduled at " + this.myRequestData.myTimestamp + " by " + Trigger.getCauseByTrace(this.myRequestData.myTraceback));
            }
            Object object = ourLock;
            synchronized (object) {
                boolean existed = ourUnderRefresh.remove(this.mySdk);
                LOG.assertTrue(existed, (Object)"Error in SDK refresh scheduling: refreshed SDK is not in the set.");
                requestData = ourToBeRefreshed.remove(this.mySdk);
                if (requestData != null) {
                    ourUnderRefresh.add(this.mySdk);
                }
            }
            if (requestData != null) {
                ProgressManager.getInstance().run((Task)new PyUpdateSdkTask(this.myProject, this.mySdk, requestData));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 4: 
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdk";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "requestData";
                    break;
                }
                case 3: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exception";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/sdk/PythonSdkUpdater$PyUpdateSdkTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "refreshPackages";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "generateSkeletons";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notifyOfGenerationFailure";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PyUpdateSdkRequestData {
        final Instant myTimestamp;
        final Throwable myTraceback;

        private PyUpdateSdkRequestData() {
            this(Instant.now(), new Throwable());
        }

        private PyUpdateSdkRequestData(@NotNull Instant timestamp, @NotNull Throwable traceback) {
            if (timestamp == null) {
                PyUpdateSdkRequestData.$$$reportNull$$$0(0);
            }
            if (traceback == null) {
                PyUpdateSdkRequestData.$$$reportNull$$$0(1);
            }
            this.myTimestamp = timestamp;
            this.myTraceback = traceback;
        }

        @NotNull
        private static PyUpdateSdkRequestData merge(@NotNull PyUpdateSdkRequestData oldRequest, @NotNull PyUpdateSdkRequestData newRequest) {
            if (oldRequest == null) {
                PyUpdateSdkRequestData.$$$reportNull$$$0(2);
            }
            if (newRequest == null) {
                PyUpdateSdkRequestData.$$$reportNull$$$0(3);
            }
            return new PyUpdateSdkRequestData(oldRequest.myTimestamp, newRequest.myTraceback);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "timestamp";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "traceback";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldRequest";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newRequest";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/sdk/PythonSdkUpdater$PyUpdateSdkRequestData";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "merge";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

