/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.toml;

import java.util.List;
import org.apache.tuweni.toml.ErrorReporter;
import org.apache.tuweni.toml.KeyVisitor;
import org.apache.tuweni.toml.MutableTomlTable;
import org.apache.tuweni.toml.TomlParseError;
import org.apache.tuweni.toml.TomlPosition;
import org.apache.tuweni.toml.TomlVersion;
import org.apache.tuweni.toml.ValueVisitor;
import org.apache.tuweni.toml.internal.TomlParser;
import org.apache.tuweni.toml.internal.TomlParserBaseVisitor;

final class LineVisitor
extends TomlParserBaseVisitor<MutableTomlTable> {
    private final MutableTomlTable table;
    private final ErrorReporter errorReporter;
    private final TomlVersion version;
    private MutableTomlTable currentTable;

    LineVisitor(ErrorReporter errorReporter, TomlVersion version) {
        this.currentTable = this.table = new MutableTomlTable();
        this.errorReporter = errorReporter;
        this.version = version;
    }

    @Override
    public MutableTomlTable visitKeyval(TomlParser.KeyvalContext ctx) {
        TomlParser.KeyContext keyContext = ctx.key();
        TomlParser.ValContext valContext = ctx.val();
        if (keyContext == null || valContext == null) {
            return this.table;
        }
        try {
            List<String> path2 = keyContext.accept(new KeyVisitor());
            if (path2 == null || path2.isEmpty()) {
                return this.table;
            }
            if (!this.version.after(TomlVersion.V0_4_0) && path2.size() > 1) {
                throw new TomlParseError("Dotted keys are not supported", new TomlPosition(keyContext));
            }
            Object value = valContext.accept(new ValueVisitor());
            if (value != null) {
                this.currentTable.set(path2, value, new TomlPosition(ctx));
            }
            return this.table;
        }
        catch (TomlParseError e) {
            this.errorReporter.reportError(e);
            return this.table;
        }
    }

    @Override
    public MutableTomlTable visitStandardTable(TomlParser.StandardTableContext ctx) {
        TomlParser.KeyContext keyContext = ctx.key();
        if (keyContext == null) {
            this.errorReporter.reportError(new TomlParseError("Empty table key", new TomlPosition(ctx)));
            return this.table;
        }
        List<String> path2 = keyContext.accept(new KeyVisitor());
        if (path2 == null) {
            return this.table;
        }
        try {
            this.currentTable = this.table.createTable(path2, new TomlPosition(ctx));
        }
        catch (TomlParseError e) {
            this.errorReporter.reportError(e);
        }
        return this.table;
    }

    @Override
    public MutableTomlTable visitArrayTable(TomlParser.ArrayTableContext ctx) {
        TomlParser.KeyContext keyContext = ctx.key();
        if (keyContext == null) {
            this.errorReporter.reportError(new TomlParseError("Empty table key", new TomlPosition(ctx)));
            return this.table;
        }
        List<String> path2 = keyContext.accept(new KeyVisitor());
        if (path2 == null) {
            return this.table;
        }
        try {
            this.currentTable = this.table.createArrayTable(path2, new TomlPosition(ctx));
        }
        catch (TomlParseError e) {
            this.errorReporter.reportError(e);
        }
        return this.table;
    }

    @Override
    protected MutableTomlTable aggregateResult(MutableTomlTable aggregate, MutableTomlTable nextResult) {
        return aggregate == null ? null : nextResult;
    }

    @Override
    protected MutableTomlTable defaultResult() {
        return this.table;
    }
}

