/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.cloud.OverseerNodePrioritizer;
import org.apache.solr.cloud.api.collections.CollApiCmds;
import org.apache.solr.cloud.api.collections.CollectionCommandContext;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.Utils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverseerRoleCmd
implements CollApiCmds.CollectionApiCommand {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final CollectionCommandContext ccc;
    private final CollectionParams.CollectionAction operation;
    private final OverseerNodePrioritizer overseerPrioritizer;

    public OverseerRoleCmd(CollectionCommandContext ccc, CollectionParams.CollectionAction operation, OverseerNodePrioritizer prioritizer) {
        this.ccc = ccc;
        this.operation = operation;
        this.overseerPrioritizer = prioritizer;
    }

    @Override
    public void call(ClusterState state, ZkNodeProps message, NamedList<Object> results) throws Exception {
        if (this.ccc.isDistributedCollectionAPI()) {
            log.error("Cluster is running with distributed Collection API execution. Ignoring Collection API operation " + this.operation);
            return;
        }
        ZkStateReader zkStateReader = this.ccc.getZkStateReader();
        SolrZkClient zkClient = zkStateReader.getZkClient();
        Map<String, List<Object>> roles = null;
        String node = message.getStr("node");
        if ("false".equals(message.getStr("persist"))) {
            this.runPrioritizer();
            return;
        }
        String roleName = message.getStr("role");
        boolean nodeExists = false;
        nodeExists = zkClient.exists("/roles.json", true);
        if (nodeExists) {
            Map tmp = (Map)Utils.fromJSON((byte[])zkClient.getData("/roles.json", null, new Stat(), true));
            roles = tmp;
        } else {
            roles = new LinkedHashMap<String, List>(1);
        }
        List nodeList = roles.computeIfAbsent(roleName, k -> new ArrayList());
        if (CollectionParams.CollectionAction.ADDROLE == this.operation) {
            log.info("Overseer role added to {}", (Object)node);
            if (!nodeList.contains(node)) {
                nodeList.add(node);
            }
        } else if (CollectionParams.CollectionAction.REMOVEROLE == this.operation) {
            log.info("Overseer role removed from {}", (Object)node);
            nodeList.remove(node);
        }
        if (nodeExists) {
            zkClient.setData("/roles.json", Utils.toJSON(roles), true);
        } else {
            zkClient.create("/roles.json", Utils.toJSON(roles), CreateMode.PERSISTENT, true);
        }
        this.runPrioritizer();
    }

    private void runPrioritizer() {
        new Thread(() -> {
            try {
                this.overseerPrioritizer.prioritizeOverseerNodes(this.ccc.getOverseerId());
            }
            catch (Exception e) {
                log.error("Error in prioritizing Overseer", (Throwable)e);
            }
        }, "OverseerPrioritizationThread").start();
    }
}

