/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.AbstractSolrEventListener;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.response.ResultContext;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.SolrIndexSearcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuerySenderListener
extends AbstractSolrEventListener {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public QuerySenderListener(SolrCore core) {
        super(core);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void newSearcher(SolrIndexSearcher newSearcher, SolrIndexSearcher currentSearcher) {
        final SolrIndexSearcher searcher = newSearcher;
        log.debug("QuerySenderListener sending requests to {}", (Object)newSearcher);
        List<NamedList<Object>> allLists = QuerySenderListener.convertQueriesToList((ArrayList)this.getArgs().getAll("queries"));
        if (allLists == null) {
            return;
        }
        for (NamedList<Object> nlst : allLists) {
            try {
                NamedList<Object> params = this.addEventParms(currentSearcher, nlst);
                if (params.get("distrib") == null) {
                    params.add("distrib", (Object)false);
                }
                LocalSolrQueryRequest req = new LocalSolrQueryRequest(this.getCore(), params){

                    @Override
                    public SolrIndexSearcher getSearcher() {
                        return searcher;
                    }

                    @Override
                    public void close() {
                    }
                };
                SolrQueryResponse rsp = new SolrQueryResponse();
                SolrRequestInfo.setRequestInfo(new SolrRequestInfo(req, rsp));
                try {
                    this.getCore().execute(this.getCore().getRequestHandler(req.getParams().get("qt")), req, rsp);
                    NamedList<Object> values = rsp.getValues();
                    for (int i = 0; i < values.size(); ++i) {
                        Object o = values.getVal(i);
                        if (o instanceof ResultContext) {
                            o = ((ResultContext)o).getDocList();
                        }
                        if (!(o instanceof DocList)) continue;
                        DocList docs = (DocList)o;
                        DocIterator iter = docs.iterator();
                        while (iter.hasNext()) {
                            newSearcher.doc(iter.nextDoc());
                        }
                    }
                }
                finally {
                    try {
                        req.close();
                    }
                    finally {
                        SolrRequestInfo.clearRequestInfo();
                    }
                }
            }
            catch (Exception exception) {}
        }
        log.info("QuerySenderListener done.");
    }

    protected static List<NamedList<Object>> convertQueriesToList(ArrayList<Object> queries) {
        ArrayList<NamedList<Object>> allLists = new ArrayList<NamedList<Object>>();
        for (Object o : queries) {
            if (o instanceof ArrayList) {
                for (Object o2 : (ArrayList)o) {
                    if (o2 instanceof NamedList) {
                        NamedList o3 = (NamedList)o2;
                        allLists.add((NamedList<Object>)o3);
                        continue;
                    }
                    log.warn("ignoring unsupported warming config ({})", o2);
                }
                continue;
            }
            if (o instanceof NamedList) {
                NamedList o3 = (NamedList)o;
                allLists.add((NamedList<Object>)o3);
                continue;
            }
            log.warn("ignoring unsupported warming config - {}", o);
        }
        return allLists;
    }
}

