/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.join;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.common.util.Hash;
import org.apache.solr.search.SolrCache;
import org.apache.solr.search.SolrIndexSearcher;

public class HashRangeQuery
extends Query {
    protected final String field;
    protected final int lower;
    protected final int upper;
    public static final String CACHE_KEY_PREFIX = "hash_";

    public HashRangeQuery(String field, int lower, int upper) {
        this.field = field;
        this.lower = lower;
        this.upper = upper;
    }

    public Weight createWeight(final IndexSearcher searcher, final ScoreMode scoreMode, final float boost) throws IOException {
        return new ConstantScoreWeight(this, boost){

            public boolean isCacheable(LeafReaderContext context) {
                return DocValues.isCacheable((LeafReaderContext)context, (String[])new String[]{HashRangeQuery.this.field});
            }

            public Scorer scorer(LeafReaderContext context) throws IOException {
                final SortedDocValues docValues = context.reader().getSortedDocValues(HashRangeQuery.this.field);
                final int[] cache = this.getCache(context);
                TwoPhaseIterator iterator = new TwoPhaseIterator((DocIdSetIterator)docValues){

                    public boolean matches() throws IOException {
                        int hash = cache != null ? cache[docValues.docID()] : this.hash(docValues);
                        return hash >= HashRangeQuery.this.lower && hash <= HashRangeQuery.this.upper;
                    }

                    public float matchCost() {
                        return cache != null ? 2.0f : 100.0f;
                    }
                };
                return new ConstantScoreScorer((Weight)this, boost, scoreMode, iterator);
            }

            private int[] getCache(LeafReaderContext context) throws IOException {
                IndexReader.CacheHelper cacheHelper = context.reader().getReaderCacheHelper();
                if (cacheHelper == null) {
                    return null;
                }
                SolrCache cache = ((SolrIndexSearcher)searcher).getCache(HashRangeQuery.CACHE_KEY_PREFIX + HashRangeQuery.this.field);
                if (cache == null) {
                    return null;
                }
                IndexReader.CacheKey cacheKey = cacheHelper.getKey();
                return cache.computeIfAbsent(cacheKey, ck -> {
                    int doc;
                    int[] hashes = new int[context.reader().maxDoc()];
                    SortedDocValues docValues = context.reader().getSortedDocValues(HashRangeQuery.this.field);
                    while ((doc = docValues.nextDoc()) != Integer.MAX_VALUE) {
                        hashes[doc] = this.hash(docValues);
                    }
                    return hashes;
                });
            }

            private int hash(SortedDocValues docValues) throws IOException {
                BytesRef bytesRef = docValues.lookupOrd(docValues.ordValue());
                return Hash.murmurhash3_x86_32((byte[])bytesRef.bytes, (int)bytesRef.offset, (int)bytesRef.length, (int)0);
            }
        };
    }

    public void visit(QueryVisitor visitor) {
        visitor.visitLeaf((Query)this);
    }

    public String toString(String field) {
        return String.format(Locale.ROOT, "{!hash_range f=%s l=%d u=%d}", this.field, this.lower, this.upper);
    }

    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((HashRangeQuery)((Object)((Object)((Object)this)).getClass().cast(other)));
    }

    private boolean equalsTo(HashRangeQuery other) {
        return this.lower == other.lower && this.upper == other.upper && Objects.equals(this.field, other.field);
    }

    public int hashCode() {
        int prime = 31;
        int result = this.classHash();
        result = 31 * result + Objects.hashCode(this.field);
        result = 31 * result + Objects.hashCode(this.lower);
        result = 31 * result + Objects.hashCode(this.upper);
        return result;
    }
}

