/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import org.apache.solr.analytics.ExpressionFactory;
import org.apache.solr.analytics.value.AnalyticsValue;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.BooleanValue;
import org.apache.solr.common.SolrException;

public class ExistsFunction {
    public static final String name = "exists";
    public static final ExpressionFactory.CreatorFunction creatorFunction = params -> {
        if (params.length != 1) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The exists function requires 1 parameter.");
        }
        AnalyticsValueStream param = params[0];
        if (param instanceof AnalyticsValue) {
            return new ValueExistsFunction((AnalyticsValue)param);
        }
        return new ValueStreamExistsFunction(param);
    };

    static class ValueExistsFunction
    extends BooleanValue.AbstractBooleanValue {
        private final AnalyticsValue param;
        public static final String name = "exists";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;

        public ValueExistsFunction(AnalyticsValue param) throws SolrException {
            this.param = param;
            this.exprStr = AnalyticsValueStream.createExpressionString("exists", param);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, param);
        }

        @Override
        public boolean getBoolean() {
            this.param.getObject();
            return this.param.exists();
        }

        @Override
        public boolean exists() {
            return true;
        }

        @Override
        public String getName() {
            return "exists";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class ValueStreamExistsFunction
    extends BooleanValue.AbstractBooleanValue {
        private final AnalyticsValueStream param;
        public static final String name = "exists";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        private boolean exists;

        public ValueStreamExistsFunction(AnalyticsValueStream param) throws SolrException {
            this.param = param;
            this.exprStr = AnalyticsValueStream.createExpressionString("exists", param);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, param);
        }

        @Override
        public boolean getBoolean() {
            this.exists = false;
            this.param.streamObjects(val -> {
                this.exists = true;
            });
            return this.exists;
        }

        @Override
        public boolean exists() {
            return true;
        }

        @Override
        public String getName() {
            return "exists";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }
}

