/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.https;

import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.https.HttpsRequestMessage;
import de.rub.nds.tlsattacker.core.https.header.HttpsHeader;
import de.rub.nds.tlsattacker.core.https.header.serializer.HttpsHeaderSerializer;
import de.rub.nds.tlsattacker.core.protocol.serializer.ProtocolMessageSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpsRequestSerializer
extends ProtocolMessageSerializer<HttpsRequestMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final HttpsRequestMessage message;

    public HttpsRequestSerializer(HttpsRequestMessage message, ProtocolVersion version) {
        super(message, version);
        this.message = message;
    }

    @Override
    public byte[] serializeProtocolMessageContent() {
        StringBuilder builder = new StringBuilder();
        builder.append((String)this.message.getRequestType().getValue()).append(" ").append((String)this.message.getRequestPath().getValue()).append(" ").append((String)this.message.getRequestProtocol().getValue()).append("\r\n");
        for (HttpsHeader header : this.message.getHeader()) {
            HttpsHeaderSerializer serializer = new HttpsHeaderSerializer(header);
            builder.append(new String(serializer.serialize()));
        }
        builder.append("\r\n");
        LOGGER.info(builder.toString());
        this.appendBytes(builder.toString().getBytes());
        return this.getAlreadySerialized();
    }
}

