/*
 * Decompiled with CFR 0.152.
 */
package org.traccar;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.LifecycleObject;
import org.traccar.MainModule;
import org.traccar.ServerManager;
import org.traccar.WindowsService;
import org.traccar.broadcast.BroadcastService;
import org.traccar.helper.model.DeviceUtil;
import org.traccar.schedule.ScheduleManager;
import org.traccar.storage.DatabaseModule;
import org.traccar.storage.Storage;
import org.traccar.web.WebModule;
import org.traccar.web.WebServer;

public final class Main {
    private static final Logger LOGGER = LoggerFactory.getLogger(Main.class);
    private static Injector injector;

    public static Injector getInjector() {
        return injector;
    }

    private Main() {
    }

    public static void logSystemInfo() {
        try {
            OperatingSystemMXBean operatingSystemBean = ManagementFactory.getOperatingSystemMXBean();
            LOGGER.info("Operating system name: " + operatingSystemBean.getName() + " version: " + operatingSystemBean.getVersion() + " architecture: " + operatingSystemBean.getArch());
            RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
            LOGGER.info("Java runtime name: " + runtimeBean.getVmName() + " vendor: " + runtimeBean.getVmVendor() + " version: " + runtimeBean.getVmVersion());
            MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();
            LOGGER.info("Memory limit heap: " + memoryBean.getHeapMemoryUsage().getMax() / 0x100000L + "mb non-heap: " + memoryBean.getNonHeapMemoryUsage().getMax() / 0x100000L + "mb");
            LOGGER.info("Character encoding: " + System.getProperty("file.encoding") + " charset: " + Charset.defaultCharset());
        }
        catch (Exception error) {
            LOGGER.warn("Failed to get system info");
        }
    }

    public static void main(String[] args) throws Exception {
        String configFile;
        Locale.setDefault(Locale.ENGLISH);
        if (args.length <= 0) {
            configFile = "./debug.xml";
            if (!new File(configFile).exists()) {
                throw new RuntimeException("Configuration file is not provided");
            }
        } else {
            configFile = args[args.length - 1];
        }
        if (args.length > 0 && args[0].startsWith("--")) {
            WindowsService windowsService = new WindowsService("traccar"){

                @Override
                public void run() {
                    Main.run(configFile);
                }
            };
            switch (args[0]) {
                case "--install": {
                    windowsService.install("traccar", null, null, null, null, configFile);
                    return;
                }
                case "--uninstall": {
                    windowsService.uninstall();
                    return;
                }
            }
            windowsService.init();
        } else {
            Main.run(configFile);
        }
    }

    public static void run(String configFile) {
        try {
            injector = Guice.createInjector((Module[])new Module[]{new MainModule(configFile), new DatabaseModule(), new WebModule()});
            Main.logSystemInfo();
            LOGGER.info("Version: " + Main.class.getPackage().getImplementationVersion());
            LOGGER.info("Starting server...");
            if (((BroadcastService)injector.getInstance(BroadcastService.class)).singleInstance()) {
                DeviceUtil.resetStatus((Storage)injector.getInstance(Storage.class));
            }
            List services = Stream.of(ServerManager.class, WebServer.class, ScheduleManager.class, BroadcastService.class).map(arg_0 -> ((Injector)injector).getInstance(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
            for (LifecycleObject service : services) {
                service.start();
            }
            Thread.setDefaultUncaughtExceptionHandler((t, e) -> LOGGER.error("Thread exception", e));
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                LOGGER.info("Stopping server...");
                for (LifecycleObject service : services) {
                    try {
                        service.stop();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }));
        }
        catch (Exception e2) {
            LOGGER.error("Main method error", (Throwable)e2);
            throw new RuntimeException(e2);
        }
    }
}

