/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental;

import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.tasks.compile.CleaningJavaCompiler;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.incremental.IncrementalResultStoringCompiler;
import org.gradle.api.internal.tasks.compile.incremental.SelectiveCompiler;
import org.gradle.api.internal.tasks.compile.incremental.cache.TaskScopedCompileCaches;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathSnapshotMaker;
import org.gradle.api.internal.tasks.compile.incremental.recomp.PreviousCompilation;
import org.gradle.api.internal.tasks.compile.incremental.recomp.PreviousCompilationData;
import org.gradle.api.internal.tasks.compile.incremental.recomp.PreviousCompilationOutputAnalyzer;
import org.gradle.api.internal.tasks.compile.incremental.recomp.RecompilationSpecProvider;
import org.gradle.language.base.internal.compile.Compiler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrementalCompilerDecorator<T extends JavaCompileSpec> {
    private static final Logger LOG = LoggerFactory.getLogger(IncrementalCompilerDecorator.class);
    private final ClasspathSnapshotMaker classpathSnapshotMaker;
    private final TaskScopedCompileCaches compileCaches;
    private final CleaningJavaCompiler<T> cleaningCompiler;
    private final Compiler<T> rebuildAllCompiler;
    private final PreviousCompilationOutputAnalyzer previousCompilationOutputAnalyzer;
    private StringInterner interner;

    public IncrementalCompilerDecorator(ClasspathSnapshotMaker classpathSnapshotMaker, TaskScopedCompileCaches compileCaches, CleaningJavaCompiler<T> cleaningCompiler, Compiler<T> rebuildAllCompiler, PreviousCompilationOutputAnalyzer previousCompilationOutputAnalyzer, StringInterner interner) {
        this.classpathSnapshotMaker = classpathSnapshotMaker;
        this.compileCaches = compileCaches;
        this.cleaningCompiler = cleaningCompiler;
        this.rebuildAllCompiler = rebuildAllCompiler;
        this.previousCompilationOutputAnalyzer = previousCompilationOutputAnalyzer;
        this.interner = interner;
    }

    public Compiler<T> prepareCompiler(RecompilationSpecProvider recompilationSpecProvider) {
        Compiler<T> compiler = this.getCompiler(recompilationSpecProvider);
        return new IncrementalResultStoringCompiler<T>(compiler, this.classpathSnapshotMaker, this.compileCaches.getPreviousCompilationStore(), this.interner);
    }

    private Compiler<T> getCompiler(RecompilationSpecProvider recompilationSpecProvider) {
        if (!recompilationSpecProvider.isIncremental()) {
            LOG.info("Full recompilation is required because no incremental change information is available. This is usually caused by clean builds or changing compiler arguments.");
            return this.rebuildAllCompiler;
        }
        PreviousCompilationData data = this.compileCaches.getPreviousCompilationStore().get();
        if (data == null) {
            LOG.info("Full recompilation is required because no previous compilation result is available.");
            return this.rebuildAllCompiler;
        }
        PreviousCompilation previousCompilation = new PreviousCompilation(data, this.compileCaches.getClasspathEntrySnapshotCache(), this.previousCompilationOutputAnalyzer);
        return new SelectiveCompiler<T>(previousCompilation, this.cleaningCompiler, this.rebuildAllCompiler, recompilationSpecProvider, this.classpathSnapshotMaker);
    }
}

