/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import java.io.File;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.plugins.ReportingBasePlugin;
import org.gradle.api.plugins.internal.DefaultProjectReportsPluginConvention;
import org.gradle.api.reporting.dependencies.HtmlDependencyReportTask;
import org.gradle.api.tasks.diagnostics.DependencyReportTask;
import org.gradle.api.tasks.diagnostics.PropertyReportTask;
import org.gradle.api.tasks.diagnostics.TaskReportTask;

public class ProjectReportsPlugin
implements Plugin<Project> {
    public static final String TASK_REPORT = "taskReport";
    public static final String PROPERTY_REPORT = "propertyReport";
    public static final String DEPENDENCY_REPORT = "dependencyReport";
    public static final String HTML_DEPENDENCY_REPORT = "htmlDependencyReport";
    public static final String PROJECT_REPORT = "projectReport";

    public void apply(Project project) {
        project.getPluginManager().apply(ReportingBasePlugin.class);
        DefaultProjectReportsPluginConvention convention = new DefaultProjectReportsPluginConvention(project);
        project.getConvention().getPlugins().put("projectReports", convention);
        project.getTasks().register(TASK_REPORT, TaskReportTask.class, taskReportTask -> {
            taskReportTask.setDescription("Generates a report about your tasks.");
            taskReportTask.conventionMapping("outputFile", () -> new File(convention.getProjectReportDir(), "tasks.txt"));
            taskReportTask.conventionMapping("projects", convention::getProjects);
        });
        project.getTasks().register(PROPERTY_REPORT, PropertyReportTask.class, propertyReportTask -> {
            propertyReportTask.setDescription("Generates a report about your properties.");
            propertyReportTask.conventionMapping("outputFile", () -> new File(convention.getProjectReportDir(), "properties.txt"));
            propertyReportTask.conventionMapping("projects", convention::getProjects);
        });
        project.getTasks().register(DEPENDENCY_REPORT, DependencyReportTask.class, dependencyReportTask -> {
            dependencyReportTask.setDescription("Generates a report about your library dependencies.");
            dependencyReportTask.conventionMapping("outputFile", () -> new File(convention.getProjectReportDir(), "dependencies.txt"));
            dependencyReportTask.conventionMapping("projects", convention::getProjects);
        });
        project.getTasks().create(HTML_DEPENDENCY_REPORT, HtmlDependencyReportTask.class, htmlDependencyReportTask -> {
            htmlDependencyReportTask.setDescription("Generates an HTML report about your library dependencies.");
            htmlDependencyReportTask.getReports().getHtml().getOutputLocation().convention(project.getLayout().getProjectDirectory().dir(project.provider(() -> new File(convention.getProjectReportDir(), "dependencies").getAbsolutePath())));
            htmlDependencyReportTask.conventionMapping("projects", convention::getProjects);
        });
        project.getTasks().register(PROJECT_REPORT, projectReportTask -> {
            projectReportTask.dependsOn(new Object[]{TASK_REPORT, PROPERTY_REPORT, DEPENDENCY_REPORT, HTML_DEPENDENCY_REPORT});
            projectReportTask.setDescription("Generates a report about your project.");
            projectReportTask.setGroup("reporting");
        });
    }
}

