/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.typeinference;

import jadx.core.dex.instructions.InvokeNode;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.nodes.RootNode;
import jadx.core.dex.visitors.typeinference.BoundEnum;
import jadx.core.dex.visitors.typeinference.ITypeBoundDynamic;
import jadx.core.dex.visitors.typeinference.TypeUpdateInfo;
import jadx.core.utils.TypeUtils;

public final class TypeBoundInvokeAssign
implements ITypeBoundDynamic {
    private final RootNode root;
    private final InvokeNode invokeNode;
    private final ArgType genericReturnType;

    public TypeBoundInvokeAssign(RootNode root, InvokeNode invokeNode, ArgType genericReturnType) {
        this.root = root;
        this.invokeNode = invokeNode;
        this.genericReturnType = genericReturnType;
    }

    @Override
    public BoundEnum getBound() {
        return BoundEnum.ASSIGN;
    }

    @Override
    public ArgType getType(TypeUpdateInfo updateInfo) {
        return this.getReturnType(updateInfo.getType(this.invokeNode.getArg(0)));
    }

    @Override
    public ArgType getType() {
        return this.getReturnType(this.invokeNode.getArg(0).getType());
    }

    private ArgType getReturnType(ArgType instanceType) {
        ArgType resultGeneric = TypeUtils.replaceClassGenerics(this.root, instanceType, this.genericReturnType);
        if (resultGeneric != null) {
            return resultGeneric;
        }
        return this.invokeNode.getCallMth().getReturnType();
    }

    @Override
    public RegisterArg getArg() {
        return this.invokeNode.getResult();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeBoundInvokeAssign that = (TypeBoundInvokeAssign)o;
        return this.invokeNode.equals(that.invokeNode);
    }

    public int hashCode() {
        return this.invokeNode.hashCode();
    }

    public String toString() {
        return "InvokeAssign{" + this.invokeNode.getCallMth().getShortId() + ", returnType=" + this.genericReturnType + ", currentType=" + this.getType() + ", instanceArg=" + this.invokeNode.getArg(0) + '}';
    }
}

