/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.management.ManagementFactory;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletHolder;
import org.glassfish.jersey.servlet.ServletContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.health.Result;
import org.jitsi.jicofo.ConferenceStore;
import org.jitsi.jicofo.FocusManager;
import org.jitsi.jicofo.auth.AbstractAuthAuthority;
import org.jitsi.jicofo.auth.AuthConfig;
import org.jitsi.jicofo.auth.ExternalJWTAuthority;
import org.jitsi.jicofo.auth.ShibbolethAuthAuthority;
import org.jitsi.jicofo.auth.XMPPDomainAuthAuthority;
import org.jitsi.jicofo.bridge.BridgeConfig;
import org.jitsi.jicofo.bridge.BridgeMucDetector;
import org.jitsi.jicofo.bridge.BridgeSelector;
import org.jitsi.jicofo.bridge.JvbDoctor;
import org.jitsi.jicofo.conference.JitsiMeetConferenceImpl;
import org.jitsi.jicofo.health.HealthConfig;
import org.jitsi.jicofo.health.JicofoHealthChecker;
import org.jitsi.jicofo.jibri.JibriConfig;
import org.jitsi.jicofo.jibri.JibriDetector;
import org.jitsi.jicofo.jigasi.JigasiDetector;
import org.jitsi.jicofo.rest.Application;
import org.jitsi.jicofo.rest.ConferenceRequest;
import org.jitsi.jicofo.rest.RestConfig;
import org.jitsi.jicofo.util.SynchronizedDelegate;
import org.jitsi.jicofo.version.CurrentVersionImpl;
import org.jitsi.jicofo.xmpp.BaseBrewery;
import org.jitsi.jicofo.xmpp.SmackKt;
import org.jitsi.jicofo.xmpp.XmppProvider;
import org.jitsi.jicofo.xmpp.XmppServices;
import org.jitsi.jicofo.xmpp.jingle.JingleStats;
import org.jitsi.rest.JettyHelpers;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.json.simple.JSONObject;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.impl.JidCreate;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 /2\u00020\u0001:\u0001/B\u0005\u00a2\u0006\u0002\u0010\u0002J\n\u0010#\u001a\u0004\u0018\u00010\u0004H\u0002J\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'J\u000e\u0010(\u001a\u00020%2\u0006\u0010)\u001a\u00020*J\u0006\u0010+\u001a\u00020,J\u0006\u0010-\u001a\u00020.R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u001d\u001a\u0004\u0018\u00010\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0018R\u0011\u0010\u001f\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u00060"}, d2={"Lorg/jitsi/jicofo/JicofoServices;", "", "()V", "authenticationAuthority", "Lorg/jitsi/jicofo/auth/AbstractAuthAuthority;", "getAuthenticationAuthority", "()Lorg/jitsi/jicofo/auth/AbstractAuthAuthority;", "bridgeDetector", "Lorg/jitsi/jicofo/bridge/BridgeMucDetector;", "bridgeSelector", "Lorg/jitsi/jicofo/bridge/BridgeSelector;", "getBridgeSelector", "()Lorg/jitsi/jicofo/bridge/BridgeSelector;", "focusManager", "Lorg/jitsi/jicofo/FocusManager;", "getFocusManager", "()Lorg/jitsi/jicofo/FocusManager;", "healthChecker", "Lorg/jitsi/jicofo/health/JicofoHealthChecker;", "jettyServer", "Lorg/eclipse/jetty/server/Server;", "jibriDetector", "Lorg/jitsi/jicofo/jibri/JibriDetector;", "getJibriDetector", "()Lorg/jitsi/jicofo/jibri/JibriDetector;", "jvbDoctor", "Lorg/jitsi/jicofo/bridge/JvbDoctor;", "logger", "Lorg/jitsi/utils/logging2/Logger;", "sipJibriDetector", "getSipJibriDetector", "xmppServices", "Lorg/jitsi/jicofo/xmpp/XmppServices;", "getXmppServices", "()Lorg/jitsi/jicofo/xmpp/XmppServices;", "createAuthenticationAuthority", "getConferenceDebugState", "Lorg/jitsi/utils/OrderedJsonObject;", "conferenceId", "", "getDebugState", "full", "", "getStats", "Lorg/json/simple/JSONObject;", "shutdown", "", "Companion", "jicofo"})
@SuppressFBWarnings(value={"MS_CANNOT_BE_FINAL"})
public final class JicofoServices {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger = LoggerExtensionsKt.createLogger$default(this, null, null, 3, null);
    @NotNull
    private final FocusManager focusManager;
    @Nullable
    private final AbstractAuthAuthority authenticationAuthority;
    @NotNull
    private final XmppServices xmppServices;
    @NotNull
    private final BridgeSelector bridgeSelector;
    @Nullable
    private final JvbDoctor jvbDoctor;
    @Nullable
    private final BridgeMucDetector bridgeDetector;
    @Nullable
    private final JibriDetector jibriDetector;
    @Nullable
    private final JibriDetector sipJibriDetector;
    @Nullable
    private final JicofoHealthChecker healthChecker;
    @Nullable
    private final Server jettyServer;
    @NotNull
    private static final Object jicofoServicesSingletonSyncRoot = new Object();
    @NotNull
    private static final SynchronizedDelegate<JicofoServices> jicofoServicesSingleton$delegate = new SynchronizedDelegate<Object>(null, jicofoServicesSingletonSyncRoot);

    /*
     * WARNING - void declaration
     */
    public JicofoServices() {
        Object object;
        Object object2;
        JicofoServices jicofoServices;
        BaseBrewery baseBrewery;
        EntityBareJid $this$jibriDetector_u24lambda_u2d9;
        JicofoServices jicofoServices2;
        BaseBrewery baseBrewery2;
        EntityBareJid $this$bridgeDetector_u24lambda_u2d6;
        JicofoServices jicofoServices3;
        BridgeMucDetector bridgeMucDetector;
        BaseBrewery baseBrewery3;
        JicofoServices breweryJid2;
        Object object3;
        Object $this$jvbDoctor_u24lambda_u2d3;
        Object it;
        Object object4;
        Object $this$focusManager_u24lambda_u2d0;
        Object object5;
        SmackKt.initializeSmack();
        Object object6 = object5 = new FocusManager(this, null, 2, null);
        JicofoServices jicofoServices4 = this;
        boolean bl2 = false;
        ((FocusManager)$this$focusManager_u24lambda_u2d0).start();
        jicofoServices4.focusManager = object5;
        JicofoServices jicofoServices5 = this;
        AbstractAuthAuthority abstractAuthAuthority = this.createAuthenticationAuthority();
        if (abstractAuthAuthority != null) {
            void $this$authenticationAuthority_u24lambda_u2d1;
            $this$focusManager_u24lambda_u2d0 = abstractAuthAuthority;
            AbstractAuthAuthority bl2 = $this$focusManager_u24lambda_u2d0;
            jicofoServices4 = jicofoServices5;
            boolean bl3 = false;
            $this$authenticationAuthority_u24lambda_u2d1.start();
            this.focusManager.addListener((ConferenceStore.Listener)$this$authenticationAuthority_u24lambda_u2d1);
            jicofoServices5 = jicofoServices4;
            object4 = $this$focusManager_u24lambda_u2d0;
        } else {
            object4 = null;
        }
        jicofoServices5.authenticationAuthority = object4;
        object5 = this.focusManager;
        $this$focusManager_u24lambda_u2d0 = this.focusManager;
        AbstractAuthAuthority $this$authenticationAuthority_u24lambda_u2d1 = this.authenticationAuthority;
        $this$focusManager_u24lambda_u2d0 = object5 = new XmppServices((ConferenceStore)object5, $this$authenticationAuthority_u24lambda_u2d1, (FocusManager)$this$focusManager_u24lambda_u2d0);
        jicofoServices4 = this;
        boolean bl4 = false;
        ((XmppServices)it).getClientConnection().addListener(this.focusManager);
        jicofoServices4.xmppServices = object5;
        this.bridgeSelector = new BridgeSelector(null, 1, null);
        JicofoServices jicofoServices6 = this;
        if (BridgeConfig.config.getHealthChecksEnabled()) {
            it = object5 = new JvbDoctor(this.bridgeSelector, this.xmppServices.getServiceConnection());
            jicofoServices4 = jicofoServices6;
            boolean bl5 = false;
            this.bridgeSelector.addHandler((BridgeSelector.EventHandler)$this$jvbDoctor_u24lambda_u2d3);
            jicofoServices6 = jicofoServices4;
            object3 = object5;
        } else {
            this.logger.warn("JVB health-checks disabled");
            object3 = null;
        }
        jicofoServices6.jvbDoctor = object3;
        JicofoServices jicofoServices7 = this;
        EntityBareJid entityBareJid = BridgeConfig.config.getBreweryJid();
        if (entityBareJid != null) {
            EntityBareJid bl3 = entityBareJid;
            jicofoServices4 = jicofoServices7;
            boolean bl6 = false;
            baseBrewery3 = new BridgeMucDetector(this.xmppServices.getXmppConnectionByName(BridgeConfig.config.getXmppConnectionName()), this.bridgeSelector, (EntityBareJid)((Object)breweryJid2));
            BridgeMucDetector $this$bridgeDetector_u24lambda_u2d5_u24lambda_u2d4 = baseBrewery3;
            boolean bl7 = false;
            $this$bridgeDetector_u24lambda_u2d5_u24lambda_u2d4.init();
            bridgeMucDetector = baseBrewery3;
            jicofoServices3 = jicofoServices4;
        } else {
            breweryJid2 = this;
            jicofoServices4 = jicofoServices7;
            boolean bl8 = false;
            ((JicofoServices)((Object)$this$bridgeDetector_u24lambda_u2d6)).logger.error("No bridge detector configured.");
            jicofoServices3 = jicofoServices4;
            bridgeMucDetector = null;
        }
        jicofoServices3.bridgeDetector = bridgeMucDetector;
        JicofoServices jicofoServices8 = this;
        EntityBareJid entityBareJid2 = JibriConfig.config.getBreweryJid();
        if (entityBareJid2 != null) {
            $this$bridgeDetector_u24lambda_u2d6 = entityBareJid2;
            jicofoServices4 = jicofoServices8;
            boolean bl9 = false;
            BaseBrewery $this$jibriDetector_u24lambda_u2d8_u24lambda_u2d7 = baseBrewery3 = new JibriDetector(this.xmppServices.getXmppConnectionByName(JibriConfig.config.getXmppConnectionName()), (EntityBareJid)((Object)breweryJid2), false, null, 8, null);
            boolean bl10 = false;
            $this$jibriDetector_u24lambda_u2d8_u24lambda_u2d7.init();
            baseBrewery2 = baseBrewery3;
            jicofoServices2 = jicofoServices4;
        } else {
            breweryJid2 = this;
            jicofoServices4 = jicofoServices8;
            boolean bl11 = false;
            ((JicofoServices)((Object)$this$jibriDetector_u24lambda_u2d9)).logger.info("No Jibri detector configured.");
            jicofoServices2 = jicofoServices4;
            baseBrewery2 = null;
        }
        jicofoServices2.jibriDetector = baseBrewery2;
        JicofoServices jicofoServices9 = this;
        EntityBareJid entityBareJid3 = JibriConfig.config.getSipBreweryJid();
        if (entityBareJid3 != null) {
            $this$jibriDetector_u24lambda_u2d9 = entityBareJid3;
            jicofoServices4 = jicofoServices9;
            boolean bl12 = false;
            BaseBrewery $this$sipJibriDetector_u24lambda_u2d11_u24lambda_u2d10 = baseBrewery3 = new JibriDetector(this.xmppServices.getClientConnection(), (EntityBareJid)((Object)breweryJid2), true, null, 8, null);
            boolean bl13 = false;
            $this$sipJibriDetector_u24lambda_u2d11_u24lambda_u2d10.init();
            baseBrewery = baseBrewery3;
            jicofoServices = jicofoServices4;
        } else {
            void $this$sipJibriDetector_u24lambda_u2d12;
            breweryJid2 = this;
            jicofoServices4 = jicofoServices9;
            boolean bl14 = false;
            $this$sipJibriDetector_u24lambda_u2d12.logger.info("No SIP Jibri detector configured.");
            jicofoServices = jicofoServices4;
            baseBrewery = null;
        }
        jicofoServices.sipJibriDetector = baseBrewery;
        JicofoServices jicofoServices10 = this;
        if (HealthConfig.config.getEnabled()) {
            void $this$healthChecker_u24lambda_u2d13;
            $this$jvbDoctor_u24lambda_u2d3 = object5 = new JicofoHealthChecker(HealthConfig.config, this.focusManager, this.bridgeSelector, (Collection<XmppProvider>)SetsKt.setOf(this.xmppServices.getClientConnection()));
            jicofoServices4 = jicofoServices10;
            boolean bl15 = false;
            $this$healthChecker_u24lambda_u2d13.start();
            jicofoServices10 = jicofoServices4;
            object2 = object5;
        } else {
            object2 = null;
        }
        jicofoServices10.healthChecker = object2;
        JicofoServices jicofoServices11 = this;
        if (RestConfig.config.getEnabled()) {
            void it2;
            this.logger.info("Starting HTTP server with config: " + RestConfig.config.getHttpServerConfig() + ".");
            object6 = this.authenticationAuthority;
            Application restApp = new Application(object6 instanceof ShibbolethAuthAuthority ? (ShibbolethAuthAuthority)object6 : null, CurrentVersionImpl.VERSION, this.healthChecker, RestConfig.config.getEnableConferenceRequest() ? new ConferenceRequest(this.xmppServices.getConferenceIqHandler()) : null);
            Object bl15 = object6 = JettyHelpers.createServer(RestConfig.config.getHttpServerConfig());
            jicofoServices4 = jicofoServices11;
            boolean bl16 = false;
            JettyHelpers.getServletContextHandler((Server)it2).addServlet(new ServletHolder(new ServletContainer(restApp)), "/*");
            it2.start();
            jicofoServices11 = jicofoServices4;
            object = object6;
        } else {
            object = null;
        }
        jicofoServices11.jettyServer = object;
    }

    @NotNull
    public final FocusManager getFocusManager() {
        return this.focusManager;
    }

    @Nullable
    public final AbstractAuthAuthority getAuthenticationAuthority() {
        return this.authenticationAuthority;
    }

    @NotNull
    public final XmppServices getXmppServices() {
        return this.xmppServices;
    }

    @NotNull
    public final BridgeSelector getBridgeSelector() {
        return this.bridgeSelector;
    }

    @Nullable
    public final JibriDetector getJibriDetector() {
        return this.jibriDetector;
    }

    @Nullable
    public final JibriDetector getSipJibriDetector() {
        return this.sipJibriDetector;
    }

    public final void shutdown() {
        Object it;
        AbstractAuthAuthority abstractAuthAuthority = this.authenticationAuthority;
        if (abstractAuthAuthority != null) {
            it = abstractAuthAuthority;
            boolean bl = false;
            this.focusManager.removeListener((ConferenceStore.Listener)it);
            ((AbstractAuthAuthority)it).shutdown();
        }
        JicofoHealthChecker jicofoHealthChecker = this.healthChecker;
        if (jicofoHealthChecker != null) {
            jicofoHealthChecker.shutdown();
        }
        Server server = this.jettyServer;
        if (server != null) {
            server.stop();
        }
        JvbDoctor jvbDoctor = this.jvbDoctor;
        if (jvbDoctor != null) {
            it = jvbDoctor;
            boolean bl = false;
            this.bridgeSelector.removeHandler((BridgeSelector.EventHandler)it);
            ((JvbDoctor)it).shutdown();
        }
        BridgeMucDetector bridgeMucDetector = this.bridgeDetector;
        if (bridgeMucDetector != null) {
            bridgeMucDetector.shutdown();
        }
        JibriDetector jibriDetector = this.jibriDetector;
        if (jibriDetector != null) {
            jibriDetector.shutdown();
        }
        JibriDetector jibriDetector2 = this.sipJibriDetector;
        if (jibriDetector2 != null) {
            jibriDetector2.shutdown();
        }
        this.xmppServices.getClientConnection().removeListener(this.focusManager);
        this.focusManager.stop();
        this.xmppServices.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    private final AbstractAuthAuthority createAuthenticationAuthority() {
        AbstractAuthAuthority abstractAuthAuthority;
        if (AuthConfig.config.getEnabled()) {
            void var1_1;
            AbstractAuthAuthority abstractAuthAuthority2;
            this.logger.info("Starting authentication service with config=" + AuthConfig.config + ".");
            switch (WhenMappings.$EnumSwitchMapping$0[AuthConfig.config.getType().ordinal()]) {
                case 1: {
                    abstractAuthAuthority2 = new XMPPDomainAuthAuthority(AuthConfig.config.getEnableAutoLogin(), AuthConfig.config.getAuthenticationLifetime(), JidCreate.domainBareFrom(AuthConfig.config.getLoginUrl()));
                    break;
                }
                case 2: {
                    abstractAuthAuthority2 = new ExternalJWTAuthority(JidCreate.domainBareFrom(AuthConfig.config.getLoginUrl()));
                    break;
                }
                case 3: {
                    abstractAuthAuthority2 = new ShibbolethAuthAuthority(AuthConfig.config.getEnableAutoLogin(), AuthConfig.config.getAuthenticationLifetime(), AuthConfig.config.getLoginUrl(), AuthConfig.config.getLogoutUrl());
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            AbstractAuthAuthority authAuthority = abstractAuthAuthority2;
            abstractAuthAuthority = var1_1;
        } else {
            this.logger.info("Authentication service disabled.");
            abstractAuthAuthority = null;
        }
        return abstractAuthAuthority;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final JSONObject getStats() {
        JSONObject jSONObject;
        block3: {
            void $this$getStats_u24lambda_u2d22_u24lambda_u2d21_u24lambda_u2d20;
            JSONObject jSONObject2;
            Object it;
            JSONObject $this$getStats_u24lambda_u2d22 = jSONObject = new JSONObject();
            boolean bl = false;
            $this$getStats_u24lambda_u2d22.putAll(this.focusManager.getStats());
            $this$getStats_u24lambda_u2d22.put("bridge_selector", this.bridgeSelector.getStats());
            JibriDetector jibriDetector = this.jibriDetector;
            if (jibriDetector != null) {
                it = jibriDetector;
                boolean bl2 = false;
                $this$getStats_u24lambda_u2d22.put("jibri_detector", ((JibriDetector)it).getStats());
            }
            JibriDetector jibriDetector2 = this.sipJibriDetector;
            if (jibriDetector2 != null) {
                it = jibriDetector2;
                boolean bl3 = false;
                $this$getStats_u24lambda_u2d22.put("sip_jibri_detector", ((JibriDetector)it).getStats());
            }
            JigasiDetector jigasiDetector = this.xmppServices.getJigasiDetector();
            if (jigasiDetector != null) {
                it = jigasiDetector;
                boolean bl4 = false;
                $this$getStats_u24lambda_u2d22.put("jigasi_detector", ((JigasiDetector)it).getStats());
            }
            $this$getStats_u24lambda_u2d22.put("jigasi", this.xmppServices.getJigasiStats());
            $this$getStats_u24lambda_u2d22.put("threads", ManagementFactory.getThreadMXBean().getThreadCount());
            $this$getStats_u24lambda_u2d22.put("jingle", JingleStats.Companion.toJson());
            JicofoHealthChecker jicofoHealthChecker = this.healthChecker;
            if (jicofoHealthChecker == null) break block3;
            it = jicofoHealthChecker;
            boolean bl5 = false;
            Result result2 = ((JicofoHealthChecker)it).getResult();
            $this$getStats_u24lambda_u2d22.put("slow_health_check", ((JicofoHealthChecker)it).getTotalSlowHealthChecks());
            $this$getStats_u24lambda_u2d22.put("healthy", result2.getSuccess());
            JSONObject jSONObject3 = jSONObject2 = new JSONObject();
            String string = "health";
            JSONObject jSONObject4 = $this$getStats_u24lambda_u2d22;
            boolean bl6 = false;
            $this$getStats_u24lambda_u2d22_u24lambda_u2d21_u24lambda_u2d20.put("success", result2.getSuccess());
            $this$getStats_u24lambda_u2d22_u24lambda_u2d21_u24lambda_u2d20.put("hardFailure", result2.getHardFailure());
            $this$getStats_u24lambda_u2d22_u24lambda_u2d21_u24lambda_u2d20.put("responseCode", result2.getResponseCode());
            $this$getStats_u24lambda_u2d22_u24lambda_u2d21_u24lambda_u2d20.put("sticky", result2.getSticky());
            $this$getStats_u24lambda_u2d22_u24lambda_u2d21_u24lambda_u2d20.put("message", result2.getMessage());
            Unit unit = Unit.INSTANCE;
            jSONObject4.put(string, jSONObject2);
        }
        return jSONObject;
    }

    @NotNull
    public final OrderedJsonObject getDebugState(boolean full) {
        OrderedJsonObject orderedJsonObject;
        OrderedJsonObject $this$getDebugState_u24lambda_u2d23 = orderedJsonObject = new OrderedJsonObject();
        boolean bl = false;
        $this$getDebugState_u24lambda_u2d23.put("focus_manager", this.focusManager.getDebugState(full));
        $this$getDebugState_u24lambda_u2d23.put("bridge_selector", this.bridgeSelector.getDebugState());
        Object object = this.jibriDetector;
        if (object == null || (object = ((JibriDetector)object).getDebugState()) == null) {
            object = "null";
        }
        $this$getDebugState_u24lambda_u2d23.put("jibri_detector", object);
        Object object2 = this.sipJibriDetector;
        if (object2 == null || (object2 = ((JibriDetector)object2).getDebugState()) == null) {
            object2 = "null";
        }
        $this$getDebugState_u24lambda_u2d23.put("sip_jibri_detector", object2);
        Object object3 = this.xmppServices.getJigasiDetector();
        if (object3 == null || (object3 = ((JigasiDetector)object3).getDebugState()) == null) {
            object3 = "null";
        }
        $this$getDebugState_u24lambda_u2d23.put("jigasi_detector", object3);
        return orderedJsonObject;
    }

    @NotNull
    public final OrderedJsonObject getConferenceDebugState(@NotNull String conferenceId) {
        Intrinsics.checkNotNullParameter(conferenceId, "conferenceId");
        OrderedJsonObject $this$getConferenceDebugState_u24lambda_u2d24 = new OrderedJsonObject();
        boolean bl = false;
        EntityBareJid entityBareJid = JidCreate.entityBareFrom(conferenceId);
        Intrinsics.checkNotNullExpressionValue(entityBareJid, "entityBareFrom(conferenceId)");
        JitsiMeetConferenceImpl conference = this.focusManager.getConference(entityBareJid);
        Object object = conference;
        if (object == null || (object = ((JitsiMeetConferenceImpl)object).getDebugState()) == null) {
            object = new OrderedJsonObject();
        }
        Intrinsics.checkNotNullExpressionValue(object, "conference?.debugState ?: OrderedJsonObject()");
        return object;
    }

    @NotNull
    public static final Object getJicofoServicesSingletonSyncRoot() {
        return Companion.getJicofoServicesSingletonSyncRoot();
    }

    @Nullable
    public static final JicofoServices getJicofoServicesSingleton() {
        return Companion.getJicofoServicesSingleton();
    }

    public static final void setJicofoServicesSingleton(@Nullable JicofoServices jicofoServices) {
        Companion.setJicofoServicesSingleton(jicofoServices);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R5\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u00048F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b\u000b\u0010\f\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001c\u0010\r\u001a\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000e\u0010\u0002\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lorg/jitsi/jicofo/JicofoServices$Companion;", "", "()V", "<set-?>", "Lorg/jitsi/jicofo/JicofoServices;", "jicofoServicesSingleton", "getJicofoServicesSingleton$annotations", "getJicofoServicesSingleton", "()Lorg/jitsi/jicofo/JicofoServices;", "setJicofoServicesSingleton", "(Lorg/jitsi/jicofo/JicofoServices;)V", "jicofoServicesSingleton$delegate", "Lorg/jitsi/jicofo/util/SynchronizedDelegate;", "jicofoServicesSingletonSyncRoot", "getJicofoServicesSingletonSyncRoot$annotations", "getJicofoServicesSingletonSyncRoot", "()Ljava/lang/Object;", "jicofo"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        @NotNull
        public final Object getJicofoServicesSingletonSyncRoot() {
            return jicofoServicesSingletonSyncRoot;
        }

        @JvmStatic
        public static /* synthetic */ void getJicofoServicesSingletonSyncRoot$annotations() {
        }

        @Nullable
        public final JicofoServices getJicofoServicesSingleton() {
            return (JicofoServices)jicofoServicesSingleton$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[0]);
        }

        public final void setJicofoServicesSingleton(@Nullable JicofoServices jicofoServices) {
            jicofoServicesSingleton$delegate.setValue(this, (KProperty<?>)$$delegatedProperties[0], jicofoServices);
        }

        @JvmStatic
        public static /* synthetic */ void getJicofoServicesSingleton$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1(new MutablePropertyReference1Impl(Companion.class, "jicofoServicesSingleton", "getJicofoServicesSingleton()Lorg/jitsi/jicofo/JicofoServices;", 0))};
            $$delegatedProperties = kPropertyArray;
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AuthConfig.Type.values().length];
            nArray[AuthConfig.Type.XMPP.ordinal()] = 1;
            nArray[AuthConfig.Type.JWT.ordinal()] = 2;
            nArray[AuthConfig.Type.SHIBBOLETH.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

