/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.version;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jitsi.utils.version.Version;
import org.jitsi.utils.version.VersionImpl;

public class CurrentVersionImpl {
    private static int parsedMajor;
    private static int parsedMinor;
    private static String parsedBuildId;
    public static final int VERSION_MAJOR;
    public static final int VERSION_MINOR;
    public static final String PRE_RELEASE_ID;
    public static final String NIGHTLY_BUILD_ID;
    public static final Version VERSION;

    static {
        Matcher m;
        parsedMajor = 1;
        parsedMinor = 1;
        parsedBuildId = null;
        String version = CurrentVersionImpl.class.getPackage().getImplementationVersion();
        if (version != null && (m = Pattern.compile("(\\d*)\\.(\\d*)-(.*)").matcher(version)).find()) {
            try {
                parsedMajor = Integer.parseInt(m.group(1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                parsedMinor = Integer.parseInt(m.group(2));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            parsedBuildId = m.group(3);
        }
        VERSION_MAJOR = parsedMajor;
        VERSION_MINOR = parsedMinor;
        PRE_RELEASE_ID = null;
        NIGHTLY_BUILD_ID = parsedBuildId != null ? parsedBuildId : "build.git";
        VERSION = new VersionImpl("JiCoFo", VERSION_MAJOR, VERSION_MINOR, NIGHTLY_BUILD_ID, PRE_RELEASE_ID);
    }
}

