/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.util.logging.Level;
import java.util.logging.Logger;

public class Async {
    public static Thread go(Runnable runnable) {
        Thread thread2 = Async.daemonThreadFrom(runnable);
        thread2.start();
        return thread2;
    }

    public static Thread go(Runnable runnable, String threadName) {
        Thread thread2 = Async.daemonThreadFrom(runnable);
        thread2.setName(threadName);
        thread2.start();
        return thread2;
    }

    public static Thread daemonThreadFrom(Runnable runnable) {
        Thread thread2 = new Thread(runnable);
        thread2.setDaemon(true);
        return thread2;
    }

    public static abstract class ThrowingRunnable
    implements Runnable {
        public static final Logger LOGGER = Logger.getLogger(ThrowingRunnable.class.getName());

        @Override
        public final void run() {
            try {
                this.runOrThrow();
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                LOGGER.log(Level.WARNING, "Caught Exception", e);
            }
        }

        public abstract void runOrThrow() throws Exception;
    }
}

