/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function.valuesource;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiTerms;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.docvalues.IntDocValues;
import org.apache.lucene.queries.function.valuesource.FieldCacheSource;
import org.apache.lucene.util.BytesRef;

public class JoinDocFreqValueSource
extends FieldCacheSource {
    public static final String NAME = "joindf";
    protected final String qfield;

    public JoinDocFreqValueSource(String field, String qfield) {
        super(field);
        this.qfield = qfield;
    }

    @Override
    public String description() {
        return "joindf(" + this.field + ":(" + this.qfield + "))";
    }

    @Override
    public FunctionValues getValues(Map<Object, Object> context, LeafReaderContext readerContext) throws IOException {
        final SortedDocValues terms = DocValues.getSorted((LeafReader)readerContext.reader(), (String)this.field);
        IndexReader top = ReaderUtil.getTopLevelContext((IndexReaderContext)readerContext).reader();
        Terms t = MultiTerms.getTerms((IndexReader)top, (String)this.qfield);
        final TermsEnum termsEnum = t == null ? TermsEnum.EMPTY : t.iterator();
        return new IntDocValues(this){
            int lastDocID;
            {
                super(vs);
                this.lastDocID = -1;
            }

            @Override
            public int intVal(int doc) throws IOException {
                BytesRef term;
                if (doc < this.lastDocID) {
                    throw new IllegalArgumentException("docs were sent out-of-order: lastDocID=" + this.lastDocID + " vs docID=" + doc);
                }
                this.lastDocID = doc;
                int curDocID = terms.docID();
                if (doc > curDocID) {
                    curDocID = terms.advance(doc);
                }
                if (doc == curDocID && termsEnum.seekExact(term = terms.lookupOrd(terms.ordValue()))) {
                    return termsEnum.docFreq();
                }
                return 0;
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        if (o.getClass() != JoinDocFreqValueSource.class) {
            return false;
        }
        JoinDocFreqValueSource other = (JoinDocFreqValueSource)o;
        if (!this.qfield.equals(other.qfield)) {
            return false;
        }
        return super.equals(other);
    }

    @Override
    public int hashCode() {
        return this.qfield.hashCode() + super.hashCode();
    }
}

