/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.metrics_generator.linux;

import java.util.HashMap;
import java.util.Map;
import org.opensearch.performanceanalyzer.metrics_generator.DiskIOMetricsGenerator;
import org.opensearch.performanceanalyzer.os.ThreadDiskIO;

public class LinuxDiskIOMetricsGenerator
implements DiskIOMetricsGenerator {
    private Map<String, ThreadDiskIO.IOMetrics> diskIOMetricsMap = new HashMap<String, ThreadDiskIO.IOMetrics>();

    @Override
    public double getAvgReadThroughputBps(String threadId) {
        return this.diskIOMetricsMap.get((Object)threadId).avgReadThroughputBps;
    }

    @Override
    public double getAvgReadSyscallRate(String threadId) {
        return this.diskIOMetricsMap.get((Object)threadId).avgReadSyscallRate;
    }

    @Override
    public double getAvgWriteThroughputBps(String threadId) {
        return this.diskIOMetricsMap.get((Object)threadId).avgWriteThroughputBps;
    }

    @Override
    public double getAvgWriteSyscallRate(String threadId) {
        return this.diskIOMetricsMap.get((Object)threadId).avgWriteSyscallRate;
    }

    @Override
    public double getAvgTotalThroughputBps(String threadId) {
        return this.diskIOMetricsMap.get((Object)threadId).avgTotalThroughputBps;
    }

    @Override
    public double getAvgTotalSyscallRate(String threadId) {
        return this.diskIOMetricsMap.get((Object)threadId).avgTotalSyscallRate;
    }

    @Override
    public boolean hasDiskIOMetrics(String threadId) {
        return this.diskIOMetricsMap.containsKey(threadId);
    }

    @Override
    public void addSample() {
        ThreadDiskIO.addSample();
    }

    public void setDiskIOMetrics(String threadId, ThreadDiskIO.IOMetrics ioMetrics) {
        this.diskIOMetricsMap.put(threadId, ioMetrics);
    }
}

