/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.reader;

import java.io.File;
import java.sql.Connection;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jooq.BatchBindStep;
import org.opensearch.performanceanalyzer.metrics.AllMetrics;
import org.opensearch.performanceanalyzer.reader.ClusterManagerEventMetricsSnapshot;
import org.opensearch.performanceanalyzer.reader.EventProcessor;
import org.opensearch.performanceanalyzer.reader.ReaderMetricsProcessor;
import org.opensearch.performanceanalyzer.reader_writer_shared.Event;

public class ClusterManagerMetricsEventProcessor
implements EventProcessor {
    private static final Logger LOG = LogManager.getLogger(ClusterManagerMetricsEventProcessor.class);
    private ClusterManagerEventMetricsSnapshot clusterManagerSnap;
    private BatchBindStep handle;
    private long startTime;
    private long endTime;

    private ClusterManagerMetricsEventProcessor(ClusterManagerEventMetricsSnapshot clusterManagerSnap) {
        this.clusterManagerSnap = clusterManagerSnap;
    }

    static ClusterManagerMetricsEventProcessor buildClusterManagerMetricEventsProcessor(long currWindowStartTime, Connection conn, NavigableMap<Long, ClusterManagerEventMetricsSnapshot> clusterManagerEventMetricsMap) {
        ClusterManagerEventMetricsSnapshot clusterManagerSnap = (ClusterManagerEventMetricsSnapshot)clusterManagerEventMetricsMap.get(currWindowStartTime);
        if (clusterManagerSnap == null) {
            clusterManagerSnap = new ClusterManagerEventMetricsSnapshot(conn, currWindowStartTime);
            Map.Entry<Long, ClusterManagerEventMetricsSnapshot> entry = clusterManagerEventMetricsMap.lastEntry();
            if (entry != null) {
                clusterManagerSnap.rolloverInflightRequests(entry.getValue());
            }
            clusterManagerEventMetricsMap.put(currWindowStartTime, clusterManagerSnap);
        }
        return new ClusterManagerMetricsEventProcessor(clusterManagerSnap);
    }

    @Override
    public void initializeProcessing(long startTime, long endTime) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.handle = this.clusterManagerSnap.startBatchPut();
    }

    @Override
    public void finalizeProcessing() {
        if (this.handle.size() > 0) {
            this.handle.execute();
        }
        LOG.debug("Final clusterManagerEvents request metrics {}", this.clusterManagerSnap.fetchAll());
    }

    @Override
    public void processEvent(Event event) {
        String[] keyElements = event.key.split(File.separatorChar == '\\' ? "\\\\" : File.separator);
        String threadId = keyElements[1];
        String insertOrder = keyElements[3];
        String startOrFinish = keyElements[4];
        if (startOrFinish.equals("start")) {
            this.emitStartClusterManagerEventMetric(event, insertOrder, threadId);
        } else if (startOrFinish.equals("finish")) {
            this.emitEndClusterManagerEventMetric(event, insertOrder, threadId);
        }
    }

    @Override
    public boolean shouldProcessEvent(Event event) {
        return event.key.contains("cluster_manager_task");
    }

    @Override
    public void commitBatchIfRequired() {
        if (this.handle.size() > 500) {
            this.handle.execute();
            this.handle = this.clusterManagerSnap.startBatchPut();
        }
    }

    private void emitStartClusterManagerEventMetric(Event entry, String insertOrder, String threadId) {
        Map<String, String> keyValueMap = ReaderMetricsProcessor.extractEntryData(entry.value);
        String priority = keyValueMap.get(AllMetrics.ClusterManagerMetricDimensions.CLUSTER_MANAGER_TASK_PRIORITY.toString());
        long st = Long.parseLong(keyValueMap.get(AllMetrics.CommonMetric.START_TIME.toString()));
        String taskType = keyValueMap.get(AllMetrics.ClusterManagerMetricDimensions.CLUSTER_MANAGER_TASK_TYPE.toString());
        String taskMetadata = keyValueMap.get(AllMetrics.ClusterManagerMetricDimensions.CLUSTER_MANAGER_TASK_METADATA.toString());
        long queueTime = Long.parseLong(keyValueMap.get(AllMetrics.ClusterManagerMetricDimensions.CLUSTER_MANAGER_TASK_QUEUE_TIME.toString()));
        this.handle.bind(new Object[]{threadId, insertOrder, priority, taskType, taskMetadata, queueTime, st, null});
    }

    private void emitEndClusterManagerEventMetric(Event entry, String insertOrder, String threadId) {
        Map<String, String> keyValueMap = ReaderMetricsProcessor.extractEntryData(entry.value);
        long finishTime = Long.parseLong(keyValueMap.get(AllMetrics.CommonMetric.FINISH_TIME.toString()));
        this.handle.bind(new Object[]{threadId, insertOrder, null, null, null, null, null, finishTime});
    }
}

