/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.opensearch.SpecialPermission;

public class NonValidatingObjectMapper {
    private static final ObjectMapper nonValidatingObjectMapper = new ObjectMapper();

    public static void inject(InjectableValues.Std injectableValues) {
        nonValidatingObjectMapper.setInjectableValues((InjectableValues)injectableValues);
    }

    public static <T> T readValue(final String string, final JavaType jt) throws IOException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<T>(){

                @Override
                public T run() throws Exception {
                    return nonValidatingObjectMapper.readValue(string, jt);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    public static TypeFactory getTypeFactory() {
        return nonValidatingObjectMapper.getTypeFactory();
    }

    static {
        nonValidatingObjectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        nonValidatingObjectMapper.configure(JsonParser.Feature.STRICT_DUPLICATE_DETECTION, false);
        nonValidatingObjectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        nonValidatingObjectMapper.configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, false);
    }
}

