/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.scan;

import com.google.common.annotations.VisibleForTesting;
import org.opensearch.sql.expression.ReferenceExpression;
import org.opensearch.sql.opensearch.storage.OpenSearchIndexScan;
import org.opensearch.sql.opensearch.storage.scan.OpenSearchIndexScanAggregationBuilder;
import org.opensearch.sql.opensearch.storage.scan.OpenSearchIndexScanQueryBuilder;
import org.opensearch.sql.planner.logical.LogicalAggregation;
import org.opensearch.sql.planner.logical.LogicalFilter;
import org.opensearch.sql.planner.logical.LogicalHighlight;
import org.opensearch.sql.planner.logical.LogicalLimit;
import org.opensearch.sql.planner.logical.LogicalProject;
import org.opensearch.sql.planner.logical.LogicalSort;
import org.opensearch.sql.storage.TableScanOperator;
import org.opensearch.sql.storage.read.TableScanBuilder;

public class OpenSearchIndexScanBuilder
extends TableScanBuilder {
    private TableScanBuilder delegate;
    private boolean isLimitPushedDown = false;

    @VisibleForTesting
    OpenSearchIndexScanBuilder(TableScanBuilder delegate) {
        this.delegate = delegate;
    }

    public OpenSearchIndexScanBuilder(OpenSearchIndexScan indexScan) {
        this.delegate = new OpenSearchIndexScanQueryBuilder(indexScan);
    }

    public TableScanOperator build() {
        return this.delegate.build();
    }

    public boolean pushDownFilter(LogicalFilter filter) {
        return this.delegate.pushDownFilter(filter);
    }

    public boolean pushDownAggregation(LogicalAggregation aggregation) {
        if (this.isLimitPushedDown) {
            return false;
        }
        this.delegate = new OpenSearchIndexScanAggregationBuilder((OpenSearchIndexScan)this.delegate.build());
        return this.delegate.pushDownAggregation(aggregation);
    }

    public boolean pushDownSort(LogicalSort sort) {
        if (!this.sortByFieldsOnly(sort)) {
            return false;
        }
        return this.delegate.pushDownSort(sort);
    }

    public boolean pushDownLimit(LogicalLimit limit) {
        this.isLimitPushedDown = true;
        return this.delegate.pushDownLimit(limit);
    }

    public boolean pushDownProject(LogicalProject project) {
        return this.delegate.pushDownProject(project);
    }

    public boolean pushDownHighlight(LogicalHighlight highlight) {
        return this.delegate.pushDownHighlight(highlight);
    }

    private boolean sortByFieldsOnly(LogicalSort sort) {
        return sort.getSortList().stream().map(sortItem -> sortItem.getRight() instanceof ReferenceExpression).reduce(true, Boolean::logicalAnd);
    }
}

