/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.awarenesshealth;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opensearch.OpenSearchParseException;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.awarenesshealth.ClusterAwarenessAttributeValueHealth;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.common.Strings;
import org.opensearch.common.collect.ImmutableOpenMap;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentFragment;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentParserUtils;

public class ClusterAwarenessAttributesHealth
implements Iterable<ClusterAwarenessAttributeValueHealth>,
Writeable,
ToXContentFragment {
    private final String awarenessAttributeName;
    private Map<String, ClusterAwarenessAttributeValueHealth> awarenessAttributeValueHealthMap;

    public ClusterAwarenessAttributesHealth(String awarenessAttributeValue, boolean displayUnassignedShardLevelInfo, ClusterState clusterState) {
        this.awarenessAttributeName = awarenessAttributeValue;
        HashMap<String, List<String>> attributesNodeList = new HashMap<String, List<String>>();
        ImmutableOpenMap<String, DiscoveryNode> nodeMap = clusterState.nodes().getDataNodes();
        this.awarenessAttributeValueHealthMap = new HashMap<String, ClusterAwarenessAttributeValueHealth>();
        if (!nodeMap.isEmpty()) {
            Iterator<String> iter = nodeMap.keysIt();
            while (iter.hasNext()) {
                List<String> clusterAwarenessAttributeNodeList;
                String node = iter.next();
                DiscoveryNode nodeDiscovery = nodeMap.get(node);
                Map<String, String> nodeAttributes = nodeDiscovery.getAttributes();
                if (nodeAttributes.isEmpty() || !nodeAttributes.containsKey(this.awarenessAttributeName)) continue;
                String attributeValue = nodeAttributes.get(this.awarenessAttributeName);
                if (!attributesNodeList.containsKey(attributeValue)) {
                    clusterAwarenessAttributeNodeList = new ArrayList();
                    attributesNodeList.put(attributeValue, clusterAwarenessAttributeNodeList);
                } else {
                    clusterAwarenessAttributeNodeList = (List)attributesNodeList.get(attributeValue);
                }
                clusterAwarenessAttributeNodeList.add(node);
            }
        }
        this.setClusterAwarenessAttributeValue(attributesNodeList, displayUnassignedShardLevelInfo, clusterState);
    }

    private void setClusterAwarenessAttributeValue(Map<String, List<String>> perAttributeValueNodeList, boolean displayUnassignedShardLevelInfo, ClusterState clusterState) {
        int numAttributes = perAttributeValueNodeList.size();
        int shardsPerAttributeValue = 0;
        if (numAttributes != 0) {
            shardsPerAttributeValue = clusterState.getMetadata().getTotalNumberOfShards() / numAttributes;
        }
        HashMap<String, ClusterAwarenessAttributeValueHealth> clusterAwarenessAttributeValueHealthMap = new HashMap<String, ClusterAwarenessAttributeValueHealth>();
        for (String attributeValueKey : perAttributeValueNodeList.keySet()) {
            ClusterAwarenessAttributeValueHealth clusterAwarenessAttributeValueHealth = new ClusterAwarenessAttributeValueHealth(attributeValueKey, perAttributeValueNodeList.get(attributeValueKey));
            clusterAwarenessAttributeValueHealth.computeAttributeValueLevelInfo(clusterState, displayUnassignedShardLevelInfo, shardsPerAttributeValue);
            clusterAwarenessAttributeValueHealthMap.put(attributeValueKey, clusterAwarenessAttributeValueHealth);
        }
        this.awarenessAttributeValueHealthMap = clusterAwarenessAttributeValueHealthMap;
    }

    public ClusterAwarenessAttributesHealth(StreamInput in) throws IOException {
        this.awarenessAttributeName = in.readString();
        int size = in.readVInt();
        if (size > 0) {
            this.awarenessAttributeValueHealthMap = new HashMap<String, ClusterAwarenessAttributeValueHealth>(size);
            for (int i = 0; i < size; ++i) {
                ClusterAwarenessAttributeValueHealth clusterAwarenessAttributeValueHealth = new ClusterAwarenessAttributeValueHealth(in);
                this.awarenessAttributeValueHealthMap.put(clusterAwarenessAttributeValueHealth.getName(), clusterAwarenessAttributeValueHealth);
            }
        } else {
            this.awarenessAttributeValueHealthMap = Collections.emptyMap();
        }
    }

    ClusterAwarenessAttributesHealth(String awarenessAttributeName, Map<String, ClusterAwarenessAttributeValueHealth> awarenessAttributeValueHealthMap) {
        this.awarenessAttributeName = awarenessAttributeName;
        this.awarenessAttributeValueHealthMap = awarenessAttributeValueHealthMap;
    }

    public String getAwarenessAttributeName() {
        return this.awarenessAttributeName;
    }

    public Map<String, ClusterAwarenessAttributeValueHealth> getAwarenessAttributeHealthMap() {
        return this.awarenessAttributeValueHealthMap;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.awarenessAttributeName);
        int size = this.awarenessAttributeValueHealthMap.size();
        out.writeVInt(size);
        if (size > 0) {
            for (ClusterAwarenessAttributeValueHealth attributeHealthMapPerValue : this) {
                attributeHealthMapPerValue.writeTo(out);
            }
        }
    }

    @Override
    public Iterator<ClusterAwarenessAttributeValueHealth> iterator() {
        return this.awarenessAttributeValueHealthMap.values().iterator();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.getAwarenessAttributeName());
        for (ClusterAwarenessAttributeValueHealth clusterAwarenessAttributeValueHealth : this) {
            clusterAwarenessAttributeValueHealth.toXContent(builder, params);
        }
        builder.endObject();
        return null;
    }

    public static ClusterAwarenessAttributesHealth fromXContent(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.nextToken(), parser);
        XContentParser.Token token = parser.nextToken();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, token, parser);
        String attributeName = parser.currentName();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.nextToken(), parser);
        HashMap<String, ClusterAwarenessAttributeValueHealth> clusterAwarenessAttributeValueHealthMap = new HashMap<String, ClusterAwarenessAttributeValueHealth>();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, token, parser);
            String attributeValue = parser.currentName();
            token = parser.nextToken();
            if (token == XContentParser.Token.START_OBJECT) {
                int active_shards = 0;
                int initializing_shards = 0;
                int relocating_shards = 0;
                int unassigned_shards = 0;
                int nodes = 0;
                double weight = 0.0;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        String currentFieldName;
                        switch (currentFieldName = parser.currentName()) {
                            case "active_shards": {
                                if (parser.nextToken() != XContentParser.Token.VALUE_NUMBER) {
                                    throw new OpenSearchParseException("failed to parse active shards field, expected number but found unknown type", new Object[0]);
                                }
                                active_shards = parser.intValue();
                                break;
                            }
                            case "initializing_shards": {
                                if (parser.nextToken() != XContentParser.Token.VALUE_NUMBER) {
                                    throw new OpenSearchParseException("failed to parse initializing shards field, expected number but found unknown type", new Object[0]);
                                }
                                initializing_shards = parser.intValue();
                                break;
                            }
                            case "relocating_shards": {
                                if (parser.nextToken() != XContentParser.Token.VALUE_NUMBER) {
                                    throw new OpenSearchParseException("failed to parse relocating shards field, expected number but found unknown type", new Object[0]);
                                }
                                relocating_shards = parser.intValue();
                                break;
                            }
                            case "unassigned_shards": {
                                if (parser.nextToken() != XContentParser.Token.VALUE_NUMBER) {
                                    throw new OpenSearchParseException("failed to parse unassigned field, expected number but found unknown type", new Object[0]);
                                }
                                unassigned_shards = parser.intValue();
                                break;
                            }
                            case "data_nodes": {
                                if (parser.nextToken() != XContentParser.Token.VALUE_NUMBER) {
                                    throw new OpenSearchParseException("failed to parse node field, expected number but found unknown type", new Object[0]);
                                }
                                nodes = parser.intValue();
                                break;
                            }
                            case "weight": {
                                if (parser.nextToken() != XContentParser.Token.VALUE_NUMBER) {
                                    throw new OpenSearchParseException("failed to parse weight field, expected number but found unknown type", new Object[0]);
                                }
                                weight = parser.doubleValue();
                            }
                        }
                        continue;
                    }
                    throw new OpenSearchParseException("failed to parse attribute health map", new Object[0]);
                }
                ClusterAwarenessAttributeValueHealth clusterAwarenessAttributeValueHealth = new ClusterAwarenessAttributeValueHealth(attributeValue, active_shards, initializing_shards, relocating_shards, unassigned_shards, nodes, weight);
                clusterAwarenessAttributeValueHealthMap.put(clusterAwarenessAttributeValueHealth.getName(), clusterAwarenessAttributeValueHealth);
                continue;
            }
            throw new OpenSearchParseException("failed to parse awareness attribute value health", new Object[0]);
        }
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.END_OBJECT, parser.nextToken(), parser);
        return new ClusterAwarenessAttributesHealth(attributeName, clusterAwarenessAttributeValueHealthMap);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClusterAwarenessAttributesHealth)) {
            return false;
        }
        ClusterAwarenessAttributesHealth that = (ClusterAwarenessAttributesHealth)o;
        return this.awarenessAttributeName.equals(that.awarenessAttributeName) && this.awarenessAttributeValueHealthMap.size() == that.awarenessAttributeValueHealthMap.size();
    }

    public int hashCode() {
        return Objects.hash(this.awarenessAttributeName, this.awarenessAttributeValueHealthMap);
    }
}

