/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.node;

import com.carrotsearch.hppc.ObjectContainer;
import com.carrotsearch.hppc.ObjectHashSet;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.opensearch.LegacyESVersion;
import org.opensearch.Version;
import org.opensearch.cluster.AbstractDiffable;
import org.opensearch.cluster.Diff;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.node.DiscoveryNodeRole;
import org.opensearch.common.Booleans;
import org.opensearch.common.Nullable;
import org.opensearch.common.Strings;
import org.opensearch.common.collect.ImmutableOpenMap;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.regex.Regex;
import org.opensearch.common.transport.TransportAddress;
import org.opensearch.common.util.set.Sets;

public class DiscoveryNodes
extends AbstractDiffable<DiscoveryNodes>
implements Iterable<DiscoveryNode> {
    public static final DiscoveryNodes EMPTY_NODES = DiscoveryNodes.builder().build();
    private final ImmutableOpenMap<String, DiscoveryNode> nodes;
    private final ImmutableOpenMap<String, DiscoveryNode> dataNodes;
    private final ImmutableOpenMap<String, DiscoveryNode> clusterManagerNodes;
    private final ImmutableOpenMap<String, DiscoveryNode> ingestNodes;
    private final String clusterManagerNodeId;
    private final String localNodeId;
    private final Version minNonClientNodeVersion;
    private final Version maxNonClientNodeVersion;
    private final Version maxNodeVersion;
    private final Version minNodeVersion;

    private DiscoveryNodes(ImmutableOpenMap<String, DiscoveryNode> nodes, ImmutableOpenMap<String, DiscoveryNode> dataNodes, ImmutableOpenMap<String, DiscoveryNode> clusterManagerNodes, ImmutableOpenMap<String, DiscoveryNode> ingestNodes, String clusterManagerNodeId, String localNodeId, Version minNonClientNodeVersion, Version maxNonClientNodeVersion, Version maxNodeVersion, Version minNodeVersion) {
        this.nodes = nodes;
        this.dataNodes = dataNodes;
        this.clusterManagerNodes = clusterManagerNodes;
        this.ingestNodes = ingestNodes;
        this.clusterManagerNodeId = clusterManagerNodeId;
        this.localNodeId = localNodeId;
        this.minNonClientNodeVersion = minNonClientNodeVersion;
        this.maxNonClientNodeVersion = maxNonClientNodeVersion;
        this.minNodeVersion = minNodeVersion;
        this.maxNodeVersion = maxNodeVersion;
    }

    @Override
    public Iterator<DiscoveryNode> iterator() {
        return this.nodes.valuesIt();
    }

    public boolean isLocalNodeElectedClusterManager() {
        if (this.localNodeId == null) {
            return false;
        }
        return this.localNodeId.equals(this.clusterManagerNodeId);
    }

    @Deprecated
    public boolean isLocalNodeElectedMaster() {
        return this.isLocalNodeElectedClusterManager();
    }

    public int getSize() {
        return this.nodes.size();
    }

    public ImmutableOpenMap<String, DiscoveryNode> getNodes() {
        return this.nodes;
    }

    public ImmutableOpenMap<String, DiscoveryNode> getDataNodes() {
        return this.dataNodes;
    }

    public ImmutableOpenMap<String, DiscoveryNode> getClusterManagerNodes() {
        return this.clusterManagerNodes;
    }

    @Deprecated
    public ImmutableOpenMap<String, DiscoveryNode> getMasterNodes() {
        return this.getClusterManagerNodes();
    }

    public ImmutableOpenMap<String, DiscoveryNode> getIngestNodes() {
        return this.ingestNodes;
    }

    public ImmutableOpenMap<String, DiscoveryNode> getClusterManagerAndDataNodes() {
        ImmutableOpenMap.Builder<String, DiscoveryNode> nodes = ImmutableOpenMap.builder(this.dataNodes);
        nodes.putAll(this.clusterManagerNodes);
        return nodes.build();
    }

    @Deprecated
    public ImmutableOpenMap<String, DiscoveryNode> getMasterAndDataNodes() {
        return this.getClusterManagerAndDataNodes();
    }

    public ImmutableOpenMap<String, DiscoveryNode> getCoordinatingOnlyNodes() {
        ImmutableOpenMap.Builder<String, DiscoveryNode> nodes = ImmutableOpenMap.builder(this.nodes);
        nodes.removeAll((ObjectContainer<String>)this.clusterManagerNodes.keys());
        nodes.removeAll((ObjectContainer<String>)this.dataNodes.keys());
        nodes.removeAll((ObjectContainer<String>)this.ingestNodes.keys());
        return nodes.build();
    }

    public Stream<DiscoveryNode> clusterManagersFirstStream() {
        return Stream.concat(StreamSupport.stream(this.clusterManagerNodes.spliterator(), false).map(cur -> (DiscoveryNode)cur.value), StreamSupport.stream(this.spliterator(), false).filter(n -> !n.isClusterManagerNode()));
    }

    @Deprecated
    public Stream<DiscoveryNode> mastersFirstStream() {
        return this.clusterManagersFirstStream();
    }

    public DiscoveryNode get(String nodeId) {
        return this.nodes.get(nodeId);
    }

    public boolean nodeExists(String nodeId) {
        return this.nodes.containsKey(nodeId);
    }

    public boolean nodeExists(DiscoveryNode node) {
        DiscoveryNode existing = this.nodes.get(node.getId());
        return existing != null && existing.equals(node);
    }

    public boolean nodeExistsWithSameRoles(DiscoveryNode discoveryNode) {
        DiscoveryNode existing = this.nodes.get(discoveryNode.getId());
        return existing != null && existing.equals(discoveryNode) && existing.getRoles().equals(discoveryNode.getRoles());
    }

    public boolean nodeExistsWithBWCVersion(DiscoveryNode discoveryNode) {
        DiscoveryNode existing = this.nodes.get(discoveryNode.getId());
        return existing != null && existing.equals(discoveryNode) && existing.getVersion().equals(LegacyESVersion.V_7_10_2) && discoveryNode.getVersion().onOrAfter(Version.V_1_0_0);
    }

    public String getClusterManagerNodeId() {
        return this.clusterManagerNodeId;
    }

    @Deprecated
    public String getMasterNodeId() {
        return this.getClusterManagerNodeId();
    }

    public String getLocalNodeId() {
        return this.localNodeId;
    }

    public DiscoveryNode getLocalNode() {
        return this.nodes.get(this.localNodeId);
    }

    @Nullable
    public DiscoveryNode getClusterManagerNode() {
        if (this.clusterManagerNodeId != null) {
            return this.nodes.get(this.clusterManagerNodeId);
        }
        return null;
    }

    @Deprecated
    @Nullable
    public DiscoveryNode getMasterNode() {
        return this.getClusterManagerNode();
    }

    public DiscoveryNode findByAddress(TransportAddress address) {
        for (ObjectCursor cursor : this.nodes.values()) {
            DiscoveryNode node = (DiscoveryNode)cursor.value;
            if (!node.getAddress().equals(address)) continue;
            return node;
        }
        return null;
    }

    public Version getSmallestNonClientNodeVersion() {
        return this.minNonClientNodeVersion;
    }

    public Version getLargestNonClientNodeVersion() {
        return this.maxNonClientNodeVersion;
    }

    public Version getMinNodeVersion() {
        return this.minNodeVersion;
    }

    public Version getMaxNodeVersion() {
        return this.maxNodeVersion;
    }

    public DiscoveryNode resolveNode(String node) {
        String[] resolvedNodeIds = this.resolveNodes(node);
        if (resolvedNodeIds.length > 1) {
            throw new IllegalArgumentException("resolved [" + node + "] into [" + resolvedNodeIds.length + "] nodes, where expected to be resolved to a single node");
        }
        if (resolvedNodeIds.length == 0) {
            throw new IllegalArgumentException("failed to resolve [" + node + "], no matching nodes");
        }
        return this.nodes.get(resolvedNodeIds[0]);
    }

    public String[] resolveNodes(String ... nodes) {
        if (nodes == null || nodes.length == 0) {
            return (String[])StreamSupport.stream(this.spliterator(), false).map(DiscoveryNode::getId).toArray(String[]::new);
        }
        ObjectHashSet resolvedNodesIds = new ObjectHashSet(nodes.length);
        for (String nodeId : nodes) {
            if (nodeId == null) {
                assert (nodeId != null) : "nodeId should not be null";
                continue;
            }
            if (nodeId.equals("_local")) {
                String localNodeId = this.getLocalNodeId();
                if (localNodeId == null) continue;
                resolvedNodesIds.add((Object)localNodeId);
                continue;
            }
            if (nodeId.equals("_master") || nodeId.equals("_cluster_manager")) {
                String clusterManagerNodeId = this.getClusterManagerNodeId();
                if (clusterManagerNodeId == null) continue;
                resolvedNodesIds.add((Object)clusterManagerNodeId);
                continue;
            }
            if (this.nodeExists(nodeId)) {
                resolvedNodesIds.add((Object)nodeId);
                continue;
            }
            for (DiscoveryNode node : this) {
                if (!"_all".equals(nodeId) && !Regex.simpleMatch(nodeId, node.getName()) && !Regex.simpleMatch(nodeId, node.getHostAddress()) && !Regex.simpleMatch(nodeId, node.getHostName())) continue;
                resolvedNodesIds.add((Object)node.getId());
            }
            int index = nodeId.indexOf(58);
            if (index == -1) continue;
            String matchAttrName = nodeId.substring(0, index);
            String matchAttrValue = nodeId.substring(index + 1);
            if (DiscoveryNodeRole.DATA_ROLE.roleName().equals(matchAttrName)) {
                if (Booleans.parseBoolean((String)matchAttrValue, (boolean)true)) {
                    resolvedNodesIds.addAll(this.dataNodes.keys());
                    continue;
                }
                resolvedNodesIds.removeAll(this.dataNodes.keys());
                continue;
            }
            if (this.roleNameIsClusterManager(matchAttrName)) {
                if (Booleans.parseBoolean((String)matchAttrValue, (boolean)true)) {
                    resolvedNodesIds.addAll(this.clusterManagerNodes.keys());
                    continue;
                }
                resolvedNodesIds.removeAll(this.clusterManagerNodes.keys());
                continue;
            }
            if (DiscoveryNodeRole.INGEST_ROLE.roleName().equals(matchAttrName)) {
                if (Booleans.parseBoolean((String)matchAttrValue, (boolean)true)) {
                    resolvedNodesIds.addAll(this.ingestNodes.keys());
                    continue;
                }
                resolvedNodesIds.removeAll(this.ingestNodes.keys());
                continue;
            }
            if ("coordinating_only".equals(matchAttrName)) {
                if (Booleans.parseBoolean((String)matchAttrValue, (boolean)true)) {
                    resolvedNodesIds.addAll(this.getCoordinatingOnlyNodes().keys());
                    continue;
                }
                resolvedNodesIds.removeAll(this.getCoordinatingOnlyNodes().keys());
                continue;
            }
            for (DiscoveryNode node : this) {
                for (DiscoveryNodeRole discoveryNodeRole : Sets.difference(node.getRoles(), DiscoveryNodeRole.BUILT_IN_ROLES)) {
                    if (!discoveryNodeRole.roleName().equals(matchAttrName)) continue;
                    if (Booleans.parseBoolean((String)matchAttrValue, (boolean)true)) {
                        resolvedNodesIds.add((Object)node.getId());
                        continue;
                    }
                    resolvedNodesIds.remove((Object)node.getId());
                }
            }
            for (DiscoveryNode node : this) {
                for (Map.Entry entry : node.getAttributes().entrySet()) {
                    String attrName = (String)entry.getKey();
                    String attrValue = (String)entry.getValue();
                    if (!Regex.simpleMatch(matchAttrName, attrName) || !Regex.simpleMatch(matchAttrValue, attrValue)) continue;
                    resolvedNodesIds.add((Object)node.getId());
                }
            }
        }
        return (String[])resolvedNodesIds.toArray(String.class);
    }

    public DiscoveryNodes newNode(DiscoveryNode node) {
        return new Builder(this).add(node).build();
    }

    public Delta delta(DiscoveryNodes other) {
        ArrayList<DiscoveryNode> removed = new ArrayList<DiscoveryNode>();
        ArrayList<DiscoveryNode> added = new ArrayList<DiscoveryNode>();
        for (DiscoveryNode node : other) {
            if (this.nodeExists(node)) continue;
            removed.add(node);
        }
        for (DiscoveryNode node : this) {
            if (other.nodeExists(node)) continue;
            added.add(node);
        }
        return new Delta(other.getClusterManagerNode(), this.getClusterManagerNode(), this.localNodeId, Collections.unmodifiableList(removed), Collections.unmodifiableList(added));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("nodes: \n");
        for (DiscoveryNode node : this) {
            sb.append("   ").append(node);
            if (node == this.getLocalNode()) {
                sb.append(", local");
            }
            if (node == this.getClusterManagerNode()) {
                sb.append(", cluster-manager");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (this.clusterManagerNodeId == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeString(this.clusterManagerNodeId);
        }
        out.writeVInt(this.nodes.size());
        for (DiscoveryNode node : this) {
            node.writeTo(out);
        }
    }

    public static DiscoveryNodes readFrom(StreamInput in, DiscoveryNode localNode) throws IOException {
        Builder builder = new Builder();
        if (in.readBoolean()) {
            builder.clusterManagerNodeId(in.readString());
        }
        if (localNode != null) {
            builder.localNodeId(localNode.getId());
        }
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            DiscoveryNode node = new DiscoveryNode(in);
            if (localNode != null && node.getId().equals(localNode.getId())) {
                node = localNode;
            }
            assert (builder.validateAdd(node) == null) : "building disco nodes from network doesn't pass preflight: " + builder.validateAdd(node);
            builder.putUnsafe(node);
        }
        return builder.build();
    }

    public static Diff<DiscoveryNodes> readDiffFrom(StreamInput in, DiscoveryNode localNode) throws IOException {
        return AbstractDiffable.readDiffFrom((StreamInput in1) -> DiscoveryNodes.readFrom(in1, localNode), in);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DiscoveryNodes nodes) {
        return new Builder(nodes);
    }

    @Deprecated
    private boolean roleNameIsClusterManager(String matchAttrName) {
        return DiscoveryNodeRole.MASTER_ROLE.roleName().equals(matchAttrName) || DiscoveryNodeRole.CLUSTER_MANAGER_ROLE.roleName().equals(matchAttrName);
    }

    public static class Builder {
        private final ImmutableOpenMap.Builder<String, DiscoveryNode> nodes;
        private String clusterManagerNodeId;
        private String localNodeId;

        public Builder() {
            this.nodes = ImmutableOpenMap.builder();
        }

        public Builder(DiscoveryNodes nodes) {
            this.clusterManagerNodeId = nodes.getClusterManagerNodeId();
            this.localNodeId = nodes.getLocalNodeId();
            this.nodes = ImmutableOpenMap.builder(nodes.getNodes());
        }

        public Builder add(DiscoveryNode node) {
            String preflight = this.validateAdd(node);
            if (preflight != null) {
                throw new IllegalArgumentException(preflight);
            }
            this.putUnsafe(node);
            return this;
        }

        @Nullable
        public DiscoveryNode get(String nodeId) {
            return this.nodes.get(nodeId);
        }

        private void putUnsafe(DiscoveryNode node) {
            this.nodes.put(node.getId(), node);
        }

        public Builder remove(String nodeId) {
            this.nodes.remove(nodeId);
            return this;
        }

        public Builder remove(DiscoveryNode node) {
            if (node.equals(this.nodes.get(node.getId()))) {
                this.nodes.remove(node.getId());
            }
            return this;
        }

        public Builder clusterManagerNodeId(String clusterManagerNodeId) {
            this.clusterManagerNodeId = clusterManagerNodeId;
            return this;
        }

        @Deprecated
        public Builder masterNodeId(String clusterManagerNodeId) {
            return this.clusterManagerNodeId(clusterManagerNodeId);
        }

        public Builder localNodeId(String localNodeId) {
            this.localNodeId = localNodeId;
            return this;
        }

        private String validateAdd(DiscoveryNode node) {
            for (ObjectCursor cursor : this.nodes.values()) {
                DiscoveryNode existingNode = (DiscoveryNode)cursor.value;
                if (node.getAddress().equals(existingNode.getAddress()) && !node.getId().equals(existingNode.getId())) {
                    return "can't add node " + node + ", found existing node " + existingNode + " with same address";
                }
                if (!node.getId().equals(existingNode.getId()) || node.equals(existingNode)) continue;
                return "can't add node " + node + ", found existing node " + existingNode + " with the same id but is a different node instance";
            }
            return null;
        }

        public DiscoveryNodes build() {
            ImmutableOpenMap.Builder<String, DiscoveryNode> dataNodesBuilder = ImmutableOpenMap.builder();
            ImmutableOpenMap.Builder<String, DiscoveryNode> clusterManagerNodesBuilder = ImmutableOpenMap.builder();
            ImmutableOpenMap.Builder<String, DiscoveryNode> ingestNodesBuilder = ImmutableOpenMap.builder();
            Version minNodeVersion = null;
            Version maxNodeVersion = null;
            Version minNonClientNodeVersion = null;
            Version maxNonClientNodeVersion = null;
            Iterator<ObjectObjectCursor<String, DiscoveryNode>> iterator = this.nodes.iterator();
            while (iterator.hasNext()) {
                ObjectObjectCursor<String, DiscoveryNode> nodeEntry = iterator.next();
                if (((DiscoveryNode)nodeEntry.value).isDataNode()) {
                    dataNodesBuilder.put((String)nodeEntry.key, (DiscoveryNode)nodeEntry.value);
                }
                if (((DiscoveryNode)nodeEntry.value).isClusterManagerNode()) {
                    clusterManagerNodesBuilder.put((String)nodeEntry.key, (DiscoveryNode)nodeEntry.value);
                }
                Version version = ((DiscoveryNode)nodeEntry.value).getVersion();
                if (((DiscoveryNode)nodeEntry.value).isDataNode() || ((DiscoveryNode)nodeEntry.value).isClusterManagerNode()) {
                    if (minNonClientNodeVersion == null) {
                        minNonClientNodeVersion = version;
                        maxNonClientNodeVersion = version;
                    } else {
                        minNonClientNodeVersion = Version.min(minNonClientNodeVersion, version);
                        maxNonClientNodeVersion = Version.max(maxNonClientNodeVersion, version);
                    }
                }
                if (((DiscoveryNode)nodeEntry.value).isIngestNode()) {
                    ingestNodesBuilder.put((String)nodeEntry.key, (DiscoveryNode)nodeEntry.value);
                }
                minNodeVersion = minNodeVersion == null ? version : Version.min(minNodeVersion, version);
                maxNodeVersion = maxNodeVersion == null ? version : Version.max(maxNodeVersion, version);
            }
            return new DiscoveryNodes(this.nodes.build(), dataNodesBuilder.build(), clusterManagerNodesBuilder.build(), ingestNodesBuilder.build(), this.clusterManagerNodeId, this.localNodeId, minNonClientNodeVersion == null ? Version.CURRENT : minNonClientNodeVersion, maxNonClientNodeVersion == null ? Version.CURRENT : maxNonClientNodeVersion, maxNodeVersion == null ? Version.CURRENT : maxNodeVersion, minNodeVersion == null ? Version.CURRENT : minNodeVersion);
        }

        public boolean isLocalNodeElectedClusterManager() {
            return this.clusterManagerNodeId != null && this.clusterManagerNodeId.equals(this.localNodeId);
        }

        @Deprecated
        public boolean isLocalNodeElectedMaster() {
            return this.isLocalNodeElectedClusterManager();
        }
    }

    public static class Delta {
        private final String localNodeId;
        @Nullable
        private final DiscoveryNode previousClusterManagerNode;
        @Nullable
        private final DiscoveryNode newClusterManagerNode;
        private final List<DiscoveryNode> removed;
        private final List<DiscoveryNode> added;

        private Delta(@Nullable DiscoveryNode previousClusterManagerNode, @Nullable DiscoveryNode newClusterManagerNode, String localNodeId, List<DiscoveryNode> removed, List<DiscoveryNode> added) {
            this.previousClusterManagerNode = previousClusterManagerNode;
            this.newClusterManagerNode = newClusterManagerNode;
            this.localNodeId = localNodeId;
            this.removed = removed;
            this.added = added;
        }

        public boolean hasChanges() {
            return this.clusterManagerNodeChanged() || !this.removed.isEmpty() || !this.added.isEmpty();
        }

        public boolean clusterManagerNodeChanged() {
            return !Objects.equals(this.newClusterManagerNode, this.previousClusterManagerNode);
        }

        @Deprecated
        public boolean masterNodeChanged() {
            return this.clusterManagerNodeChanged();
        }

        @Nullable
        public DiscoveryNode previousClusterManagerNode() {
            return this.previousClusterManagerNode;
        }

        @Deprecated
        @Nullable
        public DiscoveryNode previousMasterNode() {
            return this.previousClusterManagerNode();
        }

        @Nullable
        public DiscoveryNode newClusterManagerNode() {
            return this.newClusterManagerNode;
        }

        @Deprecated
        @Nullable
        public DiscoveryNode newMasterNode() {
            return this.newClusterManagerNode();
        }

        public boolean removed() {
            return !this.removed.isEmpty();
        }

        public List<DiscoveryNode> removedNodes() {
            return this.removed;
        }

        public boolean added() {
            return !this.added.isEmpty();
        }

        public List<DiscoveryNode> addedNodes() {
            return this.added;
        }

        public String shortSummary() {
            String addedNodesExceptLocalNode;
            StringBuilder summary = new StringBuilder();
            if (this.clusterManagerNodeChanged()) {
                summary.append("cluster-manager node changed {previous [");
                if (this.previousClusterManagerNode() != null) {
                    summary.append(this.previousClusterManagerNode());
                }
                summary.append("], current [");
                if (this.newClusterManagerNode() != null) {
                    summary.append(this.newClusterManagerNode());
                }
                summary.append("]}");
            }
            if (this.removed()) {
                if (summary.length() > 0) {
                    summary.append(", ");
                }
                summary.append("removed {").append(Strings.collectionToCommaDelimitedString(this.removedNodes())).append('}');
            }
            if (this.added() && (addedNodesExceptLocalNode = this.addedNodes().stream().filter(node -> !node.getId().equals(this.localNodeId)).map(DiscoveryNode::toString).collect(Collectors.joining(","))).length() > 0) {
                if (summary.length() > 0) {
                    summary.append(", ");
                }
                summary.append("added {").append(addedNodesExceptLocalNode).append('}');
            }
            return summary.toString();
        }
    }
}

