/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.routing;

import com.carrotsearch.hppc.ObjectIntHashMap;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.CollectionUtil;
import org.opensearch.Assertions;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.routing.IndexRoutingTable;
import org.opensearch.cluster.routing.IndexShardRoutingTable;
import org.opensearch.cluster.routing.RecoverySource;
import org.opensearch.cluster.routing.RoutingChangesObserver;
import org.opensearch.cluster.routing.RoutingNode;
import org.opensearch.cluster.routing.RoutingTable;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.cluster.routing.ShardRoutingState;
import org.opensearch.cluster.routing.UnassignedInfo;
import org.opensearch.cluster.routing.allocation.ExistingShardsAllocator;
import org.opensearch.common.Nullable;
import org.opensearch.common.Randomness;
import org.opensearch.common.collect.Tuple;
import org.opensearch.index.Index;
import org.opensearch.index.shard.ShardId;

public class RoutingNodes
implements Iterable<RoutingNode> {
    private final Map<String, RoutingNode> nodesToShards = new HashMap<String, RoutingNode>();
    private final UnassignedShards unassignedShards = new UnassignedShards(this);
    private final Map<ShardId, List<ShardRouting>> assignedShards = new HashMap<ShardId, List<ShardRouting>>();
    private final boolean readOnly;
    private int inactivePrimaryCount = 0;
    private int inactiveShardCount = 0;
    private int relocatingShards = 0;
    private final Map<String, ObjectIntHashMap<String>> nodesPerAttributeNames = new HashMap<String, ObjectIntHashMap<String>>();
    private final Map<String, Recoveries> recoveriesPerNode = new HashMap<String, Recoveries>();
    private final Map<String, Recoveries> initialReplicaRecoveries = new HashMap<String, Recoveries>();
    private final Map<String, Recoveries> initialPrimaryRecoveries = new HashMap<String, Recoveries>();
    private static final List<ShardRouting> EMPTY = Collections.emptyList();

    public RoutingNodes(ClusterState clusterState) {
        this(clusterState, true);
    }

    public RoutingNodes(ClusterState clusterState, boolean readOnly) {
        this.readOnly = readOnly;
        RoutingTable routingTable = clusterState.routingTable();
        for (ObjectCursor cursor : clusterState.nodes().getDataNodes().values()) {
            String nodeId = ((DiscoveryNode)cursor.value).getId();
            this.nodesToShards.put(((DiscoveryNode)cursor.value).getId(), new RoutingNode(nodeId, clusterState.nodes().get(nodeId), new ShardRouting[0]));
        }
        for (ObjectCursor indexRoutingTable : routingTable.indicesRouting().values()) {
            for (IndexShardRoutingTable indexShard : (IndexRoutingTable)indexRoutingTable.value) {
                assert (indexShard.primary != null);
                for (ShardRouting shard : indexShard) {
                    if (shard.assignedToNode()) {
                        RoutingNode routingNode = this.nodesToShards.computeIfAbsent(shard.currentNodeId(), k -> new RoutingNode(shard.currentNodeId(), clusterState.nodes().get(shard.currentNodeId()), new ShardRouting[0]));
                        routingNode.add(shard);
                        this.assignedShardsAdd(shard);
                        if (shard.relocating()) {
                            ++this.relocatingShards;
                            routingNode = this.nodesToShards.computeIfAbsent(shard.relocatingNodeId(), k -> new RoutingNode(shard.relocatingNodeId(), clusterState.nodes().get(shard.relocatingNodeId()), new ShardRouting[0]));
                            ShardRouting targetShardRouting = shard.getTargetRelocatingShard();
                            this.addInitialRecovery(targetShardRouting, indexShard.primary);
                            routingNode.add(targetShardRouting);
                            this.assignedShardsAdd(targetShardRouting);
                            continue;
                        }
                        if (!shard.initializing()) continue;
                        if (shard.primary()) {
                            ++this.inactivePrimaryCount;
                        }
                        ++this.inactiveShardCount;
                        this.addInitialRecovery(shard, indexShard.primary);
                        continue;
                    }
                    this.unassignedShards.add(shard);
                }
            }
        }
    }

    private void addRecovery(ShardRouting routing) {
        this.updateRecoveryCounts(routing, true, this.findAssignedPrimaryIfPeerRecovery(routing));
    }

    private void removeRecovery(ShardRouting routing) {
        this.updateRecoveryCounts(routing, false, this.findAssignedPrimaryIfPeerRecovery(routing));
    }

    private void addInitialRecovery(ShardRouting routing, ShardRouting initialPrimaryShard) {
        this.updateRecoveryCounts(routing, true, initialPrimaryShard);
    }

    private void updateRecoveryCounts(ShardRouting routing, boolean increment, @Nullable ShardRouting primary) {
        int howMany;
        int n = howMany = increment ? 1 : -1;
        assert (routing.initializing()) : "routing must be initializing: " + routing;
        assert (primary == null || primary.assignedToNode()) : "shard is initializing but its primary is not assigned to a node";
        if (routing.primary() && (primary == null || primary == routing)) {
            assert (routing.relocatingNodeId() == null) : "Routing must be a non relocating primary";
            Recoveries.getOrAdd(this.initialPrimaryRecoveries, routing.currentNodeId()).addIncoming(howMany);
            return;
        }
        Recoveries.getOrAdd(this.getRecoveries(routing), routing.currentNodeId()).addIncoming(howMany);
        if (routing.recoverySource().getType() == RecoverySource.Type.PEER) {
            if (primary == null) {
                throw new IllegalStateException("shard is peer recovering but primary is unassigned");
            }
            Recoveries.getOrAdd(this.getRecoveries(routing), primary.currentNodeId()).addOutgoing(howMany);
            if (!increment && routing.primary() && routing.relocatingNodeId() != null) {
                for (ShardRouting assigned : this.assignedShards(routing.shardId())) {
                    if (assigned.primary() || !assigned.initializing() || assigned.recoverySource().getType() != RecoverySource.Type.PEER) continue;
                    Map<String, Recoveries> recoveriesToUpdate = this.getRecoveries(assigned);
                    Recoveries.getOrAdd(recoveriesToUpdate, routing.relocatingNodeId()).addOutgoing(-1);
                    Recoveries.getOrAdd(recoveriesToUpdate, routing.currentNodeId()).addOutgoing(1);
                }
            }
        }
    }

    private Map<String, Recoveries> getRecoveries(ShardRouting routing) {
        if (routing.unassignedReasonIndexCreated() && !routing.primary()) {
            return this.initialReplicaRecoveries;
        }
        return this.recoveriesPerNode;
    }

    public int getIncomingRecoveries(String nodeId) {
        return this.recoveriesPerNode.getOrDefault(nodeId, Recoveries.EMPTY).getIncoming();
    }

    public int getInitialPrimariesIncomingRecoveries(String nodeId) {
        return this.initialPrimaryRecoveries.getOrDefault(nodeId, Recoveries.EMPTY).getIncoming();
    }

    public int getOutgoingRecoveries(String nodeId) {
        return this.recoveriesPerNode.getOrDefault(nodeId, Recoveries.EMPTY).getOutgoing();
    }

    public int getInitialIncomingRecoveries(String nodeId) {
        return this.initialReplicaRecoveries.getOrDefault(nodeId, Recoveries.EMPTY).getIncoming();
    }

    public int getInitialOutgoingRecoveries(String nodeId) {
        return this.initialReplicaRecoveries.getOrDefault(nodeId, Recoveries.EMPTY).getOutgoing();
    }

    @Nullable
    private ShardRouting findAssignedPrimaryIfPeerRecovery(ShardRouting routing) {
        List<ShardRouting> shardRoutings;
        ShardRouting primary = null;
        if (routing.recoverySource() != null && routing.recoverySource().getType() == RecoverySource.Type.PEER && (shardRoutings = this.assignedShards.get(routing.shardId())) != null) {
            for (ShardRouting shardRouting : shardRoutings) {
                if (!shardRouting.primary()) continue;
                if (shardRouting.active()) {
                    return shardRouting;
                }
                if (primary == null) {
                    primary = shardRouting;
                    continue;
                }
                if (primary.relocatingNodeId() == null) continue;
                primary = shardRouting;
            }
        }
        return primary;
    }

    @Override
    public Iterator<RoutingNode> iterator() {
        return Collections.unmodifiableCollection(this.nodesToShards.values()).iterator();
    }

    public Iterator<RoutingNode> mutableIterator() {
        this.ensureMutable();
        return this.nodesToShards.values().iterator();
    }

    public UnassignedShards unassigned() {
        return this.unassignedShards;
    }

    public RoutingNode node(String nodeId) {
        return this.nodesToShards.get(nodeId);
    }

    public ObjectIntHashMap<String> nodesPerAttributesCounts(String attributeName) {
        ObjectIntHashMap nodesPerAttributesCounts = this.nodesPerAttributeNames.get(attributeName);
        if (nodesPerAttributesCounts != null) {
            return nodesPerAttributesCounts;
        }
        nodesPerAttributesCounts = new ObjectIntHashMap();
        for (RoutingNode routingNode : this) {
            String attrValue = routingNode.node().getAttributes().get(attributeName);
            nodesPerAttributesCounts.addTo((Object)attrValue, 1);
        }
        this.nodesPerAttributeNames.put(attributeName, (ObjectIntHashMap<String>)nodesPerAttributesCounts);
        return nodesPerAttributesCounts;
    }

    public boolean hasUnassignedPrimaries() {
        return this.unassignedShards.getNumPrimaries() + this.unassignedShards.getNumIgnoredPrimaries() > 0;
    }

    public boolean hasUnassignedShards() {
        return !this.unassignedShards.isEmpty() || !this.unassignedShards.isIgnoredEmpty();
    }

    public boolean hasInactivePrimaries() {
        return this.inactivePrimaryCount > 0;
    }

    public boolean hasInactiveShards() {
        return this.inactiveShardCount > 0;
    }

    public int getRelocatingShardCount() {
        return this.relocatingShards;
    }

    public List<ShardRouting> assignedShards(ShardId shardId) {
        List<ShardRouting> replicaSet = this.assignedShards.get(shardId);
        return replicaSet == null ? EMPTY : Collections.unmodifiableList(replicaSet);
    }

    @Nullable
    public ShardRouting getByAllocationId(ShardId shardId, String allocationId) {
        List<ShardRouting> replicaSet = this.assignedShards.get(shardId);
        if (replicaSet == null) {
            return null;
        }
        for (ShardRouting shardRouting : replicaSet) {
            if (!shardRouting.allocationId().getId().equals(allocationId)) continue;
            return shardRouting;
        }
        return null;
    }

    public ShardRouting activePrimary(ShardId shardId) {
        for (ShardRouting shardRouting : this.assignedShards(shardId)) {
            if (!shardRouting.primary() || !shardRouting.active()) continue;
            return shardRouting;
        }
        return null;
    }

    public ShardRouting activeReplicaWithHighestVersion(ShardId shardId) {
        return this.assignedShards(shardId).stream().filter(shr -> !shr.primary() && shr.active()).filter(shr -> this.node(shr.currentNodeId()) != null).max(Comparator.comparing(shr -> this.node(shr.currentNodeId()).node(), Comparator.nullsFirst(Comparator.comparing(DiscoveryNode::getVersion)))).orElse(null);
    }

    public boolean allReplicasActive(ShardId shardId, Metadata metadata) {
        List<ShardRouting> shards = this.assignedShards(shardId);
        if (shards.isEmpty() || shards.size() < metadata.getIndexSafe(shardId.getIndex()).getNumberOfReplicas() + 1) {
            return false;
        }
        for (ShardRouting shard : shards) {
            if (shard.active()) continue;
            return false;
        }
        return true;
    }

    public List<ShardRouting> shards(Predicate<ShardRouting> predicate) {
        ArrayList<ShardRouting> shards = new ArrayList<ShardRouting>();
        for (RoutingNode routingNode : this) {
            for (ShardRouting shardRouting : routingNode) {
                if (!predicate.test(shardRouting)) continue;
                shards.add(shardRouting);
            }
        }
        return shards;
    }

    public List<ShardRouting> shardsWithState(ShardRoutingState ... state) {
        ArrayList<ShardRouting> shards = new ArrayList<ShardRouting>();
        for (RoutingNode routingNode : this) {
            shards.addAll(routingNode.shardsWithState(state));
        }
        for (ShardRoutingState s : state) {
            if (s != ShardRoutingState.UNASSIGNED) continue;
            this.unassigned().forEach(shards::add);
            break;
        }
        return shards;
    }

    public List<ShardRouting> shardsWithState(String index, ShardRoutingState ... state) {
        ArrayList<ShardRouting> shards = new ArrayList<ShardRouting>();
        for (RoutingNode routingNode : this) {
            shards.addAll(routingNode.shardsWithState(index, state));
        }
        for (ShardRoutingState s : state) {
            if (s != ShardRoutingState.UNASSIGNED) continue;
            for (ShardRouting unassignedShard : this.unassignedShards) {
                if (!unassignedShard.index().getName().equals(index)) continue;
                shards.add(unassignedShard);
            }
            break;
        }
        return shards;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("routing_nodes:\n");
        for (RoutingNode routingNode : this) {
            sb.append(routingNode.prettyPrint());
        }
        sb.append("---- unassigned\n");
        for (ShardRouting shardEntry : this.unassignedShards) {
            sb.append("--------").append(shardEntry.shortSummary()).append('\n');
        }
        return sb.toString();
    }

    public ShardRouting initializeShard(ShardRouting unassignedShard, String nodeId, @Nullable String existingAllocationId, long expectedSize, RoutingChangesObserver routingChangesObserver) {
        this.ensureMutable();
        assert (unassignedShard.unassigned()) : "expected an unassigned shard " + unassignedShard;
        ShardRouting initializedShard = unassignedShard.initialize(nodeId, existingAllocationId, expectedSize);
        this.node(nodeId).add(initializedShard);
        ++this.inactiveShardCount;
        if (initializedShard.primary()) {
            ++this.inactivePrimaryCount;
        }
        this.addRecovery(initializedShard);
        this.assignedShardsAdd(initializedShard);
        routingChangesObserver.shardInitialized(unassignedShard, initializedShard);
        return initializedShard;
    }

    public Tuple<ShardRouting, ShardRouting> relocateShard(ShardRouting startedShard, String nodeId, long expectedShardSize, RoutingChangesObserver changes) {
        this.ensureMutable();
        ++this.relocatingShards;
        ShardRouting source = startedShard.relocate(nodeId, expectedShardSize);
        ShardRouting target = source.getTargetRelocatingShard();
        this.updateAssigned(startedShard, source);
        this.node(target.currentNodeId()).add(target);
        this.assignedShardsAdd(target);
        this.addRecovery(target);
        changes.relocationStarted(startedShard, target);
        return Tuple.tuple((Object)source, (Object)target);
    }

    public ShardRouting startShard(Logger logger, ShardRouting initializingShard, RoutingChangesObserver routingChangesObserver) {
        this.ensureMutable();
        ShardRouting startedShard = this.started(initializingShard);
        logger.trace("{} marked shard as started (routing: {})", (Object)initializingShard.shardId(), (Object)initializingShard);
        routingChangesObserver.shardStarted(initializingShard, startedShard);
        if (initializingShard.relocatingNodeId() != null) {
            RoutingNode relocationSourceNode = this.node(initializingShard.relocatingNodeId());
            ShardRouting relocationSourceShard = relocationSourceNode.getByShardId(initializingShard.shardId());
            assert (relocationSourceShard.isRelocationSourceOf(initializingShard));
            assert (relocationSourceShard.getTargetRelocatingShard() == initializingShard) : "relocation target mismatch, expected: " + initializingShard + " but was: " + relocationSourceShard.getTargetRelocatingShard();
            this.remove(relocationSourceShard);
            routingChangesObserver.relocationCompleted(relocationSourceShard);
            if (startedShard.primary()) {
                List<ShardRouting> assignedShards = this.assignedShards(startedShard.shardId());
                for (ShardRouting routing : new ArrayList<ShardRouting>(assignedShards)) {
                    if (!routing.initializing() || routing.primary()) continue;
                    if (routing.isRelocationTarget()) {
                        ShardRouting sourceShard = this.getByAllocationId(routing.shardId(), routing.allocationId().getRelocationId());
                        ShardRouting startedReplica = this.cancelRelocation(sourceShard);
                        this.remove(routing);
                        routingChangesObserver.shardFailed(routing, new UnassignedInfo(UnassignedInfo.Reason.REINITIALIZED, "primary changed"));
                        this.relocateShard(startedReplica, sourceShard.relocatingNodeId(), sourceShard.getExpectedShardSize(), routingChangesObserver);
                        continue;
                    }
                    ShardRouting reinitializedReplica = this.reinitReplica(routing);
                    routingChangesObserver.initializedReplicaReinitialized(routing, reinitializedReplica);
                }
            }
        }
        return startedShard;
    }

    public void failShard(Logger logger, ShardRouting failedShard, UnassignedInfo unassignedInfo, IndexMetadata indexMetadata, RoutingChangesObserver routingChangesObserver) {
        List<ShardRouting> assignedShards;
        this.ensureMutable();
        assert (failedShard.assignedToNode()) : "only assigned shards can be failed";
        assert (indexMetadata.getIndex().equals(failedShard.index())) : "shard failed for unknown index (shard entry: " + failedShard + ")";
        assert (this.getByAllocationId(failedShard.shardId(), failedShard.allocationId().getId()) == failedShard) : "shard routing to fail does not exist in routing table, expected: " + failedShard + " but was: " + this.getByAllocationId(failedShard.shardId(), failedShard.allocationId().getId());
        logger.debug("{} failing shard {} with unassigned info ({})", (Object)failedShard.shardId(), (Object)failedShard, (Object)unassignedInfo.shortSummary());
        if (failedShard.primary() && !(assignedShards = this.assignedShards(failedShard.shardId())).isEmpty()) {
            for (ShardRouting routing : new ArrayList<ShardRouting>(assignedShards)) {
                if (routing.primary() || !routing.initializing()) continue;
                ShardRouting replicaShard = this.getByAllocationId(routing.shardId(), routing.allocationId().getId());
                assert (replicaShard != null) : "failed to re-resolve " + routing + " when failing replicas";
                UnassignedInfo primaryFailedUnassignedInfo = new UnassignedInfo(UnassignedInfo.Reason.PRIMARY_FAILED, "primary failed while replica initializing", null, 0, unassignedInfo.getUnassignedTimeInNanos(), unassignedInfo.getUnassignedTimeInMillis(), false, UnassignedInfo.AllocationStatus.NO_ATTEMPT, Collections.emptySet());
                this.failShard(logger, replicaShard, primaryFailedUnassignedInfo, indexMetadata, routingChangesObserver);
            }
        }
        if (failedShard.relocating()) {
            ShardRouting targetShard = this.getByAllocationId(failedShard.shardId(), failedShard.allocationId().getRelocationId());
            assert (targetShard.isRelocationTargetOf(failedShard));
            if (failedShard.primary()) {
                logger.trace("{} is removed due to the failure/cancellation of the source shard", (Object)targetShard);
                this.remove(targetShard);
                routingChangesObserver.shardFailed(targetShard, unassignedInfo);
            } else {
                logger.trace("{}, relocation source failed / cancelled, mark as initializing without relocation source", (Object)targetShard);
                this.removeRelocationSource(targetShard);
                routingChangesObserver.relocationSourceRemoved(targetShard);
            }
        }
        if (failedShard.initializing()) {
            if (failedShard.relocatingNodeId() == null) {
                if (failedShard.primary()) {
                    this.unassignPrimaryAndPromoteActiveReplicaIfExists(failedShard, unassignedInfo, routingChangesObserver);
                } else {
                    this.moveToUnassigned(failedShard, unassignedInfo);
                }
            } else {
                logger.trace("{} is a relocation target, resolving source to cancel relocation ({})", (Object)failedShard, (Object)unassignedInfo.shortSummary());
                ShardRouting sourceShard = this.getByAllocationId(failedShard.shardId(), failedShard.allocationId().getRelocationId());
                assert (sourceShard.isRelocationSourceOf(failedShard));
                logger.trace("{}, resolved source to [{}]. canceling relocation ... ({})", (Object)failedShard.shardId(), (Object)sourceShard, (Object)unassignedInfo.shortSummary());
                this.cancelRelocation(sourceShard);
                this.remove(failedShard);
            }
        } else {
            assert (failedShard.active());
            if (failedShard.primary()) {
                this.unassignPrimaryAndPromoteActiveReplicaIfExists(failedShard, unassignedInfo, routingChangesObserver);
            } else if (failedShard.relocating()) {
                this.remove(failedShard);
            } else {
                this.moveToUnassigned(failedShard, unassignedInfo);
            }
        }
        routingChangesObserver.shardFailed(failedShard, unassignedInfo);
        assert (this.node(failedShard.currentNodeId()).getByShardId(failedShard.shardId()) == null) : "failedShard " + failedShard + " was matched but wasn't removed";
    }

    public void swapPrimaryWithReplica(Logger logger, ShardRouting primaryShard, ShardRouting replicaShard, RoutingChangesObserver changes) {
        assert (primaryShard.primary()) : "Invalid primary shard provided";
        assert (!replicaShard.primary()) : "Invalid Replica shard provided";
        ShardRouting newPrimary = primaryShard.moveActivePrimaryToReplica();
        ShardRouting newReplica = replicaShard.moveActiveReplicaToPrimary();
        this.updateAssigned(primaryShard, newPrimary);
        this.updateAssigned(replicaShard, newReplica);
        logger.info("Swap relocation performed for shard [{}]", (Object)newPrimary.shortSummary());
        changes.replicaPromoted(newPrimary);
    }

    private void unassignPrimaryAndPromoteActiveReplicaIfExists(ShardRouting failedShard, UnassignedInfo unassignedInfo, RoutingChangesObserver routingChangesObserver) {
        assert (failedShard.primary());
        ShardRouting activeReplica = this.activeReplicaWithHighestVersion(failedShard.shardId());
        if (activeReplica == null) {
            this.moveToUnassigned(failedShard, unassignedInfo);
        } else {
            this.movePrimaryToUnassignedAndDemoteToReplica(failedShard, unassignedInfo);
            this.promoteReplicaToPrimary(activeReplica, routingChangesObserver);
        }
    }

    private void promoteReplicaToPrimary(ShardRouting activeReplica, RoutingChangesObserver routingChangesObserver) {
        assert (activeReplica.started()) : "replica relocation should have been cancelled: " + activeReplica;
        this.promoteActiveReplicaShardToPrimary(activeReplica);
        routingChangesObserver.replicaPromoted(activeReplica);
    }

    private ShardRouting started(ShardRouting shard) {
        assert (shard.initializing()) : "expected an initializing shard " + shard;
        if (shard.relocatingNodeId() == null) {
            --this.inactiveShardCount;
            if (shard.primary()) {
                --this.inactivePrimaryCount;
            }
        }
        this.removeRecovery(shard);
        ShardRouting startedShard = shard.moveToStarted();
        this.updateAssigned(shard, startedShard);
        return startedShard;
    }

    private ShardRouting cancelRelocation(ShardRouting shard) {
        --this.relocatingShards;
        ShardRouting cancelledShard = shard.cancelRelocation();
        this.updateAssigned(shard, cancelledShard);
        return cancelledShard;
    }

    private ShardRouting promoteActiveReplicaShardToPrimary(ShardRouting replicaShard) {
        assert (replicaShard.active()) : "non-active shard cannot be promoted to primary: " + replicaShard;
        assert (!replicaShard.primary()) : "primary shard cannot be promoted to primary: " + replicaShard;
        ShardRouting primaryShard = replicaShard.moveActiveReplicaToPrimary();
        this.updateAssigned(replicaShard, primaryShard);
        return primaryShard;
    }

    private void remove(ShardRouting shard) {
        assert (!shard.unassigned()) : "only assigned shards can be removed here (" + shard + ")";
        this.node(shard.currentNodeId()).remove(shard);
        if (shard.initializing() && shard.relocatingNodeId() == null) {
            --this.inactiveShardCount;
            assert (this.inactiveShardCount >= 0);
            if (shard.primary()) {
                --this.inactivePrimaryCount;
            }
        } else if (shard.relocating()) {
            shard = this.cancelRelocation(shard);
        }
        this.assignedShardsRemove(shard);
        if (shard.initializing()) {
            this.removeRecovery(shard);
        }
    }

    private ShardRouting removeRelocationSource(ShardRouting shard) {
        assert (shard.isRelocationTarget()) : "only relocation target shards can have their relocation source removed (" + shard + ")";
        ShardRouting relocationMarkerRemoved = shard.removeRelocationSource();
        this.updateAssigned(shard, relocationMarkerRemoved);
        ++this.inactiveShardCount;
        return relocationMarkerRemoved;
    }

    private void assignedShardsAdd(ShardRouting shard) {
        assert (!shard.unassigned()) : "unassigned shard " + shard + " cannot be added to list of assigned shards";
        List shards = this.assignedShards.computeIfAbsent(shard.shardId(), k -> new ArrayList());
        assert (this.assertInstanceNotInList(shard, shards)) : "shard " + shard + " cannot appear twice in list of assigned shards";
        shards.add(shard);
    }

    private boolean assertInstanceNotInList(ShardRouting shard, List<ShardRouting> shards) {
        for (ShardRouting s : shards) {
            assert (s != shard);
        }
        return true;
    }

    private void assignedShardsRemove(ShardRouting shard) {
        List<ShardRouting> replicaSet = this.assignedShards.get(shard.shardId());
        if (replicaSet != null) {
            Iterator<ShardRouting> iterator = replicaSet.iterator();
            while (iterator.hasNext()) {
                if (shard != iterator.next()) continue;
                iterator.remove();
                return;
            }
        }
        assert (false) : "No shard found to remove";
    }

    private ShardRouting reinitReplica(ShardRouting shard) {
        assert (!shard.primary()) : "shard must be a replica: " + shard;
        assert (shard.initializing()) : "can only reinitialize an initializing replica: " + shard;
        assert (!shard.isRelocationTarget()) : "replication target cannot be reinitialized: " + shard;
        ShardRouting reinitializedShard = shard.reinitializeReplicaShard();
        this.updateAssigned(shard, reinitializedShard);
        return reinitializedShard;
    }

    private void updateAssigned(ShardRouting oldShard, ShardRouting newShard) {
        assert (oldShard.shardId().equals(newShard.shardId())) : "can only update " + oldShard + " by shard with same shard id but was " + newShard;
        assert (!oldShard.unassigned() && !newShard.unassigned()) : "only assigned shards can be updated in list of assigned shards (prev: " + oldShard + ", new: " + newShard + ")";
        assert (oldShard.currentNodeId().equals(newShard.currentNodeId())) : "shard to update " + oldShard + " can only update " + oldShard + " by shard assigned to same node but was " + newShard;
        this.node(oldShard.currentNodeId()).update(oldShard, newShard);
        List shardsWithMatchingShardId = this.assignedShards.computeIfAbsent(oldShard.shardId(), k -> new ArrayList());
        int previousShardIndex = shardsWithMatchingShardId.indexOf(oldShard);
        assert (previousShardIndex >= 0) : "shard to update " + oldShard + " does not exist in list of assigned shards";
        shardsWithMatchingShardId.set(previousShardIndex, newShard);
    }

    private ShardRouting moveToUnassigned(ShardRouting shard, UnassignedInfo unassignedInfo) {
        assert (!shard.unassigned()) : "only assigned shards can be moved to unassigned (" + shard + ")";
        this.remove(shard);
        ShardRouting unassigned = shard.moveToUnassigned(unassignedInfo);
        this.unassignedShards.add(unassigned);
        return unassigned;
    }

    private ShardRouting movePrimaryToUnassignedAndDemoteToReplica(ShardRouting shard, UnassignedInfo unassignedInfo) {
        assert (!shard.unassigned()) : "only assigned shards can be moved to unassigned (" + shard + ")";
        assert (shard.primary()) : "only primary can be demoted to replica (" + shard + ")";
        this.remove(shard);
        ShardRouting unassigned = shard.moveToUnassigned(unassignedInfo).moveUnassignedFromPrimary();
        this.unassignedShards.add(unassigned);
        return unassigned;
    }

    public int size() {
        return this.nodesToShards.size();
    }

    public static boolean assertShardStats(RoutingNodes routingNodes) {
        if (!Assertions.ENABLED) {
            return true;
        }
        int unassignedPrimaryCount = 0;
        int unassignedIgnoredPrimaryCount = 0;
        int inactivePrimaryCount = 0;
        int inactiveShardCount = 0;
        int relocating = 0;
        HashMap<Index, Integer> indicesAndShards = new HashMap<Index, Integer>();
        for (RoutingNode node : routingNodes) {
            for (ShardRouting shardRouting : node) {
                Object i;
                if (shardRouting.initializing() && shardRouting.relocatingNodeId() == null) {
                    ++inactiveShardCount;
                    if (shardRouting.primary()) {
                        ++inactivePrimaryCount;
                    }
                }
                if (shardRouting.relocating()) {
                    ++relocating;
                }
                if ((i = (Integer)indicesAndShards.get(shardRouting.index())) == null) {
                    i = shardRouting.id();
                }
                indicesAndShards.put(shardRouting.index(), Math.max((Integer)i, shardRouting.id()));
            }
        }
        Set entries = indicesAndShards.entrySet();
        HashMap<ShardId, HashSet> shardsByShardId = new HashMap<ShardId, HashSet>();
        for (RoutingNode routingNode : routingNodes) {
            for (ShardRouting shardRouting : routingNode) {
                HashSet shards = shardsByShardId.computeIfAbsent(new ShardId(shardRouting.index(), shardRouting.id()), k -> new HashSet());
                shards.add(shardRouting);
            }
        }
        for (Map.Entry entry : entries) {
            Index index = (Index)entry.getKey();
            for (int i = 0; i < (Integer)entry.getValue(); ++i) {
                ShardId shardId = new ShardId(index, i);
                HashSet shards = (HashSet)shardsByShardId.get(shardId);
                List<ShardRouting> mutableShardRoutings = routingNodes.assignedShards(shardId);
                assert (shards == null && mutableShardRoutings.size() == 0 || shards != null && shards.size() == mutableShardRoutings.size() && shards.containsAll(mutableShardRoutings));
            }
        }
        for (ShardRouting shardRouting : routingNodes.unassigned()) {
            if (!shardRouting.primary()) continue;
            ++unassignedPrimaryCount;
        }
        for (ShardRouting shardRouting : routingNodes.unassigned().ignored()) {
            if (!shardRouting.primary()) continue;
            ++unassignedIgnoredPrimaryCount;
        }
        RoutingNodes.assertRecoveriesPerNode(routingNodes, routingNodes.initialPrimaryRecoveries, false, x -> RoutingNodes.isNonRelocatingPrimary(x));
        RoutingNodes.assertRecoveriesPerNode(routingNodes, Recoveries.unionRecoveries(routingNodes.recoveriesPerNode, routingNodes.initialReplicaRecoveries), true, x -> !RoutingNodes.isNonRelocatingPrimary(x));
        assert (unassignedPrimaryCount == routingNodes.unassignedShards.getNumPrimaries()) : "Unassigned primaries is [" + unassignedPrimaryCount + "] but RoutingNodes returned unassigned primaries [" + routingNodes.unassigned().getNumPrimaries() + "]";
        assert (unassignedIgnoredPrimaryCount == routingNodes.unassignedShards.getNumIgnoredPrimaries()) : "Unassigned ignored primaries is [" + unassignedIgnoredPrimaryCount + "] but RoutingNodes returned unassigned ignored primaries [" + routingNodes.unassigned().getNumIgnoredPrimaries() + "]";
        assert (inactivePrimaryCount == routingNodes.inactivePrimaryCount) : "Inactive Primary count [" + inactivePrimaryCount + "] but RoutingNodes returned inactive primaries [" + routingNodes.inactivePrimaryCount + "]";
        assert (inactiveShardCount == routingNodes.inactiveShardCount) : "Inactive Shard count [" + inactiveShardCount + "] but RoutingNodes returned inactive shards [" + routingNodes.inactiveShardCount + "]";
        assert (routingNodes.getRelocatingShardCount() == relocating) : "Relocating shards mismatch [" + routingNodes.getRelocatingShardCount() + "] but expected [" + relocating + "]";
        return true;
    }

    private static void assertRecoveriesPerNode(RoutingNodes routingNodes, Map<String, Recoveries> recoveriesPerNode, boolean verifyOutgoingRecoveries, Function<ShardRouting, Boolean> incomingCountFilter) {
        for (Map.Entry<String, Recoveries> recoveries : recoveriesPerNode.entrySet()) {
            String node = recoveries.getKey();
            Recoveries value = recoveries.getValue();
            int incoming = 0;
            int outgoing = 0;
            RoutingNode routingNode = routingNodes.nodesToShards.get(node);
            if (routingNode != null) {
                for (ShardRouting routing : routingNode) {
                    if (routing.initializing() && incomingCountFilter.apply(routing).booleanValue()) {
                        ++incoming;
                    }
                    if (!verifyOutgoingRecoveries || !routing.primary() || routing.isRelocationTarget()) continue;
                    for (ShardRouting assigned : routingNodes.assignedShards.get(routing.shardId())) {
                        if (!assigned.initializing() || assigned.recoverySource().getType() != RecoverySource.Type.PEER) continue;
                        ++outgoing;
                    }
                }
            }
            assert (incoming == value.incoming) : incoming + " != " + value.incoming + " node: " + routingNode;
            assert (outgoing == value.outgoing) : outgoing + " != " + value.outgoing + " node: " + routingNode;
        }
    }

    private static boolean isNonRelocatingPrimary(ShardRouting routing) {
        return routing.primary() && routing.relocatingNodeId() == null;
    }

    private void ensureMutable() {
        if (this.readOnly) {
            throw new IllegalStateException("can't modify RoutingNodes - readonly");
        }
    }

    public Iterator<ShardRouting> nodeInterleavedShardIterator(boolean movePrimaryFirst) {
        final ArrayDeque<Iterator<ShardRouting>> queue = new ArrayDeque<Iterator<ShardRouting>>();
        for (Map.Entry<String, RoutingNode> entry : this.nodesToShards.entrySet()) {
            queue.add(entry.getValue().copyShards().iterator());
        }
        if (movePrimaryFirst) {
            return new Iterator<ShardRouting>(){
                private Queue<ShardRouting> replicaShards = new ArrayDeque<ShardRouting>();
                private Queue<Iterator<ShardRouting>> replicaIterators = new ArrayDeque<Iterator<ShardRouting>>();

                @Override
                public boolean hasNext() {
                    while (!queue.isEmpty()) {
                        if (((Iterator)queue.peek()).hasNext()) {
                            return true;
                        }
                        queue.poll();
                    }
                    if (!this.replicaShards.isEmpty()) {
                        return true;
                    }
                    while (!this.replicaIterators.isEmpty()) {
                        if (this.replicaIterators.peek().hasNext()) {
                            return true;
                        }
                        this.replicaIterators.poll();
                    }
                    return false;
                }

                @Override
                public ShardRouting next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    while (!queue.isEmpty()) {
                        Iterator iter = (Iterator)queue.poll();
                        if (!iter.hasNext()) continue;
                        ShardRouting result = (ShardRouting)iter.next();
                        if (result.primary()) {
                            queue.offer(iter);
                            return result;
                        }
                        this.replicaShards.offer(result);
                        this.replicaIterators.offer(iter);
                    }
                    if (!this.replicaShards.isEmpty()) {
                        return this.replicaShards.poll();
                    }
                    Iterator<ShardRouting> replicaIterator = this.replicaIterators.poll();
                    ShardRouting replicaShard = replicaIterator.next();
                    this.replicaIterators.offer(replicaIterator);
                    assert (!replicaShard.primary());
                    return replicaShard;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return new Iterator<ShardRouting>(){

            @Override
            public boolean hasNext() {
                while (!queue.isEmpty()) {
                    if (((Iterator)queue.peek()).hasNext()) {
                        return true;
                    }
                    queue.poll();
                }
                return false;
            }

            @Override
            public ShardRouting next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Iterator iter = (Iterator)queue.poll();
                queue.offer(iter);
                return (ShardRouting)iter.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static final class UnassignedShards
    implements Iterable<ShardRouting> {
        private final RoutingNodes nodes;
        private final List<ShardRouting> unassigned;
        private final List<ShardRouting> ignored;
        private int primaries = 0;
        private int ignoredPrimaries = 0;

        public UnassignedShards(RoutingNodes nodes) {
            this.nodes = nodes;
            this.unassigned = new ArrayList<ShardRouting>();
            this.ignored = new ArrayList<ShardRouting>();
        }

        public void add(ShardRouting shardRouting) {
            if (shardRouting.primary()) {
                ++this.primaries;
            }
            this.unassigned.add(shardRouting);
        }

        public void sort(Comparator<ShardRouting> comparator) {
            this.nodes.ensureMutable();
            CollectionUtil.timSort(this.unassigned, comparator);
        }

        public int size() {
            return this.unassigned.size();
        }

        public int getNumPrimaries() {
            return this.primaries;
        }

        public int getNumIgnoredPrimaries() {
            return this.ignoredPrimaries;
        }

        public UnassignedIterator iterator() {
            return new UnassignedIterator();
        }

        public List<ShardRouting> ignored() {
            return Collections.unmodifiableList(this.ignored);
        }

        public void ignoreShard(ShardRouting shard, UnassignedInfo.AllocationStatus allocationStatus, RoutingChangesObserver changes) {
            this.nodes.ensureMutable();
            if (shard.primary()) {
                ++this.ignoredPrimaries;
                UnassignedInfo currInfo = shard.unassignedInfo();
                assert (currInfo != null);
                if (!allocationStatus.equals(currInfo.getLastAllocationStatus())) {
                    UnassignedInfo newInfo = new UnassignedInfo(currInfo.getReason(), currInfo.getMessage(), currInfo.getFailure(), currInfo.getNumFailedAllocations(), currInfo.getUnassignedTimeInNanos(), currInfo.getUnassignedTimeInMillis(), currInfo.isDelayed(), allocationStatus, currInfo.getFailedNodeIds());
                    ShardRouting updatedShard = shard.updateUnassigned(newInfo, shard.recoverySource());
                    changes.unassignedInfoUpdated(shard, newInfo);
                    shard = updatedShard;
                }
            }
            this.ignored.add(shard);
        }

        public boolean isEmpty() {
            return this.unassigned.isEmpty();
        }

        public boolean isIgnoredEmpty() {
            return this.ignored.isEmpty();
        }

        public void shuffle() {
            this.nodes.ensureMutable();
            Randomness.shuffle(this.unassigned);
        }

        public ShardRouting[] drain() {
            this.nodes.ensureMutable();
            ShardRouting[] mutableShardRoutings = this.unassigned.toArray(new ShardRouting[this.unassigned.size()]);
            this.unassigned.clear();
            this.primaries = 0;
            return mutableShardRoutings;
        }

        public ShardRouting[] drainIgnored() {
            this.nodes.ensureMutable();
            ShardRouting[] mutableShardRoutings = this.ignored.toArray(new ShardRouting[this.ignored.size()]);
            this.ignored.clear();
            this.ignoredPrimaries = 0;
            return mutableShardRoutings;
        }

        public class UnassignedIterator
        implements Iterator<ShardRouting>,
        ExistingShardsAllocator.UnassignedAllocationHandler {
            private final ListIterator<ShardRouting> iterator;
            private ShardRouting current;

            public UnassignedIterator() {
                this.iterator = UnassignedShards.this.unassigned.listIterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public ShardRouting next() {
                this.current = this.iterator.next();
                return this.current;
            }

            @Override
            public ShardRouting initialize(String nodeId, @Nullable String existingAllocationId, long expectedShardSize, RoutingChangesObserver routingChangesObserver) {
                UnassignedShards.this.nodes.ensureMutable();
                this.innerRemove();
                return UnassignedShards.this.nodes.initializeShard(this.current, nodeId, existingAllocationId, expectedShardSize, routingChangesObserver);
            }

            @Override
            public void removeAndIgnore(UnassignedInfo.AllocationStatus attempt, RoutingChangesObserver changes) {
                UnassignedShards.this.nodes.ensureMutable();
                this.innerRemove();
                UnassignedShards.this.ignoreShard(this.current, attempt, changes);
            }

            private void updateShardRouting(ShardRouting shardRouting) {
                this.current = shardRouting;
                this.iterator.set(shardRouting);
            }

            @Override
            public ShardRouting updateUnassigned(UnassignedInfo unassignedInfo, RecoverySource recoverySource, RoutingChangesObserver changes) {
                UnassignedShards.this.nodes.ensureMutable();
                ShardRouting updatedShardRouting = this.current.updateUnassigned(unassignedInfo, recoverySource);
                changes.unassignedInfoUpdated(this.current, unassignedInfo);
                this.updateShardRouting(updatedShardRouting);
                return updatedShardRouting;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove is not supported in unassigned iterator, use removeAndIgnore or initialize");
            }

            private void innerRemove() {
                this.iterator.remove();
                if (this.current.primary()) {
                    --UnassignedShards.this.primaries;
                }
            }
        }
    }

    private static final class Recoveries {
        private static final Recoveries EMPTY = new Recoveries();
        private int incoming = 0;
        private int outgoing = 0;

        private Recoveries() {
        }

        void addOutgoing(int howMany) {
            assert (this.outgoing + howMany >= 0) : this.outgoing + howMany + " must be >= 0";
            this.outgoing += howMany;
        }

        void addIncoming(int howMany) {
            assert (this.incoming + howMany >= 0) : this.incoming + howMany + " must be >= 0";
            this.incoming += howMany;
        }

        int getOutgoing() {
            return this.outgoing;
        }

        int getIncoming() {
            return this.incoming;
        }

        public static Recoveries getOrAdd(Map<String, Recoveries> map, String key) {
            Recoveries recoveries = map.get(key);
            if (recoveries == null) {
                recoveries = new Recoveries();
                map.put(key, recoveries);
            }
            return recoveries;
        }

        static Map<String, Recoveries> unionRecoveries(Map<String, Recoveries> first, Map<String, Recoveries> second) {
            HashMap<String, Recoveries> recoveries = new HashMap<String, Recoveries>();
            Recoveries.addRecoveries(recoveries, first);
            Recoveries.addRecoveries(recoveries, second);
            return recoveries;
        }

        private static void addRecoveries(Map<String, Recoveries> existingRecoveries, Map<String, Recoveries> newRecoveries) {
            for (String node : newRecoveries.keySet()) {
                Recoveries r2 = newRecoveries.get(node);
                Recoveries r1 = Recoveries.getOrAdd(existingRecoveries, node);
                r1.addIncoming(r2.incoming);
                r1.addOutgoing(r2.outgoing);
            }
        }
    }
}

