/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.util;

import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;

public class FeatureFlags {
    public static final String REPLICATION_TYPE = "opensearch.experimental.feature.replication_type.enabled";
    public static final String REMOTE_STORE = "opensearch.experimental.feature.remote_store.enabled";
    public static final String SEARCHABLE_SNAPSHOT = "opensearch.experimental.feature.searchable_snapshot.enabled";
    public static final String SEARCHABLE_SNAPSHOT_EXTENDED_COMPATIBILITY = "opensearch.experimental.feature.searchable_snapshot.extended_compatibility.enabled";
    public static final String EXTENSIONS = "opensearch.experimental.feature.extensions.enabled";
    private static Settings settings;
    public static final Setting<Boolean> REPLICATION_TYPE_SETTING;
    public static final Setting<Boolean> REMOTE_STORE_SETTING;
    public static final Setting<Boolean> SEARCHABLE_SNAPSHOT_SETTING;
    public static final Setting<Boolean> EXTENSIONS_SETTING;

    public static void initializeFeatureFlags(Settings openSearchSettings) {
        settings = openSearchSettings;
    }

    public static boolean isEnabled(String featureFlagName) {
        if ("true".equalsIgnoreCase(System.getProperty(featureFlagName))) {
            return true;
        }
        return settings != null && settings.getAsBoolean(featureFlagName, false) != false;
    }

    static {
        REPLICATION_TYPE_SETTING = Setting.boolSetting(REPLICATION_TYPE, false, Setting.Property.NodeScope);
        REMOTE_STORE_SETTING = Setting.boolSetting(REMOTE_STORE, false, Setting.Property.NodeScope);
        SEARCHABLE_SNAPSHOT_SETTING = Setting.boolSetting(SEARCHABLE_SNAPSHOT, false, Setting.Property.NodeScope);
        EXTENSIONS_SETTING = Setting.boolSetting(EXTENSIONS, false, Setting.Property.NodeScope);
    }
}

