/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.extensions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.WriteableSetting;
import org.opensearch.extensions.DiscoveryExtensionNode;
import org.opensearch.transport.TransportRequest;

public class AddSettingsUpdateConsumerRequest
extends TransportRequest {
    private final DiscoveryExtensionNode extensionNode;
    private final List<WriteableSetting> componentSettings;

    public AddSettingsUpdateConsumerRequest(DiscoveryExtensionNode extensionNode, List<Setting<?>> componentSettings) {
        this.extensionNode = extensionNode;
        this.componentSettings = new ArrayList<WriteableSetting>(componentSettings.size());
        for (Setting<?> setting : componentSettings) {
            this.componentSettings.add(new WriteableSetting(setting));
        }
    }

    public AddSettingsUpdateConsumerRequest(StreamInput in) throws IOException {
        super(in);
        this.extensionNode = new DiscoveryExtensionNode(in);
        int componentSettingsCount = in.readVInt();
        this.componentSettings = new ArrayList<WriteableSetting>(componentSettingsCount);
        for (int i = 0; i < componentSettingsCount; ++i) {
            this.componentSettings.add(new WriteableSetting(in));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.extensionNode.writeTo(out);
        out.writeVInt(this.componentSettings.size());
        for (WriteableSetting componentSetting : this.componentSettings) {
            componentSetting.writeTo(out);
        }
    }

    public List<WriteableSetting> getComponentSettings() {
        return new ArrayList<WriteableSetting>(this.componentSettings);
    }

    public DiscoveryExtensionNode getExtensionNode() {
        return this.extensionNode;
    }

    public String toString() {
        return "AddSettingsUpdateConsumerRequest{extensionNode=" + this.extensionNode.toString() + "}";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AddSettingsUpdateConsumerRequest that = (AddSettingsUpdateConsumerRequest)obj;
        return Objects.equals(this.extensionNode, that.extensionNode) && Objects.equals(this.componentSettings, that.componentSettings);
    }

    public int hashCode() {
        return Objects.hash(this.extensionNode, this.componentSettings);
    }
}

