/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.extensions.action;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.transport.TransportRequest;

public class TransportActionRequestFromExtension
extends TransportRequest {
    private final String action;
    private final byte[] requestBytes;
    private final String uniqueId;

    public TransportActionRequestFromExtension(String action, byte[] requestBytes, String uniqueId) {
        this.action = action;
        this.requestBytes = requestBytes;
        this.uniqueId = uniqueId;
    }

    public TransportActionRequestFromExtension(StreamInput in) throws IOException {
        super(in);
        this.action = in.readString();
        this.requestBytes = in.readByteArray();
        this.uniqueId = in.readString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.action);
        out.writeByteArray(this.requestBytes);
        out.writeString(this.uniqueId);
    }

    public String getAction() {
        return this.action;
    }

    public byte[] getRequestBytes() {
        return this.requestBytes;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public String toString() {
        return "TransportActionRequestFromExtension{action=" + this.action + ", requestBytes=" + this.requestBytes + ", uniqueId=" + this.uniqueId + "}";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TransportActionRequestFromExtension that = (TransportActionRequestFromExtension)obj;
        return Objects.equals(this.action, that.action) && Objects.equals(this.requestBytes, that.requestBytes) && Objects.equals(this.uniqueId, that.uniqueId);
    }

    public int hashCode() {
        return Objects.hash(this.action, this.requestBytes, this.uniqueId);
    }
}

