/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.store.remote.directory;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.NoLockFactory;
import org.opensearch.LegacyESVersion;
import org.opensearch.Version;
import org.opensearch.common.lucene.store.ByteArrayIndexInput;
import org.opensearch.index.snapshots.blobstore.BlobStoreIndexShardSnapshot;
import org.opensearch.index.store.remote.file.OnDemandBlockSnapshotIndexInput;
import org.opensearch.index.store.remote.utils.TransferManager;

public final class RemoteSnapshotDirectory
extends Directory {
    public static final Version SEARCHABLE_SNAPSHOT_EXTENDED_COMPATIBILITY_MINIMUM_VERSION = LegacyESVersion.fromId(6000099);
    private static final String VIRTUAL_FILE_PREFIX = "v__";
    private final Map<String, BlobStoreIndexShardSnapshot.FileInfo> fileInfoMap;
    private final FSDirectory localStoreDir;
    private final TransferManager transferManager;

    public RemoteSnapshotDirectory(BlobStoreIndexShardSnapshot snapshot, FSDirectory localStoreDir, TransferManager transferManager) {
        this.fileInfoMap = snapshot.indexFiles().stream().collect(Collectors.toMap(BlobStoreIndexShardSnapshot.FileInfo::physicalName, f -> f));
        this.localStoreDir = localStoreDir;
        this.transferManager = transferManager;
    }

    public String[] listAll() throws IOException {
        return this.fileInfoMap.keySet().toArray(new String[0]);
    }

    public void deleteFile(String name) throws IOException {
    }

    public IndexOutput createOutput(String name, IOContext context) {
        return NoopIndexOutput.INSTANCE;
    }

    public IndexInput openInput(String name, IOContext context) throws IOException {
        BlobStoreIndexShardSnapshot.FileInfo fileInfo = this.fileInfoMap.get(name);
        if (fileInfo.name().startsWith(VIRTUAL_FILE_PREFIX)) {
            return new ByteArrayIndexInput(fileInfo.physicalName(), fileInfo.metadata().hash().bytes);
        }
        return new OnDemandBlockSnapshotIndexInput(fileInfo, this.localStoreDir, this.transferManager);
    }

    public void close() throws IOException {
        this.localStoreDir.close();
    }

    public long fileLength(String name) throws IOException {
        return this.fileInfoMap.get(name).length();
    }

    public Set<String> getPendingDeletions() throws IOException {
        return Collections.emptySet();
    }

    public IndexOutput createTempOutput(String prefix, String suffix, IOContext context) {
        throw new UnsupportedOperationException();
    }

    public void sync(Collection<String> names) throws IOException {
    }

    public void syncMetaData() {
    }

    public void rename(String source, String dest) throws IOException {
    }

    public Lock obtainLock(String name) throws IOException {
        return NoLockFactory.INSTANCE.obtainLock(null, null);
    }

    static class NoopIndexOutput
    extends IndexOutput {
        static final NoopIndexOutput INSTANCE = new NoopIndexOutput();

        NoopIndexOutput() {
            super("noop", "noop");
        }

        public void close() throws IOException {
        }

        public long getFilePointer() {
            return 0L;
        }

        public long getChecksum() throws IOException {
            return 0L;
        }

        public void writeByte(byte b) throws IOException {
        }

        public void writeBytes(byte[] b, int offset, int length) throws IOException {
        }
    }
}

