/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.recovery;

import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.indices.cluster.IndicesClusterStateService;
import org.opensearch.indices.replication.common.ReplicationFailedException;
import org.opensearch.indices.replication.common.ReplicationListener;
import org.opensearch.indices.replication.common.ReplicationState;

public class RecoveryListener
implements ReplicationListener {
    private final ShardRouting shardRouting;
    private final long primaryTerm;
    private final IndicesClusterStateService indicesClusterStateService;

    public RecoveryListener(ShardRouting shardRouting, long primaryTerm, IndicesClusterStateService indicesClusterStateService) {
        this.shardRouting = shardRouting;
        this.primaryTerm = primaryTerm;
        this.indicesClusterStateService = indicesClusterStateService;
    }

    @Override
    public void onDone(ReplicationState state) {
        this.indicesClusterStateService.handleRecoveryDone(state, this.shardRouting, this.primaryTerm);
    }

    @Override
    public void onFailure(ReplicationState state, ReplicationFailedException e, boolean sendShardFailure) {
        this.indicesClusterStateService.handleRecoveryFailure(this.shardRouting, sendShardFailure, e);
    }
}

