/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.backpressure.stats;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.Version;
import org.opensearch.common.Nullable;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentFragment;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.search.backpressure.settings.SearchBackpressureMode;
import org.opensearch.search.backpressure.stats.SearchShardTaskStats;
import org.opensearch.search.backpressure.stats.SearchTaskStats;

public class SearchBackpressureStats
implements ToXContentFragment,
Writeable {
    private final SearchShardTaskStats searchShardTaskStats;
    private final SearchBackpressureMode mode;
    @Nullable
    private final SearchTaskStats searchTaskStats;

    public SearchBackpressureStats(SearchTaskStats searchTaskStats, SearchShardTaskStats searchShardTaskStats, SearchBackpressureMode mode) {
        this.searchShardTaskStats = searchShardTaskStats;
        this.mode = mode;
        this.searchTaskStats = searchTaskStats;
    }

    public SearchBackpressureStats(StreamInput in) throws IOException {
        this.searchShardTaskStats = new SearchShardTaskStats(in);
        this.mode = SearchBackpressureMode.fromName(in.readString());
        this.searchTaskStats = in.getVersion().onOrAfter(Version.V_2_6_0) ? in.readOptionalWriteable(SearchTaskStats::new) : null;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("search_backpressure");
        if (this.searchTaskStats != null) {
            builder.field("search_task", (ToXContent)this.searchTaskStats);
        }
        builder.field("search_shard_task", (ToXContent)this.searchShardTaskStats);
        builder.field("mode", this.mode.getName());
        return builder.endObject();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.searchShardTaskStats.writeTo(out);
        out.writeString(this.mode.getName());
        if (out.getVersion().onOrAfter(Version.V_2_6_0)) {
            out.writeOptionalWriteable(this.searchTaskStats);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchBackpressureStats that = (SearchBackpressureStats)o;
        return this.mode == that.mode && Objects.equals(this.searchTaskStats, that.searchTaskStats) && Objects.equals(this.searchShardTaskStats, that.searchShardTaskStats);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.searchTaskStats, this.searchShardTaskStats, this.mode});
    }
}

