/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.painless.ir;

import org.opensearch.painless.ClassWriter;
import org.opensearch.painless.Location;
import org.opensearch.painless.MethodWriter;
import org.opensearch.painless.ir.DeclarationBlockNode;
import org.opensearch.painless.ir.ExpressionNode;
import org.opensearch.painless.ir.IRNode;
import org.opensearch.painless.ir.LoopNode;
import org.opensearch.painless.phase.IRTreeVisitor;
import org.opensearch.painless.symbol.WriteScope;
import org.opensearch.repackage.org.objectweb.asm.Label;

public class ForLoopNode
extends LoopNode {
    private IRNode initializerNode;
    private ExpressionNode afterthoughtNode;

    public void setInitialzerNode(IRNode initializerNode) {
        this.initializerNode = initializerNode;
    }

    public IRNode getInitializerNode() {
        return this.initializerNode;
    }

    public void setAfterthoughtNode(ExpressionNode afterthoughtNode) {
        this.afterthoughtNode = afterthoughtNode;
    }

    public ExpressionNode getAfterthoughtNode() {
        return this.afterthoughtNode;
    }

    @Override
    public <Scope> void visit(IRTreeVisitor<Scope> irTreeVisitor, Scope scope) {
        irTreeVisitor.visitForLoop(this, scope);
    }

    @Override
    public <Scope> void visitChildren(IRTreeVisitor<Scope> irTreeVisitor, Scope scope) {
        if (this.initializerNode != null) {
            this.initializerNode.visit(irTreeVisitor, scope);
        }
        if (this.getConditionNode() != null) {
            this.getConditionNode().visit(irTreeVisitor, scope);
        }
        if (this.afterthoughtNode != null) {
            this.afterthoughtNode.visit(irTreeVisitor, scope);
        }
        if (this.getBlockNode() != null) {
            this.getBlockNode().visit(irTreeVisitor, scope);
        }
    }

    public ForLoopNode(Location location) {
        super(location);
    }

    @Override
    protected void write(ClassWriter classWriter, MethodWriter methodWriter, WriteScope writeScope) {
        WriteScope.Variable loop;
        methodWriter.writeStatementOffset(this.getLocation());
        writeScope = writeScope.newScope();
        Label start = new Label();
        Label begin = this.afterthoughtNode == null ? start : new Label();
        Label end = new Label();
        if (this.initializerNode instanceof DeclarationBlockNode) {
            this.initializerNode.write(classWriter, methodWriter, writeScope);
        } else if (this.initializerNode instanceof ExpressionNode) {
            ExpressionNode initializer = (ExpressionNode)this.initializerNode;
            initializer.write(classWriter, methodWriter, writeScope);
            methodWriter.writePop(MethodWriter.getType(initializer.getExpressionType()).getSize());
        }
        methodWriter.mark(start);
        if (this.getConditionNode() != null && !this.isContinuous()) {
            this.getConditionNode().write(classWriter, methodWriter, writeScope);
            methodWriter.ifZCmp(153, end);
        }
        if ((loop = writeScope.getInternalVariable("loop")) != null) {
            methodWriter.writeLoopCounter(loop.getSlot(), this.getLocation());
        }
        boolean allEscape = false;
        if (this.getBlockNode() != null) {
            allEscape = this.getBlockNode().doAllEscape();
            this.getBlockNode().continueLabel = begin;
            this.getBlockNode().breakLabel = end;
            this.getBlockNode().write(classWriter, methodWriter, writeScope);
        }
        if (this.afterthoughtNode != null) {
            methodWriter.mark(begin);
            this.afterthoughtNode.write(classWriter, methodWriter, writeScope);
            methodWriter.writePop(MethodWriter.getType(this.afterthoughtNode.getExpressionType()).getSize());
        }
        if (this.afterthoughtNode != null || !allEscape) {
            methodWriter.goTo(start);
        }
        methodWriter.mark(end);
    }
}

