/*
 * Decompiled with CFR 0.152.
 */
package com.github.wnameless.json.flattener;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.PrettyPrint;
import com.eclipsesource.json.WriterConfig;
import com.github.wnameless.json.flattener.PrintMode;
import com.github.wnameless.json.flattener.StringEscapePolicy;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.apache.commons.text.translate.CharSequenceTranslator;

public class JsonifyArrayList<E>
extends ArrayList<E> {
    private static final long serialVersionUID = 1L;
    private CharSequenceTranslator translator = StringEscapePolicy.NORMAL.getCharSequenceTranslator();

    public void setTranslator(CharSequenceTranslator translator) {
        this.translator = translator;
    }

    public String toString(PrintMode printMode) {
        StringWriter sw = new StringWriter();
        try {
            switch (printMode) {
                case REGULAR: {
                    Json.parse((String)this.toString()).writeTo((Writer)sw, (WriterConfig)PrettyPrint.singleLine());
                    break;
                }
                case PRETTY: {
                    Json.parse((String)this.toString()).writeTo((Writer)sw, WriterConfig.PRETTY_PRINT);
                    break;
                }
                default: {
                    return this.toString();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sw.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (Object e : this) {
            if (e instanceof String) {
                sb.append('\"');
                sb.append(this.translator.translate((CharSequence)((String)e)));
                sb.append('\"');
            } else {
                sb.append(e);
            }
            sb.append(',');
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append(']');
        return sb.toString();
    }
}

