/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.util.Base64;
import lombok.Generated;
import org.apache.commons.io.serialization.ValidatingObjectInputStream;
import org.opensearch.ml.common.MLModel;
import org.opensearch.ml.engine.exceptions.ModelSerDeSerException;

public final class ModelSerDeSer {
    public static final String[] ACCEPT_CLASS_PATTERNS = new String[]{"java.lang.*", "java.util.*", "java.time.*", "org.opensearch.ml.*", "*org.tribuo.*", "libsvm.*", "com.oracle.labs.*", "[*", "com.amazon.randomcutforest.*"};

    public static String serializeToBase64(Object model) {
        byte[] bytes = ModelSerDeSer.serialize(model);
        return ModelSerDeSer.encodeBase64(bytes);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] serialize(Object model) {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);){
                objectOutputStream.writeObject(model);
                objectOutputStream.flush();
                byArray = byteArrayOutputStream.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new ModelSerDeSerException("Failed to serialize model.", e.getCause());
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Object deserialize(byte[] modelBin) {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(modelBin);){
            Object object;
            try (ValidatingObjectInputStream validatingObjectInputStream = new ValidatingObjectInputStream((InputStream)inputStream);){
                validatingObjectInputStream.accept(ACCEPT_CLASS_PATTERNS);
                object = validatingObjectInputStream.readObject();
            }
            return object;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new ModelSerDeSerException("Failed to deserialize model.", e.getCause());
        }
    }

    public static Object deserialize(MLModel model) {
        byte[] decodeBytes = ModelSerDeSer.decodeBase64(model.getContent());
        return ModelSerDeSer.deserialize(decodeBytes);
    }

    public static byte[] decodeBase64(String base64Str) {
        return Base64.getDecoder().decode(base64Str);
    }

    public static String encodeBase64(byte[] bytes) {
        return Base64.getEncoder().encodeToString(bytes);
    }

    @Generated
    private ModelSerDeSer() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

