/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionResponse;
import org.opensearch.action.ActionType;
import org.opensearch.client.Client;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.component.LifecycleComponent;
import org.opensearch.common.io.stream.NamedWriteableRegistry;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.IndexScopedSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.settings.SettingsFilter;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.env.Environment;
import org.opensearch.env.NodeEnvironment;
import org.opensearch.plugins.ActionPlugin;
import org.opensearch.plugins.Plugin;
import org.opensearch.repositories.RepositoriesService;
import org.opensearch.rest.RestController;
import org.opensearch.rest.RestHandler;
import org.opensearch.script.ScriptService;
import org.opensearch.securityanalytics.action.AckAlertsAction;
import org.opensearch.securityanalytics.action.CreateIndexMappingsAction;
import org.opensearch.securityanalytics.action.DeleteDetectorAction;
import org.opensearch.securityanalytics.action.DeleteRuleAction;
import org.opensearch.securityanalytics.action.GetAlertsAction;
import org.opensearch.securityanalytics.action.GetAllRuleCategoriesAction;
import org.opensearch.securityanalytics.action.GetDetectorAction;
import org.opensearch.securityanalytics.action.GetFindingsAction;
import org.opensearch.securityanalytics.action.GetIndexMappingsAction;
import org.opensearch.securityanalytics.action.GetMappingsViewAction;
import org.opensearch.securityanalytics.action.IndexDetectorAction;
import org.opensearch.securityanalytics.action.IndexRuleAction;
import org.opensearch.securityanalytics.action.SearchDetectorAction;
import org.opensearch.securityanalytics.action.SearchRuleAction;
import org.opensearch.securityanalytics.action.UpdateIndexMappingsAction;
import org.opensearch.securityanalytics.action.ValidateRulesAction;
import org.opensearch.securityanalytics.indexmanagment.DetectorIndexManagementService;
import org.opensearch.securityanalytics.mapper.IndexTemplateManager;
import org.opensearch.securityanalytics.mapper.MapperService;
import org.opensearch.securityanalytics.model.Detector;
import org.opensearch.securityanalytics.model.DetectorInput;
import org.opensearch.securityanalytics.model.Rule;
import org.opensearch.securityanalytics.resthandler.RestAcknowledgeAlertsAction;
import org.opensearch.securityanalytics.resthandler.RestCreateIndexMappingsAction;
import org.opensearch.securityanalytics.resthandler.RestDeleteDetectorAction;
import org.opensearch.securityanalytics.resthandler.RestDeleteRuleAction;
import org.opensearch.securityanalytics.resthandler.RestGetAlertsAction;
import org.opensearch.securityanalytics.resthandler.RestGetAllRuleCategoriesAction;
import org.opensearch.securityanalytics.resthandler.RestGetDetectorAction;
import org.opensearch.securityanalytics.resthandler.RestGetFindingsAction;
import org.opensearch.securityanalytics.resthandler.RestGetIndexMappingsAction;
import org.opensearch.securityanalytics.resthandler.RestGetMappingsViewAction;
import org.opensearch.securityanalytics.resthandler.RestIndexDetectorAction;
import org.opensearch.securityanalytics.resthandler.RestIndexRuleAction;
import org.opensearch.securityanalytics.resthandler.RestSearchDetectorAction;
import org.opensearch.securityanalytics.resthandler.RestSearchRuleAction;
import org.opensearch.securityanalytics.resthandler.RestUpdateIndexMappingsAction;
import org.opensearch.securityanalytics.resthandler.RestValidateRulesAction;
import org.opensearch.securityanalytics.settings.SecurityAnalyticsSettings;
import org.opensearch.securityanalytics.transport.TransportAcknowledgeAlertsAction;
import org.opensearch.securityanalytics.transport.TransportCreateIndexMappingsAction;
import org.opensearch.securityanalytics.transport.TransportDeleteDetectorAction;
import org.opensearch.securityanalytics.transport.TransportDeleteRuleAction;
import org.opensearch.securityanalytics.transport.TransportGetAlertsAction;
import org.opensearch.securityanalytics.transport.TransportGetAllRuleCategoriesAction;
import org.opensearch.securityanalytics.transport.TransportGetDetectorAction;
import org.opensearch.securityanalytics.transport.TransportGetFindingsAction;
import org.opensearch.securityanalytics.transport.TransportGetIndexMappingsAction;
import org.opensearch.securityanalytics.transport.TransportGetMappingsViewAction;
import org.opensearch.securityanalytics.transport.TransportIndexDetectorAction;
import org.opensearch.securityanalytics.transport.TransportIndexRuleAction;
import org.opensearch.securityanalytics.transport.TransportSearchDetectorAction;
import org.opensearch.securityanalytics.transport.TransportSearchRuleAction;
import org.opensearch.securityanalytics.transport.TransportUpdateIndexMappingsAction;
import org.opensearch.securityanalytics.transport.TransportValidateRulesAction;
import org.opensearch.securityanalytics.util.DetectorIndices;
import org.opensearch.securityanalytics.util.RuleIndices;
import org.opensearch.securityanalytics.util.RuleTopicIndices;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.watcher.ResourceWatcherService;

public class SecurityAnalyticsPlugin
extends Plugin
implements ActionPlugin {
    public static final String PLUGINS_BASE_URI = "/_plugins/_security_analytics";
    public static final String MAPPER_BASE_URI = "/_plugins/_security_analytics/mappings";
    public static final String MAPPINGS_VIEW_BASE_URI = "/_plugins/_security_analytics/mappings/view";
    public static final String FINDINGS_BASE_URI = "/_plugins/_security_analytics/findings";
    public static final String ALERTS_BASE_URI = "/_plugins/_security_analytics/alerts";
    public static final String DETECTOR_BASE_URI = "/_plugins/_security_analytics/detectors";
    public static final String RULE_BASE_URI = "/_plugins/_security_analytics/rules";
    private DetectorIndices detectorIndices;
    private RuleTopicIndices ruleTopicIndices;
    private MapperService mapperService;
    private RuleIndices ruleIndices;
    private DetectorIndexManagementService detectorIndexManagementService;
    private IndexTemplateManager indexTemplateManager;

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        this.detectorIndices = new DetectorIndices(client.admin(), clusterService, threadPool);
        this.ruleTopicIndices = new RuleTopicIndices(client, clusterService);
        this.indexTemplateManager = new IndexTemplateManager(client, clusterService, indexNameExpressionResolver, xContentRegistry);
        this.mapperService = new MapperService(client, clusterService, indexNameExpressionResolver, this.indexTemplateManager);
        this.ruleIndices = new RuleIndices(client, clusterService, threadPool);
        return List.of(this.detectorIndices, this.ruleTopicIndices, this.ruleIndices, this.mapperService, this.indexTemplateManager);
    }

    public Collection<Class<? extends LifecycleComponent>> getGuiceServiceClasses() {
        return Collections.singletonList(DetectorIndexManagementService.class);
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        return List.of(new RestHandler[]{new RestAcknowledgeAlertsAction(), new RestUpdateIndexMappingsAction(), new RestCreateIndexMappingsAction(), new RestGetIndexMappingsAction(), new RestIndexDetectorAction(), new RestGetDetectorAction(), new RestSearchDetectorAction(), new RestDeleteDetectorAction(), new RestGetFindingsAction(), new RestGetMappingsViewAction(), new RestGetAlertsAction(), new RestIndexRuleAction(), new RestSearchRuleAction(), new RestDeleteRuleAction(), new RestValidateRulesAction(), new RestGetAllRuleCategoriesAction()});
    }

    public List<NamedXContentRegistry.Entry> getNamedXContent() {
        return List.of(Detector.XCONTENT_REGISTRY, DetectorInput.XCONTENT_REGISTRY, Rule.XCONTENT_REGISTRY);
    }

    public List<Setting<?>> getSettings() {
        return List.of(SecurityAnalyticsSettings.INDEX_TIMEOUT, SecurityAnalyticsSettings.FILTER_BY_BACKEND_ROLES, SecurityAnalyticsSettings.ALERT_HISTORY_ENABLED, SecurityAnalyticsSettings.ALERT_HISTORY_ROLLOVER_PERIOD, SecurityAnalyticsSettings.ALERT_HISTORY_INDEX_MAX_AGE, SecurityAnalyticsSettings.ALERT_HISTORY_MAX_DOCS, SecurityAnalyticsSettings.ALERT_HISTORY_RETENTION_PERIOD, SecurityAnalyticsSettings.REQUEST_TIMEOUT, SecurityAnalyticsSettings.MAX_ACTION_THROTTLE_VALUE, SecurityAnalyticsSettings.FINDING_HISTORY_ENABLED, SecurityAnalyticsSettings.FINDING_HISTORY_MAX_DOCS, SecurityAnalyticsSettings.FINDING_HISTORY_INDEX_MAX_AGE, SecurityAnalyticsSettings.FINDING_HISTORY_ROLLOVER_PERIOD, SecurityAnalyticsSettings.FINDING_HISTORY_RETENTION_PERIOD);
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return List.of(new ActionPlugin.ActionHandler((ActionType)AckAlertsAction.INSTANCE, TransportAcknowledgeAlertsAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)UpdateIndexMappingsAction.INSTANCE, TransportUpdateIndexMappingsAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)CreateIndexMappingsAction.INSTANCE, TransportCreateIndexMappingsAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetIndexMappingsAction.INSTANCE, TransportGetIndexMappingsAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)IndexDetectorAction.INSTANCE, TransportIndexDetectorAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)DeleteDetectorAction.INSTANCE, TransportDeleteDetectorAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetMappingsViewAction.INSTANCE, TransportGetMappingsViewAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetDetectorAction.INSTANCE, TransportGetDetectorAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)SearchDetectorAction.INSTANCE, TransportSearchDetectorAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetFindingsAction.INSTANCE, TransportGetFindingsAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetAlertsAction.INSTANCE, TransportGetAlertsAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)IndexRuleAction.INSTANCE, TransportIndexRuleAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)SearchRuleAction.INSTANCE, TransportSearchRuleAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)DeleteRuleAction.INSTANCE, TransportDeleteRuleAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ValidateRulesAction.INSTANCE, TransportValidateRulesAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetAllRuleCategoriesAction.INSTANCE, TransportGetAllRuleCategoriesAction.class, new Class[0]));
    }
}

