/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.action;

import java.io.IOException;
import java.util.Locale;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.commons.alerting.model.Table;
import org.opensearch.securityanalytics.model.Detector;

public class GetFindingsRequest
extends ActionRequest {
    private Detector.DetectorType detectorType;
    private String detectorId;
    private Table table;
    public static final String DETECTOR_ID = "detector_id";

    public GetFindingsRequest(String detectorId) {
        this.detectorId = detectorId;
    }

    public GetFindingsRequest(StreamInput sin) throws IOException {
        this(sin.readOptionalString(), sin.readBoolean() ? (Detector.DetectorType)sin.readEnum(Detector.DetectorType.class) : null, Table.readFrom((StreamInput)sin));
    }

    public GetFindingsRequest(String detectorId, Detector.DetectorType detectorType, Table table) {
        this.detectorId = detectorId;
        this.detectorType = detectorType;
        this.table = table;
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if ((this.detectorId == null || this.detectorId.length() == 0) && this.detectorType == null) {
            validationException = ValidateActions.addValidationError((String)String.format(Locale.getDefault(), "At least one of detector type or detector id needs to be passed", DETECTOR_ID), validationException);
        }
        return validationException;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.detectorId);
        if (this.detectorType != null) {
            out.writeBoolean(true);
            out.writeEnum((Enum)this.detectorType);
        } else {
            out.writeBoolean(false);
        }
        this.table.writeTo(out);
    }

    public String getDetectorId() {
        return this.detectorId;
    }

    public Detector.DetectorType getDetectorType() {
        return this.detectorType;
    }

    public Table getTable() {
        return this.table;
    }
}

