/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.action;

import java.io.IOException;
import java.util.Locale;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentParserUtils;

public class GetIndexMappingsRequest
extends ActionRequest {
    public static final String INDEX_NAME_FIELD = "index_name";
    String indexName;

    public GetIndexMappingsRequest(String indexName) {
        this.indexName = indexName;
    }

    public GetIndexMappingsRequest(StreamInput sin) throws IOException {
        this(sin.readString());
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.indexName == null || this.indexName.length() == 0) {
            validationException = ValidateActions.addValidationError((String)String.format(Locale.getDefault(), "%s is missing", INDEX_NAME_FIELD), validationException);
        }
        return validationException;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.indexName);
    }

    public static GetIndexMappingsRequest parse(XContentParser xcp) throws IOException {
        String indexName = null;
        if (xcp.currentToken() == null) {
            xcp.nextToken();
        }
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        block6: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "index_name": {
                    indexName = xcp.text();
                    continue block6;
                }
            }
            xcp.skipChildren();
        }
        return new GetIndexMappingsRequest(indexName);
    }

    public GetIndexMappingsRequest indexName(String indexName) {
        this.indexName = indexName;
        return this;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }
}

